/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextCharPropIterator;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextStream;

public class TextStreamIterator
implements TextCharPropIterator {
    private final TextPosnBase moPosition;
    private final boolean mbForward;
    private final boolean mbVisual;
    private final int mnStartIndex;

    public TextStreamIterator(TextStream poStream, int nIndex, boolean bForward, boolean bVisual) {
        this.moPosition = new TextPosnBase(poStream, nIndex);
        this.mbForward = bForward;
        this.mbVisual = bVisual;
        this.mnStartIndex = nIndex;
    }

    public TextStreamIterator(TextPosnBase oSourcePosn, boolean bForward, boolean bVisual) {
        this.moPosition = new TextPosnBase(oSourcePosn);
        this.mbForward = bForward;
        this.mbVisual = bVisual;
        this.mnStartIndex = oSourcePosn.index();
    }

    @Override
    public int first() {
        return this.mnStartIndex;
    }

    @Override
    public int next(int nIndex) {
        this.moPosition.index(nIndex);
        return this.next();
    }

    @Override
    public int next() {
        char c = this.moPosition.charMove(this.mbForward, this.mbVisual);
        return c == '\u0000' ? Integer.MAX_VALUE : TextCharProp.getCharProperty(c);
    }

    @Override
    public int getNextIndex() {
        return this.moPosition.index();
    }
}

