/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.FrameCaret;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.ut.Rect;

class FrameCaretRect
extends FrameCaret {
    private final TextPosnBase moPosition;
    private final boolean mbAllowDangling;
    private final boolean mbAB;
    private final DispLineWrapped.CaretInfo mCaretInfo = new DispLineWrapped.CaretInfo();
    private Rect mCaret;

    FrameCaretRect(TextSparseStream poStream, TextPosnBase oPosition, boolean bAllowDangling, boolean bAB) {
        super(poStream, 1);
        this.moPosition = new TextPosnBase(oPosition);
        this.mbAllowDangling = bAllowDangling;
        this.mbAB = bAB;
        this.moPosition.position(1);
    }

    Rect getCaret() {
        return this.mCaret;
    }

    TextPosnBase getPosition() {
        return this.moPosition;
    }

    @Override
    protected boolean processOneFrame(TextFrame poFrame) {
        if (poFrame == null) {
            if (this.getStream().isAutoLoadSuppressed()) {
                return true;
            }
            int nFrameIndex = this.getFrameIndex();
            poFrame = this.getStream().getFrame(nFrameIndex, true);
            assert (poFrame != null);
            assert (poFrame.isNullFrame() != null);
            if (!this.moPosition.isSamePosition(poFrame.getStart())) {
                if (nFrameIndex + 1 != this.getStream().getFrameCount()) {
                    return true;
                }
                this.moPosition.position(0);
            }
            poFrame = this.getStream().forceFrame(nFrameIndex);
            this.setFrame(poFrame);
        }
        return super.processOneFrame(poFrame);
    }

    @Override
    protected int processCaretLine(DispLineWrapped poLine) {
        int eCaret = poLine.getCaretRect(this.moPosition, this.mbAB, this.mCaretInfo);
        if (eCaret != 0) {
            this.mCaret = this.mCaretInfo.mCaret;
            if (this.mbAllowDangling && eCaret == 1) {
                eCaret = 2;
            }
        }
        return eCaret;
    }
}

