/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.text.ABXY;
import com.adobe.xfa.text.LineHeight;
import com.adobe.xfa.text.TextDrawInfo;
import com.adobe.xfa.text.TextSelection;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;

class DrawParm {
    private final TextDrawInfo moDrawInfo;
    private GFXDriver mpoDriver;
    private Rect moInvalid;
    private float moInvalidAMin;
    private float moInvalidAMax;
    private UnitSpan moInvalidBMin;
    private UnitSpan moInvalidBMax;
    private Rect mpoTruncate;
    private float moTruncateAMin;
    private float moTruncateAMax;
    private UnitSpan moTruncateBMin;
    private UnitSpan moTruncateBMax;
    private UnitSpan moOffsetText;
    private UnitSpan moOffsetVertText;
    private UnitSpan moShiftSize;
    private int mpnCharIndex = -1;

    public DrawParm(TextDrawInfo oDrawInfo) {
        this.moDrawInfo = oDrawInfo;
    }

    public TextDrawInfo drawInfo() {
        return this.moDrawInfo;
    }

    GFXEnv env() {
        return this.moDrawInfo.getGfxEnv();
    }

    GFXDriver driver() {
        return this.mpoDriver;
    }

    void setDriver(GFXDriver poDriver) {
        this.mpoDriver = poDriver;
    }

    Rect invalid() {
        return this.moInvalid;
    }

    void setInvalid(Rect oInvalid) {
        this.moInvalid = oInvalid;
        this.setInvalidExtents(oInvalid);
    }

    float invalidAMin() {
        return this.moInvalidAMin;
    }

    float invalidAMax() {
        return this.moInvalidAMax;
    }

    UnitSpan invalidBMin() {
        return this.moInvalidBMin;
    }

    UnitSpan invalidBMax() {
        return this.moInvalidBMax;
    }

    Rect truncate() {
        return this.mpoTruncate;
    }

    void setTruncate(Rect poTruncate) {
        this.mpoTruncate = poTruncate;
        if (poTruncate != null) {
            this.setTruncateExtents(poTruncate);
        }
    }

    float truncateAMin() {
        return this.moTruncateAMin;
    }

    float truncateAMax() {
        return this.moTruncateAMax;
    }

    UnitSpan truncateBMin() {
        return this.moTruncateBMin;
    }

    UnitSpan truncateBMax() {
        return this.moTruncateBMax;
    }

    void translate(CoordPair oXYOrigin, int eOrientation) {
        this.setInvalidExtents(ABXY.toAB(oXYOrigin, this.moInvalid, eOrientation));
        if (this.mpoTruncate != null) {
            this.setTruncateExtents(ABXY.toAB(oXYOrigin, this.mpoTruncate, eOrientation));
        }
    }

    void setDispHeight(LineHeight oDispHeight) {
        this.moOffsetText = Units.toUnitSpan(oDispHeight.textOffset(0));
        this.moOffsetVertText = Units.toUnitSpan(oDispHeight.textOffset(1));
        this.moShiftSize = Units.toUnitSpan(oDispHeight.size());
    }

    UnitSpan offsetText() {
        return this.moOffsetText;
    }

    UnitSpan offsetVertText() {
        return this.moOffsetVertText;
    }

    UnitSpan shiftSize() {
        return this.moShiftSize;
    }

    public Rect page() {
        return this.moDrawInfo.getPage();
    }

    public TextSelection primary() {
        return this.moDrawInfo.getPrimary();
    }

    public TextSelection secondary() {
        return this.moDrawInfo.getSecondary();
    }

    public int charIndex() {
        return this.mpnCharIndex;
    }

    public void setCharIndex(int pnCharIndex) {
        this.mpnCharIndex = pnCharIndex;
    }

    private void setInvalidExtents(Rect oInvalid) {
        this.moInvalidAMin = Units.toFloat(oInvalid.left());
        this.moInvalidAMax = Units.toFloat(oInvalid.right());
        this.moInvalidBMin = oInvalid.top();
        this.moInvalidBMax = oInvalid.bottom();
    }

    private void setTruncateExtents(Rect poTruncate) {
        if (poTruncate != null) {
            this.moTruncateAMin = Units.toFloat(poTruncate.left());
            this.moTruncateAMax = Units.toFloat(poTruncate.right());
            this.moTruncateBMin = poTruncate.top();
            this.moTruncateBMax = poTruncate.bottom();
        }
    }
}

