/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.TextRegion;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.UnitSpan;

class DispTab
extends TextEmbed {
    private TextRegion mpoFillRegion;
    private UnitSpan moWidth = UnitSpan.ZERO;
    private UnitSpan moHeight = UnitSpan.ZERO;
    private UnitSpan moFillWidth;
    private boolean mbTrailing;

    DispTab() {
    }

    void setWidth(float oWidth) {
        this.setWidth(Units.toUnitSpan(oWidth));
    }

    void setWidth(UnitSpan oWidth) {
        this.moWidth = oWidth;
    }

    void setFillWidth(float oWidth) {
        this.moFillWidth = Units.toUnitSpan(oWidth);
    }

    UnitSpan getFillWidth() {
        return this.moFillWidth == null ? this.moWidth : this.moFillWidth;
    }

    void setHeight(UnitSpan oHeight) {
        this.moHeight = oHeight;
    }

    boolean isTrailing() {
        return this.mbTrailing;
    }

    void setTrailing(boolean bTrailing) {
        this.mbTrailing = bTrailing;
    }

    public void fill(TextContext poContext, TextAttr poMasterAttr, GFXEnv poGfxEnv) {
        assert (poMasterAttr != null);
        assert (poMasterAttr.leaderPatternEnable());
        assert (poMasterAttr.leaderPattern() == 2 || poMasterAttr.leaderPattern() == 3);
        assert (poMasterAttr.leaderContentEnable());
        this.mpoFillRegion = null;
        this.mpoFillRegion = new TextRegion();
        this.mpoFillRegion.fontService(poMasterAttr.fontService());
        this.mpoFillRegion.setContext(poContext);
        this.mpoFillRegion.allowNewLines(false);
        if (poMasterAttr.leaderPattern() == 2) {
            this.mpoFillRegion.append(".");
        } else {
            this.mpoFillRegion.append(poMasterAttr.leaderContent());
        }
        this.mpoFillRegion.setMinWidth(UnitSpan.ZERO);
        this.mpoFillRegion.setMinHeight(UnitSpan.ZERO);
        UnitSpan oMax = new UnitSpan(3, -1);
        this.mpoFillRegion.setMaxWidth(oMax);
        this.mpoFillRegion.setMaxHeight(oMax);
        this.mpoFillRegion.forceDisplay(poMasterAttr, poGfxEnv);
    }

    public TextRegion getFillRegion() {
        return this.mpoFillRegion;
    }

    @Override
    public boolean isEqual(TextEmbed poCompare) {
        return true;
    }

    @Override
    public UnitSpan width() {
        return this.moWidth;
    }

    @Override
    public UnitSpan height() {
        return this.moHeight;
    }

    @Override
    public TextEmbed cloneEmbed() {
        return new DispTab();
    }

    @Override
    public void gfxDraw(GFXEnv oEnv) {
    }

    @Override
    public int embedAt() {
        return 2;
    }

    public String toString() {
        return "tab (" + this.moWidth.toString() + ")";
    }
}

