/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.FormatInfo;
import com.adobe.xfa.text.PosnStack;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextStream;

abstract class DispRaw {
    private final PosnStack moPosnStack;
    private TextPosnBase mpoCurrent;
    private TextStream mpoStopStream;
    private int mnStopIndex;
    private boolean mbContinue;
    private boolean mbIsLastParaLine;
    private boolean mbIsLastLineInStream;

    DispRaw(FormatInfo oFormatInfo, PosnStack oPosnStack) {
        this.moPosnStack = oPosnStack;
        this.mpoCurrent = this.moPosnStack.top();
        this.mpoCurrent.position(1);
        if (oFormatInfo.getChange().type() == 3) {
            this.mpoStopStream = oFormatInfo.getChange().stream();
            this.mnStopIndex = oFormatInfo.getChange().index() + oFormatInfo.getChange().count();
        }
    }

    TextPosnBase getPosition() {
        return this.mpoCurrent;
    }

    boolean canContinue() {
        return this.mbContinue;
    }

    void run() {
        boolean bDone = false;
        while (!bDone) {
            if (this.mpoStopStream != null && this.mpoCurrent.index() >= this.mnStopIndex && this.mpoCurrent.stream() == this.mpoStopStream) {
                return;
            }
            int eItem = this.mpoCurrent.next(true);
            boolean bAdvanced = false;
            switch (eItem) {
                case 1: {
                    bAdvanced = this.onAttr();
                    break;
                }
                case 2: {
                    int c = this.mpoCurrent.nextChar(true);
                    int eData = TextCharProp.getCharProperty(c);
                    int eBreak = TextCharProp.getBreakClass(eData);
                    if (eBreak == 5 || eBreak == 9 || eBreak == 21 || eBreak == 22) {
                        bDone = true;
                        this.mbContinue = true;
                        c = 32;
                        eData = TextCharProp.makeData(31, TextCharProp.getWidthClass(eData), 1024, 8192, 0, 0x480000, 0);
                    }
                    bAdvanced = this.onChar(c, eData);
                    break;
                }
                case 3: {
                    TextField poField = this.mpoCurrent.nextField();
                    TextPosnBase oPosn = new TextPosnBase(poField, 1);
                    this.moPosnStack.push(oPosn);
                    this.mpoCurrent = this.moPosnStack.top();
                    this.onStreamStart();
                    bAdvanced = true;
                    break;
                }
                case 4: {
                    bAdvanced = this.onObject();
                    break;
                }
                case 5: {
                    bAdvanced = this.onPara();
                    this.mbIsLastParaLine = true;
                    bDone = true;
                    this.mbContinue = true;
                    break;
                }
                case 0: {
                    assert (this.moPosnStack.size() > 0);
                    this.moPosnStack.pop();
                    if (this.moPosnStack.size() == 0) {
                        this.mbIsLastParaLine = true;
                        this.mbIsLastLineInStream = true;
                        bDone = true;
                        break;
                    }
                    this.mpoCurrent = this.moPosnStack.top();
                    bAdvanced = true;
                    this.onStreamEnd();
                }
            }
            if (bAdvanced) continue;
            this.mpoCurrent.next();
        }
    }

    boolean isLastParaLine() {
        return this.mbIsLastParaLine;
    }

    boolean isLastLineInStream() {
        return this.mbIsLastLineInStream;
    }

    protected boolean onAttr() {
        return false;
    }

    protected abstract boolean onChar(int var1, int var2);

    protected abstract boolean onObject();

    protected abstract boolean onPara();

    protected void onStreamStart() {
    }

    protected void onStreamEnd() {
    }
}

