/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontItem;
import com.adobe.xfa.gfx.GFXDecorationInfo;
import com.adobe.xfa.gfx.GFXGlyphOrientation;
import com.adobe.xfa.text.ABXY;
import com.adobe.xfa.text.AFEElement;
import com.adobe.xfa.text.AFERun;
import com.adobe.xfa.text.Decoration;
import com.adobe.xfa.text.DispEmbed;
import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.DispLineRaw;
import com.adobe.xfa.text.DispMap;
import com.adobe.xfa.text.DispMapItem;
import com.adobe.xfa.text.DispMapSet;
import com.adobe.xfa.text.DispMapSpan;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DispRect;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.DispTab;
import com.adobe.xfa.text.DrawAttr;
import com.adobe.xfa.text.DrawParm;
import com.adobe.xfa.text.DrawRun;
import com.adobe.xfa.text.FormatInfo;
import com.adobe.xfa.text.Glyph;
import com.adobe.xfa.text.GlyphExtra;
import com.adobe.xfa.text.GlyphLoc;
import com.adobe.xfa.text.LayoutRenderer;
import com.adobe.xfa.text.LeaderContent;
import com.adobe.xfa.text.LeaderFill;
import com.adobe.xfa.text.LeaderRule;
import com.adobe.xfa.text.LineDesc;
import com.adobe.xfa.text.LineHeight;
import com.adobe.xfa.text.MappingManager;
import com.adobe.xfa.text.RenderGlyph;
import com.adobe.xfa.text.RenderInfo;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextDrawInfo;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextLayout;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.UnitSpan;

class DispLineWrapped
extends DispLine {
    static float CHAR_RANGE_DEFAULT = 999999.0f;
    private final DispMapSet moMaps = new DispMapSet();
    private Extra mpoExtra;
    private LineDesc moLineDesc;
    private TextAttr mpoStartAttr;
    private DispLineWrapped mpoOldLine;
    private float moAMin;
    private float moAMax;
    private float moAMaxExtended;
    private int moJFAMin;
    private int moJFAMax;
    private int moJFAMaxExtended;
    private int moBMin;
    private int moBMinExtended;
    private int moBMaxExtended;
    private float moRawWidth;
    private float moRawWidthFull;
    private int moJFRawWidth;
    private LineHeight moHeight = new LineHeight();
    private Storage<CharRange> moCharRanges;
    private CoordPair moXYOrigin = CoordPair.zeroZero();
    private static final UnitSpan gHalfPoint = new UnitSpan(19, 500);

    DispLineWrapped() {
        this.setMaps(this.moMaps);
    }

    void initialize(TextFrame poFrame, LineDesc oLineDesc) {
        super.initialize(poFrame);
        this.moLineDesc = new LineDesc(oLineDesc);
        this.mpoOldLine = null;
        if (this.moCharRanges != null) {
            this.moCharRanges.clear();
        }
        this.moHeight = new LineHeight(this.getLegacyLevel());
    }

    void setXYOrigin(CoordPair oNewOrigin) {
        this.moXYOrigin = oNewOrigin;
        CoordPair oABOrigin = ABXY.toAB(this.frame().getXYOrigin(), this.moXYOrigin, this.frame().getLayoutOrientation());
        this.moBMin = Units.toInt(oABOrigin.y());
    }

    CoordPair getXYOrigin() {
        return this.moXYOrigin;
    }

    UnitSpan getAMin() {
        return Units.toUnitSpan(this.moJFAMin);
    }

    float getAMinFloat() {
        return this.moAMin;
    }

    UnitSpan getAMax(boolean bExtended) {
        return Units.toUnitSpan(bExtended ? this.moJFAMaxExtended : this.moJFAMax);
    }

    UnitSpan getAMax() {
        return this.getAMax(false);
    }

    float getAMaxFloat(boolean bExtended) {
        return bExtended ? this.moAMaxExtended : this.moAMax;
    }

    UnitSpan getAExtent(boolean bExtended) {
        return Units.toUnitSpan((bExtended ? this.moJFAMaxExtended : this.moJFAMax) - this.moJFAMin);
    }

    UnitSpan getAExtent() {
        return this.getAExtent(false);
    }

    UnitSpan getBMin() {
        return Units.toUnitSpan(this.moBMin);
    }

    UnitSpan getBMinExtended(boolean bRelative) {
        return Units.toUnitSpan(bRelative ? this.moBMinExtended : this.moBMin + this.moBMinExtended);
    }

    UnitSpan getBMax() {
        return this.getBExtent().add(Units.toUnitSpan(this.moBMin));
    }

    UnitSpan getBMaxExtended(boolean bRelative) {
        return Units.toUnitSpan(bRelative ? this.moBMaxExtended : this.moBMin + this.moBMaxExtended);
    }

    UnitSpan getBExtent() {
        if (!this.isLastLineInStream() || this.getLegacyLevel() == -1) {
            return Units.toUnitSpan(this.moHeight.fullHeight());
        }
        if (this.getLegacyLevel() == 1 && this.moHeight.override() > 0) {
            return Units.toUnitSpan(this.moHeight.fullHeight());
        }
        return Units.toUnitSpan(this.moHeight.fullHeight() - this.moHeight.lineGap());
    }

    UnitSpan getBaselineOffset(boolean bRelative) {
        int oResult = this.moHeight.textOffset(0);
        if (!bRelative) {
            oResult += this.moBMin;
        }
        return Units.toUnitSpan(oResult);
    }

    UnitSpan getRawWidth() {
        return Units.toUnitSpan(this.moJFRawWidth);
    }

    void justify(UnitSpan oMaxWidth) {
        int eJust = this.moLineDesc.meJustifyH;
        float oSpecialL = 0.0f;
        float oSpecialR = 0.0f;
        if (this.isRTL()) {
            oSpecialR = this.moLineDesc.moSpecial;
        } else {
            oSpecialL = this.moLineDesc.moSpecial;
        }
        if (eJust == 10) {
            eJust = 7;
        }
        boolean bTrailingLeft = false;
        if (this.moLineDesc.mnTrailingSpaces > 0 && this.getGlyphCount() > 0) {
            boolean bTrailingRight;
            GlyphLoc oGlyphLoc = this.getOrderedGlyphLoc(0);
            bTrailingLeft = !this.isVisualChar(oGlyphLoc.getMapIndex());
            oGlyphLoc = this.getOrderedGlyphLoc(this.getGlyphCount() - 1);
            boolean bl = bTrailingRight = !this.isVisualChar(oGlyphLoc.getMapIndex());
            if (bTrailingLeft == bTrailingRight) {
                if (bTrailingRight) {
                    bTrailingLeft = this.isRTL();
                } else {
                    this.setTrailingWidth(0.0f);
                    this.moRawWidth = this.moRawWidthFull;
                    this.setEndInMiddle(true);
                }
            }
        }
        float oMaxUnit = Units.toFloat(oMaxWidth);
        float oShortfall = 0.0f;
        float oSpreadInsert = 0.0f;
        this.moAMin = 0.0f;
        if (this.frame().alignHPoint()) {
            switch (eJust) {
                case 6: {
                    this.moAMin -= this.moRawWidth / 2.0f;
                    break;
                }
                case 7: {
                    this.moAMin -= this.moLineDesc.moMarginR + this.moRawWidth;
                }
            }
        } else {
            this.moAMin += this.moLineDesc.moMarginL + oSpecialL;
            if ((oMaxUnit -= this.moLineDesc.moMarginL + this.moLineDesc.moMarginR + oSpecialL + oSpecialR) > this.moRawWidth) {
                oShortfall = oMaxUnit - this.moRawWidth;
            }
            boolean bSpread = false;
            switch (eJust) {
                case 6: {
                    this.moAMin += oShortfall / 2.0f;
                    break;
                }
                case 7: {
                    this.moAMin += oShortfall;
                    break;
                }
                case 8: 
                case 9: {
                    if (this.moLineDesc.mnInternalSpaces > 0) {
                        if (this.moLineDesc.meJustifyH == 9) {
                            bSpread = true;
                        } else if (this.legacyPositioning()) {
                            if (this.getLastParaLine() == 0) {
                                bSpread = true;
                            }
                        } else if (this.getLastParaLine() <= 2) {
                            bSpread = true;
                        }
                        if (bSpread) {
                            oSpreadInsert = oShortfall / (float)this.moLineDesc.mnInternalSpaces;
                        }
                    }
                    if (bSpread || !this.isRTL()) break;
                    this.moAMin += oShortfall;
                }
            }
        }
        this.moAMax = this.moAMin + this.moRawWidth;
        this.moAMaxExtended = this.moAMin + this.moRawWidthFull;
        if (bTrailingLeft) {
            this.moAMin -= this.getTrailingWidth();
        }
        if (oSpreadInsert > 0.0f || this.mpoExtra != null && this.mpoExtra.moPrevSpreadInsert > 0.0f) {
            this.needExtra();
            boolean bPendingSpreadOffset = false;
            float oDelta = oSpreadInsert - this.mpoExtra.moPrevSpreadInsert;
            float oOffset = 0.0f;
            for (int i = 0; i < this.getGlyphCount(); ++i) {
                GlyphLoc oGlyphLoc;
                int nCharIndex;
                Glyph oGlyph = this.getGlyph(i);
                GlyphExtra oGlyphExtra = this.forceExtra(i);
                oGlyphExtra.setOffsetX(oGlyphExtra.getOffsetX() + oOffset);
                if (bPendingSpreadOffset) {
                    oGlyph.setSpreadOffset(true);
                    bPendingSpreadOffset = false;
                }
                if (!this.isVisualChar(nCharIndex = (oGlyphLoc = this.getOrderedGlyphLoc(i)).getMapIndex()) || oGlyphLoc.getMapLength() != 1 || this.getBreakClass(nCharIndex) != 31) continue;
                oGlyph.setOriginalNextX(oGlyph.getOriginalNextX() + oDelta);
                oOffset += oDelta;
                bPendingSpreadOffset = true;
            }
            this.mpoExtra.moPrevSpreadInsert = oSpreadInsert;
            this.moAMax += oShortfall;
            this.moAMaxExtended += oShortfall;
        } else if (this.moLineDesc.meJustifyH == 10) {
            this.needExtra();
            float oRadixOffset = 0.0f;
            if (this.mpoStartAttr != null && this.mpoStartAttr.radixOffsetEnable()) {
                oRadixOffset = Units.toFloat(this.mpoStartAttr.radixOffset().getLength());
            }
            float oDelta = Units.toFloat(oMaxWidth);
            oDelta -= oRadixOffset;
            if (this.mpoExtra.mnRadixCharIndex != Integer.MAX_VALUE) {
                GlyphLoc oGlyphLoc = this.getMappedGlyphLoc(this.mpoExtra.mnRadixCharIndex);
                Glyph oGlyph = this.getGlyph(oGlyphLoc.getGlyphIndex());
                oDelta -= oGlyph.getDrawX(this) + this.moAMin;
            } else if (this.mpoExtra.mnLastDigitIndex != Integer.MAX_VALUE) {
                GlyphLoc oGlyphLoc = this.getMappedGlyphLoc(this.mpoExtra.mnLastDigitIndex);
                Glyph oGlyph = this.getGlyph(oGlyphLoc.getGlyphIndex());
                oDelta -= oGlyph.getDrawNextX(this) + this.moAMin;
            }
            if ((double)oDelta != 0.0) {
                this.moAMin += oDelta;
                this.moAMax += oDelta;
                this.moAMaxExtended += oDelta;
            }
        } else if (this.getCombCells() > 0) {
            int i;
            this.preAllocExtra(this.getGlyphCount());
            CombCell[] oCellRuns = new CombCell[this.getGlyphCount()];
            int nFilledCells = 0;
            int nPrevGlyph = 0;
            int nGlyph = 0;
            while (nGlyph < this.getGlyphCount()) {
                if (nGlyph > nPrevGlyph) {
                    oCellRuns[nFilledCells] = new CombCell(nGlyph - nPrevGlyph);
                    ++nFilledCells;
                }
                nPrevGlyph = nGlyph;
                int nGroup = this.getGlyph(nGlyph).getGroup(this);
                if (nGroup == 0) {
                    nGlyph = this.nextGlyphBaseAccentIndex(nGlyph);
                    continue;
                }
                ++nGlyph;
                while (nGlyph < this.getGlyphCount() && this.getGlyph(nGlyph).getGroup(this) == nGroup) {
                    ++nGlyph;
                }
                nGlyph = this.nextGlyphBaseAccentIndex(nGlyph - 1);
            }
            if (nGlyph > nPrevGlyph) {
                oCellRuns[nFilledCells] = new CombCell(nGlyph - nPrevGlyph);
                ++nFilledCells;
            }
            int nMaxCells = this.getCombCells();
            int nSkip = 0;
            if (nMaxCells > nFilledCells) {
                nSkip = nMaxCells - nFilledCells;
            }
            switch (eJust) {
                case 5: 
                case 11: {
                    nSkip = 0;
                    break;
                }
                case 6: 
                case 12: {
                    nSkip /= 2;
                }
            }
            float oCellWidth = oMaxUnit / (float)nMaxCells;
            float oHalfWidth = oCellWidth / 2.0f;
            int nGlyphIndex = 0;
            for (i = 0; i < nFilledCells; ++i) {
                int nBaseIndex = nGlyphIndex;
                Glyph poGlyph = this.getGlyph(nGlyphIndex);
                if (poGlyph.isRTL()) {
                    nBaseIndex = nGlyphIndex + oCellRuns[i].mnCombiningSize - 1;
                }
                oCellRuns[i].mnBaseGlyphIndex = nBaseIndex;
                int nCell = nSkip + i;
                float oCentreX = oCellWidth * (float)nCell + oHalfWidth;
                DispRect oBBox = this.getABGlyphBBox(nBaseIndex);
                float oGlyphWidth = oBBox.xMax - oBBox.xMin;
                float oX = oCentreX - oGlyphWidth / 2.0f;
                if (i == 0) {
                    this.moAMin = oX;
                }
                oCellRuns[i].moX = oX -= this.moAMin;
                if (i > 0) {
                    oCellRuns[i - 1].moNextX = oX;
                }
                if (i + 1 == nFilledCells) {
                    float oNextX = oCellWidth * (float)(nCell + 1) + oHalfWidth;
                    if (oNextX > oMaxUnit) {
                        oNextX = oMaxUnit;
                    }
                    oCellRuns[i].moNextX = oNextX -= this.moAMin;
                }
                nGlyphIndex += oCellRuns[i].mnCombiningSize;
            }
            nGlyphIndex = 0;
            for (i = 0; i < nFilledCells; ++i) {
                CombCell oCell = oCellRuns[i];
                Glyph oBaseGlyph = this.getGlyph(oCell.mnBaseGlyphIndex);
                float oDelta = oCell.moX - oBaseGlyph.getDrawX(this);
                for (int j = 0; j < oCell.mnCombiningSize; ++j) {
                    this.forceExtra(nGlyphIndex);
                    this.getGlyph(nGlyphIndex).setComb(this, oDelta, oCell.moNextX);
                    ++nGlyphIndex;
                }
            }
            if (nFilledCells == 0) {
                if (eJust == 13) {
                    --nSkip;
                }
                this.moAMin = oCellWidth * (float)nSkip + oHalfWidth;
            }
            this.moAMax = oMaxUnit;
            this.moAMaxExtended = oMaxUnit;
        }
        this.moJFAMin = Units.toInt(this.moAMin);
        this.moJFAMax = Units.forceInt(this.moAMax);
        this.moJFAMaxExtended = Units.toInt(this.moAMaxExtended);
    }

    void updateSubsettedChars() {
        if (this.getGlyphCount() == 0) {
            return;
        }
        for (int i = 0; i < this.getGlyphCount(); ++i) {
            FontItem poFontItem;
            FontInstance oFontInstance;
            GlyphLoc oGlyphLoc = this.getGlyphLoc(i);
            TextAttr poAttr = this.getMappedAttr(oGlyphLoc.getMapIndex());
            if (poAttr == null || (oFontInstance = poAttr.fontInstance()) == null || (poFontItem = oFontInstance.getFontItem()) == null) continue;
            RenderGlyph oRenderGlyph = new RenderGlyph();
            this.getRenderChar(poAttr, oFontInstance, oGlyphLoc, this.getGlyph(oGlyphLoc.getGlyphIndex()), oRenderGlyph);
            poFontItem.addSubsettedGlyphs(oRenderGlyph.mnGlyphID, oRenderGlyph.mcGlyph);
        }
    }

    FontItem getRenderChar(TextAttr poAttr, FontInstance oFontInstance, GlyphLoc oGlyphLoc, Glyph oGlyph, RenderGlyph oRenderGlyph, FontItem poFontItem) {
        FontItem poUnicodeFont;
        this.getRenderChar(poAttr, oFontInstance, oGlyphLoc, oGlyph, oRenderGlyph);
        if (oRenderGlyph.mcGlyph == 0 && (poUnicodeFont = poFontItem.getUnicodeFont()) != null) {
            poFontItem = poUnicodeFont;
        }
        return poFontItem;
    }

    TextPosn getStartPosition() {
        if (this.getPositionCount() > 0) {
            return this.getPosition(0).pp();
        }
        if (this.mpoExtra != null && this.mpoExtra.mpoEmptyPosn != null) {
            return this.mpoExtra.mpoEmptyPosn;
        }
        return null;
    }

    TextPosnBase getEndPosition() {
        TextPosnBase oResult = null;
        if (this.getPositionCount() > 0) {
            DispPosn oMappedPosn = this.getPosition(this.getPositionCount() - 1);
            oResult = new TextPosnBase(oMappedPosn.pp().stream(), oMappedPosn.pp().index() + oMappedPosn.getMapLength());
        } else if (this.mpoExtra != null && this.mpoExtra.mpoEmptyPosn != null) {
            oResult = new TextPosnBase(this.mpoExtra.mpoEmptyPosn);
        }
        return oResult;
    }

    TextAttr getStartAttr() {
        return this.mpoStartAttr;
    }

    int getHorizontalJustification() {
        return this.moLineDesc.meJustifyH;
    }

    DispRect getXYGlyphBBox(int nGlyphIndex, boolean bBaselineShift) {
        return ABXY.toXY(this.moXYOrigin, this.getABGlyphBBox(nGlyphIndex, bBaselineShift), this.frame().getLayoutOrientation());
    }

    DispRect getABGlyphBBox(int nGlyphIndex, boolean bBaselineShift) {
        DispRect oResult = new DispRect();
        int nGlyphLocIndex = this.getGlyphLocOrder(nGlyphIndex);
        GlyphLoc oGlyphLoc = this.getGlyphLoc(nGlyphLocIndex);
        int nEmbedIndex = this.findObject(oGlyphLoc);
        if (nEmbedIndex >= 0) {
            DispEmbed oMapEmbed = this.getEmbed(nEmbedIndex);
            TextEmbed poEmbed = oMapEmbed.getEmbed();
            UnitSpan oHeight = poEmbed.height();
            oResult.xMax = Units.toFloat(poEmbed.width());
            switch (poEmbed.embedAt()) {
                case 1: {
                    oResult.yMin = Units.toFloat(this.moHeight.before() - this.moHeight.textOffset(0));
                    oResult.yMax = oResult.yMin + Units.toFloat(oHeight);
                    break;
                }
                case 2: {
                    oResult.yMax = Units.toFloat(this.moHeight.descent());
                    oResult.yMin = oResult.yMax - Units.toFloat(oHeight);
                    break;
                }
                default: {
                    oResult.yMin = -Units.toFloat(oHeight);
                    break;
                }
            }
        } else {
            Glyph oGlyph = this.getGlyph(nGlyphIndex);
            int eGlyphOrientation = oGlyph.getOrientation();
            int nCharIndex = oGlyphLoc.getMapIndex();
            DispRun oRun = this.getMappedRun(nCharIndex);
            TextAttr poAttr = oRun.getAttr();
            float oShift = 0.0f;
            boolean bFound = false;
            if (poAttr != null && bBaselineShift && poAttr.baselineShiftEnable() && !poAttr.baselineShift().isNeutral()) {
                oShift = Units.toFloat(poAttr.baselineShift().applyShift(UnitSpan.ZERO, Units.toUnitSpan(this.moHeight.textOffset(0))));
            }
            if (!bFound) {
                oResult.xMin = 0.0f;
                oResult.xMax = oGlyph.getDrawNextX(this) - oGlyph.getDrawX(this);
                oResult.yMin = Units.toFloat(this.moHeight.before() - this.moHeight.textOffset(eGlyphOrientation));
                oResult.yMax = Units.toFloat(this.moHeight.descent());
            }
            oResult.yMin += oShift;
            oResult.yMax += oShift;
        }
        return oResult;
    }

    DispRect getABGlyphBBox(int nGlyphIndex) {
        return this.getABGlyphBBox(nGlyphIndex, false);
    }

    CharRange getCharExtent(int nPositionIndex, int nCharIndex, int nStreamOffset) {
        this.getCharOffset(nPositionIndex, nCharIndex, nStreamOffset, 0);
        DispPosn oPosition = this.getPosition(nPositionIndex);
        if (nStreamOffset + 1 < DispLineWrapped.getCharStreamCount(oPosition)) {
            this.getCharOffset(nPositionIndex, nCharIndex, nStreamOffset + 1, 1);
        } else {
            if (nCharIndex + 1 >= oPosition.getMapIndex() + oPosition.getMapLength()) {
                ++nPositionIndex;
            }
            this.getCharOffset(nPositionIndex, nCharIndex + 1, 0, 1);
        }
        CharRange poRange = this.getCharRange(nCharIndex);
        while (true) {
            assert (poRange != null);
            if (nStreamOffset == 0) {
                CharRange oResult = new CharRange(poRange);
                oResult.mpoNext = null;
                return oResult;
            }
            poRange = poRange.mpoNext;
            --nStreamOffset;
        }
    }

    void preAllocOffsets() {
        if (this.moCharRanges == null) {
            this.moCharRanges = new Storage();
        }
        int size = this.getCharCount();
        this.moCharRanges.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.moCharRanges.set(i, new CharRange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean gfxDraw(DrawParm oParm) {
        if (this.getGlyphCount() == 0) {
            return true;
        }
        if (!this.isFirstLineInStream() && this.isFirstParaLine()) {
            oParm.driver().paraHint();
        }
        oParm.setDispHeight(this.moHeight);
        DrawAttr oCurrentAttr = new DrawAttr(this, oParm);
        oCurrentAttr.drawBackground();
        DrawRun oRun = new DrawRun(this, oParm);
        boolean bTruncate = false;
        UnitSpan oTruncAMin = null;
        UnitSpan oTruncAMax = null;
        boolean bFits = true;
        if (oParm.truncate() != null) {
            oTruncAMin = Units.toUnitSpan(oParm.truncateAMin() - this.moAMin);
            oTruncAMax = Units.toUnitSpan(oParm.truncateAMax() - this.moAMin);
            bTruncate = true;
        }
        RenderInfo oRenderInfo = new RenderInfo();
        oRenderInfo.mbAttrChange = true;
        int[] pcText = null;
        if (this.hasAXTEMappings()) {
            this.needExtra();
            this.mpoExtra.createFlatText(this);
            pcText = this.mpoExtra.mpcFlatText;
        } else {
            pcText = this.getCharArray();
        }
        boolean popRenderContext = false;
        if (oParm.charIndex() < 0) {
            oParm.driver().setUnicodeChars(pcText);
        } else {
            oParm.driver().pushRenderContext(pcText, oParm.charIndex());
            popRenderContext = true;
        }
        try {
            while (oCurrentAttr.prepareGlyph(oRenderInfo)) {
                int nGlyphIndex = oRenderInfo.mpoGlyphLoc.getGlyphIndex();
                Glyph oGlyph = this.getGlyph(nGlyphIndex);
                float oX = oGlyph.getDrawX(this) + this.moAMin;
                boolean bSuppressGlyph = false;
                if (bTruncate) {
                    if (Units.toUnitSpan(oGlyph.getDrawX(this)).lt(oTruncAMin)) {
                        bSuppressGlyph = true;
                    } else {
                        UnitSpan oDelta = Units.toUnitSpan(oGlyph.getDrawNextX(this)).subtract(oTruncAMax);
                        if (oDelta.value() > 0 && oDelta.gt(gHalfPoint)) {
                            bSuppressGlyph = true;
                        }
                    }
                    if (bSuppressGlyph && (oRenderInfo.mpoGlyphLoc.getMapLength() > 1 || this.isVisualChar(oRenderInfo.mpoGlyphLoc.getMapIndex()))) {
                        bFits = false;
                    }
                }
                DispRect oBBox = this.getABGlyphBBox(nGlyphIndex);
                float oAMin = oBBox.xMin + oX;
                float oAMax = oBBox.xMax + oX;
                if (!(oAMin <= oParm.invalidAMax()) || !(oAMax >= oParm.invalidAMin()) || bSuppressGlyph) continue;
                float oY = oGlyph.getDrawY(this) + Units.toFloat(oCurrentAttr.getBaseline());
                DispEmbed poDispEmbed = this.isObject(oRenderInfo.mpoGlyphLoc);
                boolean bRenderGlyph = false;
                boolean bRenderObject = false;
                if (poDispEmbed == null) {
                    bRenderGlyph = true;
                } else {
                    DispTab poDispTab = this.tabAt(oRenderInfo.mpoGlyphLoc.getMapIndex());
                    if (poDispTab == null || this.legacyPositioning()) {
                        bRenderObject = true;
                    } else {
                        bRenderGlyph = this.renderTabLeader(oParm, poDispTab, oRenderInfo.mpoGlyphLoc, oCurrentAttr, oRun);
                    }
                }
                if (bRenderObject) {
                    oRun.flush();
                    TextEmbed poEmbed = poDispEmbed.getEmbed();
                    UnitSpan oTop = UnitSpan.ZERO;
                    UnitSpan oHeight = poEmbed.height();
                    switch (poEmbed.embedAt()) {
                        case 0: {
                            oTop = Units.toUnitSpan(oY);
                            oTop = oTop.subtract(oHeight);
                            break;
                        }
                        case 1: {
                            oTop = Units.toUnitSpan(this.moHeight.before());
                            break;
                        }
                        case 2: {
                            oTop = Units.toUnitSpan(this.moHeight.before() + this.moHeight.spacing());
                            oTop = oTop.subtract(oHeight);
                        }
                    }
                    CoordPair oOffset = new CoordPair(Units.toUnitSpan(oX), oTop);
                    oParm.driver().pushOffset(false, oOffset);
                    try {
                        poEmbed.gfxDraw(oParm.env());
                    }
                    finally {
                        oParm.driver().popOffset();
                    }
                    oRenderInfo.mbAttrChange = true;
                    oRun.forceAttrChange();
                }
                if (!bRenderGlyph) continue;
                if (!oRenderInfo.mbFlushBefore && (this.optycaJustify() || oGlyph.isSpreadOffset() || oGlyph.isComb() || poDispEmbed != null)) {
                    oRenderInfo.mbFlushBefore = true;
                }
                if (!oRenderInfo.mbFlushBefore) {
                    // empty if block
                }
                if (oRenderInfo.mbFlushBefore) {
                    oRun.flush();
                }
                oRun.addGlyph(oCurrentAttr, oRenderInfo, oX, oY, oGlyph.isRTL());
                if (!oRenderInfo.mbFlushAfter) continue;
                oRun.flush();
            }
            oRun.flush();
            oRun.clear();
            oCurrentAttr.flush();
        }
        finally {
            if (popRenderContext) {
                oParm.driver().popRenderContext();
            }
        }
        return bFits;
    }

    DispLineWrapped getOldLine() {
        return this.mpoOldLine;
    }

    void setOldLine(DispLineWrapped poOld) {
        this.mpoOldLine = poOld;
    }

    Rect diff(DispLineWrapped poCompare, Rect oABDiff) {
        Rect oThisDiff = null;
        if (poCompare == null) {
            oThisDiff = this.getABLineExtent();
        } else if (this.getXYOrigin() != poCompare.getXYOrigin() || this.moHeight.fullHeight() != poCompare.moHeight.fullHeight()) {
            oThisDiff = this.getABLineExtent().union(poCompare.getABLineExtent());
        } else {
            int i;
            int nCompareGlyphs = poCompare.getGlyphCount();
            int nGlyphMax = this.getGlyphCount();
            if (nGlyphMax > nCompareGlyphs) {
                nGlyphMax = nCompareGlyphs;
            }
            for (i = 0; i < nGlyphMax && !this.diffGlyphs(poCompare, i, i); ++i) {
            }
            if (i < this.getGlyphCount() || i < nCompareGlyphs) {
                int nDiffStart = i;
                DispRect oDiffRect = new DispRect();
                if (nDiffStart >= nCompareGlyphs) {
                    oDiffRect = this.getABSubExtent(nDiffStart, this.getGlyphCount() - 1);
                } else if (nDiffStart >= this.getGlyphCount()) {
                    oDiffRect = poCompare.getABSubExtent(nDiffStart, nCompareGlyphs - 1);
                } else {
                    int j = nCompareGlyphs;
                    i = this.getGlyphCount();
                    while (i > nDiffStart && j > nDiffStart && !this.diffGlyphs(poCompare, --i, --j)) {
                    }
                    oDiffRect = this.getABSubExtent(nDiffStart, i);
                    DispRect oDiffCompare = poCompare.getABSubExtent(nDiffStart, j);
                    if (oDiffCompare.xMin < oDiffRect.xMin) {
                        oDiffRect.xMin = oDiffCompare.xMin;
                    }
                    if (oDiffCompare.yMax < oDiffRect.yMax) {
                        oDiffRect.yMax = oDiffCompare.yMax;
                    }
                    if (oDiffCompare.xMax > oDiffRect.xMax) {
                        oDiffRect.xMax = oDiffCompare.xMax;
                    }
                    if (oDiffCompare.yMax > oDiffRect.yMax) {
                        oDiffRect.yMax = oDiffCompare.yMax;
                    }
                }
                oThisDiff = new Rect(Units.toUnitSpan(oDiffRect.xMin), Units.forceUnitSpan(oDiffRect.xMax), Units.toUnitSpan(oDiffRect.yMax), Units.forceUnitSpan(oDiffRect.yMax));
            }
        }
        if (oThisDiff == null) {
            return oABDiff;
        }
        oThisDiff = oThisDiff.add(new CoordPair(UnitSpan.ZERO, Units.toUnitSpan(this.moBMin)));
        return oABDiff == null ? oThisDiff : oABDiff.union(oThisDiff);
    }

    int getCaretRect(TextPosnBase oPosn, boolean bAB, CaretInfo caretInfo) {
        int eCaret = this.findPosition(oPosn, caretInfo);
        if (eCaret != 2) {
            if (!this.isEmptyPosition(oPosn)) {
                return eCaret;
            }
            eCaret = 2;
        }
        float oA = this.getCharOffset(caretInfo.posnIndex, caretInfo.index, caretInfo.auxInfo, oPosn.affinity());
        UnitSpan oAUnit = Units.toUnitSpan(oA);
        caretInfo.mCaret = new Rect(oAUnit, UnitSpan.ZERO, oAUnit, this.getBExtent());
        if (!bAB) {
            caretInfo.mCaret = ABXY.toXY(this.moXYOrigin, caretInfo.mCaret, this.frame().getLayoutOrientation());
        }
        return eCaret;
    }

    int validateCaretPosn(TextPosnBase oPosn, boolean bAB) {
        DispLine.PosnInfo findInfo = new DispLine.PosnInfo();
        int eCaret = this.findPosition(oPosn, findInfo);
        if (eCaret == 0 && this.isEmptyPosition(oPosn)) {
            eCaret = 2;
        }
        return eCaret;
    }

    int getCaretPosn(TextStream poStream, UnitSpan oSearch, TextPosnBase oResult) {
        return this.getCaretPosn(poStream, oSearch, oResult, false);
    }

    int getCaretPosn(TextStream poStream, UnitSpan oSearch, TextPosnBase oResult, boolean bAllowDescendents) {
        int eResult = 0;
        if (this.getGlyphCount() == 0) {
            if (this.mpoExtra != null && this.mpoExtra.mpoEmptyPosn != null && this.mpoExtra.mpoEmptyPosn.stream() == poStream) {
                oResult.copyFrom(this.mpoExtra.mpoEmptyPosn);
                eResult = 2;
            }
        } else {
            int i;
            float oX = Units.toFloat(oSearch);
            HitTest oHitTest = new HitTest(this, poStream, oX);
            oResult.associate(null);
            for (i = 0; i < this.getGlyphCount(); ++i) {
                int nGlyphLocIndex = this.getGlyphLocOrder(i);
                GlyphLoc oGlyphLoc = this.getGlyphLoc(nGlyphLocIndex);
                int nCharIndex = oGlyphLoc.getMapIndex();
                DispPosn oPosition = this.getMappedPosition(nCharIndex);
                if (oPosition.pp().stream() != poStream && (!bAllowDescendents || !oPosition.pp().stream().isDescendentOf(poStream))) continue;
                oHitTest.tryHit(nGlyphLocIndex, oPosition);
            }
            if (!oHitTest.hasHit() && poStream != null) {
                DispMapItem poFieldPosn = null;
                for (i = 1; i < this.getPositionCount(); ++i) {
                    DispPosn oTest = this.getPosition(i);
                    if (oTest.getMapLength() != 0 || oTest.pp().stream() != poStream) continue;
                    poFieldPosn = this.getPosition(i - 1);
                    break;
                }
                if (poFieldPosn != null && poFieldPosn.getMapLength() > 0) {
                    int nAfterCharIndex = poFieldPosn.getMapIndex() + poFieldPosn.getMapLength();
                    oHitTest.tryHit(this.getMappedGlyphLoc(nAfterCharIndex - 1), (DispPosn)poFieldPosn, nAfterCharIndex, 0);
                }
            }
            if ((eResult = oHitTest.reconcile(oResult)) != 0) {
                this.checkAXTELigature(oResult, true);
            }
        }
        return eResult;
    }

    int getCaretStartEnd(TextStream poStream, boolean bEnd, boolean bVisual, TextPosnBase oResult) {
        int eCaret = 0;
        if (this.getPositionCount() == 0 && this.mpoExtra != null && this.mpoExtra.mpoEmptyPosn != null) {
            oResult.copyFrom(this.mpoExtra.mpoEmptyPosn);
            eCaret = 2;
        } else if (bVisual) {
            UnitSpan oSearch = bEnd == this.isRTL() ? Units.toUnitSpan(this.moJFAMin) : Units.toUnitSpan(this.moJFAMaxExtended);
            eCaret = this.getCaretPosn(poStream, oSearch, oResult, true);
            if (eCaret != 0 && oResult.stream() != poStream) {
                TextPosnBase oPath = new TextPosnBase();
                oResult.stream().isDescendentOf(poStream, oPath);
                if (bEnd != oResult.isRTL()) {
                    oPath.nextUserPosn();
                }
                oResult.copyFrom(oPath);
            }
        } else {
            int nStreamIndex = 0;
            int nCharIndex = 0;
            for (int i = 0; i < this.getPositionCount(); ++i) {
                int nTestCharIndex;
                DispPosn oPosition = this.getPosition(i);
                if (oPosition.pp().stream() != poStream) continue;
                if (bEnd) {
                    nTestCharIndex = oPosition.getMapIndex() + oPosition.getMapLength();
                    boolean bAtEnd = false;
                    if (!this.isValidPosition(nTestCharIndex)) {
                        if (oPosition.getMapLength() == 0) {
                            nTestCharIndex = 0;
                        }
                        bAtEnd = true;
                    }
                    if (nTestCharIndex <= nCharIndex) continue;
                    nCharIndex = nTestCharIndex;
                    int nStreamOffset = DispLineWrapped.getPositionStreamCount(oPosition);
                    if (bAtEnd && nStreamOffset > 0) {
                        --nStreamOffset;
                    }
                    nStreamIndex = DispLineWrapped.charToStreamIndex(oPosition, oPosition.getMapIndex(), nStreamOffset);
                    eCaret = 2;
                    continue;
                }
                nTestCharIndex = oPosition.getMapIndex();
                if (!this.isValidPosition(nTestCharIndex)) continue;
                nStreamIndex = oPosition.pp().index();
                eCaret = 2;
                break;
            }
            if (eCaret != 0) {
                oResult.associate(poStream, nStreamIndex);
            }
        }
        return eCaret;
    }

    int getCaretLeftRight(TextPosnBase oPosn, boolean bRight, TextPosnBase oResult) {
        int c = 0;
        int eCaret = 2;
        int eItem = 0;
        oResult.copyFrom(oPosn);
        oResult.setRTL(false);
        int n = eItem = bRight ? oResult.nextUserPosnType(false) : oResult.prevUserPosnType(false);
        if (eItem == 0) {
            return 0;
        }
        switch (eItem) {
            case 2: {
                c = bRight == oResult.isRTL() ? oResult.nextChar(true) : oResult.prevChar(true);
                break;
            }
            case 5: {
                c = 10;
                break;
            }
            default: {
                c = 65532;
            }
        }
        DispLine.PosnInfo findInfo = new DispLine.PosnInfo();
        eCaret = this.findPosition(oResult, findInfo);
        if (eCaret == 0 && !this.isEmptyPosition(oResult)) {
            c = 0;
        }
        return c;
    }

    DispLine.PosnInfo getCaretGlyph(int nCharIndex, int nStreamOffset, int eAffinity) {
        DispLine.PosnInfo result = new DispLine.PosnInfo();
        if (nCharIndex >= this.getCharCount()) {
            int nIndex = this.getGlyphCount() - 1;
            GlyphLoc oGlyphLoc = this.getGlyphLoc(nIndex);
            result.index = oGlyphLoc.getGlyphIndex();
            Glyph oGlyph = this.getGlyph(result.index);
            if (oGlyph.isRTL()) {
                oGlyphLoc = this.getMappedGlyphLoc(this.getCharCount() - 1);
                result.index = oGlyphLoc.getGlyphIndex();
                result.auxInfo = 0;
            } else {
                result.auxInfo = 100;
            }
        } else {
            int nCharInner = 0;
            if (nStreamOffset > 0) {
                this.charToStreamInfo(nCharIndex, result);
                if (nStreamOffset > result.auxInfo) {
                    nStreamOffset = result.auxInfo;
                }
                if (result.auxInfo <= 1) {
                    nCharInner = 100;
                } else {
                    double nRatio = (double)(nStreamOffset - 1) / (double)(result.auxInfo - 1);
                    nCharInner = (int)Math.round(100.0 * (2.0 + nRatio) / 3.0);
                }
            } else if (eAffinity == 1 && nCharIndex > 0) {
                GlyphLoc oGlyphLoc = this.getMappedGlyphLoc(nCharIndex);
                result.index = oGlyphLoc.getGlyphIndex();
                Glyph oGlyph = this.getGlyph(result.index);
                GlyphLoc oPrevGlyphLoc = this.getMappedGlyphLoc(nCharIndex - 1);
                Glyph oPrevGlyph = this.getGlyph(oPrevGlyphLoc.getGlyphIndex());
                if (oGlyph.isRTL() != oPrevGlyph.isRTL()) {
                    --nCharIndex;
                    nCharInner = 100;
                }
            }
            result.index = nCharIndex;
            result.auxInfo = nCharInner;
        }
        return result;
    }

    void checkAXTELigature(TextPosnBase oPosn, boolean bForward) {
        DispLine.PosnInfo info = new DispLine.PosnInfo();
        int eCaret = this.findPosition(oPosn, info);
        if (eCaret == 0) {
            return;
        }
        if (info.auxInfo == 0) {
            return;
        }
        DispPosn oMapPosn = this.getMappedPosition(info.index);
        if (bForward) {
            oPosn.index(oMapPosn.pp().index() + oMapPosn.getStreamCount());
        } else {
            oPosn.index(oMapPosn.pp().index());
        }
    }

    LineHeight dispHeight() {
        return this.moHeight;
    }

    boolean isAtStart(TextPosnBase oPosn) {
        TextPosnBase oResult = new TextPosnBase();
        if (this.getCaretStartEnd(oPosn.stream(), false, false, oResult) == 0) {
            return false;
        }
        oResult.tighten(true);
        TextPosnBase oCurrent = new TextPosnBase(oPosn);
        oCurrent.tighten(true);
        return oCurrent.stream() == oResult.stream() && oCurrent.index() == oResult.index();
    }

    void fill(DispLineRaw poSource, int nStart, int nLength) {
        TextAttr poTrailingAttr;
        int nVisual;
        TextAttr poStartAttr = null;
        boolean bHasObjects = false;
        int n = nVisual = nLength > this.moLineDesc.mnTrailingSpaces ? nLength - this.moLineDesc.mnTrailingSpaces : 0;
        if (nVisual < nLength && (poTrailingAttr = poSource.getMappedAttr(nStart + nVisual)) != null && poTrailingAttr.invisibleEnable() && poTrailingAttr.invisible() && poTrailingAttr.invisChar() != '\u0000') {
            nVisual = nLength;
        }
        if (nLength == 0) {
            TextAttr poStartAttr2 = this.getLastAttr();
            if (poStartAttr2 != null) {
                this.moHeight.accumulate(poStartAttr, poStartAttr2.layoutOrientation() == 0 ? 0 : 1, this.isFirstLineInStream());
            }
            if (this.mpoExtra == null || this.mpoExtra.mpoEmptyPosn == null) {
                this.needExtra();
                this.mpoExtra.mpoEmptyPosn = new TextPosn();
            }
            this.mpoExtra.mpoEmptyPosn.associate(this.stream(), Integer.MAX_VALUE, 1);
        } else {
            if (this.mpoExtra != null) {
                this.mpoExtra.mpoEmptyPosn = null;
            }
            this.preAllocChars(nLength);
            DispPosn oParentStart = poSource.getMappedPosition(nStart);
            int nIndex = DispLineWrapped.charToStreamIndex(oParentStart, nStart, 0);
            DispPosn oInitialPosn = new DispPosn(oParentStart.pp().stream(), nIndex, oParentStart.pp().position());
            oInitialPosn.setStreamCount(oParentStart.getStreamCount());
            WrappedSpan oPosition = new WrappedSpan(this, poSource.getPositionMap(), nStart, nLength, oInitialPosn);
            WrappedSpan oRun = new WrappedSpan(this, poSource.getRunMap(), nStart, nLength, null);
            TextAttr poPrevAttr = null;
            boolean bHasSingleColour = true;
            boolean bHasDecoration = false;
            poStartAttr = oRun.r().getAttr();
            if (poStartAttr.charSpacingEnable() && poStartAttr.charSpacing().getLengthValue() != 0 || !poStartAttr.wordSpacingEnable() || poStartAttr.wordSpacing().getLengthValue() != 0) {
                // empty if block
            }
            if (oParentStart.getMapLength() == 0) {
                oPosition.update(nStart);
            }
            int nLimit = nStart + nLength;
            for (int i = nStart; i < nLimit; ++i) {
                DispEmbed poDispEMbed;
                int c = poSource.getChar(i);
                int eBreak = poSource.getBreakData(i);
                if (this.moLineDesc.meJustifyH == 10) {
                    this.needExtra();
                    if (this.mpoExtra.mnRadixCharIndex == Integer.MAX_VALUE && poStartAttr != null) {
                        if (!this.legacyPositioning() && poStartAttr.radixPos() != Integer.MAX_VALUE) {
                            if (i == poStartAttr.radixPos()) {
                                this.mpoExtra.mnRadixCharIndex = this.getCharCount();
                            }
                        } else if (c == poStartAttr.radixChar()) {
                            this.mpoExtra.mnRadixCharIndex = this.getCharCount();
                        }
                    }
                    if (TextCharProp.getBreakClass(eBreak) == 24) {
                        this.mpoExtra.mnLastDigitIndex = this.getCharCount();
                    }
                }
                oPosition.update(i);
                oRun.update(i);
                if (Decoration.hasDecoration(oRun.r().getAttr())) {
                    bHasDecoration = true;
                }
                if ((poDispEMbed = poSource.isObject(i)) != null) {
                    this.add(new DispEmbed(poDispEMbed), this.getCharCount());
                    bHasObjects = true;
                    if (poSource.tabAt(i) != null) {
                        this.moHeight.accumulate(oRun.r().getAttr(), oRun.r().glyphOrientation(), this.isFirstLineInStream());
                    } else {
                        TextEmbed poEmbed = poDispEMbed.getEmbed();
                        if (poEmbed.enforceHeight()) {
                            this.moHeight.cancelOverride();
                        }
                        UnitSpan oHeight = poEmbed.height();
                        if (poEmbed.embedAt() == 2) {
                            this.moHeight.accumulateSize(oHeight);
                        } else {
                            this.moHeight.accumulateAscent(oHeight);
                        }
                    }
                } else {
                    this.moHeight.accumulate(oRun.r().getAttr(), oRun.r().glyphOrientation(), this.isFirstLineInStream());
                }
                this.addChar(c, eBreak);
                TextAttr poThisAttr = oRun.r().getAttr();
                if (poThisAttr != poPrevAttr && poThisAttr != null && poPrevAttr != null) {
                    if (DispLineWrapped.testColourChange(poPrevAttr, poThisAttr)) {
                        bHasSingleColour = false;
                    }
                    if (poThisAttr.charSpacingEnable() && poThisAttr.charSpacing().getLengthValue() != 0 || !poThisAttr.wordSpacingEnable() || poThisAttr.wordSpacing().getLengthValue() != 0) {
                        // empty if block
                    }
                }
                poPrevAttr = poThisAttr;
            }
            oPosition.finish();
            oRun.finish();
            this.reconcileBaselineShifts();
            this.setHasDecoration(bHasDecoration);
            this.setHasSingleColour(bHasSingleColour);
            TextSparseStream poRootStream = this.frame().getStream();
            TextStream poLastStream = this.getPosition(this.getPositionCount() - 1).pp().stream();
            if (poLastStream != poRootStream) {
                DispPosn oPath = new DispPosn();
                poLastStream.isDescendentOf(poRootStream, oPath.pp());
                oPath.pp().position(1);
                oPath.pp().nextUserPosn();
                if (!oPath.pp().nextUserPosn()) {
                    this.add(oPath, this.getCharCount(), 0);
                }
            }
        }
        this.setVisualCharCount(nVisual);
        this.recordStartAttr(poStartAttr);
        this.format(poSource, nStart);
        if (bHasObjects) {
            for (int i = 0; i < this.getGlyphCount(); ++i) {
                GlyphLoc oGlyphLoc = this.getGlyphLoc(i);
                int nCharIndex = oGlyphLoc.getMapIndex();
                DispEmbed poDispEmbed = this.isObject(nCharIndex);
                if (poDispEmbed == null || this.tabAt(nCharIndex) == null) continue;
                this.setChar(nCharIndex, 9, TextCharProp.defaultSpace);
            }
        }
        this.moHeight.reconcile();
        float oRawWidth = this.moLineDesc.moMarginL + this.moLineDesc.moSpecial + this.moRawWidth + this.moLineDesc.moMarginR;
        this.moJFRawWidth = Units.forceInt(oRawWidth);
        Rect oExtent = this.getABLineExtent();
        this.moBMinExtended = Units.toInt(oExtent.top());
        this.moBMaxExtended = Units.toInt(oExtent.bottom());
        UnitSpan oExtendedHeight = Units.toUnitSpan(this.moBMaxExtended - this.moBMinExtended);
        if (this.isFirstLineInStream() && this.moHeight.adjustLineSpacing(oExtent.top())) {
            this.moBMinExtended = 0;
            this.moBMaxExtended = Units.toInt(oExtendedHeight);
        }
    }

    void compose(TextLayout poLayout, boolean bAllowCharGlyphs) {
        UnitSpan oHeight = this.getBExtent();
        UnitSpan oAscent = Units.toUnitSpan(this.moHeight.textOffset(0));
        UnitSpan oDescent = oHeight.subtract(oAscent);
        LayoutRenderer oRenderer = new LayoutRenderer(poLayout, this, oAscent, oDescent, bAllowCharGlyphs);
        UnitSpan oLargeNeg = new UnitSpan(3, -16777215);
        UnitSpan oLargePos = new UnitSpan(3, 0xFFFFFF);
        Rect oInvalid = new Rect(oLargeNeg, oLargeNeg, oLargePos, oLargePos);
        TextDrawInfo oDrawInfo = new TextDrawInfo(oRenderer);
        DrawParm oParm = new DrawParm(oDrawInfo);
        oParm.setDriver(oRenderer.driver());
        oParm.setInvalid(oInvalid);
        this.gfxDraw(oParm);
        oRenderer.finish();
    }

    @Override
    void clear() {
        super.clear();
        this.moMaps.clear();
        this.moHeight.detach();
        this.mpoStartAttr = null;
        this.moAMin = 0.0f;
        this.moAMax = 0.0f;
        this.moAMaxExtended = 0.0f;
        this.moJFAMin = 0;
        this.moJFAMax = 0;
        this.moJFAMaxExtended = 0;
        this.moBMin = 0;
        this.moBMinExtended = 0;
        this.moBMaxExtended = 0;
        this.moRawWidth = 0.0f;
        this.moRawWidthFull = 0.0f;
        this.moXYOrigin = CoordPair.zeroZero();
        this.moHeight.reset();
        for (int i = 0; i < this.moCharRanges.size(); ++i) {
            CharRange oRange = (CharRange)this.moCharRanges.get(i);
            oRange.moMinX = CHAR_RANGE_DEFAULT;
            oRange.moMaxX = CHAR_RANGE_DEFAULT;
            oRange.mpoNext = null;
        }
        if (this.mpoExtra != null) {
            this.mpoExtra.clear();
        }
    }

    void textDebug(int lineNumber) {
        TextContext context = this.display().getContext();
        if (context.debug()) {
            int i;
            StringBuilder output = new StringBuilder(Integer.toString(lineNumber));
            output.append(": Line left: ");
            output.append(this.getAMin().toString());
            output.append(", right: ");
            output.append(this.getAMax().toString());
            output.append(", top: ");
            output.append(this.getBMin().toString());
            output.append(", bottom: ");
            output.append(this.getBMax().toString());
            output.append(", objects: ");
            output.append(Integer.toString(this.getEmbedCount()));
            output.append(", characters: ");
            output.append(Integer.toString(this.getCharCount()));
            context.debug(output.toString());
            for (i = 0; i < this.getEmbedCount(); ++i) {
                output.delete(0, output.length());
                DispEmbed oMapEmbed = this.getEmbed(i);
                TextEmbed poEmbed = oMapEmbed.getEmbed();
                output.append("  Object ");
                output.append(Integer.toString(i));
                output.append(": width: ");
                output.append(poEmbed.width().toString());
                output.append(", height: ");
                output.append(poEmbed.height().toString());
                context.debug(output.toString());
            }
            output.delete(0, output.length());
            output.append("  Text: ");
            for (i = 0; i < this.getCharCount(); ++i) {
                int c = this.getChar(i);
                if (c >= 32 && c < 127) {
                    output.append((char)c);
                    continue;
                }
                output.append(Units.hexToString(c));
            }
            context.debug(output.toString());
            for (i = 0; i < this.getGlyphCount(); ++i) {
                output.delete(0, output.length());
                Glyph oGlyph = this.getGlyph(i);
                GlyphLoc oGlyphLoc = this.getOrderedGlyphLoc(i);
                String sTypeface = "?";
                String sEncoding = "?";
                TextAttr poAttr = this.getMappedAttr(oGlyphLoc.getMapIndex());
                if (poAttr != null) {
                    sTypeface = poAttr.typeface();
                    sEncoding = poAttr.encoding();
                }
                int milliPointOffset = Units.toInt(oGlyph.getDrawX(this));
                UnitSpan unitOffset = new UnitSpan(19, milliPointOffset);
                int milliPointWidth = Units.toInt(oGlyph.getDrawNextX(this) - oGlyph.getDrawX(this));
                UnitSpan unitWidth = new UnitSpan(19, milliPointWidth);
                output.append("   Glyph: ");
                output.append(Integer.toString(oGlyph.getGlyph()));
                output.append(", index: ");
                output.append(Integer.toString(oGlyphLoc.getMapIndex()));
                output.append(" (");
                output.append(Integer.toString(oGlyphLoc.getMapLength()));
                output.append("), x: ");
                output.append(unitOffset.toString());
                output.append(", width: ");
                output.append(unitWidth.toString());
                output.append(", font: ");
                output.append(sTypeface);
                output.append(" (");
                output.append(sEncoding);
                output.append(")");
                context.debug(output.toString());
            }
        }
    }

    private void needExtra() {
        if (this.mpoExtra == null) {
            this.mpoExtra = new Extra();
        }
    }

    private boolean isEmptyPosition(TextPosnBase oPosn) {
        return this.getPositionCount() == 0 && this.mpoExtra != null && this.mpoExtra.mpoEmptyPosn != null && oPosn.stream() == this.mpoExtra.mpoEmptyPosn.stream() && oPosn.index() == this.mpoExtra.mpoEmptyPosn.index();
    }

    private void format(DispLineRaw poSourceLine, int nCharOffset) {
        DispMapSet maps = this.getMaps();
        FormatInfo formatInfo = poSourceLine.getFormatInfo();
        MappingManager mappingManager = formatInfo.getMappingManager();
        AFERun afeRun = formatInfo.getAFERun();
        int glyphCount = this.getCharCount();
        int glyphOffset = nCharOffset;
        if (mappingManager != null) {
            mappingManager.applyToWrappedLine(this, afeRun, nCharOffset);
        }
        if (poSourceLine.getGlyphLocMap() != null && poSourceLine.getGlyphLocMap().size() > 0 && maps.moGlyphLocMap != null && maps.moGlyphLocMap.size() > 0) {
            glyphCount = maps.moGlyphLocMap.size();
            glyphOffset = poSourceLine.getGlyphLocMap().findItem(nCharOffset);
        }
        this.preAllocGlyphs(glyphCount, false);
        if (mappingManager != null) {
            this.populateGlyphLocOrder(glyphCount);
        }
        DispLine.GlyphMaker glyphMaker = new DispLine.GlyphMaker(this);
        assert (afeRun != null);
        for (int i = 0; i < glyphCount; ++i) {
            int glyphLocIndex = this.getGlyphLocOrder(i);
            GlyphLoc glyphLoc = this.getGlyphLoc(glyphLocIndex);
            AFEElement afeElement = afeRun.getElement(glyphLocIndex + glyphOffset);
            glyphMaker.addGlyph(afeElement, glyphLoc.getMapIndex());
        }
        glyphMaker.applyWidths();
        this.moRawWidth = this.getWidth() - this.getTrailingWidth();
        this.moRawWidthFull = this.getWidth();
    }

    private void populateGlyphLocOrder(int glyphCount) {
        if (this.getGlyphLocMap().size() > 0) {
            this.allocateGlyphLocOrder(glyphCount);
            for (int i = 0; i < glyphCount; ++i) {
                this.setGlyphLocOrder(this.getGlyphLoc(i).getGlyphIndex(), i);
            }
        }
    }

    private boolean diffGlyphs(DispLineWrapped poCompare, int nThisIndex, int nCompareIndex) {
        boolean bCompareVisual;
        TextAttr poCompareAttr;
        Glyph oThisGlyph = this.getGlyph(nThisIndex);
        Glyph oCompareGlyph = poCompare.getGlyph(nCompareIndex);
        if (oThisGlyph.getGlyph() != oCompareGlyph.getGlyph() || oThisGlyph.getDrawX(this) + this.moAMin != oCompareGlyph.getDrawX(poCompare) + poCompare.moAMin || oThisGlyph.getDrawY(this) != oCompareGlyph.getDrawY(poCompare)) {
            return true;
        }
        GlyphLoc oThisGlyphLoc = this.getOrderedGlyphLoc(nThisIndex);
        GlyphLoc oCompareGlyphLoc = poCompare.getOrderedGlyphLoc(nCompareIndex);
        int nThisRunIndex = this.getRunMap().findItem(oThisGlyphLoc.getMapIndex());
        int nCompareRunIndex = poCompare.getRunMap().findItem(oCompareGlyphLoc.getMapIndex());
        TextAttr poThisAttr = this.getRun(nThisRunIndex).getAttr();
        if (poThisAttr != (poCompareAttr = poCompare.getRun(nCompareRunIndex).getAttr())) {
            if (poThisAttr == null || poCompareAttr == null) {
                return true;
            }
            if (!poThisAttr.equals(poCompareAttr)) {
                return true;
            }
        }
        if (poThisAttr == null) {
            return false;
        }
        if (oThisGlyphLoc.getMapLength() > 1) {
            return false;
        }
        boolean bThisVisual = this.isVisualChar(oThisGlyphLoc.getMapIndex());
        if (bThisVisual == (bCompareVisual = poCompare.isVisualChar(oCompareGlyphLoc.getMapIndex()))) {
            return false;
        }
        return GFXDecorationInfo.extractDecoration(poThisAttr.underline()) != GFXDecorationInfo.decorateNone || GFXDecorationInfo.extractDecoration(poThisAttr.strikeout()) != GFXDecorationInfo.decorateNone || GFXDecorationInfo.extractDecoration(poThisAttr.overline()) != GFXDecorationInfo.decorateNone;
    }

    private Rect getABLineExtent() {
        DispRect oExtent = null;
        oExtent = this.getGlyphCount() > 0 ? this.getABSubExtent(0, this.getGlyphCount() - 1) : new DispRect();
        oExtent.yMin = Units.toFloat(this.getBMin());
        oExtent.yMax = Units.toFloat(this.getBMax());
        UnitSpan oLeft = Units.toUnitSpan(oExtent.xMin);
        UnitSpan oTop = Units.toUnitSpan(oExtent.yMin);
        UnitSpan oRight = Units.forceUnitSpan(oExtent.xMax);
        UnitSpan oBottom = Units.forceUnitSpan(oExtent.yMax);
        if (this.getAMin().lt(oLeft)) {
            oLeft = this.getAMin();
        }
        if (this.getAMax().gt(oRight)) {
            oRight = this.getAMax();
        }
        return new Rect(oLeft, oTop, oRight, oBottom);
    }

    private DispRect getABSubExtent(int nFirst, int nLast) {
        float oBMax;
        DispRect oExtent = new DispRect();
        boolean bFirst = true;
        float oHorzOffset = Units.toFloat(this.moHeight.textOffset(0));
        float oVertOffset = Units.toFloat(this.moHeight.textOffset(1));
        for (int i = nFirst; i <= nLast; ++i) {
            Glyph oGlyph = this.getGlyph(i);
            float oX = oGlyph.getDrawX(this);
            float oNextX = oGlyph.getDrawNextX(this);
            float oY = oGlyph.getDrawY(this);
            DispRect oGlyphExtent = this.getABGlyphBBox(i, true);
            oGlyphExtent.xMin = oGlyphExtent.xMin >= 0.0f ? oX : (oGlyphExtent.xMin += oX);
            oGlyphExtent.xMax += oX;
            if (oGlyphExtent.xMax < oNextX) {
                oGlyphExtent.xMax = oNextX;
            }
            oY = GFXGlyphOrientation.usesHorizontalGlyphs(oGlyph.getOrientation()) ? (oY += oHorzOffset) : (oY += oVertOffset);
            oGlyphExtent.yMin += oY;
            oGlyphExtent.yMax += oY;
            if (bFirst) {
                oExtent.xMin = oGlyphExtent.xMin;
                oExtent.yMin = oGlyphExtent.yMin;
                oExtent.xMax = oGlyphExtent.xMax;
                oExtent.yMax = oGlyphExtent.yMax;
                bFirst = false;
                continue;
            }
            if (oGlyphExtent.xMin < oExtent.xMin) {
                oExtent.xMin = oGlyphExtent.xMin;
            }
            if (oGlyphExtent.yMin < oExtent.yMin) {
                oExtent.yMin = oGlyphExtent.yMin;
            }
            if (oGlyphExtent.xMax > oExtent.xMax) {
                oExtent.xMax = oGlyphExtent.xMax;
            }
            if (!(oGlyphExtent.yMax > oExtent.yMax)) continue;
            oExtent.yMax = oGlyphExtent.yMax;
        }
        oExtent.xMin += this.moAMin;
        oExtent.xMax += this.moAMin;
        if (oExtent.yMin > 0.0f) {
            oExtent.yMin = 0.0f;
        }
        if (oExtent.yMax < (oBMax = Units.toFloat(this.getBExtent()))) {
            oExtent.yMax = oBMax;
        }
        return oExtent;
    }

    private float getCharOffset(int nPositionIndex, int nCharIndex, int nStreamOffset, int eAffinity) {
        float oX;
        int nActualChar = nCharIndex;
        int nActualStream = nStreamOffset;
        if (eAffinity == 1) {
            if (nStreamOffset > 0) {
                --nActualStream;
            } else if (nCharIndex > 0) {
                --nActualChar;
                nActualStream = 0;
                boolean bBackupPosition = false;
                if (nPositionIndex >= this.getPositionCount()) {
                    bBackupPosition = true;
                } else {
                    DispPosn oPosition = this.getPosition(nPositionIndex);
                    if (nActualChar < oPosition.getMapIndex()) {
                        bBackupPosition = true;
                    }
                }
                if (bBackupPosition) {
                    assert (nPositionIndex > 0);
                    DispPosn oPrevPosition = this.getPosition(nPositionIndex - 1);
                    if (DispLineWrapped.getPositionType(oPrevPosition) == 2) {
                        nActualStream = oPrevPosition.getStreamCount() - 1;
                    }
                }
            } else {
                eAffinity = 0;
            }
        }
        if (this.moCharRanges == null) {
            this.moCharRanges = new Storage();
        }
        if (nActualChar >= this.moCharRanges.size()) {
            int oldSize = this.moCharRanges.size();
            this.moCharRanges.setSize(this.getCharCount() + 1);
            int newSize = this.moCharRanges.size();
            for (int i = oldSize; i < newSize; ++i) {
                this.moCharRanges.set(i, new CharRange());
            }
        }
        CharRange poRange = (CharRange)this.moCharRanges.get(nActualChar);
        while (nActualStream > 0) {
            CharRange poNext = poRange.mpoNext;
            if (poNext == null) {
                poRange.mpoNext = poNext = new CharRange();
            }
            poRange = poNext;
            --nActualStream;
        }
        boolean useMax = eAffinity == 1;
        float f = oX = useMax ? poRange.moMaxX : poRange.moMinX;
        if (!CharRange.isInitialized(oX)) {
            oX = 0.0f;
            if (this.getGlyphCount() == 0) {
                oX = this.moAMin;
            } else {
                DispLine.PosnInfo posnInfo = this.getCaretGlyph(nCharIndex, nStreamOffset, eAffinity);
                Glyph oGlyph = this.getGlyph(posnInfo.index);
                oX = posnInfo.auxInfo >= 100 ? oGlyph.getOriginalNextX() : oGlyph.getOriginalX() + oGlyph.getWidth(this) * (float)posnInfo.auxInfo / 100.0f;
                oX += oGlyph.getOffsetX(this) + this.moAMin;
                if (useMax) {
                    poRange.moMaxX = oX;
                } else {
                    poRange.moMinX = oX;
                }
            }
        }
        return oX;
    }

    private void getRenderChar(TextAttr poAttr, FontInstance oFontInstance, GlyphLoc oGlyphLoc, Glyph oGlyph, RenderGlyph oRenderGlyph) {
        oRenderGlyph.mnGlyphID = oGlyph.getGlyph();
        oRenderGlyph.mcGlyph = 0;
        if (oGlyphLoc.getMapLength() == 1 && !oGlyph.isInMultiple() && !oGlyph.isAXTELigature()) {
            oRenderGlyph.mcGlyph = this.getChar(oGlyphLoc.getMapIndex());
        }
        if (oFontInstance == null) {
            return;
        }
        FontItem poFontItem = oFontInstance.getFontItem();
        if (poFontItem == null) {
            return;
        }
        if (oGlyphLoc.getMapLength() == 1 && this.tabAt(oGlyphLoc.getMapIndex()) != null) {
            oRenderGlyph.mcGlyph = 32;
        }
        if (DispLineWrapped.isUnicodeFont(poAttr)) {
            oRenderGlyph.mcGlyph = 0;
            return;
        }
        if (oGlyphLoc.getMapLength() > 1) {
            oRenderGlyph.mcGlyph = 0;
            return;
        }
        if (oRenderGlyph.mcGlyph < 48 || oRenderGlyph.mcGlyph <= 57) {
            // empty if block
        }
        if (oRenderGlyph.mnGlyphID == poFontItem.getNotDefGlyphID()) {
            return;
        }
        if (oGlyph.renderByGlyphID()) {
            oRenderGlyph.mcGlyph = 0;
            return;
        }
    }

    private boolean renderTabLeader(DrawParm oParm, DispTab poDispTab, GlyphLoc poGlyphLoc, DrawAttr oDrawAttr, DrawRun oRun) {
        int nCharIndex = poGlyphLoc.getMapIndex();
        TextAttr poAttr = this.getMappedAttr(nCharIndex);
        if (poAttr == null || !poAttr.leaderPatternEnable()) {
            return true;
        }
        switch (poAttr.leaderPattern()) {
            case 1: {
                LeaderRule oFiller = new LeaderRule(oParm, oDrawAttr);
                return this.renderTabLeader(oFiller, poAttr, poDispTab, poGlyphLoc, oRun);
            }
            case 2: 
            case 3: {
                LeaderContent oFiller = new LeaderContent(oParm, nCharIndex);
                return this.renderTabLeader(oFiller, poAttr, poDispTab, poGlyphLoc, oRun);
            }
        }
        return true;
    }

    private boolean renderTabLeader(LeaderFill oFiller, TextAttr poAttr, DispTab poDispTab, GlyphLoc poGlyphLoc, DrawRun oRun) {
        if (!oFiller.setup(this, poAttr, poDispTab, poGlyphLoc)) {
            return true;
        }
        oRun.flush();
        return oFiller.render();
    }

    private void reconcileBaselineShifts() {
        if (this.moHeight.hasBaselineShift()) {
            for (int i = 0; i < this.getCharCount(); ++i) {
                if (this.isObject(i) != null) continue;
                DispRun oRun = this.getMappedRun(i);
                this.moHeight.accumulateBaselineShift(oRun.getAttr());
            }
        }
    }

    private void recordStartAttr(TextAttr poStartAttr) {
        if (poStartAttr != null) {
            if (this.isFirstParaLine() && poStartAttr.spaceBeforeEnable()) {
                this.moHeight.before(Units.toInt(poStartAttr.spaceBefore().getLength()));
            }
            if (this.isLastParaLine() && poStartAttr.spaceAfterEnable()) {
                this.moHeight.accumulateAfter(poStartAttr.spaceAfter().getLength());
            }
            this.mpoStartAttr = poStartAttr;
        }
    }

    private static boolean testColourChange(TextAttr poPrevAttr, TextAttr poThisAttr) {
        if (poPrevAttr == poThisAttr || poPrevAttr == null || poThisAttr == null) {
            return false;
        }
        if (poThisAttr.colourEnable() && poPrevAttr.colourEnable() && !poThisAttr.colour().equals(poPrevAttr.colour())) {
            return true;
        }
        if (poThisAttr.colourBgEnable() && poPrevAttr.colourBgEnable() && !poThisAttr.colourBg().equals(poPrevAttr.colourBg())) {
            return true;
        }
        return poThisAttr.transparentEnable() && poPrevAttr.transparentEnable() && poThisAttr.transparent() != poPrevAttr.transparent();
    }

    private CharRange getCharRange(int index) {
        return (CharRange)this.moCharRanges.get(index);
    }

    private static class CombCell {
        final int mnCombiningSize;
        int mnBaseGlyphIndex;
        float moX;
        float moNextX;

        CombCell(int nCombiningSize) {
            this.mnCombiningSize = nCombiningSize;
        }
    }

    private static class HitTest {
        private final DispLineWrapped mpoLine;
        private final float moX;
        private final HitTestHit moResult = new HitTestHit();
        private final HitTestHit moTrailing = new HitTestHit();
        private final CaretInfo mCaretInfo = new CaretInfo();

        HitTest(DispLineWrapped poLine, TextStream poStream, float oX) {
            this.mpoLine = poLine;
            this.moX = oX;
        }

        void tryHit(int nGlyphLocIndex, DispPosn oPosition) {
            GlyphLoc oGlyphLoc = this.mpoLine.getGlyphLoc(nGlyphLocIndex);
            for (int i = 0; i <= oGlyphLoc.getMapLength(); ++i) {
                int nCharIndex = oGlyphLoc.getMapIndex() + i;
                DispLine.charToStreamInfo(oPosition, nCharIndex, this.mCaretInfo);
                for (int nStreamOffset = 0; nStreamOffset < this.mCaretInfo.auxInfo; ++nStreamOffset) {
                    this.tryHit(oGlyphLoc, oPosition, nCharIndex, nStreamOffset);
                }
            }
        }

        void tryHit(GlyphLoc oGlyphLoc, DispPosn oPosition, int nCharIndex, int nStreamOffset) {
            HitTestHit oHit = this.mpoLine.isValidPosition(nCharIndex) ? this.moResult : this.moTrailing;
            int nStreamIndex = DispLine.charToStreamIndex(oPosition, nCharIndex, nStreamOffset);
            TextPosnBase oPosn = new TextPosnBase(oPosition.pp().stream(), nStreamIndex);
            for (int nAffinity = 0; nAffinity < 2; ++nAffinity) {
                oPosn.affinity(nAffinity == 0 ? 1 : 0);
                int eCaret = this.mpoLine.getCaretRect(oPosn, true, this.mCaretInfo);
                if (eCaret == 0) continue;
                float oDelta = Units.toFloat(this.mCaretInfo.mCaret.left());
                if ((oDelta -= this.moX) < 0.0f) {
                    oDelta = -oDelta;
                }
                if (oHit.moPosn.stream() != null && !(oDelta < oHit.moBestDelta)) continue;
                oHit.moPosn.associate(oPosition.pp().stream(), nStreamIndex);
                oHit.moPosn.affinity(oPosn.affinity());
                oHit.moPosn.setRTL(this.mpoLine.getGlyph(oGlyphLoc.getGlyphIndex()).isRTL());
                oHit.moBestDelta = oDelta;
            }
        }

        boolean hasHit() {
            return this.moResult.moPosn.stream() != null || this.moTrailing.moPosn.stream() != null;
        }

        int reconcile(TextPosnBase oResult) {
            if (this.moResult.moPosn.stream() != null) {
                oResult.copyFrom(this.moResult.moPosn);
                return 2;
            }
            if (this.moTrailing.moPosn.stream() != null) {
                oResult.copyFrom(this.moTrailing.moPosn);
                return 1;
            }
            return 0;
        }

        private static class HitTestHit {
            final TextPosnBase moPosn = new TextPosnBase();
            float moBestDelta;

            private HitTestHit() {
            }
        }
    }

    private static class WrappedSpan
    extends DispMapSpan {
        private final DispMap moParentMap;
        private int mnParentMapIndex;
        private int mnParentCharStart;
        private int mnParentCharMax;
        private final int mnParentCharLimit;

        WrappedSpan(DispLineWrapped poLine, DispMap oParentMap, int nParentCharStart, int nParentCharLength, DispMapItem poInitial) {
            super(poLine);
            this.moParentMap = oParentMap;
            this.mnParentCharLimit = nParentCharStart + nParentCharLength;
            this.setup(nParentCharStart, poInitial);
        }

        void update(int nParentCharIndex) {
            if (nParentCharIndex >= this.mnParentCharMax) {
                this.flush();
                this.setup(nParentCharIndex, null);
            }
        }

        void finish() {
            this.flush();
        }

        private void setup(int nParentCharStart, DispMapItem poInitial) {
            this.mnParentCharStart = nParentCharStart;
            this.mnParentMapIndex = this.moParentMap.findItem(this.mnParentCharStart);
            assert (this.moParentMap.isValidMapIndex(this.mnParentMapIndex));
            DispMapItem oParentItem = this.moParentMap.getItem(this.mnParentMapIndex);
            if (poInitial == null) {
                this.copyFrom(oParentItem);
            } else {
                this.copyFrom(poInitial);
            }
            this.mnParentCharMax = oParentItem.getMapIndex() + oParentItem.getMapLength();
            if (this.mnParentCharMax > this.mnParentCharLimit) {
                this.mnParentCharMax = this.mnParentCharLimit;
            }
        }
    }

    private static class Extra {
        TextContext mpoContext;
        TextPosn mpoEmptyPosn;
        int[] mpcFlatText;
        int mnFlatLength;
        float moPrevSpreadInsert;
        int mnRadixCharIndex = Integer.MAX_VALUE;
        int mnLastDigitIndex = Integer.MAX_VALUE;

        Extra() {
        }

        void attachContext(TextContext poNewContext) {
            this.mpoContext = poNewContext;
        }

        void createFlatText(DispLineWrapped poLine) {
            int i;
            if (this.mpcFlatText != null) {
                return;
            }
            int nPositions = poLine.getPositionCount();
            int nChars = 0;
            for (i = 0; i < nPositions; ++i) {
                DispPosn oPosition = poLine.getPosition(i);
                nChars += DispLine.getPositionStreamCount(oPosition);
            }
            assert (nChars > 0);
            this.mpcFlatText = new int[nChars];
            this.mnFlatLength = nChars;
            int dest = 0;
            block5: for (i = 0; i < nPositions; ++i) {
                DispPosn oPosition = poLine.getPosition(i);
                switch (DispLine.getPositionType(oPosition)) {
                    case 1: {
                        int[] source = poLine.getCharArray();
                        int index = oPosition.getMapIndex();
                        int limit = index + oPosition.getMapLength();
                        while (index < limit) {
                            this.mpcFlatText[dest++] = source[index++];
                        }
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        TextPosnBase oSourcePosn = new TextPosnBase(oPosition.pp());
                        int nCopy = oPosition.getStreamCount();
                        while (nCopy-- > 0) {
                            this.mpcFlatText[dest++] = oSourcePosn.nextChar();
                        }
                        continue block5;
                    }
                    default: {
                        assert (false);
                        continue block5;
                    }
                }
            }
            assert (dest == this.mnFlatLength);
        }

        void clear() {
            this.mpoEmptyPosn = null;
            this.mpcFlatText = null;
            this.mnFlatLength = 0;
            this.moPrevSpreadInsert = 0.0f;
            this.mnRadixCharIndex = Integer.MAX_VALUE;
            this.mnLastDigitIndex = Integer.MAX_VALUE;
        }
    }

    static class CharRange {
        CharRange mpoNext;
        float moMinX;
        float moMaxX;

        CharRange() {
            this.mpoNext = null;
            this.moMinX = CHAR_RANGE_DEFAULT;
            this.moMaxX = CHAR_RANGE_DEFAULT;
        }

        CharRange(CharRange source) {
            this.moMinX = source.moMinX;
            this.moMaxX = source.moMaxX;
        }

        static boolean isInitialized(float oValue) {
            return oValue != CHAR_RANGE_DEFAULT;
        }
    }

    static class CaretInfo
    extends DispLine.PosnInfo {
        Rect mCaret;

        CaretInfo() {
        }
    }
}

