/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.formatting;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.UnitSpan;

public final class Margin
extends ProtoableNode {
    public Margin(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "margin", "margin", null, XFA.MARGINTAG, "margin");
    }

    @Override
    public Attribute defaultAttribute(int eTag) {
        return this.defaultAttributeImpl(eTag, null);
    }

    private Attribute defaultAttributeImpl(int eTag, CachedInfo oCachedInfo) {
        if (eTag == XFA.LEFTINSETTAG || eTag == XFA.TOPINSETTAG || eTag == XFA.RIGHTINSETTAG || eTag == XFA.BOTTOMINSETTAG) {
            int ePlacement;
            Element poMargin;
            Element poCurrentUI;
            Element poUI;
            Element poContainer;
            Element oParent = this.getXFAParent();
            if (oParent != null && (oParent.getClassTag() == XFA.TEXTEDITTAG || oParent.getClassTag() == XFA.NUMERICEDITTAG || oParent.getClassTag() == XFA.DATETIMEEDITTAG || oParent.getClassTag() == XFA.SIGNATURETAG || oParent.getClassTag() == XFA.PASSWORDEDITTAG || oParent.getClassTag() == XFA.CHOICELISTTAG)) {
                Element poBorder;
                boolean bAutoCalculateMargins;
                boolean bl = bAutoCalculateMargins = !this.isDefault(true);
                if (bAutoCalculateMargins && (poBorder = oParent.getElement(XFA.BORDERTAG, true, 0, false, false)) != null) {
                    int eBorderPresence;
                    boolean bIgnorePresence = this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_POSITIONING);
                    int n = eBorderPresence = bIgnorePresence ? 1076494336 : poBorder.getEnum(XFA.PRESENCETAG);
                    if (eBorderPresence != 1076494338 && eBorderPresence != 1076494339) {
                        boolean bIs3D = this.is3D(poBorder);
                        boolean bParentHasComb = oParent.isSpecified(XFA.COMBTAG, true, 0);
                        UnitSpan oThickness = UnitSpan.ZERO;
                        int nEdge = 0;
                        if (eTag == XFA.TOPINSETTAG) {
                            nEdge = 0;
                        } else if (eTag == XFA.RIGHTINSETTAG) {
                            nEdge = 1;
                        } else if (eTag == XFA.BOTTOMINSETTAG) {
                            nEdge = 2;
                        } else if (eTag == XFA.LEFTINSETTAG) {
                            nEdge = 3;
                        }
                        for (int nCacheLoop = nEdge; nCacheLoop < 4; ++nCacheLoop) {
                            int ePresence;
                            oThickness = UnitSpan.ZERO;
                            Element poEdge = poBorder.getElement(XFA.EDGETAG, true, nCacheLoop, true, false);
                            int n2 = ePresence = bIgnorePresence ? 1076494336 : poEdge.getEnum(XFA.PRESENCETAG);
                            if (ePresence != 1076494338 && ePresence != 1076494339) {
                                Element poContainer2;
                                Element poUI2;
                                oThickness = ((Measurement)poEdge.getAttribute(XFA.THICKNESSTAG)).getUnitSpan();
                                if (!bParentHasComb) {
                                    oThickness = oThickness.multiply(2.0);
                                }
                                if (bIs3D) {
                                    oThickness = oThickness.multiply(2.0);
                                }
                                if (nCacheLoop == 0 && (poUI2 = oParent.getXFAParent()) != null && ((poContainer2 = poUI2.getXFAParent()) instanceof Field || poContainer2 instanceof Draw)) {
                                    Element poFont = poContainer2.getElement(XFA.FONTTAG, true, 0, true, false);
                                    UnitSpan oFontSize = ((Measurement)poFont.getAttribute(XFA.SIZETAG)).getUnitSpan();
                                    oFontSize = oFontSize.divide(4);
                                    oThickness = oThickness.add(oFontSize);
                                }
                            }
                            if (oCachedInfo == null) {
                                return new Measurement(oThickness);
                            }
                            oCachedInfo.mbThicknessesValid = true;
                            oCachedInfo.moThicknesses[nCacheLoop] = oThickness;
                        }
                        return new Measurement(oCachedInfo.moThicknesses[nEdge]);
                    }
                }
            } else if (!(oParent == null || oParent.getClassTag() != XFA.CAPTIONTAG || !((poContainer = oParent.getXFAParent()) instanceof Field) && !(poContainer instanceof Draw) || (poUI = poContainer.getElement(XFA.UITAG, true, 0, false, false)) == null || (poCurrentUI = (Element)poUI.getOneOfChild(true, false)) == null || poCurrentUI.getClassTag() != XFA.TEXTEDITTAG && poCurrentUI.getClassTag() != XFA.NUMERICEDITTAG && poCurrentUI.getClassTag() != XFA.DATETIMEEDITTAG && poCurrentUI.getClassTag() != XFA.SIGNATURETAG && poCurrentUI.getClassTag() != XFA.PASSWORDEDITTAG && poCurrentUI.getClassTag() != XFA.CHOICELISTTAG || (poMargin = poCurrentUI.getElement(XFA.MARGINTAG, true, 0, false, false)) == null || ((ePlacement = oParent.getEnum(XFA.PLACEMENTTAG)) != 0x400003 && ePlacement != 0x400001 || eTag != XFA.TOPINSETTAG && eTag != XFA.BOTTOMINSETTAG) && (ePlacement != 0x400000 && ePlacement != 0x400002 || eTag != XFA.LEFTINSETTAG && eTag != XFA.RIGHTINSETTAG))) {
                return poMargin.getAttribute(eTag);
            }
        }
        return super.defaultAttribute(eTag);
    }

    boolean is3D(Element oNode) {
        int eEdgeStroke;
        boolean bFailed = false;
        boolean bFirst = true;
        int eCurrentStroke = eEdgeStroke = 0x330000;
        int ePresence = 1076494336;
        block0: for (int i = 0; i < 4 && !bFailed; ++i) {
            Element oEdge = oNode.peekElement(XFA.EDGETAG, false, i);
            Element oCorner = oNode.peekElement(XFA.CORNERTAG, false, i);
            Element oTest = oEdge;
            for (int j = 0; j < 2; ++j) {
                Measurement oRadius;
                if (oTest != null && (ePresence = oTest.getEnum(XFA.PRESENCETAG)) == 1076494336) {
                    eEdgeStroke = oTest.getEnum(XFA.STROKETAG);
                    if (bFirst) {
                        eCurrentStroke = eEdgeStroke;
                        bFirst = false;
                    } else if (eEdgeStroke != eCurrentStroke) {
                        bFailed = true;
                        continue block0;
                    }
                }
                if (oCorner != null && ((oRadius = (Measurement)oCorner.peekAttribute(XFA.RADIUSTAG)) == null || oRadius.getValue() == 0.0)) continue block0;
                oTest = oCorner;
            }
        }
        return !bFailed && (eEdgeStroke == 0x330006 || eEdgeStroke == 0x330005 || eEdgeStroke == 0x330004 || eEdgeStroke == 0x330003);
    }

    @Override
    public boolean isContextSensitiveAttribute(int eTag) {
        return eTag == XFA.LEFTINSETTAG || eTag == XFA.RIGHTINSETTAG || eTag == XFA.TOPINSETTAG || eTag == XFA.BOTTOMINSETTAG || super.isContextSensitiveAttribute(eTag);
    }

    public void getInsets(ObjectHolder<UnitSpan> oTHolder, ObjectHolder<UnitSpan> oRHolder, ObjectHolder<UnitSpan> oBHolder, ObjectHolder<UnitSpan> oLHolder) {
        CachedInfo oCache = new CachedInfo();
        int[] eTags = new int[]{XFA.TOPINSETTAG, XFA.RIGHTINSETTAG, XFA.BOTTOMINSETTAG, XFA.LEFTINSETTAG};
        UnitSpan[] oResults = new UnitSpan[]{UnitSpan.ZERO, UnitSpan.ZERO, UnitSpan.ZERO, UnitSpan.ZERO};
        for (int nEdge = 0; nEdge < 4; ++nEdge) {
            Attribute oAttr = this.getAttribute(eTags[nEdge], true, false);
            Measurement oM = null;
            if (oAttr == null) {
                if (oCache.mbThicknessesValid) {
                    oResults[nEdge] = oCache.moThicknesses[nEdge];
                    continue;
                }
                oM = new Measurement(this.defaultAttributeImpl(eTags[nEdge], oCache));
            } else {
                oM = new Measurement(oAttr);
            }
            oResults[nEdge] = oM.getUnitSpan();
        }
        oTHolder.value = oResults[0];
        oRHolder.value = oResults[1];
        oBHolder.value = oResults[2];
        oLHolder.value = oResults[3];
    }

    private static class CachedInfo {
        boolean mbThicknessesValid;
        final UnitSpan[] moThicknesses = new UnitSpan[4];

        private CachedInfo() {
        }
    }
}

