/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.DateTimeValue;
import com.adobe.xfa.content.DateValue;
import com.adobe.xfa.content.DecimalValue;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.FloatValue;
import com.adobe.xfa.content.ImageValue;
import com.adobe.xfa.content.IntegerValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.content.TimeValue;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.DrawScript;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;

public final class Draw
extends Container {
    private boolean bBoxModelDirtied = false;

    public Draw(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "draw", "draw", null, XFA.DRAWTAG, "draw");
    }

    public String getRawValue() {
        String sValue = "";
        Element pValueNode = this.getElement(XFA.VALUETAG, true, 0, false, false);
        if (pValueNode != null) {
            Content pContentNode = (Content)pValueNode.getOneOfChild(true, false);
            if (pContentNode == null) {
                return "";
            }
            if (pContentNode.isSameClass(XFA.IMAGETAG) || pContentNode.isSameClass(XFA.LINETAG) || pContentNode.isSameClass(XFA.RECTANGLETAG) || pContentNode.isSameClass(XFA.ARCTAG)) {
                return "";
            }
            if (pContentNode.getIsNull()) {
                return "";
            }
            if (pContentNode.isSameClass(XFA.TEXTTAG)) {
                sValue = ((TextValue)pContentNode).getValue();
            } else if (pContentNode.isSameClass(XFA.EXDATATAG)) {
                sValue = ((ExDataValue)pContentNode).getValue(false, false, true);
            } else if (pContentNode.isSameClass(XFA.DATETAG)) {
                sValue = ((DateValue)pContentNode).getValue();
            } else if (pContentNode.isSameClass(XFA.DATETIMETAG)) {
                sValue = ((DateTimeValue)pContentNode).getValue();
            } else if (pContentNode.isSameClass(XFA.TIMETAG)) {
                sValue = ((TimeValue)pContentNode).getValue();
            } else if (pContentNode.isSameClass(XFA.INTEGERTAG)) {
                sValue = ((IntegerValue)pContentNode).toString();
            } else if (pContentNode.isSameClass(XFA.FLOATTAG)) {
                sValue = Numeric.doubleToString(((FloatValue)pContentNode).getValue(), 8, false);
            } else if (pContentNode.isSameClass(XFA.DECIMALTAG)) {
                sValue = Numeric.doubleToString(((DecimalValue)pContentNode).getValue(), 8, false);
            }
        }
        return sValue;
    }

    public void setRawValue(String sString) {
        Node pContentNode = null;
        Element pValueNode = this.getElement(XFA.VALUETAG, 0);
        if (pValueNode != null) {
            pContentNode = pValueNode.getOneOfChild();
        }
        if (pContentNode != null) {
            if (pContentNode.isSameClass(XFA.TEXTTAG)) {
                ((TextValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.EXDATATAG)) {
                ((ExDataValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.DATETAG)) {
                ((DateValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.DATETIMETAG)) {
                ((DateTimeValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.TIMETAG)) {
                ((TimeValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.INTEGERTAG)) {
                ((IntegerValue)pContentNode).setValue(sString, false);
            } else if (pContentNode.isSameClass(XFA.FLOATTAG)) {
                ((FloatValue)pContentNode).setValue(sString, false, true, false);
            } else if (pContentNode.isSameClass(XFA.DECIMALTAG)) {
                ((DecimalValue)pContentNode).setValue(sString, false, true, false);
            } else if (pContentNode.isSameClass(XFA.IMAGETAG)) {
                ((ImageValue)pContentNode).setValue(sString, "");
            } else {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.UnsupportedOperationException);
                oMessage.format("setRawValue");
                oMessage.format(pContentNode.getClassAtom());
                throw new ExFull(oMessage);
            }
        }
    }

    @Override
    public Attribute getAttribute(int eTag, boolean bPeek, boolean bValidate) {
        String oValue;
        Attribute oProperty = super.getAttribute(eTag, bPeek, bValidate);
        if (oProperty != null && eTag == XFA.LAYOUTTAG && !(oValue = oProperty.toString()).equals("lr-tb") && !oValue.equals("delegate")) {
            this.foundBadAttribute(eTag, oValue);
            return this.defaultAttribute(eTag);
        }
        return oProperty;
    }

    @Override
    public ScriptTable getScriptTable() {
        return DrawScript.getScriptTable();
    }

    @Override
    public boolean isWidthGrowSupported() {
        Node poContentNode = null;
        Element poValueNode = this.getElement(XFA.VALUETAG, true, 0, false, false);
        if (poValueNode != null) {
            poContentNode = poValueNode.getOneOfChild(true, false);
        }
        if (poContentNode != null && (poContentNode.isSameClass(XFA.ARCTAG) || poContentNode.isSameClass(XFA.LINETAG) || poContentNode.isSameClass(XFA.RECTANGLETAG))) {
            return false;
        }
        UI poUI = (UI)this.getElement(XFA.UITAG, true, 0, false, false);
        if (poUI != null) {
            poContentNode = poUI.getUIElement(true);
        }
        return poContentNode == null || !poContentNode.isSameClass(XFA.CHOICELISTTAG) && !poContentNode.isSameClass(XFA.EXOBJECTTAG);
    }

    @Override
    public boolean isHeightGrowSupported() {
        Node poContentNode = null;
        Element poValueNode = this.getElement(XFA.VALUETAG, true, 0, false, false);
        if (poValueNode != null) {
            poContentNode = poValueNode.getOneOfChild(true, false);
        }
        if (poContentNode != null && (poContentNode.isSameClass(XFA.ARCTAG) || poContentNode.isSameClass(XFA.LINETAG) || poContentNode.isSameClass(XFA.RECTANGLETAG))) {
            return false;
        }
        UI poUI = (UI)this.getElement(XFA.UITAG, true, 0, false, false);
        if (poUI != null) {
            poContentNode = poUI.getUIElement(true);
        }
        return poContentNode == null || !poContentNode.isSameClass(XFA.CHOICELISTTAG) && !poContentNode.isSameClass(XFA.EXOBJECTTAG);
    }

    public boolean isBoxModelDirtied() {
        return this.bBoxModelDirtied;
    }

    @Override
    public void setBoxModelDirtied(boolean b) {
        this.bBoxModelDirtied = b;
    }
}

