/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.automation;

import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumType;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.automation.Script;
import com.adobe.xfa.ut.StringUtils;

public final class EventTag
extends ProtoableNode {
    static final String gsFormCalc = "FormCalc";
    static final String gsJavaScript = "JavaScript";
    static final String gsMimeFormCalc = "application/x-formcalc";
    static final String gsMimeJavaScript = "application/x-javascript";

    public static EventTag createEvent(Model model, String sActivity, String sRef) {
        String aActivity = sActivity.intern();
        int eTag = XFA.getTag(aActivity);
        if (eTag != -1 && eTag == XFA.CALCULATETAG || eTag == XFA.VALIDATETAG) {
            return (EventTag)model.createElement(null, null, null, aActivity, aActivity, null, 0, null);
        }
        EventTag event = (EventTag)model.createElement(null, null, null, aActivity, aActivity, null, 0, null);
        event.setActivity(sActivity);
        event.setRef(sRef);
        return event;
    }

    public EventTag(Element pParent, Node prevSibling) {
        super(pParent, prevSibling, null, "event", "event", null, XFA.EVENTTAG, "event");
    }

    @Override
    public int defaultElement() {
        return XFA.SCRIPTTAG;
    }

    public String getActivity() {
        String className = this.getClassName();
        if (className == "event") {
            return this.getAttribute(XFA.ACTIVITYTAG).toString();
        }
        return className;
    }

    public String getContentType() {
        Script oScript = this.peekScript();
        if (oScript != null) {
            return oScript.getAttribute(XFA.CONTENTTYPETAG).toString();
        }
        return gsMimeFormCalc;
    }

    public String getLanguage() {
        String sContentType = this.getContentType();
        if (sContentType.compareToIgnoreCase(gsMimeJavaScript) == 0) {
            return gsJavaScript;
        }
        if (sContentType.compareToIgnoreCase(gsMimeFormCalc) == 0) {
            return gsFormCalc;
        }
        return sContentType;
    }

    public String getRef() {
        if (this.getClassName() == "event") {
            return this.getAttribute(XFA.REFTAG).toString();
        }
        return "";
    }

    public String getRunAt() {
        Script script = this.peekScript();
        if (script != null) {
            return script.getAttribute(XFA.RUNATTAG).toString();
        }
        return "";
    }

    public Script getScript() {
        if (this.isSameClass(XFA.EVENTTAG)) {
            Node oNode = this.getOneOfChild();
            if (oNode != null && oNode.isSameClass(XFA.SCRIPTTAG)) {
                return (Script)oNode;
            }
        } else {
            return (Script)this.getElement(XFA.SCRIPTTAG, false, 0, true, false);
        }
        return null;
    }

    public String getScriptText() {
        Script oScript = this.peekScript();
        if (oScript == null) {
            return "";
        }
        TextNode oTextNode = oScript.getText(true, false, false);
        if (oTextNode != null) {
            return oTextNode.getValue();
        }
        return "";
    }

    public Script peekScript() {
        if (this.isSameClass(XFA.EVENTTAG)) {
            Node oNode = this.getOneOfChild(true, false);
            if (oNode != null && oNode.isSameClass(XFA.SCRIPTTAG)) {
                return (Script)oNode;
            }
        } else {
            return (Script)this.peekElement(XFA.SCRIPTTAG, false, 0);
        }
        return null;
    }

    public void setActivity(String sActivity) {
        assert (this.getClassName().compareToIgnoreCase("event") == 0);
        this.setAttribute(new StringAttr("activity", sActivity), XFA.ACTIVITYTAG);
    }

    public void setContentType(String sContentType) {
        Script oScript = this.getScript();
        if (oScript != null) {
            oScript.setAttribute(new StringAttr("contentType", sContentType), XFA.CONTENTTYPETAG);
        }
    }

    public void setLanguage(String sLanguage) {
        if (sLanguage.compareToIgnoreCase(gsJavaScript) == 0) {
            this.setContentType(gsMimeJavaScript);
        } else if (sLanguage.compareToIgnoreCase(gsFormCalc) == 0) {
            this.setContentType(gsMimeFormCalc);
        } else {
            this.setContentType(sLanguage);
        }
    }

    public void setRef(String sRef) {
        assert (this.getClassName().compareToIgnoreCase("event") == 0);
        this.setAttribute(new StringAttr("ref", sRef), XFA.REFTAG);
    }

    public void setRunAt(String sTarget) {
        Script script = this.getScript();
        if (script != null) {
            script.setAttribute(EnumValue.getEnum(XFA.RUNATTAG, EnumAttr.getEnum(EnumType.RUNAT_TYPE, sTarget)), XFA.RUNATTAG);
        }
    }

    public void setScript(Script script) {
        if (this.isSameClass(XFA.EVENTTAG)) {
            this.setOneOfChild(script);
        } else {
            this.setElement(script, XFA.SCRIPTTAG, 0);
        }
    }

    public void setScriptText(String sScript) {
        TextNode oTextNode;
        Script oScript = this.getScript();
        if (oScript == null && StringUtils.isEmpty(sScript)) {
            return;
        }
        if (StringUtils.isEmpty(sScript)) {
            this.removeChild(oScript);
            return;
        }
        if (oScript == null) {
            oScript = (Script)this.getModel().createElement(null, null, null, "script", "script", null, 0, null);
            this.setScript(oScript);
        }
        if ((oTextNode = oScript.getText(true, false, false)) == null) {
            oTextNode = this.getModel().createTextNode(oScript, null, null, 0, 0);
        }
        oTextNode.setValue(sScript, true, false);
    }
}

