/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.svg;

import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Schema;
import com.adobe.xfa.SchemaStrings;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.svg.SVG;
import com.adobe.xfa.svg.SVGNode;

public final class SVGSchema
extends Schema {
    public static final String aSVG_WIDTH = "width";
    public static final String aSVG_XFACAPTION = "Caption";
    public static final String aSVG_XFACONTENT = "Content";
    private static final String[] gSVGStrings = new String[]{"#text", "desc", "g", "line", "svg", "text", "tspan", "altGlyph", "codepage", "fill", "font-family", "font-size", "font-style", "font-weight", "height", "id", "stroke", "stroke-width", "transform", "viewBox", "width", "x", "x1", "x2", "xmlns", "y", "y1", "y2"};
    private static final SVGSchema goSVG = new SVGSchema();
    private final SchemaStrings mAttributeTags = new SchemaStrings(SVG.SVG_ATTRIBUTE_COUNT);
    private final SchemaStrings mElementTags = new SchemaStrings(SVG.SVG_ELEMENT_COUNT);

    public static SVGSchema getSVGSchema() {
        return goSVG;
    }

    public static int getTagImpl(String aSVGName, boolean bIsElement) {
        if (aSVGName == null) {
            return -1;
        }
        int nRet = bIsElement ? SVGSchema.getSVGSchema().mElementTags.getInt(aSVGName) : SVGSchema.getSVGSchema().mAttributeTags.getInt(aSVGName);
        return nRet;
    }

    SVGSchema() {
        super("http://www.w3.org/2000/svg", SVG.SVG_ATTRIBUTE_MIN, SVG.SVG_ATTRIBUTE_MAX, SVG.SVG_ELEMENT_MIN, SVG.SVG_ELEMENT_MAX);
        this.schemaUsesProtos(false);
        this.initSchema();
    }

    @Override
    public String getAtom(int eTag) {
        assert (eTag >= this.mnElementMin && eTag <= this.mnAttributeMax);
        return gSVGStrings[eTag - this.mnElementMin];
    }

    @Override
    public int getAttributeTag(String aNS, String aAttrName) {
        return SVGSchema.getTagImpl(aAttrName, false);
    }

    @Override
    public int getElementTag(String aNS, String aNodeName) {
        return SVGSchema.getTagImpl(aNodeName, true);
    }

    @Override
    protected int getTextTag() {
        return SVG.TEXTDATATAG;
    }

    @Override
    protected void initSchema() {
        super.initSchema();
        for (int i = 0; i < gSVGStrings.length; ++i) {
            String atom = gSVGStrings[i];
            if (i < SVG.SVG_ELEMENT_COUNT) {
                this.mElementTags.put(atom, i + this.mnElementMin);
                continue;
            }
            if (i > SVG.SVG_KEYWORD_COUNT) continue;
            this.mAttributeTags.put(atom, i - SVG.SVG_ELEMENT_COUNT + this.mnAttributeMin);
        }
        assert (gSVGStrings.length == SVG.SVG_KEYWORD_COUNT);
        this.putAttribute(SVG.SVGTAG, SVG.WIDTHTAG, null, 0, 63, 0);
        this.putAttribute(SVG.SVGTAG, SVG.HEIGHTTAG, null, 0, 63, 0);
        this.putAttribute(SVG.SVGTAG, SVG.VIEWBOXTAG, null, 0, 63, 0);
        this.putElement(SVG.SVGTAG, SVG.GTAG, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putElement(SVG.SVGTAG, SVG.LINETAG, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putAttribute(SVG.GTAG, SVG.TRANSFORMTAG, null, 0, 63, 0);
        this.putAttribute(SVG.GTAG, SVG.WIDTHTAG, null, 0, 63, 0);
        this.putAttribute(SVG.GTAG, SVG.HEIGHTTAG, null, 0, 63, 0);
        this.putAttribute(SVG.GTAG, SVG.IDTAG, null, 0, 63, 0);
        this.putElement(SVG.GTAG, SVG.DESCTAG, ChildReln.getZeroOrOne(), 0, 63, 0);
        this.putElement(SVG.GTAG, SVG.LINETAG, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putElement(SVG.GTAG, SVG.TEXTTAG, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putElement(SVG.DESCTAG, SVG.TEXTDATATAG, ChildReln.getZeroOrOne(), 0, 63, 0);
        this.putElement(SVG.TEXTTAG, SVG.TSPANTAG, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.ALTGLYPHTAG, null, 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.FONTFAMILYTAG, new StringAttr("font-family", "Courier Std"), 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.FONTSTYLETAG, null, 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.FONTWEIGHTTAG, null, 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.FONTSIZETAG, new StringAttr("font-size", "0"), 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.FILLTAG, new StringAttr("fill", "#000000"), 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.CODEPAGETAG, null, 0, 63, 0);
        this.putAttribute(SVG.TEXTTAG, SVG.TRANSFORMTAG, null, 0, 63, 0);
        this.putElement(SVG.TSPANTAG, SVG.TEXTDATATAG, ChildReln.getZeroOrOne(), 0, 63, 0);
        this.putAttribute(SVG.TSPANTAG, SVG.XTAG, null, 0, 63, 0);
        this.putAttribute(SVG.TSPANTAG, SVG.YTAG, null, 0, 63, 0);
        this.putAttribute(SVG.TSPANTAG, SVG.FONTFAMILYTAG, new StringAttr("font-family", "Courier Std"), 0, 63, 0);
        this.putAttribute(SVG.TSPANTAG, SVG.FONTSIZETAG, new StringAttr("font-size", "0"), 0, 63, 0);
        this.putAttribute(SVG.TSPANTAG, SVG.FILLTAG, new StringAttr("fill", "#000000"), 0, 63, 0);
        this.putAttribute(SVG.TSPANTAG, SVG.ALTGLYPHTAG, null, 0, 63, 0);
        this.putAttribute(SVG.LINETAG, SVG.X1TAG, new StringAttr("x1", "0"), 0, 63, 0);
        this.putAttribute(SVG.LINETAG, SVG.X2TAG, new StringAttr("x2", "0"), 0, 63, 0);
        this.putAttribute(SVG.LINETAG, SVG.Y1TAG, new StringAttr("y1", "0"), 0, 63, 0);
        this.putAttribute(SVG.LINETAG, SVG.Y2TAG, new StringAttr("y2", "0"), 0, 63, 0);
        this.putAttribute(SVG.LINETAG, SVG.STROKETAG, null, 0, 63, 0);
        this.putAttribute(SVG.LINETAG, SVG.STROKEWIDTHTAG, new StringAttr("stroke-width", "1000"), 0, 63, 0);
    }

    @Override
    protected Element newElement(int eTag, Element parent, Node prevSibling) {
        if (eTag == SVG.SVGTAG || eTag == SVG.GTAG || eTag == SVG.DESCTAG || eTag == SVG.TEXTTAG || eTag == SVG.TSPANTAG || eTag == SVG.LINETAG || eTag == SVG.TEXTDATATAG) {
            return new SVGNode(parent, prevSibling);
        }
        return null;
    }
}

