/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.svg;

import com.adobe.xfa.XFA;
import com.adobe.xfa.svg.SVGSchema;

public final class SVG {
    public static final String TEXTDATA = "#text";
    public static final String DESC = "desc";
    public static final String G = "g";
    public static final String LINE = "line";
    public static final String SVG = "svg";
    public static final String TEXT = "text";
    public static final String TSPAN = "tspan";
    public static final String ALTGLYPH = "altGlyph";
    public static final String CODEPAGE = "codepage";
    public static final String FILL = "fill";
    public static final String FONTFAMILY = "font-family";
    public static final String FONTSIZE = "font-size";
    public static final String FONTSTYLE = "font-style";
    public static final String FONTWEIGHT = "font-weight";
    public static final String HEIGHT = "height";
    public static final String ID = "id";
    public static final String STROKE = "stroke";
    public static final String STROKEWIDTH = "stroke-width";
    public static final String TRANSFORM = "transform";
    public static final String VIEWBOX = "viewBox";
    public static final String WIDTH = "width";
    public static final String X = "x";
    public static final String X1 = "x1";
    public static final String X2 = "x2";
    public static final String XMLNS = "xmlns";
    public static final String Y = "y";
    public static final String Y1 = "y1";
    public static final String Y2 = "y2";
    public static final int SVG_INVALID = -1;
    public static final int SVG_ELEMENT_MIN;
    public static final int TEXTDATATAG;
    public static final int DESCTAG;
    public static final int GTAG;
    public static final int LINETAG;
    public static final int SVGTAG;
    public static final int TEXTTAG;
    public static final int TSPANTAG;
    public static final int SVG_ELEMENT_MAX;
    public static final int SVG_ELEMENT_COUNT;
    public static final int SVG_ATTRIBUTE_MIN;
    public static final int ALTGLYPHTAG;
    public static final int CODEPAGETAG;
    public static final int FILLTAG;
    public static final int FONTFAMILYTAG;
    public static final int FONTSIZETAG;
    public static final int FONTSTYLETAG;
    public static final int FONTWEIGHTTAG;
    public static final int HEIGHTTAG;
    public static final int IDTAG;
    public static final int STROKETAG;
    public static final int STROKEWIDTHTAG;
    public static final int TRANSFORMTAG;
    public static final int VIEWBOXTAG;
    public static final int WIDTHTAG;
    public static final int XTAG;
    public static final int X1TAG;
    public static final int X2TAG;
    public static final int XMLNSTAG;
    public static final int YTAG;
    public static final int Y1TAG;
    public static final int Y2TAG;
    public static final int SVG_ATTRIBUTE_MAX;
    public static final int SVG_ATTRIBUTE_COUNT;
    public static final int SVG_KEYWORD_COUNT;
    public static final String XFACAPTION = "Caption";
    public static final String XFACONTENT = "Content";

    public static int getTag(String aSVGName) {
        int eRet = SVGSchema.getTagImpl(aSVGName, true);
        if (eRet != -1) {
            return eRet;
        }
        return SVGSchema.getTagImpl(aSVGName, false);
    }

    public static int getElementTag(String aSVGName) {
        return SVGSchema.getTagImpl(aSVGName, true);
    }

    public static int getAttributeTag(String aSVGName) {
        return SVGSchema.getTagImpl(aSVGName, false);
    }

    public static String getString(int eTag) {
        return SVGSchema.getSVGSchema().getAtom(eTag);
    }

    public static String getAtom(int eTag) {
        return SVGSchema.getSVGSchema().getAtom(eTag);
    }

    static {
        TEXTDATATAG = SVG_ELEMENT_MIN = XFA.SVG_START;
        DESCTAG = TEXTDATATAG + 1;
        GTAG = DESCTAG + 1;
        LINETAG = GTAG + 1;
        SVGTAG = LINETAG + 1;
        TEXTTAG = SVGTAG + 1;
        SVG_ELEMENT_MAX = TSPANTAG = TEXTTAG + 1;
        SVG_ELEMENT_COUNT = SVG_ELEMENT_MAX - SVG_ELEMENT_MIN + 1;
        ALTGLYPHTAG = SVG_ATTRIBUTE_MIN = SVG_ELEMENT_MAX + 1;
        CODEPAGETAG = ALTGLYPHTAG + 1;
        FILLTAG = CODEPAGETAG + 1;
        FONTFAMILYTAG = FILLTAG + 1;
        FONTSIZETAG = FONTFAMILYTAG + 1;
        FONTSTYLETAG = FONTSIZETAG + 1;
        FONTWEIGHTTAG = FONTSTYLETAG + 1;
        HEIGHTTAG = FONTWEIGHTTAG + 1;
        IDTAG = HEIGHTTAG + 1;
        STROKETAG = IDTAG + 1;
        STROKEWIDTHTAG = STROKETAG + 1;
        TRANSFORMTAG = STROKEWIDTHTAG + 1;
        VIEWBOXTAG = TRANSFORMTAG + 1;
        WIDTHTAG = VIEWBOXTAG + 1;
        XTAG = WIDTHTAG + 1;
        X1TAG = XTAG + 1;
        X2TAG = X1TAG + 1;
        XMLNSTAG = X2TAG + 1;
        YTAG = XMLNSTAG + 1;
        Y1TAG = YTAG + 1;
        SVG_ATTRIBUTE_MAX = Y2TAG = Y1TAG + 1;
        SVG_ATTRIBUTE_COUNT = SVG_ATTRIBUTE_MAX - SVG_ATTRIBUTE_MIN + 1;
        SVG_KEYWORD_COUNT = SVG_ATTRIBUTE_MAX - SVG_ELEMENT_MIN + 1;
    }
}

