/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.service.renderer;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XMLMultiSelectNode;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.layout.Layout;
import com.adobe.xfa.layout.LayoutNode;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.util.StringTokenizer;

public class FormUtils {
    public static LayerType getLayer(Element oFormNode) {
        if (oFormNode != null) {
            LayerType eLayer = FormUtils.getExplicitLayer(oFormNode);
            if (eLayer != LayerType.ePrintAndView) {
                return eLayer;
            }
            Element oParent = oFormNode.getXFAParent();
            if (oParent == null) {
                return LayerType.ePrintAndView;
            }
            return FormUtils.getLayer(oParent);
        }
        return LayerType.ePrintAndView;
    }

    public static LayerType getLayer(Layout oLayout, Element oFormNode) {
        LayoutNode oLayoutNode = FormUtils.findRootXFALayoutNodeForFormNode(oLayout, oFormNode);
        Element oFNode = oLayoutNode.getFormNode();
        return FormUtils.getLayer(oFNode);
    }

    static LayerType getExplicitLayer(Element oFormNode) {
        if (oFormNode != null) {
            if (!oFormNode.isPropertySpecified(XFA.RELEVANTTAG, true, 0)) {
                return LayerType.ePrintAndView;
            }
            Attribute oRelevantAttr = oFormNode.getAttribute(XFA.RELEVANTTAG);
            String sRelevant = oRelevantAttr.getAttrValue();
            StringTokenizer sToker = new StringTokenizer(sRelevant);
            while (sToker.hasMoreTokens()) {
                String sLayer = sToker.nextToken();
                if (sLayer.equals("-print")) {
                    return LayerType.eViewOnly;
                }
                if (!sLayer.equals("print") && !sLayer.equals("+print")) continue;
                Model oModel = oFormNode.getModel();
                AppModel oAppModel = (AppModel)oModel.getXFAParent();
                if (oAppModel != null && oAppModel.getLegacySetting(AppModel.XFA_LEGACY_PLUSPRINT)) {
                    return LayerType.ePrintAndView;
                }
                return LayerType.ePrintOnly;
            }
        }
        return LayerType.ePrintAndView;
    }

    public static LayoutNode findRootXFALayoutNodeForFormNode(Layout oLayout, Element oFormField) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "getToolTipText");
    }

    public static String getToolTipText(LayoutNode layoutNode) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "getToolTipText");
    }

    static int getDisplayCode(LayoutNode oLayoutNode, FormField oFormField) {
        LayerType elayer = FormUtils.getLayer(oLayoutNode.getFormNode());
        int oPresence = oFormField.getEnum(XFA.PRESENCETAG);
        int nDisplay = oPresence == 1076494337 ? 1 : (elayer == LayerType.eViewOnly ? 2 : (elayer == LayerType.ePrintOnly ? 3 : 0));
        return nDisplay;
    }

    public static int getDisplayCode(Layout oLayout, FormField oFormField) {
        LayoutNode oLayoutNode = FormUtils.findRootXFALayoutNodeForFormNode(oLayout, oFormField);
        return FormUtils.getDisplayCode(oLayoutNode, oFormField);
    }

    public static void setDisplayCode(FormField oFormField, int nDisplay) {
        if (nDisplay == 0) {
            oFormField.setAttribute(1076494336, XFA.PRESENCETAG);
            oFormField.setProperty((Object)"", XFA.RELEVANTTAG);
        } else if (nDisplay == 1) {
            oFormField.setAttribute(1076494337, XFA.PRESENCETAG);
            oFormField.setProperty((Object)"", XFA.RELEVANTTAG);
        } else if (nDisplay == 2) {
            oFormField.setAttribute(1076494336, XFA.PRESENCETAG);
            oFormField.setProperty((Object)"-print", XFA.RELEVANTTAG);
        } else {
            oFormField.setAttribute(1076494337, XFA.PRESENCETAG);
            oFormField.setProperty((Object)"+print", XFA.RELEVANTTAG);
        }
    }

    public static boolean getRichTextField(FormField oField, StringHolder sMarkup) {
        Element oValueNode;
        if (oField != null && (oValueNode = oField.getElement(XFA.VALUETAG, 0)) != null) {
            Node oContentNode = oValueNode.getOneOfChild();
            if (oContentNode == null) {
                return false;
            }
            if (oContentNode instanceof ExDataValue) {
                ExDataValue oExData = (ExDataValue)oContentNode;
                Node aNode = oExData.getOneOfChild();
                if (oExData.getAttribute(XFA.CONTENTTYPETAG).toString().equals("text/plain")) {
                    return false;
                }
                if (aNode instanceof XMLMultiSelectNode) {
                    return false;
                }
                if (sMarkup != null) {
                    String sTemp = ((ExDataValue)oContentNode).getValue(true, false, false);
                    if (sTemp.indexOf(10) >= 0) {
                        sTemp = sTemp.replace("\n", "");
                    }
                    sMarkup.value = StringUtils.toXML(sTemp, StringUtils.ToXMLType.XMLTEXT, "", '\r', '\r', "<&>'\"");
                }
                return true;
            }
        }
        return false;
    }

    private FormUtils() {
    }

    public static enum LayerType {
        ePrintAndView,
        ePrintOnly,
        eViewOnly,
        eNotSet;

    }
}

