/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.service.href;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.HrefHandler;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.service.Service;
import com.adobe.xfa.service.href.HrefStore;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public class HrefService
extends Service
implements HrefHandler {
    private final HrefStore mHrefStore;
    private Node mContextNode;
    private final String msConfigSchemaName;
    public static final int CACHE_SIZE = 51200;

    public HrefService(Node contextNode, int nHrefCacheSize) {
        String sBasePath = HrefService.getBaseUrl(contextNode);
        String sUriPath = HrefService.getAlternativeUrl(contextNode);
        if (nHrefCacheSize == 0) {
            nHrefCacheSize = 51200;
        }
        this.mHrefStore = new HrefStore(this, sBasePath, sUriPath, nHrefCacheSize);
        this.mContextNode = contextNode;
        this.msConfigSchemaName = null;
    }

    public HrefService(String sConfigSchemaName, int nHrefCacheSize) {
        if (nHrefCacheSize == 0) {
            nHrefCacheSize = 51200;
        }
        this.mHrefStore = new HrefStore(this, null, null, nHrefCacheSize);
        this.mContextNode = null;
        this.msConfigSchemaName = sConfigSchemaName;
    }

    public final Node getContextNode() {
        return this.mContextNode;
    }

    public final String getConfigSchemaName() {
        return this.msConfigSchemaName;
    }

    public final void setContextNode(Node contextNode) {
        this.mContextNode = contextNode;
    }

    public final boolean isTrusted() {
        return this.mHrefStore.isTrusted();
    }

    public final void isTrusted(boolean bTrusted) {
        this.mHrefStore.isTrusted(bTrusted);
    }

    public final int getCacheSize() {
        return this.mHrefStore.getCacheSize();
    }

    final void setCacheSize(int nSize) {
        this.mHrefStore.setCacheSize(nSize);
    }

    public final void clearCache() {
        this.mHrefStore.clearCache();
    }

    public final int getCurrentCacheSize() {
        return this.mHrefStore.getCurrentCacheSize();
    }

    private final HrefStore getHrefStore() {
        return this.mHrefStore;
    }

    @Override
    public AppModel loadFragment(ProtoableNode protoableNode) {
        Attribute usehref = protoableNode.peekAttribute(XFA.USEHREFTAG);
        if (usehref == null) {
            throw new IllegalArgumentException();
        }
        return this.loadFragmentInternal(protoableNode.getAppModel(), usehref.toString(), protoableNode.getName());
    }

    @Override
    public AppModel loadFragment(AppModel appModel, String sUrl) {
        return this.loadFragmentInternal(appModel, sUrl, null);
    }

    private AppModel loadFragmentInternal(AppModel appModel, String sUrl, String sNodeName) {
        int nSharp;
        ConfigurationModel configModel;
        if (StringUtils.isEmpty(sUrl)) {
            throw new IllegalArgumentException();
        }
        Node context = this.getContextNode();
        if (context == null && this.getConfigSchemaName() != null && (configModel = ConfigurationModel.getConfigurationModel(appModel, false)) != null && (context = configModel.getCommonNode(this.getConfigSchemaName())) != null) {
            String sUriPath;
            String sBasePath = HrefService.getBaseUrl(context);
            if (!StringUtils.isEmpty(sBasePath)) {
                this.setBaseUrl(sBasePath);
            }
            if (!StringUtils.isEmpty(sUriPath = HrefService.getAlternativeUrl(context))) {
                this.setAlternativeUrl(sUriPath);
            }
            this.setContextNode(context);
        }
        if ((nSharp = sUrl.indexOf(35)) >= 0) {
            sUrl = sUrl.substring(0, nSharp);
        }
        try {
            this.getHrefStore().add(sUrl);
            HrefStore.HrefData oHrefData = this.getHrefStore().getHrefData(sUrl);
            return oHrefData.getAppModel();
        }
        catch (ExFull e) {
            MsgFormatPos oMsg = null;
            if (!StringUtils.isEmpty(sNodeName)) {
                oMsg = new MsgFormatPos(ResId.XFAHrefServiceException);
                oMsg.format(sNodeName);
                ExFull oErr = new ExFull(oMsg);
                oErr.insert(e, false);
                throw oErr;
            }
            throw e;
        }
    }

    @Override
    public Model getDocument(AppModel appModel) {
        return TemplateModel.getTemplateModel(appModel, false);
    }

    public final String getBaseUrl() {
        return this.mHrefStore.getBaseUrl();
    }

    public final void setBaseUrl(String sBaseUrl) {
        this.mHrefStore.setBaseUrl(sBaseUrl);
    }

    public final String getAlternativeUrl() {
        return this.mHrefStore.getAlternativeUrl();
    }

    public final void setAlternativeUrl(String sAltUrl) {
        this.mHrefStore.setAlternativeUrl(sAltUrl);
    }

    private static final String getBaseUrl(Node contextNode) {
        return ProtocolUtils.getTemplateBasePathFromConfig(contextNode);
    }

    private static final String getAlternativeUrl(Node contextNode) {
        return ProtocolUtils.getTemplateUriPathFromConfig(contextNode);
    }
}

