/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.layout;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.XFA;
import com.adobe.xfa.font.FontInfo;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.layout.BoxModelLayout;
import com.adobe.xfa.layout.LayoutEnv;
import com.adobe.xfa.svg.SVG;
import com.adobe.xfa.svg.SVGNode;
import com.adobe.xfa.svg.SVGTextData;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Rotate;
import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Margins;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UnitSpan;
import java.util.ArrayList;
import java.util.StringTokenizer;

class BoxModelRenderProxy
extends BoxModelLayout {
    protected LayoutEnv m_oGfxLayoutEnv;
    protected Rect m_oContentExtent = Rect.ZERO;
    protected Rect m_oCaptionExtent = Rect.ZERO;
    protected boolean m_bHasCaption;
    private boolean mbIsProxy;

    public BoxModelRenderProxy(LayoutEnv oEnv) {
        this.m_oGfxLayoutEnv = oEnv;
        this.m_bHasCaption = false;
        this.mbIsProxy = false;
    }

    @Override
    public Rect getCaptionExtent() {
        return this.m_oCaptionExtent;
    }

    @Override
    public Rect getContentExtent() {
        return this.m_oContentExtent;
    }

    @Override
    public void clear() {
        this.m_bHasCaption = false;
        this.m_oCaptionExtent = Rect.ZERO;
        this.m_oContentExtent = Rect.ZERO;
        super.clear();
    }

    public boolean allowRenderProxy() {
        return true;
    }

    @Override
    public boolean hasCaption() {
        return this.m_bHasCaption;
    }

    @Override
    public boolean isProxy() {
        return this.mbIsProxy;
    }

    @Override
    public void initialize(Element oNode) {
        assert (oNode instanceof Draw);
        if (!this.isBoxModelCompatible(oNode)) {
            return;
        }
        this.checkProxyStatus(oNode);
        this.initAnchorPoint(oNode);
        this.initMargins(oNode);
        this.initBorder(oNode);
        this.respectRotation(oNode);
        this.initVisualExtent(oNode);
    }

    @Override
    public void respectRotation(Element oNode) {
        Rotate oRotate;
        this.m_bWasRotated = false;
        this.m_oRotationAngle = Angle.ZERO;
        if ((oNode instanceof Draw || oNode instanceof Field) && oNode.isPropertySpecified(XFA.ROTATETAG, true, 0) && (oRotate = new Rotate("rotate", oNode.getAttribute(XFA.ROTATETAG).toString())) != null) {
            Angle oAngle = oRotate.getAngle();
            int lAngle = oAngle.degrees();
            if (0 > (lAngle %= 360)) {
                lAngle += 360;
            }
            this.m_oRotationAngle = oAngle = new Angle(lAngle);
            Margins oPrevMargins = this.m_oNEMargins;
            Margins oPrevBorderMargins = this.m_oBorderMargins;
            Margins oPrevWidgetBorderMargins = this.m_oContentBorderMargins;
            Margins oPrevWidgetCaptionMargins = this.m_oCapMargins;
            Margins oPrevWidgetContentMargins = this.m_oContMargins;
            Rect rcPrevNE = this.getNominalExtent();
            CoordPair oNewTL = CoordPair.ZERO_ZERO;
            CoordPair oNewTR = CoordPair.ZERO_ZERO;
            CoordPair oNewBR = CoordPair.ZERO_ZERO;
            CoordPair oPrevTL = rcPrevNE.topLeft();
            CoordPair oPrevTR = rcPrevNE.topRight();
            CoordPair oPrevBL = rcPrevNE.bottomLeft();
            CoordPair oPrevBR = rcPrevNE.bottomRight();
            Rect rcPrevContentExtent = this.getContentExtent();
            CoordPair oNewContentTL = CoordPair.ZERO_ZERO;
            CoordPair oNewContentTR = CoordPair.ZERO_ZERO;
            CoordPair oNewContentBL = CoordPair.ZERO_ZERO;
            CoordPair oNewContentBR = CoordPair.ZERO_ZERO;
            CoordPair oPrevContentTL = rcPrevContentExtent.topLeft();
            CoordPair oPrevContentTR = rcPrevContentExtent.topRight();
            CoordPair oPrevContentBL = rcPrevContentExtent.bottomLeft();
            CoordPair oPrevContentBR = rcPrevContentExtent.bottomRight();
            Rect rcPrevCaptionExtent = this.getCaptionExtent();
            CoordPair oNewCaptionTL = CoordPair.ZERO_ZERO;
            CoordPair oNewCaptionTR = CoordPair.ZERO_ZERO;
            CoordPair oNewCaptionBL = CoordPair.ZERO_ZERO;
            CoordPair oNewCaptionBR = CoordPair.ZERO_ZERO;
            CoordPair oPrevCaptionTL = rcPrevCaptionExtent.topLeft();
            CoordPair oPrevCaptionTR = rcPrevCaptionExtent.topRight();
            CoordPair oPrevCaptionBL = rcPrevCaptionExtent.bottomLeft();
            CoordPair oPrevCaptionBR = rcPrevCaptionExtent.bottomRight();
            CoordPair oNewLocalContentTL = CoordPair.ZERO_ZERO;
            CoordPair oNewLocalCaptionTL = CoordPair.ZERO_ZERO;
            CoordPair oLocalAnchor = this.m_oAnchorPoint.subtract(oPrevTL);
            CoordPair oContentOrigin = oPrevContentTL;
            CoordPair oCaptionOrigin = oPrevCaptionTL;
            switch (lAngle) {
                case 0: {
                    oNewLocalContentTL = oPrevContentTL.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedContentTopLeft = oNewLocalContentTL.subtract(oContentOrigin.rotatePoint(oLocalAnchor, oAngle));
                    oNewLocalCaptionTL = oPrevCaptionTL.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedCaptionTopLeft = oNewLocalCaptionTL.subtract(oContentOrigin.rotatePoint(oLocalAnchor, oAngle));
                    return;
                }
                case 270: {
                    oNewTR = oPrevTL.rotatePoint(this.m_oAnchorPoint, oAngle);
                    oNewBR = oPrevTR.rotatePoint(this.m_oAnchorPoint, oAngle);
                    oNewTL = oPrevBL.rotatePoint(this.m_oAnchorPoint, oAngle);
                    CoordPair oAdjust = oPrevTL.subtract(oNewTL);
                    oNewContentTR = oPrevContentTL.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentBR = oPrevContentTR.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentBL = oPrevContentBR.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTL = oPrevContentBL.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTR = oNewContentTR.add(oAdjust);
                    oNewContentBR = oNewContentBR.add(oAdjust);
                    oNewContentBL = oNewContentBL.add(oAdjust);
                    oNewContentTL = oNewContentTL.add(oAdjust);
                    oNewCaptionTR = oPrevCaptionTL.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionBR = oPrevCaptionTR.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionBL = oPrevCaptionBR.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTL = oPrevCaptionBL.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTR = oNewCaptionTR.add(oAdjust);
                    oNewCaptionBR = oNewCaptionBR.add(oAdjust);
                    oNewCaptionBL = oNewCaptionBL.add(oAdjust);
                    oNewCaptionTL = oNewCaptionTL.add(oAdjust);
                    this.m_oNEMargins = new Margins(oPrevMargins.marginBottom(), oPrevMargins.marginLeft(), oPrevMargins.marginTop(), oPrevMargins.marginRight());
                    this.m_oBorderMargins = new Margins(oPrevBorderMargins.marginBottom(), oPrevBorderMargins.marginLeft(), oPrevBorderMargins.marginTop(), oPrevBorderMargins.marginRight());
                    this.m_oContentBorderMargins = new Margins(oPrevWidgetBorderMargins.marginBottom(), oPrevWidgetBorderMargins.marginLeft(), oPrevWidgetBorderMargins.marginTop(), oPrevWidgetBorderMargins.marginRight());
                    this.m_oCapMargins = new Margins(oPrevWidgetCaptionMargins.marginBottom(), oPrevWidgetCaptionMargins.marginLeft(), oPrevWidgetCaptionMargins.marginTop(), oPrevWidgetCaptionMargins.marginRight());
                    this.m_oContMargins = new Margins(oPrevWidgetContentMargins.marginBottom(), oPrevWidgetContentMargins.marginLeft(), oPrevWidgetContentMargins.marginTop(), oPrevWidgetContentMargins.marginRight());
                    oNewLocalContentTL = oPrevContentBL.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedContentTopLeft = oNewLocalContentTL.subtract(oContentOrigin.rotatePoint(oLocalAnchor, oAngle));
                    oNewLocalCaptionTL = oPrevCaptionBL.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedCaptionTopLeft = oNewLocalCaptionTL.subtract(oCaptionOrigin.rotatePoint(oLocalAnchor, oAngle));
                    break;
                }
                case 180: {
                    oNewBR = oPrevTL.rotatePoint(this.m_oAnchorPoint, oAngle);
                    oNewTL = oPrevBR.rotatePoint(this.m_oAnchorPoint, oAngle);
                    oNewTR = oPrevBL.rotatePoint(this.m_oAnchorPoint, oAngle);
                    CoordPair oAdjust = oPrevTL.subtract(oNewTL);
                    oNewContentBR = oPrevContentTL.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentBL = oPrevContentTR.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTL = oPrevContentBR.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTR = oPrevContentBL.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTR = oNewContentTR.add(oAdjust);
                    oNewContentBR = oNewContentBR.add(oAdjust);
                    oNewContentBL = oNewContentBL.add(oAdjust);
                    oNewContentTL = oNewContentTL.add(oAdjust);
                    oNewCaptionBR = oPrevCaptionTL.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionBL = oPrevCaptionTR.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTL = oPrevCaptionBR.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTR = oPrevCaptionBL.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTR = oNewCaptionTR.add(oAdjust);
                    oNewCaptionBR = oNewCaptionBR.add(oAdjust);
                    oNewCaptionBL = oNewCaptionBL.add(oAdjust);
                    oNewCaptionTL = oNewCaptionTL.add(oAdjust);
                    this.m_oNEMargins = new Margins(oPrevMargins.marginRight(), oPrevMargins.marginBottom(), oPrevMargins.marginLeft(), oPrevMargins.marginTop());
                    this.m_oBorderMargins = new Margins(oPrevBorderMargins.marginRight(), oPrevBorderMargins.marginBottom(), oPrevBorderMargins.marginLeft(), oPrevBorderMargins.marginTop());
                    this.m_oContentBorderMargins = new Margins(oPrevWidgetBorderMargins.marginRight(), oPrevWidgetBorderMargins.marginBottom(), oPrevWidgetBorderMargins.marginLeft(), oPrevWidgetBorderMargins.marginTop());
                    this.m_oCapMargins = new Margins(oPrevWidgetCaptionMargins.marginRight(), oPrevWidgetCaptionMargins.marginBottom(), oPrevWidgetCaptionMargins.marginLeft(), oPrevWidgetCaptionMargins.marginTop());
                    this.m_oContMargins = new Margins(oPrevWidgetContentMargins.marginRight(), oPrevWidgetContentMargins.marginBottom(), oPrevWidgetContentMargins.marginLeft(), oPrevWidgetContentMargins.marginTop());
                    oNewLocalContentTL = oPrevContentBR.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedContentTopLeft = oNewLocalContentTL.subtract(oContentOrigin.rotatePoint(oLocalAnchor, oAngle));
                    oNewLocalCaptionTL = oPrevCaptionBR.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedCaptionTopLeft = oNewLocalCaptionTL.subtract(oCaptionOrigin.rotatePoint(oLocalAnchor, oAngle));
                    break;
                }
                case 90: {
                    oNewTL = oPrevTR.rotatePoint(this.m_oAnchorPoint, oAngle);
                    oNewTR = oPrevBR.rotatePoint(this.m_oAnchorPoint, oAngle);
                    oNewBR = oPrevBL.rotatePoint(this.m_oAnchorPoint, oAngle);
                    CoordPair oAdjust = oPrevTL.subtract(oNewTL);
                    oNewContentBL = oPrevContentTL.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTL = oPrevContentTR.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTR = oPrevContentBR.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentBR = oPrevContentBL.rotatePoint(oLocalAnchor, oAngle);
                    oNewContentTR = oNewContentTR.add(oAdjust);
                    oNewContentBR = oNewContentBR.add(oAdjust);
                    oNewContentBL = oNewContentBL.add(oAdjust);
                    oNewContentTL = oNewContentTL.add(oAdjust);
                    oNewCaptionBL = oPrevCaptionTL.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTL = oPrevCaptionTR.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTR = oPrevCaptionBR.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionBR = oPrevCaptionBL.rotatePoint(oLocalAnchor, oAngle);
                    oNewCaptionTR = oNewCaptionTR.add(oAdjust);
                    oNewCaptionBR = oNewCaptionBR.add(oAdjust);
                    oNewCaptionBL = oNewCaptionBL.add(oAdjust);
                    oNewCaptionTL = oNewCaptionTL.add(oAdjust);
                    this.m_oNEMargins = new Margins(oPrevMargins.marginTop(), oPrevMargins.marginRight(), oPrevMargins.marginBottom(), oPrevMargins.marginLeft());
                    this.m_oBorderMargins = new Margins(oPrevBorderMargins.marginTop(), oPrevBorderMargins.marginRight(), oPrevBorderMargins.marginBottom(), oPrevBorderMargins.marginLeft());
                    this.m_oContentBorderMargins = new Margins(oPrevWidgetBorderMargins.marginTop(), oPrevWidgetBorderMargins.marginRight(), oPrevWidgetBorderMargins.marginBottom(), oPrevWidgetBorderMargins.marginLeft());
                    this.m_oCapMargins = new Margins(oPrevWidgetCaptionMargins.marginTop(), oPrevWidgetCaptionMargins.marginRight(), oPrevWidgetCaptionMargins.marginBottom(), oPrevWidgetCaptionMargins.marginLeft());
                    this.m_oContMargins = new Margins(oPrevWidgetContentMargins.marginTop(), oPrevWidgetContentMargins.marginRight(), oPrevWidgetContentMargins.marginBottom(), oPrevWidgetContentMargins.marginLeft());
                    oNewLocalContentTL = oPrevContentTR.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedContentTopLeft = oNewLocalContentTL.subtract(oContentOrigin.rotatePoint(oLocalAnchor, oAngle));
                    oNewLocalCaptionTL = oPrevCaptionTR.rotatePoint(oLocalAnchor, oAngle);
                    this.m_oRotatedCaptionTopLeft = oNewLocalCaptionTL.subtract(oCaptionOrigin.rotatePoint(oLocalAnchor, oAngle));
                    break;
                }
                default: {
                    assert (false);
                    this.m_bWasRotated = false;
                    return;
                }
            }
            this.m_bWasRotated = 0 != lAngle;
            this.m_oAnchorType = 131072;
            this.m_oAnchorPoint = oNewTL;
            UnitSpan oNewWidth = oNewTR.x().subtract(oNewTL.x());
            UnitSpan oNewHeight = oNewBR.y().subtract(oNewTR.y());
            if (oNewWidth.value() < 0) {
                oNewWidth = oNewWidth.multiply(-1);
            }
            if (oNewHeight.value() < 0) {
                oNewHeight = oNewHeight.multiply(-1);
            }
            assert (oNewWidth.gte(UnitSpan.ZERO));
            assert (oNewHeight.gte(UnitSpan.ZERO));
            this.m_oNE = this.m_oNE.width(oNewWidth, false);
            this.m_oNE = this.m_oNE.height(oNewHeight, false);
            this.m_oCaptionExtent = this.m_oCaptionExtent.topLeft(oNewCaptionTL);
            this.m_oCaptionExtent = this.m_oCaptionExtent.bottomRight(oNewCaptionBR);
            this.m_oCaptionExtent = this.m_oContentExtent.topLeft(oNewContentTL);
            this.m_oCaptionExtent = this.m_oContentExtent.bottomRight(oNewContentBR);
            assert (!this.m_oContentExtent.isDegenerate());
        }
    }

    protected void hasCaption(boolean bHasCaption) {
        this.m_bHasCaption = bHasCaption;
    }

    protected void checkProxyStatus(Element oNode) {
        if (!this.allowRenderProxy()) {
            this.mbIsProxy = false;
            return;
        }
        if (oNode.isPropertySpecified(XFA.RENDERASTAG, true, 0)) {
            this.initFromSVG(oNode);
        } else if (!(oNode instanceof Field)) {
            this.initFromPI(oNode);
        }
    }

    private void initFromPI(Element oNode) {
        assert (oNode != null);
        ArrayList<String> oPIs = new ArrayList<String>();
        oNode.getPI("renderCache.bounds", oPIs, true);
        boolean bl = this.mbIsProxy = oPIs.size() != 0;
        if (!this.mbIsProxy) {
            return;
        }
        StringBuilder sPIValue = new StringBuilder((String)oPIs.get(0));
        StringUtils.trim(sPIValue);
        StringUtils.trimStart(sPIValue);
        StringTokenizer sToker = new StringTokenizer(sPIValue.toString());
        String sResult = null;
        int nResult = 0;
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan moContentW = new UnitSpan(3, nResult);
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan moContentH = new UnitSpan(3, nResult);
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan moCaptionW = new UnitSpan(3, nResult);
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan moCaptionH = new UnitSpan(3, nResult);
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan oRCTLX = new UnitSpan(3, nResult);
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan oRCTLY = new UnitSpan(3, nResult);
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan oRCapTLX = new UnitSpan(3, nResult);
        sResult = sToker.nextToken();
        nResult = StringUtils.safeNumber(sResult);
        UnitSpan oRCapTLY = new UnitSpan(3, nResult);
        if (0 > moContentW.value()) {
            moContentW = UnitSpan.ZERO;
        }
        if (0 > moContentH.value()) {
            moContentH = UnitSpan.ZERO;
        }
        if (0 > moCaptionW.value()) {
            moCaptionW = UnitSpan.ZERO;
        }
        if (0 > moCaptionH.value()) {
            moCaptionH = UnitSpan.ZERO;
        }
        this.m_oContentExtent = this.m_oContentExtent.topLeft(new CoordPair(oRCTLX, oRCTLY));
        this.m_oContentExtent = this.m_oContentExtent.width(moContentW, false);
        this.m_oContentExtent = this.m_oContentExtent.height(moContentH, false);
        this.m_oCaptionExtent = this.m_oCaptionExtent.topLeft(new CoordPair(oRCapTLX, oRCapTLY));
        this.m_oCaptionExtent = this.m_oCaptionExtent.width(moCaptionW, false);
        this.m_oCaptionExtent = this.m_oCaptionExtent.height(moCaptionH, false);
        this.initWidthHeight(oNode, false);
    }

    private void initFromSVG(Element oContainer) {
        this.mbIsProxy = true;
        Element renderAs = oContainer.peekElement(XFA.RENDERASTAG, false, 0);
        SVGNode svg = (SVGNode)renderAs.peekElement(SVG.SVGTAG, false, 0);
        this.m_oMinW = svg.getSVGWidth();
        this.m_oMinW = this.m_oMinW.changeUnits(3);
        this.m_oMinH = svg.getSVGHeight();
        this.m_oMinH = this.m_oMinH.changeUnits(3);
        this.m_oNE = this.m_oNE.width(this.m_oMinW, false);
        this.m_oNE = this.m_oNE.height(this.m_oMinH, false);
        this.m_oMaxW = this.m_oMinW;
        this.m_oMaxH = this.m_oMinH;
        int r = 0;
        UnitSpan oRCTLX = UnitSpan.ZERO;
        UnitSpan oRCTLY = UnitSpan.ZERO;
        SVGNode content = svg.getRegionGroup(false);
        content.parseTransform(oRCTLX, oRCTLY, r);
        this.preProcessGlyphs(content);
        UnitSpan oContentW = content.getMeasurement(SVG.WIDTHTAG);
        UnitSpan oContentH = content.getMeasurement(SVG.HEIGHTTAG);
        UnitSpan oRCapTLX = UnitSpan.ZERO;
        UnitSpan oRCapTLY = UnitSpan.ZERO;
        UnitSpan oCaptionW = UnitSpan.ZERO;
        UnitSpan oCaptionH = UnitSpan.ZERO;
        SVGNode caption = svg.getRegionGroup(true);
        if (caption == null) {
            this.m_bHasCaption = false;
        } else {
            this.m_bHasCaption = true;
            caption.parseTransform(oRCapTLX, oRCapTLY, r);
            oCaptionW = caption.getMeasurement(SVG.WIDTHTAG);
            oCaptionH = caption.getMeasurement(SVG.HEIGHTTAG);
            this.preProcessGlyphs(caption);
        }
        if (0 > oContentW.value()) {
            oContentW = UnitSpan.ZERO;
        }
        if (0 > oContentH.value()) {
            oContentH = UnitSpan.ZERO;
        }
        if (0 > oCaptionW.value()) {
            oCaptionW = UnitSpan.ZERO;
        }
        if (0 > oCaptionH.value()) {
            oCaptionH = UnitSpan.ZERO;
        }
        this.m_oContentExtent = this.m_oContentExtent.topLeft(new CoordPair(oRCTLX, oRCTLY));
        this.m_oContentExtent = this.m_oContentExtent.width(oContentW, false);
        this.m_oContentExtent = this.m_oContentExtent.height(oContentH, false);
        this.m_oContentExtent = this.m_oCaptionExtent.topLeft(new CoordPair(oRCapTLX, oRCapTLY));
        this.m_oContentExtent = this.m_oCaptionExtent.width(oCaptionW, false);
        this.m_oContentExtent = this.m_oCaptionExtent.height(oCaptionH, false);
    }

    private void preProcessGlyphs(Element group) {
        for (SVGNode t = (SVGNode)group.getFirstXFAChild(); t != null; t = (SVGNode)t.getNextXFASibling()) {
            if (t.getClassTag() != SVG.TEXTTAG) continue;
            boolean bTextBold = false;
            boolean bTextItalic = false;
            String sTextTypefaceName = t.getAttribute(SVG.FONTFAMILYTAG).toString();
            Attribute boldState = t.peekAttribute(SVG.FONTWEIGHTTAG);
            if (boldState != null) {
                bTextBold = boldState.toString().equals("bold");
            }
            UnitSpan oTextPointSize = t.getMeasurement(SVG.FONTSIZETAG);
            Attribute fontStyle = t.peekAttribute(SVG.FONTSTYLETAG);
            if (fontStyle != null) {
                bTextItalic = fontStyle.toString().equals("italic");
            }
            String sTextEncoding = t.getAttribute(SVG.CODEPAGETAG).toString();
            FontInfo oTextFontInfo = new FontInfo(sTextTypefaceName, bTextBold ? 700 : 400, bTextItalic);
            FontInstance oTextFontInstance = this.m_oGfxLayoutEnv.fontService().reconcile(oTextFontInfo, oTextPointSize, 1.0, 1.0);
            for (SVGNode tspan = (SVGNode)t.getFirstXFAChild(); tspan != null; tspan = (SVGNode)tspan.getNextXFASibling()) {
                FontInstance oFontInstance;
                int nGlyphs = 0;
                if (tspan.getClassTag() != SVG.TSPANTAG && tspan.getClassTag() != SVG.ALTGLYPHTAG) continue;
                String sTypefaceName = sTextTypefaceName;
                Attribute typeface = tspan.peekAttribute(SVG.FONTFAMILYTAG);
                if (typeface != null) {
                    sTypefaceName = typeface.toString();
                }
                boolean bBold = bTextBold;
                Attribute bold = tspan.peekAttribute(SVG.FONTWEIGHTTAG);
                if (bold != null) {
                    bBold = bold.toString().equals("bold");
                }
                UnitSpan oPointSize = oTextPointSize;
                Attribute pointSize = tspan.peekAttribute(SVG.FONTSIZETAG);
                if (pointSize != null) {
                    oPointSize = tspan.getMeasurement(SVG.FONTSIZETAG);
                }
                boolean bItalic = bTextItalic;
                fontStyle = tspan.peekAttribute(SVG.FONTSTYLETAG);
                if (fontStyle != null) {
                    bItalic = fontStyle.toString().equals("italic");
                }
                Attribute encoding = tspan.peekAttribute(SVG.CODEPAGETAG);
                String sEncoding = "";
                if (encoding != null) {
                    sEncoding = encoding.toString();
                }
                if (sTypefaceName.equals(sTextTypefaceName) && sEncoding.equals(sTextEncoding) && bBold == bTextBold && bItalic == bTextItalic) {
                    oFontInstance = oTextFontInstance;
                } else {
                    FontInfo oFontInfo = new FontInfo(sTypefaceName, bBold ? 700 : 400, bItalic);
                    oFontInstance = this.m_oGfxLayoutEnv.fontService().reconcile(oFontInfo, oPointSize, 1.0, 1.0);
                }
                if (oFontInstance == null) continue;
                if (tspan.getClassTag() == SVG.ALTGLYPHTAG) {
                    String sContent = "";
                    nGlyphs = (sContent.length() + 1) / 5;
                    int[] pnGlyphs = new int[nGlyphs];
                    String whitespace = ", ";
                    StringTokenizer sToker = new StringTokenizer(sContent, whitespace);
                    for (int i = 0; i < nGlyphs; ++i) {
                        int nID;
                        String sID = sToker.nextToken();
                        pnGlyphs[i] = nID = StringUtils.safeNumber(sID, 16);
                        oFontInstance.getFontItem().addSubsettedGlyphs(nID, 0);
                    }
                    tspan.storeGlyphs(oFontInstance, pnGlyphs, nGlyphs);
                    continue;
                }
                SVGTextData text = (SVGTextData)tspan.getProperty(SVG.TEXTDATATAG, 0);
                if (text == null) continue;
                String sContent = text.getValue();
                for (int i = 0; i < sContent.length(); ++i) {
                    oFontInstance.getFontItem().addSubsettedGlyphs(0, sContent.charAt(i));
                }
                tspan.storeText(oFontInstance, sContent);
            }
        }
    }
}

