/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;

final class BuiltinScientific {
    private BuiltinScientific() {
    }

    static void Acos(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block3: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                if (-1.0 > nVal || nVal > 1.0) {
                    throw new CalcException();
                }
                oRetSym = new CalcSymbol(Math.acos(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block3;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Asin(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block3: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                if (-1.0 > nVal || nVal > 1.0) {
                    throw new CalcException();
                }
                oRetSym = new CalcSymbol(Math.asin(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block3;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Atan(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.atan(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Atan2(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal1 = oParser.getNumeric(oArgSym[0]);
                double nVal2 = oParser.getNumeric(oArgSym[1]);
                oRetSym = new CalcSymbol(Math.atan2(nVal1, nVal2));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Cos(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.cos(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Deg2Rad(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(nVal * Math.PI / 180.0);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Exp(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.exp(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Log(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block3: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                if (nVal <= 0.0) {
                    throw new CalcException();
                }
                oRetSym = new CalcSymbol(Math.log(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block3;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Pi(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.maxArgs(nArgs, 0);
                oRetSym = new CalcSymbol(Math.PI);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Pow(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal1 = oParser.getNumeric(oArgSym[0]);
                double nVal2 = oParser.getNumeric(oArgSym[1]);
                oRetSym = nVal2 == 0.0 ? new CalcSymbol(1.0) : new CalcSymbol(Math.pow(nVal1, nVal2));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Rad2Deg(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(nVal * 180.0 / Math.PI);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Sin(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.sin(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Sqrt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block3: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                if (nVal < 0.0) {
                    throw new CalcException();
                }
                oRetSym = new CalcSymbol(Math.sqrt(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block3;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Tan(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.tan(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }
}

