/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.Int;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormInstanceManagerScript;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.form.FormSubformSet;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.ResId;
import java.util.ArrayList;
import java.util.List;

public class FormInstanceManager
extends ProtoableNode {
    private final List<Element> mInstances = new ArrayList<Element>();
    private ProtoableNode mTemplateNode;
    private boolean mbMatchDescendantsOnly;
    private InstanceListener mListener;
    private boolean mbInitializingNewInstance;

    public FormInstanceManager(Element parent, Node prevSibling) {
        super(parent, prevSibling, "", "instanceManager", "instanceManager", null, XFA.INSTANCEMANAGERTAG, "instanceManager");
    }

    public void setInstances(int nNumber, boolean bThrow) {
        int nMax = this.getMax();
        FormModel formModel = (FormModel)this.getModel();
        if (formModel.mergeMode() == 9175041) {
            if (bThrow) {
                throw new ExFull(ResId.InstanceManagmentNotAllowed);
            }
            return;
        }
        if (nNumber < 0) {
            if (bThrow) {
                throw new ExFull(new MsgFormatPos(ResId.OccurrenceViolationException, "min"));
            }
            return;
        }
        if (nNumber > nMax && nMax != -1) {
            if (bThrow) {
                throw new ExFull(new MsgFormatPos(ResId.OccurrenceViolationException, "max"));
            }
            return;
        }
        if (nNumber < this.getMin()) {
            if (bThrow) {
                throw new ExFull(new MsgFormatPos(ResId.OccurrenceViolationException, "min"));
            }
            return;
        }
        if (nNumber > this.getCount()) {
            int nManagerIndex = this.getIndex();
            nNumber -= this.getCount();
            for (int i = 0; i < nNumber; ++i) {
                this.addChild(nManagerIndex, this.getCount(), true);
            }
        } else if (nNumber < this.getCount()) {
            nNumber = this.getCount() - nNumber;
            for (int i = 0; i < nNumber; ++i) {
                this.removeInstance(this.mInstances.size() - 1, false);
            }
        }
        this.clearDefaults();
        this.notifyPeers(0, "", null);
    }

    public Node addInstance(boolean bMerge) {
        return this.addInstance(this.getCount(), bMerge);
    }

    Node addInstance(int nInstance, boolean bMerge) {
        int nMax = this.getMax();
        Node bRet = null;
        FormModel formModel = (FormModel)this.getModel();
        if (formModel.mergeMode() == 9175041) {
            throw new ExFull(ResId.InstanceManagmentNotAllowed);
        }
        if (nInstance > this.getCount()) {
            throw new ExFull(ResId.IndexOutOfBoundsException);
        }
        if (nMax != -1 && nMax <= this.getCount()) {
            throw new ExFull(new MsgFormatPos(ResId.OccurrenceViolationException, "max"));
        }
        int nManagerIndex = this.getIndex();
        bRet = this.addChild(nManagerIndex, nInstance, bMerge);
        this.clearDefaults();
        this.notifyPeers(0, "", null);
        return bRet;
    }

    void addInstance(Node instance, boolean bValidate) {
        int nMax;
        if (bValidate && (nMax = this.getMax()) != -1 && nMax < this.getCount()) {
            throw new ExFull(new MsgFormatPos(ResId.OccurrenceViolationException, "max"));
        }
        if (instance instanceof FormSubform) {
            FormSubform formSubformInstance = (FormSubform)instance;
            formSubformInstance.setInstanceManager(this);
            this.mInstances.add(formSubformInstance);
        } else if (instance instanceof FormSubformSet) {
            FormSubformSet formSubformSetInstance = (FormSubformSet)instance;
            formSubformSetInstance.setInstanceManager(this);
            this.mInstances.add(formSubformSetInstance);
        }
    }

    public void removeInstance(int nInstance, boolean bNotifyPeers) {
        Model model;
        Element instance;
        if (nInstance >= this.getCount()) {
            throw new ExFull(ResId.IndexOutOfBoundsException);
        }
        if (this.getCount() - 1 < this.getMin()) {
            throw new ExFull(new MsgFormatPos(ResId.OccurrenceViolationException, "min"));
        }
        FormModel formModel = (FormModel)this.getModel();
        if (formModel.mergeMode() == 9175041) {
            throw new ExFull(ResId.InstanceManagmentNotAllowed);
        }
        Element removedFormNode = instance = this.mInstances.get(nInstance);
        if (null != this.mListener) {
            this.mListener.preRemoveInstance(removedFormNode);
        }
        List<ScriptHandler> handlers = this.getAppModel().getScriptHandlers();
        for (int i = 0; i < handlers.size(); ++i) {
            handlers.get(i).removeReference(removedFormNode);
        }
        boolean bLegacy = this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING);
        this.cleanDataNodes(instance, bLegacy);
        if (instance instanceof FormSubform) {
            FormSubform formSubformInstance = (FormSubform)instance;
            formSubformInstance.setInstanceManager(null);
        } else if (instance instanceof FormSubformSet) {
            FormSubformSet formSubformSetInstance = (FormSubformSet)instance;
            formSubformSetInstance.setInstanceManager(null);
        }
        instance.remove();
        this.mInstances.remove(nInstance);
        if (null != this.mListener) {
            this.mListener.postRemoveInstance(removedFormNode);
        }
        if (bNotifyPeers) {
            if (nInstance < this.getCount()) {
                this.broadcastIndexChange(nInstance, this.getCount() - 1, true);
            }
            this.clearDefaults();
            this.notifyPeers(0, "", null);
        }
        if ((model = this.getModel()) != null) {
            model.removeReferences(instance);
        }
    }

    private static void arrangeProtos(ProtoableNode templateNode, int nInstance, int nPosition) {
        if (templateNode == null) {
            return;
        }
        boolean bContainer = templateNode.isContainer();
        boolean bField = templateNode.isSameClass(XFA.FIELDTAG);
        if (bField || bContainer) {
            templateNode.moveProtos(nInstance, nPosition);
        }
        if (bContainer) {
            int len = templateNode.getXFAChildCount();
            for (int i = 0; i < len; ++i) {
                FormInstanceManager.arrangeProtos((ProtoableNode)templateNode.getXFAChild(i), nInstance, nPosition);
            }
        }
    }

    public void moveInstance(int nInstance, int nPosition, boolean bNotify) {
        FormModel formModel = (FormModel)this.getModel();
        if (formModel.mergeMode() == 9175041) {
            throw new ExFull(ResId.InstanceManagmentNotAllowed);
        }
        if (nInstance == nPosition) {
            return;
        }
        if (this.getCount() < 2 || nPosition < 0 || nPosition >= this.getCount() || nInstance < 0 || nInstance >= this.getCount()) {
            throw new ExFull(ResId.IndexOutOfBoundsException);
        }
        int nMax = this.getMax();
        if (nMax == 0 || nMax == 1) {
            throw new ExFull(new MsgFormatPos(ResId.OccurrenceViolationException, "max"));
        }
        Element instance = this.mInstances.get(nInstance);
        Element position = this.mInstances.get(nPosition);
        Element movedFormNode = instance;
        if (null != this.mListener) {
            this.mListener.preMoveInstance(movedFormNode);
        }
        this.mInstances.remove(nInstance);
        Element parent = this.getXFAParent();
        Node refNode = null;
        if (this.getCount() > nPosition) {
            refNode = this.mInstances.get(nPosition);
            this.mInstances.add(nPosition, instance);
        } else {
            int nRefIndex = this.getIndex() + this.getCount() + 2;
            int nCount = 0;
            Node child = parent.getFirstXFAChild();
            while (child != null) {
                if (nCount == nRefIndex) {
                    refNode = child;
                    break;
                }
                child = child.getNextXFASibling();
                ++nCount;
            }
            this.mInstances.add(instance);
        }
        if (refNode == null) {
            parent.appendChild(instance, false);
        } else {
            parent.insertChild(instance, refNode, false);
        }
        if (null != this.mListener) {
            this.mListener.postMoveInstance(movedFormNode);
        }
        this.moveDataNodes(nInstance, nPosition);
        ProtoableNode poInstanceProto = ((ProtoableNode)instance).getProto();
        ProtoableNode poPositionProto = ((ProtoableNode)position).getProto();
        if (poInstanceProto == poPositionProto) {
            FormInstanceManager.arrangeProtos(poInstanceProto, nInstance, nPosition);
        }
        if (bNotify) {
            boolean bUseRange = !this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING);
            this.broadcastIndexChange(nInstance, nPosition, bUseRange);
            this.clearDefaults();
            this.notifyPeers(0, "", null);
        }
    }

    private void addDataNodes(int nIndex) {
    }

    public void setInstanceListener(InstanceListener listener) {
        this.mListener = listener;
    }

    void cleanup(Node node) {
        for (int i = 0; i < this.mInstances.size(); ++i) {
            Element poInstance = this.mInstances.get(i);
            if (node != poInstance) continue;
            this.mInstances.remove(i);
            break;
        }
    }

    int getCount() {
        return this.mInstances.size();
    }

    int getMin() {
        Element occur = this.getElement(XFA.OCCURTAG, 0);
        Int min = (Int)occur.getAttribute(XFA.MINTAG);
        return min.getValue();
    }

    int getMax() {
        Element occur = this.getElement(XFA.OCCURTAG, 0);
        Int max = (Int)occur.getAttribute(XFA.MAXTAG);
        return max.getValue();
    }

    void setTemplateNode(ProtoableNode templateNode) {
        String aName = templateNode.getName();
        aName = aName == "" ? "_" : ("_" + aName).intern();
        this.privateSetName(aName);
        this.mTemplateNode = templateNode;
        ProtoableNode occur = (ProtoableNode)templateNode.getElement(XFA.OCCURTAG, true, 0, false, false);
        if (occur != null) {
            occur.createProto(this, false);
        }
    }

    int findIndex(Node instance) {
        for (int i = 0; i < this.mInstances.size(); ++i) {
            if (this.mInstances.get(i) != instance) continue;
            return i;
        }
        return 0;
    }

    private void clearDefaults() {
        for (int i = 0; i < this.mInstances.size(); ++i) {
            this.mInstances.get(i).makeNonDefault(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node addChild(int nManagerIndex, int nInsertIndex, boolean bMerge) {
        if (this.mbInitializingNewInstance) {
            MsgFormatPos formatPos = new MsgFormatPos(ResId.XFAAddInstanceRecursiveException);
            ProtoableNode node = this.getTemplateNode();
            if (null != node) {
                formatPos.format(((Node)node).getName());
            }
            throw new ExFull(formatPos);
        }
        FormModel formModel = (FormModel)this.getModel();
        Element parent = this.getXFAParent();
        if (null != this.mListener) {
            this.mListener.preAddInstance();
        }
        Element mappedParent = parent.isMapped() ? parent : FormModel.getMappedParent(parent);
        boolean bMatchDescendantsOnly = formModel.getMatchDescendantsOnly();
        formModel.setMatchDescendantsOnly(this.getMatchDescendantsOnly());
        DataNode dataParent = FormModel.getDataNode(mappedParent);
        Element newFormNode = null;
        formModel.setAllowNewNodes(true);
        if (!bMerge) {
            formModel.setEmptyMerge(true);
            if (formModel.mergeMode() == 0x8C0000) {
                newFormNode = formModel.createEmptyFormNode(this.getTemplateNode(), parent, null, this);
            }
        } else {
            formModel.setEmptyMerge(false);
            if (this.getTemplateNode() instanceof Subform) {
                Container.FormInfo info = formModel.getFormInfo(this.getTemplateNode(), dataParent, null);
                DataNode matched = formModel.findMatch(info, true, FormModel.DatasetSelector.MAIN_DATASET);
                if (matched != null) {
                    newFormNode = formModel.createFormNode(this.getTemplateNode(), parent, this);
                    formModel.bindNodes(newFormNode, matched, false);
                    formModel.consumeDataNode(null, matched, FormModel.DatasetSelector.MAIN_DATASET);
                    formModel.createAndMatchChildren(this.getTemplateNode(), matched, newFormNode, null);
                } else if (info != null && (info.eMergeType == 2031618 || info.eMergeType == 2031619) && formModel.mergeMode() == 0x8C0000) {
                    newFormNode = formModel.createEmptyFormNode(this.getTemplateNode(), parent, null, this);
                }
            }
            if (newFormNode == null) {
                newFormNode = formModel.createFormNode(this.getTemplateNode(), parent, this);
                if (formModel.mergeMode() == 9175041) {
                    int eMergeType = formModel.mergeType(this.getTemplateNode(), "", null);
                    DataNode dataNode = formModel.createDataNode(newFormNode, dataParent, eMergeType, true);
                    formModel.bindNodes(newFormNode, dataNode, true);
                    formModel.consumeDataNode(null, dataNode, FormModel.DatasetSelector.MAIN_DATASET);
                    dataParent = dataNode;
                }
                formModel.createAndMatchChildren(this.getTemplateNode(), dataParent, newFormNode, null);
            }
        }
        formModel.setAllowNewNodes(false);
        Node refNode = null;
        int nRefIndex = nManagerIndex + this.getCount();
        if (parent.getXFAChildCount() > nRefIndex + 1) {
            refNode = parent.getXFAChild(nRefIndex);
        }
        if (refNode != null) {
            parent.insertChild(newFormNode, refNode, true);
        }
        if (!formModel.isLoading() || !formModel.getIgnoreCheckSum()) {
            formModel.mergeSecondPass(parent, dataParent);
        }
        if (newFormNode instanceof Container) {
            formModel.setDynamicProperties((Container)newFormNode, "", true);
        }
        this.addDataNodes(nInsertIndex);
        formModel.setMatchDescendantsOnly(bMatchDescendantsOnly);
        if (null != this.mListener) {
            Element oNewFormNode = newFormNode;
            this.mListener.postAddInstance(oNewFormNode);
        }
        this.moveInstance(this.getCount() - 1, nInsertIndex, false);
        assert (!this.mbInitializingNewInstance);
        if (!this.mbInitializingNewInstance) {
            this.mbInitializingNewInstance = true;
            try {
                String sInitialize = EnumAttr.getString(0x4B0000);
                formModel.eventOccurred(sInitialize, newFormNode);
            }
            finally {
                this.mbInitializingNewInstance = false;
            }
        }
        if (this.getCount() > 0) {
            this.broadcastIndexChange(this.getCount() - 1, nInsertIndex, true);
        }
        assert (!this.mbInitializingNewInstance);
        return newFormNode;
    }

    private static void insertNodeAfter(Node newNode, Node prevRefNode) {
        Element parent = prevRefNode.getXFAParent();
        if (parent == null) {
            throw new ExFull(ResId.InsertFailedException);
        }
        Node refNode = prevRefNode.getNextXFASibling();
        if (refNode != null) {
            if (newNode != refNode) {
                parent.insertChild(newNode, refNode, true);
            }
        } else {
            parent.appendChild(newNode, true);
        }
    }

    private void moveDataNodes(int nFrom, int nTo) {
        Element refNode;
        Element instance = this.mInstances.get(nTo);
        ArrayList<Element> dataNodes = new ArrayList<Element>();
        ArrayList<Element> prevRefDataNodes = new ArrayList<Element>();
        ArrayList<Element> postRefDataNodes = new ArrayList<Element>();
        this.getDataNodes(instance, dataNodes);
        int nNodeSet = dataNodes.size();
        boolean bGiveWarning = false;
        if (nTo > 0) {
            refNode = this.mInstances.get(nTo - 1);
            this.getDataNodes(refNode, prevRefDataNodes);
            int nPrevSet = prevRefDataNodes.size();
            if (nNodeSet == nPrevSet && nNodeSet == 1) {
                FormInstanceManager.insertNodeAfter((Node)dataNodes.get(0), (Node)prevRefDataNodes.get(0));
                return;
            }
            if (nNodeSet > nPrevSet) {
                bGiveWarning = true;
            }
            boolean bFound = false;
            for (int i = nNodeSet; i > 0; --i) {
                Element node = (Element)dataNodes.get(i - 1);
                for (int j = nPrevSet; j > 0; --j) {
                    Element node2 = (Element)prevRefDataNodes.get(j - 1);
                    if (!node2.isSameClass(node) || node.getName() != node2.getName()) continue;
                    bFound = true;
                    FormInstanceManager.insertNodeAfter(node, node2);
                    break;
                }
                if (bFound) continue;
                bGiveWarning = true;
            }
        }
        if (nTo + 1 < this.getCount()) {
            refNode = this.mInstances.get(nTo + 1);
            this.getDataNodes(refNode, postRefDataNodes);
            int nPostSet = postRefDataNodes.size();
            if (nNodeSet == nPostSet && nNodeSet == 1 && nTo == 0) {
                ((Element)postRefDataNodes.get(0)).getXFAParent().insertChild((Node)dataNodes.get(0), (Node)postRefDataNodes.get(0), true);
                return;
            }
            if (nNodeSet < nPostSet) {
                bGiveWarning = true;
            }
            block2: for (int i = 0; i < nNodeSet; ++i) {
                Element node = (Element)dataNodes.get(i);
                for (int j = 0; j < nPostSet; ++j) {
                    Element node2 = (Element)postRefDataNodes.get(j);
                    if (!node2.isSameClass(node) || node.getName() != node2.getName() || nTo != 0) continue;
                    node.getXFAParent().insertChild(node, node2, true);
                    continue block2;
                }
            }
        }
        if (bGiveWarning) {
            MsgFormatPos msgFormatPos = new MsgFormatPos(ResId.XFAMoveInstanceException);
            msgFormatPos.format(instance.getClassAtom());
            msgFormatPos.format(instance.getName());
            msgFormatPos.format(Integer.toString(nFrom));
            msgFormatPos.format(Integer.toString(nTo));
            throw new ExFull(msgFormatPos);
        }
    }

    private void getDataNodes(Node formNode, List<Element> dataNodes) {
        boolean bGetChildren = false;
        DataNode dataNode = null;
        if (formNode instanceof FormSubform) {
            bGetChildren = true;
            dataNode = ((FormSubform)formNode).getDataNode();
        } else if (formNode instanceof FormSubformSet) {
            bGetChildren = true;
        } else if (formNode instanceof FormField) {
            dataNode = ((FormField)formNode).getDataNode();
        } else if (formNode instanceof FormExclGroup) {
            bGetChildren = true;
            dataNode = ((FormExclGroup)formNode).getDataNode();
        }
        if (dataNode != null) {
            if (dataNode.getXFAParent() != null) {
                dataNodes.add(dataNode);
            }
            return;
        }
        if (bGetChildren) {
            for (Node childNode = formNode.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
                if (!(childNode instanceof Element)) continue;
                this.getDataNodes((Element)childNode, dataNodes);
            }
        }
    }

    private int getIndex() {
        Element parent = this.getXFAParent();
        int index = 0;
        Node child = parent.getFirstXFAChild();
        while (child != null && child != this) {
            child = child.getNextXFASibling();
            ++index;
        }
        return index;
    }

    private void broadcastIndexChange(int nStart, int nEnd, boolean bRange) {
        FormModel formModel = (FormModel)this.getModel();
        String sIndexChange = EnumAttr.getString(4915221);
        if (bRange) {
            int nMin = Math.min(nStart, nEnd);
            int nMax = Math.max(nStart, nEnd);
            for (int i = nMin; i <= nMax; ++i) {
                formModel.eventOccurred(sIndexChange, this.mInstances.get(i));
            }
        } else {
            formModel.eventOccurred(sIndexChange, this.mInstances.get(nStart));
            if (nStart != nEnd) {
                formModel.eventOccurred(sIndexChange, this.mInstances.get(nEnd));
            }
        }
    }

    private boolean canRestoreCount(Element node, FormModel model) {
        if (model.getIgnoreCheckSum()) {
            return true;
        }
        int eRetValue = model.mergeType(node, "", null);
        if (eRetValue != 0x1F0000 && eRetValue != 2031618) {
            return false;
        }
        if (node.isContainer()) {
            for (Node childNode = node.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
                if (!(childNode instanceof Element) || this.canRestoreCount((Element)childNode, model)) continue;
                return false;
            }
        }
        return true;
    }

    private void cleanDataNodes(Node formNode, boolean bLegacyMode) {
        boolean bGetChildren = false;
        DataNode dataNode = null;
        if (formNode instanceof FormSubform) {
            bGetChildren = true;
            FormSubform formSubform = (FormSubform)formNode;
            dataNode = formSubform.getDataNode();
            formSubform.cleanupListeners();
        } else if (formNode instanceof FormSubformSet) {
            bGetChildren = true;
        } else if (formNode instanceof FormField) {
            FormField formField = (FormField)formNode;
            dataNode = formField.getDataNode();
            formField.cleanupListeners();
        } else if (formNode instanceof FormExclGroup) {
            bGetChildren = true;
            FormExclGroup formExclGroup = (FormExclGroup)formNode;
            dataNode = formExclGroup.getDataNode();
            formExclGroup.cleanupListeners();
        }
        if (dataNode != null && dataNode.getXFAParent() != null) {
            int nPeer = 0;
            int nListenerCount = 0;
            Peer peer = dataNode.getPeer(nPeer);
            while (peer != null) {
                if (peer instanceof FormDataListener) {
                    ++nListenerCount;
                }
                peer = dataNode.getPeer(++nPeer);
            }
            if (nListenerCount == 0) {
                dataNode.remove();
            }
            if (bLegacyMode) {
                return;
            }
        }
        if (bGetChildren) {
            for (Node child = formNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                this.cleanDataNodes(child, bLegacyMode);
            }
        }
    }

    @Override
    public void getDeltas(Element delta, XFAList list) {
        if (!this.isSameClass(delta)) {
            return;
        }
        FormModel model = (FormModel)this.getModel();
        if (model.isLoading()) {
            Element deltaOccur;
            FormInstanceManager deltaManager = (FormInstanceManager)delta;
            ProtoableNode templateNode = this.mTemplateNode;
            int nNewCount = 0;
            int nStartIndex = deltaManager.getIndex() + 1;
            Element deltaParent = deltaManager.getXFAParent();
            Node deltaChild = deltaParent.getFirstXFAChild();
            for (int nChildIndex = 0; deltaChild != null && nChildIndex != nStartIndex; deltaChild = deltaChild.getNextXFASibling(), ++nChildIndex) {
            }
            while (deltaChild != null && !deltaChild.isSameClass(XFA.INSTANCEMANAGERTAG)) {
                if (deltaChild.isSameClass(templateNode)) {
                    ++nNewCount;
                }
                deltaChild = deltaChild.getNextXFASibling();
            }
            if (list != null && delta instanceof Element && (deltaOccur = delta.getElement(XFA.OCCURTAG, true, 0, false, false)) != null) {
                Element thisOccur = this.getElement(XFA.OCCURTAG, 0);
                Int value = (Int)deltaOccur.getAttribute(XFA.MINTAG, true, false);
                if (value != null) {
                    thisOccur.setAttribute(value, XFA.MINTAG);
                }
                if ((value = (Int)deltaOccur.getAttribute(XFA.MAXTAG, true, false)) != null) {
                    thisOccur.setAttribute(value, XFA.MAXTAG);
                }
                if ((value = (Int)deltaOccur.getAttribute(XFA.INITIALTAG, true, false)) != null) {
                    thisOccur.setAttribute(value, XFA.INITIALTAG);
                }
            }
            if (nNewCount != this.getCount() && this.canRestoreCount(templateNode, model)) {
                this.setInstances(nNewCount, false);
            }
        }
        super.getDeltas(delta, list);
    }

    boolean instanceManagerPermsCheck() {
        if (!this.checkAncestorPerms()) {
            return false;
        }
        for (int nIndex = 0; nIndex < this.mInstances.size(); ++nIndex) {
            Element instance = this.mInstances.get(nIndex);
            if (instance == null || instance.checkDescendentPerms()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ScriptTable getScriptTable() {
        return FormInstanceManagerScript.getScriptTable();
    }

    private ProtoableNode getTemplateNode() {
        return this.mTemplateNode;
    }

    public void setMatchDescendantsOnly(boolean bDescendantsOnly) {
        this.mbMatchDescendantsOnly = bDescendantsOnly;
    }

    public boolean getMatchDescendantsOnly() {
        return this.mbMatchDescendantsOnly;
    }

    public static interface InstanceListener {
        public void preAddInstance();

        public void preRemoveInstance(Node var1);

        public void preMoveInstance(Node var1);

        public void postAddInstance(Node var1);

        public void postRemoveInstance(Node var1);

        public void postMoveInstance(Node var1);
    }
}

