/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.font;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.xfa.font.FontInfo;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.ut.UnitSpan;
import java.util.HashMap;
import java.util.Map;

public class FontItem
extends FontInfo {
    private final Font mAFEFont;
    private PDFFontDescription mAFEPDFDesc;
    private double mAscent;
    private double mLegacyAscent;
    private double mDescent;
    private double mLineGap;
    private double mLegacyLineGap;
    private double mSpacing;
    private final Map<Integer, Integer> mGlyphMap = new HashMap<Integer, Integer>();
    private final Map<InstanceKey, FontInstance> mInstances = new HashMap<InstanceKey, FontInstance>();

    FontItem(FontInfo info, Font afeFont) {
        super(info);
        this.mAFEFont = afeFont;
    }

    public static double ctLegacyScale(double emScale, double advance) {
        assert (emScale != 0.0);
        double onePtRel = advance / emScale;
        long truncated = (long)(onePtRel * 65536.0);
        double result = (double)truncated / 65536.0;
        return result;
    }

    public Font getAFEFont() {
        return this.mAFEFont;
    }

    public double getAscent() {
        return this.mAscent;
    }

    public double getLegacyAscent() {
        return this.mLegacyAscent;
    }

    public double getDescent() {
        return this.mDescent;
    }

    public double getLineGap() {
        return this.mLineGap;
    }

    public double getLegacyLineGap() {
        return this.mLegacyLineGap;
    }

    public double getSpacing() {
        return this.mSpacing;
    }

    public double getCharWidth(int c, boolean useHorizontalGlyphs) {
        int glyphID = this.getGlyphID(c);
        if (glyphID == 0) {
            return -1.0;
        }
        return this.getGlyphWidth(glyphID, useHorizontalGlyphs);
    }

    public int getNotDefGlyphID() {
        return 0;
    }

    public int getGlyphID(int c) {
        Integer value = this.mGlyphMap.get(c);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public double getGlyphWidth(int glyphID, boolean useHorizontalGlyphs) {
        double width = -1.0;
        PDFFontDescription pdfDesc = this.forcePDFDesc();
        if (pdfDesc != null) {
            try {
                width = this.mAFEPDFDesc.getAdvance(glyphID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FontItem.ctLegacyScale(1000.0, width);
    }

    public boolean validateChar(int c, boolean useHorizontalGlyphs) {
        return true;
    }

    public FontInstance reconcile(UnitSpan size) {
        return this.reconcile(size, 1.0, 1.0);
    }

    public FontInstance reconcile(UnitSpan size, double horizontalScale, double verticalScale) {
        InstanceKey key = new InstanceKey(size, horizontalScale, verticalScale);
        FontInstance instance = this.lookup(key);
        if (instance == null) {
            instance = new FontInstance(this, size);
            this.mInstances.put(key, instance);
        }
        return instance;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int hash = 29;
        hash = hash * 31 ^ super.hashCode();
        return hash;
    }

    public static boolean match(FontItem o1, FontItem o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public void addSubsettedGlyphs(int glyph, int chr) {
    }

    public FontItem getUnicodeFont() {
        return this;
    }

    public boolean isPWIDApplied() {
        return false;
    }

    public void mapGlyph(int c, int glyphID) {
        this.mGlyphMap.put(c, glyphID);
    }

    boolean loadMetrics() {
        try {
            LineMetrics lineMetrics = this.mAFEFont.getCoolTypeLineMetrics();
            double scale = this.mAFEFont.getUnitsPerEmY();
            this.mLegacyAscent = this.mAscent = lineMetrics.ascender / scale;
            this.mDescent = -lineMetrics.descender / scale;
            if (this.mAscent + this.mDescent < 1.0) {
                this.mAscent = 1.0 - this.mDescent;
            }
            this.mLineGap = 0.2;
            this.mLegacyLineGap = lineMetrics.linegap / scale;
            this.mSpacing = 1.2;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private FontInstance lookup(InstanceKey key) {
        return this.mInstances.get(key);
    }

    private PDFFontDescription forcePDFDesc() {
        if (this.mAFEPDFDesc == null) {
            try {
                this.mAFEPDFDesc = this.mAFEFont.getPDFFontDescription();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mAFEPDFDesc;
    }

    static class InstanceKey {
        final UnitSpan mSize;
        final float mHorizontalScale;
        final float mVerticalScale;

        InstanceKey(UnitSpan size) {
            this.mSize = size;
            this.mHorizontalScale = 1.0f;
            this.mVerticalScale = 1.0f;
        }

        InstanceKey(UnitSpan size, double horizontalScale, double verticalScale) {
            this.mSize = size;
            this.mHorizontalScale = (float)horizontalScale;
            this.mVerticalScale = (float)verticalScale;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            InstanceKey compare = (InstanceKey)object;
            if (!UnitSpan.match(this.mSize, compare.mSize)) {
                return false;
            }
            return this.mHorizontalScale == compare.mHorizontalScale && this.mVerticalScale == compare.mVerticalScale;
        }

        public int hashCode() {
            int result = this.mSize.hashCode();
            int f = Float.floatToIntBits(this.mHorizontalScale);
            result = result * 31 ^ f;
            f = Float.floatToIntBits(this.mVerticalScale);
            result = result * 31 ^ f;
            return result;
        }
    }
}

