/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.dom.ElementImpl;
import com.adobe.xfa.dom.NodeImpl;
import com.adobe.xfa.dom.ParentNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DocumentImpl
extends ParentNode
implements org.w3c.dom.Document {
    static final String XML_VERSION = "1.1";
    private ElementImpl mDocumentElement;
    private final Document mXFADoc;

    DocumentImpl(Document xfaDoc) {
        super(null, xfaDoc);
        this.mXFADoc = xfaDoc;
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node source) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return null;
    }

    @Override
    public Comment createComment(String data) {
        return null;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return null;
    }

    @Override
    public org.w3c.dom.Element createElement(String name) throws DOMException {
        return null;
    }

    @Override
    public org.w3c.dom.Element createElementNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return null;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return null;
    }

    @Override
    public Text createTextNode(String data) {
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        return null;
    }

    @Override
    public org.w3c.dom.Element getDocumentElement() {
        return this.mDocumentElement;
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public org.w3c.dom.Element getElementById(String elementId) {
        assert (this.mXFADoc != null);
        ElementImpl result = null;
        Element xfaElement = this.mXFADoc.getElementByXMLId(elementId);
        if (xfaElement != null) {
            NodeImpl mappedNode = this.attachNode(xfaElement);
            assert (mappedNode != null);
            assert (mappedNode instanceof ElementImpl);
            result = (ElementImpl)mappedNode;
        }
        return result;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        assert (this.mDocumentElement != null);
        return this.mDocumentElement.getElementsByTagName(name);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        assert (this.mDocumentElement != null);
        return this.mDocumentElement.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public DOMImplementation getImplementation() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public String getXmlVersion() {
        return XML_VERSION;
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node arg0, boolean arg1) throws DOMException {
        throw new DOMException(9, "");
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        assert (this.mDocumentElement != null);
        return this.mDocumentElement.isDefaultNamespace(namespaceURI);
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node other) {
        if (this == other) {
            return true;
        }
        if (!super.isEqualNode(other)) {
            return false;
        }
        return other instanceof DocumentImpl;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setDocumentURI(String documentURI) {
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String result = null;
        if (this.mDocumentElement != null) {
            result = this.mDocumentElement.lookupNamespaceURI(prefix);
        }
        return result;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        String result = null;
        if (this.mDocumentElement != null) {
            result = this.mDocumentElement.lookupPrefix(namespaceURI);
        }
        return result;
    }

    org.w3c.dom.Node attach(Node xfaNode) {
        if (xfaNode instanceof Document) {
            return xfaNode == this.mXFADoc ? this : null;
        }
        return this.attachNode(xfaNode);
    }

    void setDocumentElement(ElementImpl documentElement) {
        assert (this.mDocumentElement == null);
        this.mDocumentElement = documentElement;
    }

    @Override
    boolean testDefaultNamespace(String namespaceURI) {
        return false;
    }

    private NodeImpl attachNode(Node xfaNode) {
        if (xfaNode instanceof Document) {
            assert (xfaNode == this.mXFADoc);
            return this;
        }
        Element xfaParent = DocumentImpl.getXFAParent(xfaNode);
        if (xfaParent == null) {
            return null;
        }
        NodeImpl parentNode = this.attachNode(xfaParent);
        if (parentNode == null) {
            return null;
        }
        assert (parentNode instanceof ParentNode);
        ParentNode parent = (ParentNode)parentNode;
        return parent.lookupXFAChild(xfaNode);
    }
}

