/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.FloatScript;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public final class FloatValue
extends Content {
    public FloatValue(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "float", "float", null, XFA.FLOATTAG, "float");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.getValue() == ((FloatValue)object).getValue();
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getValue());
        return super.hashCode() ^ (int)(bits ^ bits >>> 32);
    }

    @Override
    public ScriptTable getScriptTable() {
        return FloatScript.getScriptTable();
    }

    public double getValue() {
        double dVal = 0.0;
        String sVal = this.getStrValue();
        if (!StringUtils.isEmpty(sVal)) {
            dVal = Numeric.stringToDouble(sVal, false);
        }
        return dVal;
    }

    public void setValue(double newValue, boolean bNotify, boolean bDefault) {
        String sNum = Numeric.doubleToString(newValue, 8, false);
        super.setStrValue(sNum, true, false);
    }

    @Override
    public void setValue(String sValue, boolean bFromData, boolean bNotify, boolean bDefault) {
        if (StringUtils.isEmpty(sValue)) {
            this.setStrValue("", true, false);
        } else {
            double dVal = Numeric.stringToDouble(sValue, true);
            boolean bTypeMismatch = Double.isNaN(dVal);
            if (bTypeMismatch) {
                if (!this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
                    MsgFormatPos oMessage = new MsgFormatPos(ResId.TypeMismatch);
                    oMessage.format(this.getSOMExpression());
                    oMessage.format(sValue);
                    this.getModel().addErrorList(new ExFull(oMessage), 3, this);
                }
                if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING) && !this.getAppModel().getLegacySetting(AppModel.XFA_PATCH_W_2447677)) {
                    this.setValue(0.0, true, false);
                } else if (bFromData) {
                    this.setStrValue(sValue, true, false);
                }
                return;
            }
            this.setValue(dVal, true, false);
        }
    }

    @Override
    public String toString() {
        return Numeric.doubleToString(this.getValue(), 8, false);
    }

    @Override
    public void appendChild(Node child, boolean bValidate) {
        if (child instanceof TextNode) {
            TextNode textChild = (TextNode)child;
            textChild.setValue(FloatValue.normalizeValue(textChild.getValue()), false, textChild.isDefault(true));
        }
        super.appendChild(child, bValidate);
    }

    @Override
    public void insertChild(Node child, Node poRefNode, boolean bValidate) {
        if (child instanceof TextNode) {
            TextNode textChild = (TextNode)child;
            textChild.setValue(FloatValue.normalizeValue(textChild.getValue()), false, textChild.isDefault(true));
        }
        super.insertChild(child, poRefNode, bValidate);
    }

    private static String formatValue(double dValue) {
        return Numeric.doubleToString(dValue, 8, false);
    }

    private static String normalizeValue(String sValue) {
        if (StringUtils.isEmpty(sValue)) {
            return "";
        }
        return FloatValue.formatValue(Numeric.stringToDouble(sValue, false));
    }

    public boolean valueHasTypeMismatch() {
        String sVal = this.getStrValue();
        if (StringUtils.isEmpty(sVal)) {
            return false;
        }
        double dVal = Numeric.stringToDouble(sVal, true);
        return Double.isNaN(dVal);
    }
}

