/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

public class SchemaStrings {
    private final String[] keys;
    private final int[] values;
    private int size;
    private final int hashMask;

    public SchemaStrings(int size) {
        int capacity = SchemaStrings.calculateTableSize(size);
        this.keys = new String[capacity];
        this.values = new int[capacity];
        this.hashMask = capacity - 1;
    }

    private static int calculateTableSize(int capacity) {
        int n;
        assert (capacity > 0);
        capacity = capacity * 10 / 8;
        for (n = 16; capacity > n; n *= 2) {
        }
        return n;
    }

    public void put(String sStr, int eTag) {
        int capacity = this.keys.length;
        assert (this.size < capacity - 1);
        int position = sStr.hashCode() & this.hashMask;
        while (true) {
            assert (!sStr.equals(this.keys[position]));
            if (this.keys[position] == null) {
                this.keys[position] = sStr;
                this.values[position] = eTag;
                ++this.size;
                return;
            }
            if (++position != capacity) continue;
            position = 0;
        }
    }

    public int getInt(String sStr) {
        int capacity = this.keys.length;
        int position = sStr.hashCode() & this.hashMask;
        String key;
        while ((key = this.keys[position]) != null) {
            if (key.equals(sStr)) {
                return this.values[position];
            }
            if (++position != capacity) continue;
            position = 0;
        }
        return -1;
    }
}

