/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import java.util.ArrayList;
import java.util.List;

final class SaveNameSpaceChecker {
    private final Node mStopNode;
    private final List<NameSpaceHolder> mPrefixes = new ArrayList<NameSpaceHolder>();

    public SaveNameSpaceChecker(Node oSaveNode) {
        if (oSaveNode != null) {
            oSaveNode = Element.getXMLParent(oSaveNode);
        }
        this.mStopNode = oSaveNode;
    }

    public Node stopNode() {
        return this.mStopNode;
    }

    public boolean missingPrefix(Element element, String aPrefix, String aNameSpaceURI, boolean bSuppressEmptyNSCheck) {
        boolean bEmpty;
        boolean bl = bEmpty = aPrefix == "" && aNameSpaceURI == "";
        if (bEmpty && (aNameSpaceURI == "http://www.w3.org/XML/1998/namespace" || aPrefix == "xml")) {
            return true;
        }
        NameSpaceHolder nameSpaceHolder = this.locatePrefix(aPrefix);
        if (nameSpaceHolder == null || nameSpaceHolder.getNamespaceOwners().size() == 0) {
            if (bEmpty && bSuppressEmptyNSCheck) {
                return true;
            }
        } else {
            List<NameSpaceOwner> nameSpaceOwners = nameSpaceHolder.getNamespaceOwners();
            for (int i = nameSpaceOwners.size() - 1; i >= 0; --i) {
                Element checkElement = element;
                NameSpaceOwner nameSpaceNode = nameSpaceOwners.get(i);
                while (checkElement != this.mStopNode) {
                    if (checkElement == nameSpaceNode.getOwner()) {
                        return nameSpaceNode.getUri() == aNameSpaceURI;
                    }
                    checkElement = Element.getXMLParent(checkElement);
                }
            }
        }
        return false;
    }

    public void addPrefix(Element element, String aPrefix, String aNamespace) {
        NameSpaceHolder nameSpaceHolder = this.locatePrefix(aPrefix);
        if (nameSpaceHolder == null) {
            nameSpaceHolder = new NameSpaceHolder(aPrefix);
            this.mPrefixes.add(nameSpaceHolder);
        }
        nameSpaceHolder.getNamespaceOwners().add(new NameSpaceOwner(element, aNamespace));
    }

    public void removePrefix(Element element, String aPrefix) {
        NameSpaceHolder nameSpaceHolder = this.locatePrefix(aPrefix);
        if (nameSpaceHolder != null) {
            List<NameSpaceOwner> nameSpaceOwner = nameSpaceHolder.getNamespaceOwners();
            for (int i = nameSpaceOwner.size() - 1; i >= 0; --i) {
                if (element != nameSpaceOwner.get(i).getOwner()) continue;
                nameSpaceOwner.remove(i);
                break;
            }
        }
    }

    private NameSpaceHolder locatePrefix(String aPrefix) {
        int nSize = this.mPrefixes.size();
        for (int i = 0; i < nSize; ++i) {
            NameSpaceHolder nameSpaceHolder = this.mPrefixes.get(i);
            if (aPrefix != nameSpaceHolder.getPrefix()) continue;
            return nameSpaceHolder;
        }
        return null;
    }

    private static final class NameSpaceHolder {
        private final List<NameSpaceOwner> mNameSpaceOwners = new ArrayList<NameSpaceOwner>();
        private final String maPrefix;

        public NameSpaceHolder(String aPrefix) {
            this.maPrefix = aPrefix;
        }

        public List<NameSpaceOwner> getNamespaceOwners() {
            return this.mNameSpaceOwners;
        }

        public String getPrefix() {
            return this.maPrefix;
        }
    }

    private static final class NameSpaceOwner {
        private final Element mOwner;
        private final String maUri;

        public NameSpaceOwner(Element owner, String uri) {
            this.mOwner = owner;
            this.maUri = uri;
        }

        public Element getOwner() {
            return this.mOwner;
        }

        public String getUri() {
            return this.maUri;
        }
    }
}

