/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.AttributeInfo;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.ChildRelnInfo;
import com.adobe.xfa.SchemaPairs;

public final class NodeSchema {
    private AttributeInfo[] mAttributeInfoArray;
    private SchemaPairs mAttributes;
    private SchemaPairs mChildren;
    private ChildRelnInfo[] mChildrenInfoArray;
    private SchemaPairs mForeignChildren;
    private final int mnAttributeMax;
    private final int mnAttributeMin;
    private final int mnElementMax;
    private final int mnElementMin;

    public NodeSchema(int nAttributeMin, int nAttributeMax, int nElementMin, int nElementMax) {
        this.mnAttributeMin = nAttributeMin;
        this.mnAttributeMax = nAttributeMax;
        this.mnElementMin = nElementMin;
        this.mnElementMax = nElementMax;
    }

    public NodeSchema(NodeSchema other, int nAttributeMin, int nAttributeMax, int nElementMin, int nElementMax) {
        this(nAttributeMin, nAttributeMax, nElementMin, nElementMax);
        if (other != null) {
            int attrCount = this.ATTR_COUNT();
            if (other.mAttributes != null) {
                this.mAttributes = new SchemaPairs(other.mAttributes);
            }
            if (other.mAttributeInfoArray != null) {
                this.mAttributeInfoArray = new AttributeInfo[attrCount];
                for (int i = 0; i < attrCount; ++i) {
                    if (other.mAttributeInfoArray[i] == null) continue;
                    this.mAttributeInfoArray[i] = other.mAttributeInfoArray[i];
                }
            }
            int elementCount = this.ELEMENT_COUNT();
            if (other.mChildren != null) {
                this.mChildren = new SchemaPairs(other.mChildren);
            }
            if (other.mChildrenInfoArray != null) {
                this.mChildrenInfoArray = new ChildRelnInfo[elementCount];
                for (int i = 0; i < elementCount; ++i) {
                    if (other.mChildrenInfoArray[i] == null) continue;
                    this.mChildrenInfoArray[i] = other.mChildrenInfoArray[i];
                }
            }
            if (other.mForeignChildren != null) {
                int nSize = other.mForeignChildren.size();
                for (int i = 0; i < nSize; ++i) {
                    ChildRelnInfo copy = null;
                    if (other.mForeignChildren.value(i) != null) {
                        copy = (ChildRelnInfo)other.mForeignChildren.value(i);
                    }
                    this.mForeignChildren.put(other.mForeignChildren.key(i), copy);
                }
            }
        }
    }

    void addAttr(int eTag, Attribute oAttr, int nVersionIntro, int nVersionDep, int nAvailability, int descriptionResID) {
        if (this.mAttributes == null) {
            this.mAttributes = new SchemaPairs();
            assert (this.mAttributeInfoArray == null);
            this.mAttributeInfoArray = new AttributeInfo[this.ATTR_COUNT()];
        }
        this.mAttributes.put(eTag, oAttr);
        int nSlot = this.ATTR_OFFSET(eTag);
        assert (nSlot < this.ATTR_COUNT());
        assert (nSlot >= 0);
        this.mAttributeInfoArray[nSlot] = new AttributeInfo(oAttr, nVersionIntro, nVersionDep, nAvailability, descriptionResID);
        assert (this.ATTR_OFFSET(this.mnAttributeMin) == 0);
    }

    void addChild(int eTag, ChildReln oChildReln, int nVersionIntro, int nVersionDep, int nAvailability, int descriptionResID) {
        if (this.mChildren == null) {
            this.mChildren = new SchemaPairs();
            assert (this.mChildrenInfoArray == null);
            this.mChildrenInfoArray = new ChildRelnInfo[this.ELEMENT_COUNT()];
        }
        this.mChildren.put(eTag, oChildReln);
        int nSlot = this.ELEMENT_OFFSET(eTag);
        assert (nSlot < this.ELEMENT_COUNT());
        assert (nSlot >= 0);
        this.mChildrenInfoArray[nSlot] = new ChildRelnInfo(oChildReln, nVersionIntro, nVersionDep, nAvailability, descriptionResID);
    }

    void addForeignChild(int eTag, ChildReln oChildReln, int nVersionIntro, int nVersionDep, int nAvailability, int descriptionResID) {
        if (this.mForeignChildren == null) {
            this.mForeignChildren = new SchemaPairs();
        }
        if (this.mChildren == null) {
            this.mChildren = new SchemaPairs();
        }
        this.mChildren.put(eTag, oChildReln);
        ChildRelnInfo info = new ChildRelnInfo(oChildReln, nVersionIntro, nVersionDep, nAvailability, descriptionResID);
        this.mForeignChildren.put(eTag, info);
    }

    private int ATTR_COUNT() {
        return this.mnAttributeMax - this.mnAttributeMin + 1;
    }

    private int ATTR_OFFSET(int _e) {
        return _e - this.mnAttributeMin;
    }

    private int ELEMENT_COUNT() {
        return this.mnElementMax - this.mnElementMin + 1;
    }

    private int ELEMENT_OFFSET(int _e) {
        return _e - this.mnElementMin;
    }

    public AttributeInfo getAttributeInfo(int eTag) {
        if (this.mAttributeInfoArray == null || eTag > this.mnAttributeMax || eTag < this.mnAttributeMin) {
            return null;
        }
        return this.mAttributeInfoArray[eTag - this.mnAttributeMin];
    }

    public ChildRelnInfo getChildRelnInfo(int eTag) {
        if (this.mChildrenInfoArray == null || eTag > this.mnElementMax || eTag < this.mnElementMin) {
            if (this.mForeignChildren == null) {
                return null;
            }
            return (ChildRelnInfo)this.mForeignChildren.get(eTag);
        }
        return this.mChildrenInfoArray[eTag - this.mnElementMin];
    }

    public SchemaPairs getValidAttributes() {
        return this.mAttributes;
    }

    public SchemaPairs getValidChildren() {
        return this.mChildren;
    }
}

