/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.AttributeInfo;
import com.adobe.xfa.Chars;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.NodeListFilter;
import com.adobe.xfa.NodeSchema;
import com.adobe.xfa.NodeScript;
import com.adobe.xfa.NodeValidationInfo;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Packet;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class Node
extends Obj {
    public static final int CREATE_REPLACE = 0;
    public static final int CREATE_MUST_NOT_EXIST = 1;
    public static final int CREATE_IF_NOT_EXIST = 2;
    public static final int CREATE_ALWAYS_NEW = 3;
    public static final String gsXFANamespacePrefix = "http://www.xfa.org/schema/";
    private boolean mbDefault;
    private boolean mbLocked;
    private boolean mbIsDirty;
    private boolean mbIsMapped;
    private boolean mbPermsLock;
    private boolean mbIsTransient;
    protected Node mNextXMLSibling;
    private Element mXMLParent;
    private boolean mbChildListModified = true;
    private Document mDocument;
    private Element mXfaPeer;
    private static final ScriptDynamicPropObj locateChildByClassPropObj = new NodeScriptDynamicPropObj(true, 10, 63);
    private static final ScriptDynamicPropObj locateChildByNamePropObj = new NodeScriptDynamicPropObj(false, 10, 63);

    Node(Element parent, Node prevSibling) {
        if (parent == null) {
            return;
        }
        this.mXMLParent = parent;
        parent.setChildListModified(true);
        this.setDocument(parent.getOwnerDocument());
        if (parent.getFirstXMLChild() == null) {
            assert (prevSibling == null);
            parent.setFirstChild(this);
        } else {
            if (prevSibling == null) {
                prevSibling = parent.getLastXMLChild();
            } else assert (prevSibling.getXMLParent() == parent);
            if (prevSibling != null) {
                this.mNextXMLSibling = prevSibling.mNextXMLSibling;
                prevSibling.mNextXMLSibling = this;
            }
        }
        parent.setDirty();
    }

    public Node assignNode(String sSOMExpression, String sValue, int eMode) {
        return null;
    }

    protected Node createChild(boolean bIsLeaf, String aName) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Node#createChild");
    }

    protected boolean canCreateChild(boolean bIsLeaf, String aName) {
        return false;
    }

    public boolean checkPerms() {
        return !this.isPermsLockSet();
    }

    public boolean checkAncestorPerms() {
        for (Node node = this; node != null; node = node.getXFAParent()) {
            if (node.checkPerms()) continue;
            return false;
        }
        return true;
    }

    public boolean checkDescendentPerms() {
        if (!this.checkPerms()) {
            return false;
        }
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (child.checkDescendentPerms()) continue;
            return false;
        }
        return true;
    }

    static void checkValidNameSpace(Object oNode, String sName) {
        if (oNode instanceof Element || oNode instanceof Attribute) {
            String sNameSpaceUri = null;
            sNameSpaceUri = oNode instanceof Element ? ((Element)oNode).getNS() : ((Attribute)oNode).getNS();
            if (sNameSpaceUri == "" && sName.indexOf(58) >= 0 && (!(oNode instanceof Attribute) || sName.startsWith("xmlns:"))) {
                throw new ExFull(ResId.NAMESPACE_PREFIX_ERR);
            }
        }
    }

    public abstract Node clone(Element var1);

    static boolean doQualifyNodeName(String sNodeName, boolean bSuppressThrow) {
        if (StringUtils.isEmpty(sNodeName)) {
            throw new ExFull(ResId.DOM_NODE_NAME_ERR);
        }
        boolean bValid = true;
        int i = 0;
        char cChar = sNodeName.charAt(i);
        if (cChar != '_' && cChar != ':' && !Character.isLetter(cChar)) {
            bValid = false;
        } else {
            ++i;
            while (i < sNodeName.length()) {
                cChar = sNodeName.charAt(i);
                if (cChar != '.' && cChar != '-' && cChar != '_' && cChar != ':' && !Character.isLetterOrDigit(cChar)) {
                    bValid = false;
                    break;
                }
                ++i;
            }
        }
        if (!bSuppressThrow && !bValid) {
            MsgFormatPos oMsg = new MsgFormatPos(ResId.DOM_NODE_NAME_ERR);
            oMsg.format(sNodeName);
            throw new ExFull(oMsg);
        }
        return bValid;
    }

    public NodeList getAll(boolean bByName) {
        if (bByName && this.getName() == "") {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.NoNameException);
            oMessage.format("index").format("classIndex");
            throw new ExFull(oMessage);
        }
        ArrayNodeList all = new ArrayNodeList();
        Element poParent = this.getXFAParent();
        if (poParent == null) {
            all.append(this);
        } else {
            Element pNewParent;
            while (poParent.isTransparent() && (pNewParent = poParent.getXFAParent()) != null) {
                poParent = pNewParent;
            }
            this.getAll(poParent, bByName, all);
        }
        return all;
    }

    private final void getAll(Element parent, boolean bByName, ArrayNodeList all) {
        if (parent == null) {
            return;
        }
        for (Node child = parent.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (this.isLikeNode(child, bByName)) {
                all.append(child);
            }
            if (!(child instanceof Element) || !child.isTransparent()) continue;
            this.getAll((Element)child, bByName, all);
        }
    }

    protected final boolean isChildListModified() {
        return this.mbChildListModified;
    }

    public final int getXMLChildCount() {
        int count = 0;
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            ++count;
        }
        return count;
    }

    public String getData() {
        return "";
    }

    @Override
    protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek) {
        Node child = NodeScript.getScriptChild(this, sPropertyName, !bPropertyOverride);
        if (child != null) {
            return bPropertyOverride ? locateChildByClassPropObj : locateChildByNamePropObj;
        }
        return null;
    }

    protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek, int nXFAVersion, int nAvailability) {
        if (NodeScript.getScriptChild(this, sPropertyName, !bPropertyOverride) != null) {
            ScriptDynamicPropObj propObj;
            ScriptDynamicPropObj scriptDynamicPropObj = propObj = bPropertyOverride ? locateChildByClassPropObj : locateChildByNamePropObj;
            if (propObj.getXFAVersion() == nXFAVersion && propObj.getAvailability() == nAvailability) {
                return propObj;
            }
            return new NodeScriptDynamicPropObj(bPropertyOverride, nXFAVersion, nAvailability);
        }
        return null;
    }

    public Node getFirstXMLChild() {
        return null;
    }

    public final Element getFirstXMLChildElement() {
        return Node.getNextXMLElement(this.getFirstXMLChild());
    }

    public Node getFirstXFAChild() {
        return null;
    }

    public int getIndex(boolean bByName) {
        Element nextParent;
        if (bByName && this.getName() == "") {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.NoNameException);
            oMessage.format("all");
            oMessage.format("getIndex");
            throw new ExFull(oMessage);
        }
        Element parent = this.getXFAParent();
        if (parent == null) {
            return 0;
        }
        while (parent.isTransparent() && (nextParent = parent.getXFAParent()) != null) {
            parent = nextParent;
        }
        IntegerHolder nMatchCount = new IntegerHolder();
        if (this.getIndex(parent, bByName, nMatchCount)) {
            return nMatchCount.value;
        }
        return 0;
    }

    final boolean getIndex(Node parent, boolean bByName, IntegerHolder nMatchCount) {
        if (parent == null) {
            return false;
        }
        for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (this == child) {
                return true;
            }
            if (this.isLikeNode(child, bByName)) {
                ++nMatchCount.value;
            }
            if (!child.isTransparent() || !this.getIndex(child, bByName, nMatchCount)) continue;
            return true;
        }
        return false;
    }

    public Node getLastXMLChild() {
        Element parent = this.getXMLParent();
        if (parent == null) {
            return null;
        }
        Node last = null;
        for (Node child = parent.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            last = child;
        }
        return last;
    }

    public final boolean getLocked() {
        return this.mbLocked;
    }

    public Model getModel() {
        if (this.getXMLParent() != null) {
            return this.getXMLParent().getModel();
        }
        return null;
    }

    public abstract String getName();

    public final Node getNextXMLSibling() {
        return this.mNextXMLSibling;
    }

    public final Element getNextXMLSiblingElement() {
        return Node.getNextXMLElement(this.mNextXMLSibling);
    }

    public Node getNextXFASibling() {
        Node sibling;
        for (sibling = this.mNextXMLSibling; sibling != null && sibling.getClassTag() == XFA.INVALID_ELEMENT; sibling = sibling.getNextXMLSibling()) {
        }
        return sibling;
    }

    public NodeList getNodes() {
        return new ArrayNodeList();
    }

    public final Document getOwnerDocument() {
        return this.mDocument;
    }

    public Element getXMLParent() {
        return this.mXMLParent;
    }

    public Element getXFAParent() {
        return this.getXMLParent();
    }

    public Node getPreviousXMLSibling() {
        Element parent;
        Node node = this;
        if (node instanceof Element.DualDomNode) {
            node = ((Element.DualDomNode)((Object)node)).getXmlPeer();
        }
        if ((parent = node.getXMLParent()) == null) {
            return null;
        }
        Node prev = null;
        for (Node child = parent.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (child == node) {
                return prev;
            }
            prev = child;
        }
        return null;
    }

    public String getPrivateName() {
        return this.getName();
    }

    public Object getProperty(int ePropertyTag, int nOccurrence) {
        return null;
    }

    public Object getProperty(String propertyName, int nOccurrence) {
        return null;
    }

    @Override
    public ScriptTable getScriptTable() {
        return NodeScript.getScriptTable();
    }

    final Node getSibling(Node parent, int searchIndex, boolean bByName, IntegerHolder matchCount) {
        if (parent == null || parent.getFirstXFAChild() == null) {
            return null;
        }
        for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            Node node;
            if (this.isLikeNode(child, bByName)) {
                if (matchCount.value == searchIndex) {
                    return child;
                }
                ++matchCount.value;
            }
            if (!child.isTransparent() || (node = this.getSibling(child, searchIndex, bByName, matchCount)) == null) continue;
            return node;
        }
        return null;
    }

    public Node getSibling(int index, boolean bByName, boolean bExceptionIfNotFound) {
        Element nextParent;
        if (bByName) assert (this.getName() != "");
        Element parent = this.getXFAParent();
        if (parent == null) {
            if (index == 0) {
                return this;
            }
            if (!bExceptionIfNotFound) {
                return null;
            }
            throw new ExFull(ResId.IndexOutOfBoundsException);
        }
        while (parent.isTransparent() && (nextParent = parent.getXFAParent()) != null) {
            parent = nextParent;
        }
        Node sibling = this.getSibling(parent, index, bByName, new IntegerHolder());
        if (sibling != null) {
            return sibling;
        }
        if (bExceptionIfNotFound) {
            throw new ExFull(ResId.IndexOutOfBoundsException);
        }
        return null;
    }

    public final String getSOMExpression() {
        return this.getSOMExpression(null, false);
    }

    public final String getSOMExpression(Node oRelativeTo, boolean bSkipZeroIndex) {
        String sParent;
        Element oParent;
        if (this == oRelativeTo) {
            return "$";
        }
        StringBuilder sNodeName = new StringBuilder(this.getSomName());
        if (StringUtils.isEmpty(sNodeName)) {
            throw new ExFull(new MsgFormat(ResId.NamelessNodeInGetSOMException, this.getClassAtom()));
        }
        SOMParser.escapeSomName(sNodeName);
        boolean bUseName = sNodeName.charAt(0) != '#';
        int nIndex = this.getIndex(bUseName);
        if (!bSkipZeroIndex || nIndex != 0) {
            sNodeName.append('[');
            sNodeName.append(Integer.toString(nIndex));
            sNodeName.append(']');
        }
        if ((oParent = this.getXFAParent()) != null && oParent != oRelativeTo && (sParent = oParent.getSOMExpression(oRelativeTo, bSkipZeroIndex)).length() > 0) {
            sNodeName.insert(0, '.');
            sNodeName.insert(0, sParent);
        }
        return sNodeName.toString();
    }

    public String getSomName() {
        if (this.useNameInSOM()) {
            return this.getName();
        }
        return "#" + this.getClassAtom();
    }

    public final String getUniqueSOMName(Element contextNode) {
        Element ancestor = this.getXMLParent();
        while (true) {
            if (ancestor == null) {
                return "";
            }
            if (ancestor == contextNode) break;
            ancestor = ancestor.getXMLParent();
        }
        String sNodeName = this.getSomName();
        if (StringUtils.isEmpty(sNodeName)) {
            return "";
        }
        SOMNameFilter filter = new SOMNameFilter(sNodeName);
        List<Node> nodesInContext = filter.filterNodes(contextNode, 0);
        sNodeName = SOMParser.escapeSomName(sNodeName);
        Element parent = this.getXMLParent();
        String sSiblingsSOM = sNodeName + "[*]";
        NodeList scopeMatches = parent.resolveNodes(sSiblingsSOM, false, false, false);
        if (nodesInContext.size() == 1 && scopeMatches.length() == 1) {
            return sNodeName;
        }
        if (scopeMatches.length() > 1) {
            boolean bUseName = sNodeName.charAt(0) != '#';
            int nIndex = this.getIndex(bUseName);
            sNodeName = sNodeName + '[' + Integer.toString(nIndex) + ']';
        }
        if (scopeMatches.length() == nodesInContext.size()) {
            return sNodeName;
        }
        if (parent == contextNode) {
            return sNodeName;
        }
        String sParent = parent.getUniqueSOMName(contextNode);
        return sParent + '.' + sNodeName;
    }

    public boolean getWillDirty() {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return false;
        }
        return document.getWillDirty();
    }

    public final int getXFAChildCount() {
        int count = 0;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            ++count;
        }
        return count;
    }

    NodeList getXFANodes() {
        return null;
    }

    public final void hasChanged(boolean bIsDirty) {
        if (!this.getWillDirty()) {
            return;
        }
        Node node = this instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)this)).getXmlPeer() : this;
        node.mbIsDirty = bIsDirty;
        if (node instanceof ModelPeer && !(node instanceof Model.DualDomModel)) {
            node = ((ModelPeer)node).getXfaPeer();
        }
        for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            child.hasChanged(bIsDirty);
        }
    }

    public final void cleanDirtyFlags() {
        Node node = this instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)this)).getXmlPeer() : this;
        node.mbIsDirty = false;
        if (node instanceof ModelPeer && !(node instanceof Model.DualDomModel)) {
            node = ((ModelPeer)node).getXfaPeer();
        }
        for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            child.cleanDirtyFlags();
        }
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isDefault(boolean bCheckProto) {
        Node peer;
        Node node = peer = this instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)this)).getXmlPeer() : this;
        if (peer != null) {
            return peer.mbDefault;
        }
        return false;
    }

    public final boolean isDirty() {
        Node node = this instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)this)).getXmlPeer() : this;
        return node.mbIsDirty;
    }

    public final void setDirty() {
        if (!this.getWillDirty()) {
            return;
        }
        for (Node node = this; node != null; node = node.getXMLParent()) {
            Node node2 = node = node instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)node)).getXmlPeer() : node;
            if (node.mbIsDirty) {
                return;
            }
            node.mbIsDirty = true;
        }
    }

    public final void setDocument(Document document) {
        this.mDocument = document;
    }

    public abstract boolean isLeaf();

    boolean isLikeNode(Node pNode, boolean bByName) {
        if (this == pNode) {
            return true;
        }
        if (bByName) {
            return this.getName() == pNode.getName();
        }
        return this.isSameClass(pNode);
    }

    public boolean isMapped() {
        return this.mbIsMapped;
    }

    public boolean isPermsLockSet() {
        return this.mbPermsLock;
    }

    public boolean isPropertySpecified(int ePropertyTag, boolean bCheckProtos, int nOccurrence) {
        return false;
    }

    boolean isPropertySpecified(String propertyName, boolean bCheckProtos, int nOccurrence) {
        return false;
    }

    public boolean isSpecified(int ePropertyTag, boolean bCheckProtos, int nOccurrence) {
        return false;
    }

    boolean isSpecified(String sPropertyName, boolean bCheckProtos, int nOccurrence) {
        return false;
    }

    public boolean isTransient() {
        return this.mbIsTransient;
    }

    public void isTransient(boolean bTransient, boolean bSetChildren) {
        Element parent;
        this.mbIsTransient = bTransient;
        if (!bTransient && (parent = this.getXMLParent()) != null && parent.isTransient()) {
            ((Node)parent).isTransient(false, false);
        }
        if (!bSetChildren) {
            return;
        }
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            child.isTransient(bTransient, true);
        }
    }

    public boolean isTransparent() {
        return false;
    }

    public Node locateChildByClass(int eChildTag, int nIndex) {
        int nFound = 0;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() != eChildTag) continue;
            if (nFound == nIndex) {
                return child;
            }
            ++nFound;
        }
        return null;
    }

    public final Node locateChildByName(String aChildName, int nIndex) {
        if (aChildName == null) {
            return null;
        }
        int nFound = 0;
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (aChildName != child.getName()) continue;
            if (nFound == nIndex) {
                return child;
            }
            ++nFound;
        }
        return null;
    }

    public void makeDefault() {
        Node peer = this instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)this)).getXmlPeer() : this;
        peer.mbDefault = true;
        for (Node child = peer.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            child.makeDefault();
        }
    }

    public void makeNonDefault(boolean bRecursive) {
        Node peer;
        Node node = peer = this instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)this)).getXmlPeer() : this;
        if (peer.isDefault(false)) {
            if (this.getModel() != null) {
                Schema.checkVersion(this.getClassTag(), this.getModel(), this.getXFAParent());
            }
            peer.setDefaultFlag(false, bRecursive);
        }
        if (this.getModel() != null && !this.getModel().isLoading()) {
            this.setDirty();
        }
    }

    protected void setDefaultFlag(boolean bDefaultNode, boolean bSetChildren) {
        Node peer;
        Node node = peer = this instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)this)).getXmlPeer() : this;
        if (peer.isDefault(false) != bDefaultNode || bSetChildren) {
            Element parent;
            peer.mbDefault = bDefaultNode;
            if (bDefaultNode || bSetChildren) {
                for (Node child = peer.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                    child.setDefaultFlag(bDefaultNode, bSetChildren);
                }
            }
            if (!bDefaultNode && (parent = peer.getXMLParent()) != null && !(parent instanceof AppModel)) {
                parent.setDefaultFlag(false, false);
            }
        }
    }

    @Override
    public void notifyPeers(int eventType, String arg1, Object arg2) {
        if (this.getModel() != null && this.getModel().isLoading()) {
            return;
        }
        super.notifyPeers(eventType, arg1, arg2);
        this.sendParentUpdate(eventType, arg1, arg2);
    }

    protected void sendParentUpdate(int eventType, String arg1, Object arg2) {
        Element parent;
        if (this.notifyParent() && (parent = this.getXFAParent()) != null && !this.isMute()) {
            int eNewType;
            switch (eventType) {
                case 4: 
                case 8: {
                    eNewType = 8;
                    break;
                }
                case 5: 
                case 9: {
                    eNewType = 9;
                    break;
                }
                case 1: {
                    arg2 = this;
                }
                case 6: {
                    eNewType = 6;
                    break;
                }
                case 2: {
                    arg2 = this;
                }
                case 7: {
                    eNewType = 7;
                    break;
                }
                case 12: 
                case 16: {
                    eNewType = 16;
                    break;
                }
                case 13: 
                case 17: {
                    eNewType = 17;
                    break;
                }
                case 14: 
                case 18: {
                    eNewType = 18;
                    break;
                }
                case 15: 
                case 19: {
                    eNewType = 19;
                    break;
                }
                default: {
                    return;
                }
            }
            parent.notifyPeers(eNewType, arg1, arg2);
        }
    }

    protected boolean notifyParent() {
        return !this.isContainer();
    }

    public boolean performSOMAssignment(String sLHS, String sRHS, Obj[] oObjectParameters) {
        Model model = this.getModel();
        if (model == null) {
            return false;
        }
        AppModel appModel = model.getAppModel();
        if (appModel == null) {
            return false;
        }
        DependencyTracker oDependencyTracker = appModel.dependencyTracker();
        SOMParser oParser = new SOMParser(oDependencyTracker);
        ArrayList<SOMParser.SomResultInfo> oLHSResult = new ArrayList<SOMParser.SomResultInfo>();
        oParser.resolve(this, sLHS, oObjectParameters, oLHSResult, null);
        if (oLHSResult.size() == 0) {
            return false;
        }
        Arg arg = new Arg();
        if (sRHS == null) {
            arg.setNull();
        } else {
            arg.setString(sRHS);
        }
        for (int i = 0; i < oLHSResult.size(); ++i) {
            SOMParser.SomResultInfo oResultInfo = (SOMParser.SomResultInfo)oLHSResult.get(i);
            String sProperty = null;
            sProperty = oResultInfo.propertyName == null ? "" : oResultInfo.propertyName;
            oResultInfo.object.setScriptProperty(sProperty, arg, false);
        }
        return true;
    }

    public Node peekOneOfChild(boolean bReturnDefault) {
        return null;
    }

    Object peekProperty(int ePropTag, int nOccurrence) {
        return null;
    }

    Object peekProperty(String propertyName, int nOccurrence) {
        return null;
    }

    public abstract void postSave();

    public abstract void preSave(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        Element parent = this.getXFAParent();
        Element willDirtyNode = null;
        boolean previousWillDirty = false;
        if (this.isDefault(true)) {
            willDirtyNode = parent;
            previousWillDirty = willDirtyNode.getWillDirty();
            willDirtyNode.setWillDirty(false);
        }
        try {
            if (parent != null) {
                parent.removeChild(this);
            }
        }
        finally {
            if (willDirtyNode != null) {
                willDirtyNode.setWillDirty(previousWillDirty);
            }
        }
    }

    public final Node resolveNode(String somExpr) {
        return this.resolveNode(somExpr, false, false, false, null, null);
    }

    public final Node resolveNode(String somExpr, boolean bPeek, boolean bLastOccurence, boolean bNoProperties) {
        return this.resolveNode(somExpr, bPeek, bLastOccurence, bNoProperties, null, null);
    }

    public final Node resolveNode(String somExpr, boolean bPeek, boolean bLastOccurence, boolean bNoProperties, DependencyTracker dependencyTracker, BooleanHolder isAssociation) {
        NodeList oResult = this.resolveNodes(somExpr, bPeek, bLastOccurence, bNoProperties, dependencyTracker, isAssociation);
        if (oResult.length() == 0) {
            return null;
        }
        if (oResult.length() != 1) {
            throw new ExFull(ResId.SOMTypeException);
        }
        return (Node)oResult.item(0);
    }

    public NodeList resolveNodes(String somExpr, boolean bPeek, boolean bLastOccurence, boolean bNoProperties) {
        return this.resolveNodes(somExpr, bPeek, bLastOccurence, bNoProperties, null, null);
    }

    public NodeList resolveNodes(String somExpr, boolean bPeek, boolean bLastOccurence, boolean bNoProperties, DependencyTracker dependencyTracker, BooleanHolder isAssociation) {
        SOMParser oParser = new SOMParser(null);
        ArrayNodeList oResult = new ArrayNodeList();
        oParser.setOptions(bPeek, bLastOccurence, bNoProperties);
        oParser.resolve(this, somExpr, oResult, isAssociation);
        return oResult;
    }

    @Override
    public void sendMessenge(ExFull error, int eSeverity) {
        Model pModel = this.getModel();
        if (pModel != null) {
            pModel.addErrorList(error, eSeverity, null);
        }
    }

    public abstract void serialize(OutputStream var1, DOMSaveOptions var2, int var3, Node var4) throws IOException;

    protected final void setChildListModified(boolean bIsChildListModified) {
        this.mbChildListModified = bIsChildListModified;
    }

    public final void setLocked(boolean bLockState) {
        this.mbLocked = bLockState;
    }

    public void setMapped(boolean bIsMapped) {
        this.mbIsMapped = bIsMapped;
    }

    public void setName(String aName) {
    }

    protected final void setNextXMLSibling(Node node) {
        this.mNextXMLSibling = node;
    }

    protected final void setXMLParent(Element parent) {
        this.mXMLParent = parent;
    }

    public void setPermsLock(boolean bPermsLock) {
        this.mbPermsLock = bPermsLock;
        if (bPermsLock) {
            this.notifyPeers(10, "", null);
        } else {
            this.notifyPeers(11, "", null);
        }
    }

    public void setWillDirty(boolean bWillDirty) {
        if (this.getOwnerDocument() != null) {
            this.getOwnerDocument().setWillDirty(bWillDirty);
        }
    }

    public void setPrivateName(String aNewName) {
        this.setName(aNewName);
    }

    public final void unLock() {
        this.mbLocked = false;
    }

    boolean useNameInSOM() {
        return !StringUtils.isEmpty(this.getName());
    }

    public boolean validateSchema(int nTargetVersion, int nTargetAvailability, boolean bRecursive, List<NodeValidationInfo> pValidationInfo) {
        NodeSchema oNodeSchema;
        boolean bRet = true;
        Element poParent = this.getXFAParent();
        if (poParent != null && !Element.validateNodeSchema(this, oNodeSchema = poParent.getNodeSchema(), nTargetVersion, nTargetAvailability, pValidationInfo)) {
            bRet = false;
            if (pValidationInfo == null) {
                return false;
            }
        }
        if (!(this instanceof Element)) {
            return true;
        }
        Element e = (Element)this;
        NodeSchema oNodeSchema2 = e.getNodeSchema();
        int len = e.getNumAttrs();
        for (int i = 0; i < len; ++i) {
            AttributeInfo pInfo;
            Attribute oAttr = e.getAttr(i);
            String aAttrName = oAttr.getLocalName();
            int eTag = XFA.getTag(aAttrName);
            if (eTag == -1 || (pInfo = oNodeSchema2.getAttributeInfo(eTag)) == null) continue;
            boolean bInvalid = false;
            int nVerIntro = pInfo.getVersionIntroduced();
            int nAvail = pInfo.getAvailability();
            if (nTargetVersion < nVerIntro && !(pInfo.getDefault() instanceof EnumValue)) {
                bInvalid = true;
            } else if ((nTargetAvailability & nAvail) == 0) {
                bInvalid = true;
            }
            if (bInvalid) {
                bRet = false;
                if (pValidationInfo != null) {
                    NodeValidationInfo oInfo = new NodeValidationInfo(eTag, 0, nVerIntro, nAvail, this);
                    pValidationInfo.add(oInfo);
                    continue;
                }
                return false;
            }
            if (!(pInfo.getDefault() instanceof EnumValue)) continue;
            EnumValue oEnum = (EnumValue)e.getAttribute(eTag);
            int eValue = oEnum.getInt();
            EnumAttr eAttr = oEnum.getAttr();
            nVerIntro = eAttr.getVersionIntro();
            nAvail = eAttr.getAvailability();
            bInvalid = false;
            if (nTargetVersion < nVerIntro) {
                bInvalid = true;
            } else if ((nTargetAvailability & nAvail) == 0) {
                bInvalid = true;
            }
            if (!bInvalid) continue;
            bRet = false;
            if (pValidationInfo != null) {
                NodeValidationInfo oInfo = new NodeValidationInfo(eTag, eValue, nVerIntro, nAvail, this);
                pValidationInfo.add(oInfo);
                continue;
            }
            return false;
        }
        if (bRecursive) {
            for (Node poChild = this.getFirstXFAChild(); poChild != null; poChild = poChild.getNextXFASibling()) {
                if (poChild.validateSchema(nTargetVersion, nTargetAvailability, true, pValidationInfo)) continue;
                bRet = false;
                if (pValidationInfo != null) continue;
                return false;
            }
        }
        return bRet;
    }

    @Override
    public boolean validateUsage(int nXFAVersion, int nAvailability, boolean bUpdateVersion) {
        Model model = this.getModel();
        if (model != null) {
            return model.validateUsage(nXFAVersion, nAvailability, bUpdateVersion);
        }
        return false;
    }

    @Override
    public boolean validateUsageFailedIsFatal(int nXFAVersion, int nAvailability) {
        Model model = this.getModel();
        if (model != null) {
            return model.validateUsageFailedIsFatal(nXFAVersion, nAvailability);
        }
        return false;
    }

    public boolean compareVersions(Node oRollbackNode, ChangeLogger oChangeLogger, Object oUserData) {
        if (!this.compareVersionsBasic(oRollbackNode, this, oChangeLogger, oUserData)) {
            return false;
        }
        return this.compareVersions(oRollbackNode, this, oChangeLogger, oUserData);
    }

    protected boolean compareVersions(Node oRollbackNode, Node oContainer, ChangeLogger oChangeLogger, Object oUserData) {
        return false;
    }

    final boolean compareVersionsBasic(Node oRollbackNode, Node oContainer, ChangeLogger oChangeLogger, Object oUserData) {
        if (oRollbackNode == null) {
            if (oChangeLogger != null) {
                oChangeLogger.logChildChange(this.getXFAParent(), this, oUserData);
            }
            return false;
        }
        if (this instanceof TextNode) {
            if (this.getClassAtom() != oRollbackNode.getClassAtom()) {
                if (oChangeLogger != null) {
                    if (this.isContainer()) {
                        oChangeLogger.logChildChange(oContainer, this, oUserData);
                    } else {
                        oChangeLogger.logPropChange(oContainer, Node.getPropName(this.getXFAParent(), XFA.INVALID_ELEMENT), Node.getNodeAsXML(this), oUserData);
                    }
                }
                return false;
            }
        } else if (this instanceof Chars) assert (false);
        if (!(this instanceof Packet) && oRollbackNode instanceof Packet) {
            return ((Element)this).compareVersionsCanonically(oRollbackNode, this, oChangeLogger, oUserData);
        }
        return true;
    }

    public static String getPropName(Element oNode, int eTag) {
        StringBuilder sPropName = new StringBuilder();
        if (oNode != null && eTag != XFA.INVALID_ELEMENT) {
            sPropName.append(oNode.getModel().getSchema().getAtom(eTag));
        }
        StringBuilder sNodeName = new StringBuilder();
        while (oNode != null && !oNode.isContainer()) {
            sNodeName.append(oNode.getClassAtom());
            Element oParent = oNode.getXFAParent();
            if (oParent != null && oParent.getChildReln(oNode.getClassTag()).getMax() > 1) {
                sNodeName.append('[');
                sNodeName.append(String.valueOf(oNode.getIndex(false)));
                sNodeName.append(']');
            }
            if (StringUtils.isEmpty(sPropName)) {
                sPropName.append((CharSequence)sNodeName);
            } else {
                sPropName.insert(0, '.');
                sPropName.insert(0, sNodeName);
            }
            sNodeName.setLength(0);
            oNode = oNode.getXFAParent();
        }
        return sPropName.toString();
    }

    public String getPIName(Element oNode, String sPI) {
        String sPropName = Node.getPropName(oNode, XFA.INVALID_ELEMENT);
        StringTokenizer st = new StringTokenizer(sPI);
        String sTarget = st.hasMoreTokens() ? st.nextToken() : "";
        return sPropName + ".<?" + sTarget + " ... ?>";
    }

    public static String getNodeAsXML(Node oNode) {
        DOMSaveOptions oOptions = new DOMSaveOptions();
        oOptions.setDisplayFormat(0);
        oOptions.setSaveTransient(true);
        oOptions.setEntityChars("\r");
        oOptions.setRangeMin('\u007f');
        oOptions.setRangeMax('\u00ff');
        oOptions.setExcludePreamble(true);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        if (oNode instanceof Element) {
            Element element = (Element)oNode;
            element.getModel().normalizeNameSpaces(element, "");
            element.saveXML(oStream, oOptions);
        } else {
            oNode.getOwnerDocument().saveAs(oStream, oNode, oOptions);
        }
        return oStream.toString();
    }

    public static String getPIAsXML(String sPI) {
        return "<?" + sPI + "?>";
    }

    public void logValueChangeHelper(Node oContainer, String sNewValue, ChangeLogger oChangeLogger, Object oUserData) {
        boolean bFoundValue = false;
        boolean bFoundCaption = false;
        Node oNode = this;
        if (oNode.isSameClass(XFA.DATAGROUPTAG) || oNode.isSameClass(XFA.DATAVALUETAG)) {
            bFoundValue = true;
        } else {
            while (oNode != null && !oNode.isContainer()) {
                if (oNode.isSameClass(XFA.VALUETAG)) {
                    bFoundValue = true;
                } else if (oNode.isSameClass(XFA.CAPTIONTAG)) {
                    bFoundCaption = true;
                }
                oNode = oNode.getXFAParent();
            }
        }
        if (bFoundValue && !bFoundCaption) {
            oChangeLogger.logValueChange(oContainer, sNewValue, oUserData);
        } else {
            oChangeLogger.logPropChange(oContainer, Node.getPropName(this.getXFAParent(), XFA.INVALID_ELEMENT), sNewValue, oUserData);
        }
    }

    private static Element getNextXMLElement(Node node) {
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.mNextXMLSibling;
        }
        return null;
    }

    public Element getXfaPeer() {
        if (this.getClassTag() == XFA.INVALID_ELEMENT) {
            return this.mXfaPeer;
        }
        if (this instanceof Element) {
            return (Element)this;
        }
        return null;
    }

    public void setXfaPeer(Element xfaPeer) {
        this.mXfaPeer = xfaPeer;
    }

    public void setBoxModelDirtied(boolean b) {
    }

    public static interface ChangeLogger {
        public void logPropChange(Node var1, String var2, String var3, Object var4);

        public void logValueChange(Node var1, String var2, Object var3);

        public void logChildChange(Node var1, Node var2, Object var3);

        public void logDataChange(Node var1, Node var2, boolean var3, boolean var4, String var5, Object var6);
    }

    private static class NodeScriptDynamicPropObj
    extends ScriptDynamicPropObj {
        private final boolean mbPropertyOverride;

        NodeScriptDynamicPropObj(boolean bPropertyOverride, int nXFAVersion, int nAvailability) {
            super(nXFAVersion, nAvailability);
            this.mbPropertyOverride = bPropertyOverride;
        }

        @Override
        public boolean invokeGetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
            if (this.mbPropertyOverride) {
                return NodeScript.scriptPropLocateChildByClass(scriptThis, retValue, sPropertyName);
            }
            return NodeScript.scriptPropLocateChildByName(scriptThis, retValue, sPropertyName);
        }
    }

    private static final class SOMNameFilter
    extends NodeListFilter {
        private final String msSearchName;

        public SOMNameFilter(String sSearchName) {
            this.msSearchName = sSearchName;
        }

        @Override
        public boolean accept(Node oNode) {
            String sSOM = oNode.getSomName();
            return this.msSearchName.equals(sSOM);
        }
    }
}

