/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.EventPseudoModelScript;
import com.adobe.xfa.Obj;
import com.adobe.xfa.PseudoModel;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.ut.ExFull;

public class EventPseudoModel
extends PseudoModel {
    private final AppModel mAppModel;
    private EventInfo mEventInfo;
    private boolean mbCancelAction;
    private String msCancelActionEvent;
    private String msCanceledAction;

    public EventPseudoModel(AppModel appModel) {
        this.mAppModel = appModel;
        this.reset();
    }

    public String getPrevText() {
        return this.mEventInfo.getPrevText();
    }

    public void setPrevText(String sPrevText) {
        this.mEventInfo.setPrevText(sPrevText);
    }

    public String getPrevContentType() {
        return this.mEventInfo.getPrevContentType();
    }

    public void setPrevContentType(String sPrevContentType) {
        this.mEventInfo.setPrevContentType(sPrevContentType);
    }

    public String getChange() {
        return this.mEventInfo.getChange();
    }

    public void setChange(String sChange) {
        this.mEventInfo.setChange(sChange);
    }

    public String getNewText() {
        return this.mEventInfo.getNewText();
    }

    public void setNewText(String sNewText) {
        this.mEventInfo.setNewText(sNewText);
    }

    public String getNewContentType() {
        return this.mEventInfo.getNewContentType();
    }

    public void setNewContentType(String sNewContentType) {
        this.mEventInfo.setNewContentType(sNewContentType);
    }

    public String getFullText() {
        return this.mEventInfo.getFullText();
    }

    public void setFullText(String sFullText) {
        this.mEventInfo.setFullText(sFullText);
    }

    public int getCommitKey() {
        return this.mEventInfo.getCommitKey();
    }

    public void setCommitKey(int nCommitKey) {
        this.mEventInfo.setCommitKey(nCommitKey);
    }

    public boolean getKeyDown() {
        return this.mEventInfo.getKeyDown();
    }

    public void setKeyDown(boolean bKeyDown) {
        this.mEventInfo.setKeyDown(bKeyDown);
    }

    public boolean getModifier() {
        return this.mEventInfo.getModifier();
    }

    public void setModifier(boolean bModifier) {
        this.mEventInfo.setModifier(bModifier);
    }

    public int getName() {
        return this.mEventInfo.getName();
    }

    public void setName(int eName) {
        this.mEventInfo.setName(eName);
    }

    public String getNameAsString() {
        return ScriptHandler.executeReasonToString(this.mEventInfo.getName());
    }

    public void setName(String sName) {
        this.mEventInfo.setName(ScriptHandler.stringToExecuteReason(sName));
    }

    public int getSelEnd() {
        return this.mEventInfo.getSelEnd();
    }

    public void setSelEnd(int nSelEnd) {
        this.mEventInfo.setSelEnd(nSelEnd);
    }

    public int getSelStart() {
        return this.mEventInfo.getSelStart();
    }

    public void setSelStart(int nSelStart) {
        this.mEventInfo.setSelStart(nSelStart);
    }

    public boolean getShift() {
        return this.mEventInfo.getShift();
    }

    public void setShift(boolean bShift) {
        this.mEventInfo.setShift(bShift);
    }

    public Obj getTarget() {
        return this.mEventInfo.getTarget();
    }

    public void setTarget(Obj target) {
        this.mEventInfo.setTarget(target);
    }

    public String getSOAPFaultCode() {
        return this.mEventInfo.getSOAPFaultCode();
    }

    public void setSOAPFaultCode(String sSOAPFaultCode) {
        this.mEventInfo.setSOAPFaultCode(sSOAPFaultCode);
    }

    public String getSOAPFaultString() {
        return this.mEventInfo.getSOAPFaultString();
    }

    public void setSOAPFaultString(String sSOAPFaultString) {
        this.mEventInfo.setSOAPFaultString(sSOAPFaultString);
    }

    public boolean getReenter() {
        return this.mEventInfo.getReenter();
    }

    public void setReenter(boolean bReenter) {
        this.mEventInfo.setReenter(bReenter);
    }

    public boolean getCancelAction() {
        return this.mbCancelAction;
    }

    public String getCanceledAction() {
        return this.msCanceledAction;
    }

    public void setCancelAction(boolean bCancelAction, String sSource) {
        EventManager eventManager;
        String sCurrentEvent = sSource;
        if (sCurrentEvent == null && (eventManager = this.mAppModel.getEventManager()) != null) {
            sCurrentEvent = eventManager.getCurrentEvent();
        }
        if (!this.mbCancelAction && bCancelAction) {
            if (this.isPreActionEvent(sCurrentEvent)) {
                this.msCancelActionEvent = sCurrentEvent;
                this.mbCancelAction = true;
            }
        } else if (this.mbCancelAction && !bCancelAction) {
            if (this.msCancelActionEvent.equals("preExecute")) {
                if (sCurrentEvent.equals("postExecute") || sCurrentEvent.equals("preExecute")) {
                    this.msCancelActionEvent = null;
                    this.mbCancelAction = false;
                }
            } else if (this.msCancelActionEvent.equals("preOpen")) {
                if (sCurrentEvent.equals("postOpen") || sCurrentEvent.equals("preOpen")) {
                    this.msCancelActionEvent = null;
                    this.mbCancelAction = false;
                }
            } else if (this.msCancelActionEvent.equals("prePrint")) {
                if (sCurrentEvent.equals("postPrint") || sCurrentEvent.equals("prePrint")) {
                    this.msCancelActionEvent = null;
                    this.mbCancelAction = false;
                }
            } else if (this.msCancelActionEvent.equals("preSign")) {
                if (sCurrentEvent.equals("postSign") || sCurrentEvent.equals("preSign")) {
                    this.msCancelActionEvent = null;
                    this.mbCancelAction = false;
                }
            } else if (this.msCancelActionEvent.equals("preSubmit") && (sCurrentEvent.equals("postSubmit") || sCurrentEvent.equals("preSubmit"))) {
                this.msCancelActionEvent = null;
                this.mbCancelAction = false;
            }
        }
    }

    public void setEventInfo(EventInfo eventInfo) {
        this.mEventInfo = eventInfo;
    }

    public EventInfo getEventInfo() {
        return this.mEventInfo;
    }

    public void reset() {
        this.mEventInfo = new EventInfo();
    }

    public void emit() {
        EventManager eventManager = this.mAppModel.getEventManager();
        String sActivity = this.getNameAsString();
        int nEventID = eventManager.getEventID(sActivity);
        Obj obj = this.getTarget();
        eventManager.eventOccurred(nEventID, obj);
    }

    public boolean cancelAction(String sAction) {
        assert (this.isAction(sAction));
        boolean bResult = this.cancelOperation(sAction);
        if (bResult && this.isAction(sAction)) {
            this.msCanceledAction = sAction;
        }
        return bResult;
    }

    public boolean cancelEvent(String sEvent) {
        assert (!this.isAction(sEvent));
        return this.cancelOperation(sEvent);
    }

    public boolean isAction(String sOperation) {
        if (null == sOperation) {
            return false;
        }
        return sOperation.equals("execute") || sOperation.equals("open") || sOperation.equals("print") || sOperation.equals("sign") || sOperation.equals("submit");
    }

    boolean isPreActionEvent(String sEvent) {
        if (null == sEvent) {
            return false;
        }
        return sEvent.equals("preExecute") || sEvent.equals("preOpen") || sEvent.equals("prePrint") || sEvent.equals("preSign") || sEvent.equals("preSubmit");
    }

    boolean isPostActionEvent(String sEvent) {
        if (null == sEvent) {
            return false;
        }
        return sEvent.equals("postExecute") || sEvent.equals("postOpen") || sEvent.equals("postPrint") || sEvent.equals("postSign") || sEvent.equals("postSubmit");
    }

    protected boolean cancelOperation(String sOperation) {
        if (!this.getCancelAction()) {
            return false;
        }
        if (this.msCancelActionEvent.equals("preExecute")) {
            if (sOperation.equals("postExecute")) {
                return false;
            }
        } else if (this.msCancelActionEvent.equals("preOpen")) {
            if (sOperation.equals("postOpen")) {
                return false;
            }
        } else if (this.msCancelActionEvent.equals("prePrint")) {
            if (sOperation.equals("postPrint")) {
                return false;
            }
        } else if (this.msCancelActionEvent.equals("preSign")) {
            if (sOperation.equals("postSign")) {
                return false;
            }
        } else if (this.msCancelActionEvent.equals("preSubmit") && sOperation.equals("postSubmit")) {
            return true;
        }
        return true;
    }

    @Override
    public String getClassAtom() {
        return "eventPseudoModel";
    }

    @Override
    public String getClassName() {
        return "eventPseudoModel";
    }

    @Override
    public ScriptTable getScriptTable() {
        return EventPseudoModelScript.getScriptTable();
    }

    @Override
    public void sendMessenge(ExFull error, int eSeverity) {
        if (this.mAppModel != null) {
            this.mAppModel.addErrorList(error, eSeverity, null);
        }
    }

    @Override
    public boolean validateUsage(int nVersion, int nAvailability, boolean bUpdateVersion) {
        if (this.mAppModel != null) {
            return this.mAppModel.validateUsage(nVersion, nAvailability, bUpdateVersion);
        }
        return super.validateUsage(nVersion, nAvailability, bUpdateVersion);
    }

    @Override
    public boolean validateUsageFailedIsFatal(int nVersion, int nAvailability) {
        if (this.mAppModel != null) {
            return this.mAppModel.validateUsageFailedIsFatal(nVersion, nAvailability);
        }
        return super.validateUsageFailedIsFatal(nVersion, nAvailability);
    }

    public static class EventInfo {
        private String msPrevText;
        private String msPrevContentType;
        private String msChange;
        private String msNewText;
        private String msNewContentType;
        private String msFullText;
        private int mnCommitKey;
        private boolean mbKeyDown;
        private boolean mbModifier;
        private int meName;
        private int mnSelEnd;
        private int mnSelStart;
        private boolean mbShift;
        private Obj mTarget;
        private String msSOAPFaultCode;
        private String msSOAPFaultString;
        private boolean mbReenter;

        public String getPrevText() {
            return this.msPrevText;
        }

        public void setPrevText(String sPrevText) {
            this.msPrevText = sPrevText;
        }

        public String getPrevContentType() {
            return this.msPrevContentType;
        }

        public void setPrevContentType(String sPrevContentType) {
            this.msPrevContentType = sPrevContentType;
        }

        private String getChange() {
            return this.msChange;
        }

        public void setChange(String sChange) {
            this.msChange = sChange;
        }

        public String getNewText() {
            return this.msNewText;
        }

        public void setNewText(String sNewText) {
            this.msNewText = sNewText;
        }

        private String getNewContentType() {
            return this.msNewContentType;
        }

        private void setNewContentType(String sNewContentType) {
            this.msNewContentType = sNewContentType;
        }

        public String getFullText() {
            return this.msFullText;
        }

        public void setFullText(String sFullText) {
            this.msFullText = sFullText;
        }

        public int getCommitKey() {
            return this.mnCommitKey;
        }

        public void setCommitKey(int nCommitKey) {
            this.mnCommitKey = nCommitKey;
        }

        public boolean getKeyDown() {
            return this.mbKeyDown;
        }

        public void setKeyDown(boolean bKeyDown) {
            this.mbKeyDown = bKeyDown;
        }

        public boolean getModifier() {
            return this.mbModifier;
        }

        public void setModifier(boolean bModifier) {
            this.mbModifier = bModifier;
        }

        public int getName() {
            return this.meName;
        }

        public void setName(int eName) {
            this.meName = eName;
        }

        public int getSelEnd() {
            return this.mnSelEnd;
        }

        public void setSelEnd(int nSelEnd) {
            this.mnSelEnd = nSelEnd;
        }

        public int getSelStart() {
            return this.mnSelStart;
        }

        public void setSelStart(int nSelStart) {
            this.mnSelStart = nSelStart;
        }

        public boolean getShift() {
            return this.mbShift;
        }

        public void setShift(boolean bShift) {
            this.mbShift = bShift;
        }

        public Obj getTarget() {
            return this.mTarget;
        }

        public void setTarget(Obj target) {
            this.mTarget = target;
        }

        public String getSOAPFaultCode() {
            return this.msSOAPFaultCode;
        }

        public void setSOAPFaultCode(String sSOAPFaultCode) {
            this.msSOAPFaultCode = sSOAPFaultCode;
        }

        public String getSOAPFaultString() {
            return this.msSOAPFaultString;
        }

        public void setSOAPFaultString(String sSOAPFaultString) {
            this.msSOAPFaultString = sSOAPFaultString;
        }

        public boolean getReenter() {
            return this.mbReenter;
        }

        public void setReenter(boolean bReenter) {
            this.mbReenter = bReenter;
        }
    }
}

