/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import org.xml.sax.SAXException;

public class XPDFActionJavaScript
extends XPDFAction {
    private PDFActionJavaScript pdfActionJavaScript;
    private StringBuilder javascript;

    public XPDFActionJavaScript(PDFActionJavaScript pdfActionJavaScript) {
        super(pdfActionJavaScript);
        this.pdfActionJavaScript = pdfActionJavaScript;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        ch.startElement("JavaScript", null);
        String js = this.pdfActionJavaScript.getJavaScriptString();
        if (js == null) {
            throw new PDFInvalidDocumentException("Missing /JS key in javascript action dict.");
        }
        ch.startElement("Script");
        ch.characters(js);
        ch.endElement("Script");
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("JavaScript");
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFCharacters(char[] chars, int start, int length, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (this.javascript != null) {
            this.javascript.append(chars, start, length);
        } else {
            super.fromXPDFCharacters(chars, start, length, eh);
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Script".equals(lName)) {
            this.javascript = new StringBuilder();
            return null;
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEndElement(String lName, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ("Script".equals(lName)) {
            this.pdfActionJavaScript.setJavaScript(this.pdfActionJavaScript.getPDFDocument(), this.javascript.toString());
            this.javascript = null;
            return;
        }
        if ("Next".equals(lName)) {
            this.processingNextActions = false;
        }
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (this.pdfActionJavaScript.getJavaScriptString() == null) {
            eh.XPDFError("A 'Script' child element is required");
        }
    }
}

