/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestinationFactory;
import org.xml.sax.SAXException;

public class XPDFActionGoTo
extends XPDFAction {
    private PDFActionGoTo pdfActionGoto;

    public XPDFActionGoTo(PDFActionGoTo pdfActionGoto) {
        super(pdfActionGoto);
        this.pdfActionGoto = pdfActionGoto;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ch.startElement(parentName);
        ch.startElement("GoTo");
        if (!this.pdfActionGoto.hasDestination()) {
            throw new PDFInvalidDocumentException("Missing /D key in go-to action dict.");
        }
        XPDFDestinationFactory.newInstance(this.pdfActionGoto.getDestination()).toXPDF(ch, "Dest");
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("GoTo");
        ch.endElement(parentName);
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Dest".equals(lName)) {
            PDFDestinationExplicit dest = PDFDestinationExplicit.newSkeletonInstance(this.pdfActionGoto.getPDFDocument());
            XPDFDestinationExplicit xDest = new XPDFDestinationExplicit(dest);
            xDest.setIsInternalDestination(true);
            this.pdfActionGoto.setDestination(dest);
            return xDest;
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionGoto.hasDestination()) {
            eh.XPDFError("A 'Dest' child element is required");
        }
    }
}

