/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLCopierBase;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import javax.xml.transform.Source;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLElementReplacer
extends XMLCopierBase {
    boolean alreadyCopied;
    boolean inReplaceElement;
    int copyLevel;
    private XMLElement element;
    private boolean keepElement;
    private boolean insertElementIfNotFound;
    private Source elementSource;

    public XMLElementReplacer(XMLReader parent, XMLElement element, Source elementSource, boolean includeElement, boolean insertElementIfNotFound) {
        super(parent, true);
        this.element = element;
        this.keepElement = includeElement;
        this.insertElementIfNotFound = insertElementIfNotFound;
        this.elementSource = elementSource;
    }

    public XMLElementReplacer(XMLElement element, Source elementSource, boolean includeElement, boolean insertElementIfNotFound) {
        super(true);
        this.element = element;
        this.keepElement = includeElement;
        this.insertElementIfNotFound = insertElementIfNotFound;
        this.elementSource = elementSource;
    }

    private void insertData() throws SAXException {
        try {
            XMLUtils.insertXML(this.elementSource, this.getContentHandler());
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    protected int preElementStart(String namespaceURI, String simpleName) throws SAXException {
        if (this.alreadyCopied || this.inReplaceElement) {
            return -1;
        }
        if (this.keepElement) {
            return -1;
        }
        if (this.element.matches(namespaceURI, simpleName)) {
            this.copyLevel = this.xmlTreeDepth;
            this.inReplaceElement = true;
            return 0;
        }
        return -1;
    }

    @Override
    protected int postElementEnd(String namespaceURI, String simpleName) throws SAXException {
        if (this.alreadyCopied) {
            return -1;
        }
        if (this.keepElement) {
            return -1;
        }
        if (this.xmlTreeDepth == this.copyLevel && this.inReplaceElement && this.element.matches(namespaceURI, simpleName)) {
            this.insertData();
            this.alreadyCopied = true;
            this.succeeded = true;
            this.inReplaceElement = false;
            return 1;
        }
        return -1;
    }

    @Override
    protected int postElementStart(String namespaceURI, String simpleName) throws SAXException {
        if (this.alreadyCopied || this.inReplaceElement) {
            return -1;
        }
        if (!this.keepElement) {
            return -1;
        }
        if (this.element.matches(namespaceURI, simpleName)) {
            this.copyLevel = this.xmlTreeDepth;
            this.inReplaceElement = true;
            return 0;
        }
        return -1;
    }

    @Override
    protected int preElementEnd(String namespaceURI, String simpleName) throws SAXException {
        if (this.alreadyCopied) {
            return -1;
        }
        if (this.xmlTreeDepth == 1 && !this.alreadyCopied && this.insertElementIfNotFound) {
            this.insertData();
            this.alreadyCopied = true;
            this.succeeded = true;
            return -1;
        }
        if (!this.keepElement) {
            return -1;
        }
        if (this.xmlTreeDepth == this.copyLevel && this.inReplaceElement && this.element.matches(namespaceURI, simpleName)) {
            this.insertData();
            this.alreadyCopied = true;
            this.succeeded = true;
            this.inReplaceElement = false;
            return 1;
        }
        return -1;
    }
}

