/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xobjhandler;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCMembership;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsage;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageApp;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageAppList;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectContentType;
import java.util.ArrayList;

public class XObjectUseOptions {
    private boolean foreground;
    private OCState optionalContent = null;
    private XObjectContentType contentType = null;
    private ASRectangle clipBox = null;

    public XObjectUseOptions(boolean isForeground, OCState optionalContent, XObjectContentType contentType) {
        this.foreground = isForeground;
        this.optionalContent = optionalContent;
        this.contentType = contentType;
    }

    public XObjectUseOptions() {
        this.foreground = true;
        this.optionalContent = new OCState(true);
        this.contentType = XObjectContentType.General;
    }

    public XObjectUseOptions(ASRectangle rect) {
        this.clipBox = rect;
        this.foreground = true;
    }

    public boolean hasOptionalContent() {
        return this.optionalContent != null;
    }

    public void setPrintOn(boolean printOn) {
        if (this.optionalContent == null) {
            this.optionalContent = new OCState(true);
        }
        this.optionalContent.setPrint(printOn);
    }

    public void setViewOn(boolean viewOn) {
        if (this.optionalContent == null) {
            this.optionalContent = new OCState(true);
        }
        this.optionalContent.setView(viewOn);
    }

    public void setContentType(XObjectContentType contentType) {
        this.contentType = contentType;
    }

    public void setClipBox(PDFRectangle clipRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.clipBox = clipRect != null ? clipRect.getRectangle() : null;
    }

    public void setClipBox(double left, double bottom, double right, double top) {
        this.clipBox = new ASRectangle(left, bottom, right, top);
    }

    void setClipBox(ASRectangle rect) {
        this.clipBox = rect;
    }

    public ASRectangle getClipBox() {
        return this.clipBox;
    }

    public void makeForeground() {
        this.foreground = true;
        if (this.optionalContent == null) {
            this.optionalContent = new OCState(true);
        } else {
            this.optionalContent.setFG(true);
        }
    }

    public void makeBackground() {
        this.foreground = false;
        if (this.optionalContent == null) {
            this.optionalContent = new OCState(false);
        } else {
            this.optionalContent.setFG(false);
        }
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean hasContentType() {
        return this.contentType != null;
    }

    public XObjectContentType getContentType() {
        if (this.contentType == null) {
            this.contentType = XObjectContentType.General;
        }
        return this.contentType;
    }

    PDFOCUsage newOCUsage(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.optionalContent == null) {
            this.optionalContent = new OCState(true);
        }
        return this.optionalContent.newOCUsage(pdfDocument);
    }

    public void applyOptionalContent(PDFXObjectForm pdfXObjectForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFDocument pdfDocument = pdfXObjectForm.getPDFDocument();
        XObjectContentType contentType = this.getContentType();
        PDFOCUsage ocUsage = this.newOCUsage(pdfDocument);
        PDFOCGroup ocGroup = PDFOCGroup.newInstance(pdfDocument, contentType.getValue().asString());
        if (ocUsage != null) {
            PDFOCUsageAppList asArray;
            PDFOCProperties props;
            PDFOCConfig defaultConfig;
            ASName print;
            ocGroup.setUsage(ocUsage);
            ArrayList<ASName> entries = new ArrayList<ASName>();
            ASName view = ocUsage.getView();
            if (view != null) {
                entries.add(ASName.k_View);
            }
            if ((print = ocUsage.getPrintState()) != null) {
                entries.add(ASName.k_Print);
            }
            if ((defaultConfig = (props = pdfDocument.requireCatalog().getOCProperties()).getDefaultOCConfigDict()) == null) {
                defaultConfig = PDFOCConfig.newInstance(pdfDocument);
                props.setDefaultOCConfigDict(defaultConfig);
            }
            if ((asArray = defaultConfig.getASList()) == null) {
                asArray = PDFOCUsageAppList.newInstance(pdfDocument);
                defaultConfig.setASList(asArray);
            }
            PDFOCGroupArray appOCGList = PDFOCGroupArray.newInstance(pdfDocument, ocGroup);
            if (view != null) {
                PDFOCUsageApp viewUsageApp = PDFOCUsageApp.newInstance(pdfDocument, ASName.k_View, entries);
                viewUsageApp.setOCGs(appOCGList);
                asArray.add(viewUsageApp);
            }
            if (print != null) {
                PDFOCUsageApp printUsageApp = PDFOCUsageApp.newInstance(pdfDocument, ASName.k_Print, entries);
                printUsageApp.setOCGs(appOCGList);
                asArray.add(printUsageApp);
            }
        }
        PDFOCMembership ocMembership = PDFOCMembership.newInstance(pdfDocument);
        ocMembership.addOCG(ocGroup);
        PDFOCObject.setOC(pdfXObjectForm, (PDFOCObject)ocMembership);
    }

    private static class OCState {
        private boolean view = true;
        private boolean foreground;
        private boolean print;

        OCState(boolean forground) {
            this.foreground = forground;
            this.print = true;
        }

        void setView(boolean view) {
            this.view = view;
        }

        void setFG(boolean FG) {
            this.foreground = FG;
        }

        void setPrint(boolean print) {
            this.print = print;
        }

        PDFOCUsage newOCUsage(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFOCUsage ocUsage = PDFOCUsage.newInstance(pdfDocument);
            ocUsage.setExport(true);
            if (this.foreground) {
                ocUsage.setPageElementSubtype(PDFOCUsage.PageElementSubtype.FG);
            } else {
                ocUsage.setPageElementSubtype(PDFOCUsage.PageElementSubtype.BG);
            }
            if (this.view) {
                ocUsage.setView(true);
            } else {
                ocUsage.setView(false);
            }
            if (this.print) {
                ocUsage.setPrintState(true);
            } else {
                ocUsage.setPrintState(false);
            }
            return ocUsage;
        }
    }
}

