/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xmp;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.MetadataOptions;
import com.adobe.internal.pdftoolkit.services.xmp.PDFDictionaryMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPMetaFactoryMonitor;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.xmp.XMPConst;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class PDFDictionaryMetadataImpl
implements XMPConst,
PDFDictionaryMetadata,
DocumentListener {
    private static final long XMP_PADDING = 2048L;
    private XMPMeta xmpMeta;
    private PDFDocument pdfDocument;
    private PDFCosDictionary cosDictionary;
    private XMPService.XMPServiceListener xmpService;
    private boolean xmpWasValid;
    MetadataOptions options;
    private DocumentListenerProperties listenerProperties;
    private boolean dirty;
    private boolean internalXMPDirty;
    private int originalXMPSize;

    PDFDictionaryMetadataImpl(XMPService.XMPServiceListener serviceListener, PDFDocument pdfDocument, MetadataOptions options, PDFCosDictionary cosDictionary) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        this.pdfDocument = pdfDocument;
        this.cosDictionary = cosDictionary;
        this.buildInitialInternalXMP();
        this.xmpService = serviceListener;
        this.xmpService.registerListener(this.getListnerKey(), this);
        this.setOptions(options);
    }

    @Override
    public MetadataOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(MetadataOptions options) {
        this.options = options;
        if (this.options.getAutoUpdate() || this.options.getRemoveFiltersFromXMP() && this.options.getFilterRemovalMarksXMPDirty()) {
            this.xmpService.holdStrongly(this.getListnerKey(), true);
        } else {
            this.xmpService.holdStrongly(this.getListnerKey(), false);
        }
    }

    @Override
    public DocumentListenerProperties getProperties() {
        if (this.listenerProperties == null) {
            this.listenerProperties = new DocumentListenerProperties();
        }
        return this.listenerProperties;
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        DocumentMessage.MessageType type = message.getMessageType();
        if (type != DocumentMessage.CLOSE && (type == DocumentMessage.FINISH || type == DocumentMessage.SAVE)) {
            try {
                this.commit();
            }
            catch (PDFException e) {
                throw new PDFUnableToCompleteOperationException("Error during commit of XMP data to PDF document.", e);
            }
        }
    }

    private void markInternalXMPDirty(boolean dirty) {
        if (this.internalXMPDirty == dirty) {
            return;
        }
        this.internalXMPDirty = dirty;
        this.masterDirtyProcess();
    }

    private void masterDirtyProcess() {
        this.xmpService.markDirty(this.getListnerKey(), this.dirty);
    }

    private boolean isInternalXMPDirty() {
        return this.internalXMPDirty;
    }

    private void buildInitialInternalXMP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFMetadata pdfMetadata = this.cosDictionary.getMetadata();
        try {
            this.buildInternalXMPFromXMP(pdfMetadata);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        if (!this.xmpWasValid) {
            throw new PDFInvalidXMLException("XML is not valid");
        }
        if (this.xmpMeta == null) {
            this.xmpMeta = XMPMetaFactory.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildInternalXMPFromXMP(PDFMetadata pdfMetadata) throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream outStm = null;
        try {
            if (pdfMetadata != null) {
                outStm = new ByteArrayOutputStream(pdfMetadata.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pdfMetadata.getLength());
                pdfMetadata.getStreamData(outStm);
                is = new ByteArrayInputStream(outStm.toByteArray());
                this.originalXMPSize = outStm.size();
                this.xmpWasValid = true;
                this.xmpMeta = XMPMetaFactoryMonitor.parse(is, XMPService.XMPCORE_PARSE_OPTIONS, this.pdfDocument);
            }
        }
        catch (Exception e) {
            this.xmpWasValid = false;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (outStm != null) {
                    outStm.close();
                }
            }
        }
        return this.xmpWasValid;
    }

    @Override
    public void importXMP(InputStream xmp) throws PDFInvalidXMLException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        try {
            this.xmpMeta = XMPMetaFactoryMonitor.parse(xmp, new ParseOptions(), this.pdfDocument);
            this.markInternalXMPDirty(true);
        }
        catch (XMPException e) {
            throw new PDFInvalidXMLException("Unable to parse XMP", e);
        }
    }

    @Override
    public void exportXMP(OutputStream xmp) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            XMPMetaFactoryMonitor.serialize(this.xmpMeta, xmp, new SerializeOptions().setIndent("   ").setUseCanonicalFormat(true), this.pdfDocument);
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
    }

    @Override
    public String getHeaderAttributesAsString() {
        return this.xmpMeta.getPacketHeader();
    }

    @Override
    public String[] getHeaderAttributesAsArray() {
        String headerAttributes = this.getHeaderAttributesAsString();
        if (headerAttributes == null) {
            return new String[0];
        }
        return headerAttributes.split(" ");
    }

    @Override
    public void commit() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        try {
            if (this.xmpMeta == null) {
                throw new PDFUnableToCompleteOperationException("Internal XMP representation is empty.");
            }
            PDFMetadata pdfMetadata = this.cosDictionary.getMetadata();
            if (this.isInternalXMPDirty() || this.options.getRemoveFiltersFromXMP() && this.options.getFilterRemovalMarksXMPDirty() && pdfMetadata != null && (pdfMetadata.hasOutputFilters() || pdfMetadata.hasInputFilters())) {
                this.updateDictionaryXMP(pdfMetadata);
            }
        }
        finally {
            this.markInternalXMPDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDictionaryXMP(PDFMetadata pdfMetadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidXMLException {
        OutputByteStream obs = null;
        OutputStream os = null;
        InputByteStream ibs = null;
        try {
            obs = this.pdfDocument.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, (long)this.originalXMPSize + 2048L);
            os = obs.toOutputStream();
            XMPMetaFactoryMonitor.serialize(this.xmpMeta, os, new SerializeOptions().setIndent("   ").setUseCanonicalFormat(true), this.pdfDocument);
            int i = 0;
            while ((long)i < 2048L) {
                os.write(32);
                ++i;
            }
            os.close();
            os = null;
            ibs = obs.closeAndConvert();
            obs = null;
            if (pdfMetadata != null) {
                pdfMetadata.setStreamData(ibs.toInputStream());
                if (this.options.getRemoveFiltersFromXMP()) {
                    pdfMetadata.removeOutputFilters();
                }
                ibs = null;
            } else {
                pdfMetadata = PDFMetadata.newInstance(this.pdfDocument, ibs);
                ibs = null;
                this.cosDictionary.setMetadata(pdfMetadata);
            }
        }
        catch (XMPException e) {
            throw new PDFUnableToCompleteOperationException("Could not serialize XMP", e);
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to serialize XMP data.", e);
        }
        finally {
            try {
                try {
                    if (obs != null) {
                        obs.close();
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    finally {
                        if (ibs != null) {
                            ibs.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Error trying to close streams.", e);
            }
        }
    }

    @Override
    public boolean wasInitialXMPValid() {
        return this.xmpWasValid;
    }

    protected Object getListnerKey() {
        return this.cosDictionary;
    }
}

