/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;

public final class XFDFDestination
extends PDFCosObject {
    public static final int DEST_NONE = 0;
    public static final int DEST_NAME = 1;
    public static final int DEST_XYZ = 2;
    public static final int DEST_FIT = 3;
    public static final int DEST_FITH = 4;
    public static final int DEST_FITV = 5;
    public static final int DEST_FITR = 6;
    public static final int DEST_FITB = 7;
    public static final int DEST_FITBH = 8;
    public static final int DEST_FITBV = 9;

    private XFDFDestination(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static XFDFDestination newInstance(PDFDocument pdfDocument, byte[] name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosString cosObject = PDFCosObject.newCosString(pdfDocument, name);
        return new XFDFDestination(cosObject);
    }

    public static XFDFDestination newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArrayNull(pdfDocument, 6);
        return new XFDFDestination(cosObject);
    }

    public static XFDFDestination getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        XFDFDestination pdfObject = (XFDFDestination)PDFCosObject.getCachedInstance(cosObject, XFDFDestination.class);
        if (pdfObject == null) {
            pdfObject = new XFDFDestination(cosObject);
        }
        return pdfObject;
    }

    public int getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int type = 0;
        switch (this.getCosObject().getType()) {
            case 3: 
            case 4: {
                type = 1;
                break;
            }
            case 5: {
                CosArray destArray = (CosArray)this.getCosObject();
                if (destArray.size() == 0) {
                    return 0;
                }
                ASName desType = destArray.getName(1);
                type = desType != null ? (desType.equals(ASName.k_XYZ) ? 2 : (desType.equals(ASName.k_Fit) ? 3 : (desType.equals(ASName.k_FitH) ? 4 : (desType.equals(ASName.k_FitV) ? 5 : (desType.equals(ASName.k_FitR) ? 6 : (desType.equals(ASName.k_FitB) ? 7 : (desType.equals(ASName.k_FitBH) ? 8 : (desType.equals(ASName.k_FitBV) ? 9 : 0)))))))) : 0;
            }
        }
        return type;
    }

    public String getTypeAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        return ((CosArray)this.getCosObject()).getName(1).asString(true);
    }

    public void setType(String type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray destArray = (CosArray)this.getCosObject();
        destArray.setName(1, type);
    }

    public String getDestName() throws PDFSecurityException {
        CosObject cosObj = this.getCosObject();
        switch (cosObj.getType()) {
            case 3: {
                return ((CosName)cosObj).nameValue().asString(true);
            }
            case 4: {
                byte[] b = ((CosString)cosObj).stringValue().getBytes();
                return XFDFUtil.toXFDFStringFromByteString(b);
            }
        }
        return null;
    }

    public String getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        CosObject pageObj = ((CosArray)this.getCosObject()).get(0);
        if (pageObj instanceof CosNumeric) {
            return Integer.toString(pageObj.intValue());
        }
        if (pageObj instanceof CosNull) {
            return null;
        }
        try {
            PDFPage page = PDFPage.getInstance(pageObj);
            return Integer.toString(page.getIndex());
        }
        catch (Exception exp) {
            return null;
        }
    }

    public void setPage(String page, boolean remote) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray destArray = (CosArray)this.getCosObject();
        int pageNum = Integer.parseInt(page);
        if (remote) {
            destArray.setInt(0, pageNum);
        } else if (this.getPDFDocument().requirePages().getNumPages() > pageNum) {
            destArray.set(0, this.getPDFDocument().requirePages().getPage(pageNum).getCosObject());
        }
    }

    public void setPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosArray().set(0, page.getCosObject());
    }

    public String getLeftOrTop() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        return this.getArrayIndex(2);
    }

    public void setLeftOrTop(String left) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosArray destArray = (CosArray)this.getCosObject();
        try {
            destArray.setDouble(2, Double.parseDouble(left));
        }
        catch (NumberFormatException e) {
            throw new PDFInvalidParameterException("Expected Double value.", e);
        }
    }

    public String getTopOrBottom() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        return this.getArrayIndex(3);
    }

    public void setTopOrBottom(String top) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        CosArray destArray = (CosArray)this.getCosObject();
        try {
            destArray.setDouble(3, Double.parseDouble(top));
        }
        catch (NumberFormatException e) {
            throw new PDFInvalidParameterException("Unable to set created XFDF destination in the PDF document", e);
        }
    }

    public String getZoomOrRight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        return this.getArrayIndex(4);
    }

    public void setZoomOrRight(String right) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosArray destArray = (CosArray)this.getCosObject();
        try {
            destArray.setDouble(4, Double.parseDouble(right));
        }
        catch (NumberFormatException e) {
            throw new PDFInvalidParameterException("Unable to set created XFDF destination in the PDF document", e);
        }
    }

    public String getTop() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        return this.getArrayIndex(5);
    }

    private String getArrayIndex(int index) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray arrObj = (CosArray)this.getCosObject();
        if (arrObj != null && arrObj.size() > index) {
            CosObject obj = ((CosArray)this.getCosObject()).get(index);
            return obj instanceof CosNull ? null : Double.toString(obj.doubleValue());
        }
        return null;
    }

    public void setTop(String top) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        CosArray destArray = (CosArray)this.getCosObject();
        try {
            destArray.setDouble(5, Double.parseDouble(top));
        }
        catch (NumberFormatException e) {
            throw new PDFInvalidParameterException("Unable to set created XFDF destination in the PDF document", e);
        }
    }

    public void finalizeArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray destArray = (CosArray)this.getCosObject();
        switch (this.getType()) {
            case 3: 
            case 7: {
                destArray.remove(destArray.size() - 1);
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                destArray.remove(destArray.size() - 1);
                destArray.remove(destArray.size() - 1);
            }
            case 2: {
                destArray.remove(destArray.size() - 1);
            }
        }
    }
}

