/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationPolygon
extends XFDFAnnotation {
    static final String ELEM_POLYGON = "polygon";
    static final String ELEM_VERTICES = "vertices";

    XFDFAnnotationPolygon(PDFAnnotationPolygon pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationPolygon(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, true);
        this.addInteriorColorXFDFAttribute(annotsAtts);
        try {
            handler.startElement("", ELEM_POLYGON, ELEM_POLYGON, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            this.createXFDFExData3DMarkup(handler);
            this.createXFDFVertices(handler);
            handler.endElement("", ELEM_POLYGON, ELEM_POLYGON);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationPolygon polygonAnnot = PDFAnnotationPolygon.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(polygonAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillMarkupAttributes(polygonAnnot, elemAttrs);
            this.fillBorderStyleAttributes(polygonAnnot, elemAttrs);
            this.fillBorderEffectsAttributes(polygonAnnot, elemAttrs);
            this.fillInteriorColorAttribute(polygonAnnot, elemAttrs);
            this.fillIntentAttribute(polygonAnnot, elemAttrs);
            int attrInd = XFDFAnnotationPolygon.findAttribute("rotation", elemAttrs);
            if (attrInd != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                polygonAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    this.setIsPageRotate(true);
                }
            }
            if (this.setAnnotation(polygonAnnot, gotPage)) {
                this.pdfAnnot = polygonAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

