/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.template;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFAElement;
import com.adobe.xfa.Element;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.UnitSpan;

public class XFAFont
extends XFAElement {
    String typeface;
    XFAFontWeight weight;
    XFAFontPosture posture;
    double pointSize;
    private static final int HASH_PRIME = 1000003;

    public XFAFont(Element fontElement) {
        if (fontElement == null) {
            return;
        }
        this.setTypeface(fontElement.getAttribute(XFA.TYPEFACETAG).getAttrValue());
        this.setWeight(XFAFontWeight.getInstance(fontElement.getAttribute(XFA.WEIGHTTAG).getAttrValue()));
        this.setPosture(XFAFontPosture.getInstance(fontElement.getAttribute(XFA.POSTURETAG).getAttrValue()));
        this.setPointSize(fontElement.getAttribute(XFA.SIZETAG).getAttrValue());
    }

    public XFAFontPosture getPosture() {
        return this.posture;
    }

    private void setPosture(XFAFontPosture posture) {
        this.posture = posture;
    }

    public String getTypeface() {
        return this.typeface;
    }

    private void setTypeface(String typeface) {
        this.typeface = typeface;
    }

    public XFAFontWeight getWeight() {
        return this.weight;
    }

    private void setWeight(XFAFontWeight weight) {
        this.weight = weight;
    }

    public boolean equals(PDFFont pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfFont == null) {
            throw new PDFInvalidParameterException("Cannot compare a null pdf font to the XFAFont");
        }
        PDFFontDescriptor pdfFontDescriptor = pdfFont.getFontDescriptor();
        if (pdfFontDescriptor == null) {
            throw new PDFInvalidDocumentException("Null pdf font descriptor for supplied pdf font");
        }
        ASString fontFamilyName = pdfFontDescriptor.getFontFamily();
        if (fontFamilyName != null) {
            String pdfFontName = fontFamilyName.asString();
            if (!this.compareTypeface(pdfFontName)) {
                return false;
            }
        } else {
            return false;
        }
        int pdfFontWeight = pdfFontDescriptor.getFontWeight();
        XFAFontWeight xfaFontWeight = XFAFontWeight.NORMAL;
        if (pdfFontWeight >= 700) {
            xfaFontWeight = XFAFontWeight.BOLD;
        }
        if (!this.compareFontWeights(xfaFontWeight)) {
            return false;
        }
        double pdfItalicAngle = pdfFontDescriptor.getItalicAngle();
        XFAFontPosture xfaFontPosture = XFAFontPosture.NORMAL;
        if (pdfItalicAngle != 0.0) {
            xfaFontPosture = XFAFontPosture.ITALIC;
        }
        return this.compareFontPostures(xfaFontPosture);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 1000003 + (this.typeface == null ? 0 : this.typeface.hashCode());
        hash = hash * 1000003 + (int)this.pointSize;
        hash = hash * 1000003 + (this.posture == null ? 0 : this.posture.hashCode());
        hash = hash * 1000003 + (this.weight == null ? 0 : this.weight.hashCode());
        return hash;
    }

    private boolean compareFontPostures(XFAFontPosture xfaFontPosture) {
        return this.posture.equals(xfaFontPosture);
    }

    private boolean compareFontWeights(XFAFontWeight xfaFontWeight) {
        return this.weight.equals(xfaFontWeight);
    }

    private boolean compareTypeface(String pdfFontName) {
        return this.getTypeface().equalsIgnoreCase(pdfFontName);
    }

    public double getPointSize() {
        return this.pointSize;
    }

    private void setPointSize(String pointSize) {
        UnitSpan unitSpan = new UnitSpan(pointSize);
        UnitSpan unitSpanPica = new UnitSpan(unitSpan.valueAsUnit(19));
        UnitSpan unitSpanPoint = unitSpanPica.divide(1000);
        this.pointSize = unitSpanPoint.value();
    }

    public static final class XFAFontWeight {
        private final String weight;
        public static final XFAFontWeight NORMAL = new XFAFontWeight("normal");
        public static final XFAFontWeight BOLD = new XFAFontWeight("bold");
        private static final XFAFontWeight[] weightValues = new XFAFontWeight[]{NORMAL, BOLD};

        private XFAFontWeight(String weight) {
            this.weight = weight;
        }

        public static XFAFontWeight getInstance(String s) {
            if (s == null) {
                return NORMAL;
            }
            for (int i = 0; i < weightValues.length; ++i) {
                if (!s.equalsIgnoreCase(XFAFontWeight.weightValues[i].weight)) continue;
                return weightValues[i];
            }
            return null;
        }

        public String toString() {
            return this.weight;
        }

        public boolean isEmpty() {
            return this.weight.trim().length() == 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof XFAFontWeight)) {
                return false;
            }
            XFAFontWeight otherElement = (XFAFontWeight)obj;
            return otherElement.weight.equals(this.weight);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 1000003 + (this.weight == null ? 0 : this.weight.hashCode());
            return hash;
        }
    }

    public static final class XFAFontPosture {
        private final String posture;
        public static final XFAFontPosture NORMAL = new XFAFontPosture("normal");
        public static final XFAFontPosture ITALIC = new XFAFontPosture("italic");
        private static final XFAFontPosture[] postureValues = new XFAFontPosture[]{NORMAL, ITALIC};

        private XFAFontPosture(String posture) {
            this.posture = posture;
        }

        public static XFAFontPosture getInstance(String s) {
            if (s == null) {
                return NORMAL;
            }
            for (int i = 0; i < postureValues.length; ++i) {
                if (!s.equalsIgnoreCase(XFAFontPosture.postureValues[i].posture)) continue;
                return postureValues[i];
            }
            return null;
        }

        public String toString() {
            return this.posture;
        }

        public boolean isEmpty() {
            return this.posture.trim().length() == 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof XFAFontPosture)) {
                return false;
            }
            XFAFontPosture otherElement = (XFAFontPosture)obj;
            return otherElement.posture.equals(this.posture);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 1000003 + (this.posture == null ? 0 : this.posture.hashCode());
            return hash;
        }
    }
}

