/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.xfa.Node;
import com.adobe.xfa.NodeListFilter;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import java.util.List;

public final class ManifestExclusionFilter
extends NodeListFilter {
    private final List<String> mExcludedFields;
    private Node mLastExclGroup;

    public ManifestExclusionFilter(List<String> excludedFields) {
        this.mExcludedFields = excludedFields;
    }

    @Override
    public boolean accept(Node node) {
        if (node != null && (ManifestExclusionFilter.isTemplateField(node) || ManifestExclusionFilter.isTemplateExclGroup(node))) {
            this.mLastExclGroup = null;
            if (ManifestExclusionFilter.isTemplateField(node)) {
                if (node.getXFAParent() == this.mLastExclGroup) {
                    return false;
                }
            } else {
                this.mLastExclGroup = node;
            }
            if (this.mExcludedFields == null) {
                return true;
            }
            String sSOMExpression = node.getSOMExpression(node.getModel(), false);
            if (sSOMExpression.length() > 0) {
                int nSize = this.mExcludedFields.size();
                for (int nIndex = 0; nIndex < nSize; ++nIndex) {
                    if (!sSOMExpression.equals(this.mExcludedFields.get(nIndex))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean isTemplateField(Node node) {
        return node instanceof Field && !(node instanceof FormField);
    }

    protected static boolean isTemplateExclGroup(Node node) {
        return node instanceof ExclGroup && !(node instanceof FormExclGroup);
    }
}

