/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.Utils;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.configuration.ConfigurationValue;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.StringUtils;

public class Validate
extends FormModel.Validate {
    private final DocumentContext mDocumentContext;
    private final StringBuilder mMessageBuffer = new StringBuilder();
    private int mnMessageCount;
    private int mnMessageLines;
    private int mnMessagesBuffered;
    private boolean mbMessageOverflow;
    private int meValidationMessaging;
    private static final int MESSAGE_QUOTA = 5;
    private static final int MESSAGE_LINES = 30;

    public Validate(DocumentContext documentContext) {
        this.mDocumentContext = documentContext;
        this.meValidationMessaging = 1082654722;
        if (this.mDocumentContext != null && this.mDocumentContext.isRollbackDoc()) {
            this.setNullTestEnabled(false);
            this.setFormatTestEnabled(false);
            this.setScriptTestEnabled(false);
            this.setBarcodeTestEnabled(false);
        }
    }

    public Validate(DocumentContext documentContext, boolean bScriptTest, boolean bNullTest, boolean bFormatTest, boolean bBarcodeTest) {
        super(bScriptTest, bNullTest, bFormatTest, bBarcodeTest);
        this.mDocumentContext = documentContext;
        this.meValidationMessaging = 1082654722;
        if (this.mDocumentContext != null && this.mDocumentContext.isRollbackDoc()) {
            this.setNullTestEnabled(false);
            this.setFormatTestEnabled(false);
            this.setScriptTestEnabled(false);
            this.setBarcodeTestEnabled(false);
        }
    }

    @Override
    public boolean onValidateScriptFailed(ProtoableNode node, String script, String language, String validationMessage, BooleanHolder disableValidate) {
        TemplateModel templateModel;
        assert (node instanceof Field || node instanceof Subform || node instanceof ExclGroup);
        boolean bLegacyAlerts = false;
        TemplateModel templateModel2 = templateModel = this.mDocumentContext == null ? null : this.mDocumentContext.getTemplateModel();
        if (templateModel != null && templateModel.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
            bLegacyAlerts = true;
        }
        String sMessage = !StringUtils.isEmpty(validationMessage) ? validationMessage : (bLegacyAlerts ? node.getName() + ResourceLoader.loadResource(ResId.VALIDATE_FAILED) : this.constructMessage(node, ResId.VALIDATE_WARNING_MESSAGE));
        int eVal = 0x380000;
        if (node.isPropertySpecified(XFA.VALIDATETAG, true, 0)) {
            Element validate = node.getElement(XFA.VALIDATETAG, 0);
            eVal = validate.getEnum(XFA.SCRIPTTESTTAG);
            if (3670018 == eVal) {
                ++this.mnNumFailures;
            } else if (eVal == 3670017 && this.mDocumentContext != null && !bLegacyAlerts && this.shouldDisplaySingleValidationMessage()) {
                if (!disableValidate.value) {
                    ++this.mnMessageCount;
                    disableValidate.value = this.shouldDisableValidate(node);
                }
                if (!disableValidate.value) {
                    ++this.mnNumFailures;
                }
                return true;
            }
        }
        this.handleValidationMessaging(sMessage, eVal);
        return true;
    }

    @Override
    public boolean onValidateNullTestFailed(ProtoableNode node, String validationMessage, BooleanHolder disableValidate) {
        TemplateModel templateModel;
        if (!(node instanceof Field) && !(node instanceof ExclGroup)) {
            return false;
        }
        boolean bLegacyAlerts = false;
        TemplateModel templateModel2 = templateModel = this.mDocumentContext == null ? null : this.mDocumentContext.getTemplateModel();
        if (templateModel != null && templateModel.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
            bLegacyAlerts = true;
        }
        String sMessage = "";
        if (!StringUtils.isEmpty(validationMessage)) {
            sMessage = validationMessage;
        } else if (!bLegacyAlerts) {
            sMessage = this.constructMessage(node, ResId.VALIDATE_WARNING_MESSAGE_NULLTEST);
        }
        FormModel formModel = (FormModel)node.getModel();
        ExFull nullTestFailed = new ExFull(ResId.VALIDATE_NULLTEST_FAILED, sMessage);
        nullTestFailed.wasReported(true);
        int eVal = 0x380000;
        if (node.isPropertySpecified(XFA.VALIDATETAG, true, 0)) {
            Element validate = node.getElement(XFA.VALIDATETAG, 0);
            eVal = validate.getEnum(XFA.NULLTESTTAG);
            if (3670018 == eVal) {
                ++this.mnNumFailures;
                nullTestFailed.wasReported(false);
            } else if (eVal == 3670017 && this.mDocumentContext != null && !bLegacyAlerts && this.shouldDisplaySingleValidationMessage()) {
                if (!disableValidate.value) {
                    ++this.mnMessageCount;
                    disableValidate.value = this.shouldDisableValidate(node);
                }
                if (!disableValidate.value) {
                    ++this.mnNumFailures;
                }
                return false;
            }
        }
        if (this.meValidationMessaging == 1082654722) {
            formModel.addErrorList(nullTestFailed, 3, node);
        } else {
            this.handleValidationMessaging(sMessage, eVal);
        }
        return false;
    }

    @Override
    public boolean onValidateFormatTestFailed(FormField field, String validationMessage, BooleanHolder disableValidate) {
        TemplateModel templateModel;
        boolean bLegacyAlerts = false;
        TemplateModel templateModel2 = templateModel = this.mDocumentContext == null ? null : this.mDocumentContext.getTemplateModel();
        if (templateModel != null && templateModel.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
            bLegacyAlerts = true;
        }
        String sMessage = !StringUtils.isEmpty(validationMessage) ? validationMessage : (bLegacyAlerts ? field.getName() + ResourceLoader.loadResource(ResId.VALIDATE_FAILED) : this.constructMessage(field, ResId.VALIDATE_WARNING_MESSAGE));
        int eVal = 0x380000;
        if (field.isPropertySpecified(XFA.VALIDATETAG, true, 0)) {
            Element validate = field.getElement(XFA.VALIDATETAG, 0);
            eVal = validate.getEnum(XFA.FORMATTESTTAG);
            if (eVal == 3670018) {
                ++this.mnNumFailures;
            } else if (eVal == 3670017 && this.mDocumentContext != null && !bLegacyAlerts && this.shouldDisplaySingleValidationMessage()) {
                if (!disableValidate.value) {
                    ++this.mnMessageCount;
                    disableValidate.value = this.shouldDisableValidate(field);
                }
                if (!disableValidate.value) {
                    ++this.mnNumFailures;
                }
                return false;
            }
        }
        this.handleValidationMessaging(sMessage, eVal);
        return false;
    }

    @Override
    public boolean onValidateBarcodeTestFailed(FormField field, String validationMessage) {
        this.handleValidationMessaging(validationMessage, 0x380000);
        return false;
    }

    private String constructMessage(Element node, int nResId) {
        assert (node != null);
        String sReturnVal = ResourceLoader.loadResource(nResId);
        FormModel formModel = this.mDocumentContext.getFormModel();
        if (formModel != null && sReturnVal.indexOf("%0") != -1) {
            sReturnVal = sReturnVal.replace("%0", formModel.getFriendlyName(node));
        }
        return sReturnVal;
    }

    private boolean shouldDisableValidate(Node node) {
        assert (node != null);
        return false;
    }

    @Override
    public FormModel.Validate clone() {
        return new Validate(this.mDocumentContext, this.isScriptTestEnabled(), this.isNullTestEnabled(), this.isFormatTestEnabled(), this.isBarcodeTestEnabled());
    }

    @Override
    public boolean validateBarcode(Element element, String barcodeType, String value) {
        return true;
    }

    private boolean shouldDisplaySingleValidationMessage() {
        return this.meValidationMessaging == 1082654722 || this.meValidationMessaging == 1082654721 && this.mnMessageCount == 0;
    }

    private void handleValidationMessaging(String sMessage, int eSeverity) {
        ++this.mnMessageCount;
        if (this.meValidationMessaging != 0x40880000) {
            if (this.meValidationMessaging == 1082654722) {
                Utils.AlertNote(sMessage, eSeverity, this.mDocumentContext != null ? this.mDocumentContext.mpdDoc : null);
            } else if (this.meValidationMessaging == 1082654721 && this.mnMessageCount == 1) {
                Utils.AlertNote(sMessage, eSeverity, this.mDocumentContext != null ? this.mDocumentContext.mpdDoc : null);
            } else if (this.meValidationMessaging == 1082654723) {
                this.bufferValidationMessage(sMessage);
            }
        }
    }

    private void bufferValidationMessage(String sMessage) {
        if (this.mbMessageOverflow) {
            return;
        }
        if (this.mnMessageCount > 5) {
            this.mbMessageOverflow = true;
            return;
        }
        int nLines = 0;
        int n = sMessage.length();
        for (int i = 0; i < n; ++i) {
            if (sMessage.charAt(i) != '\n') continue;
            ++nLines;
        }
        if (this.mMessageBuffer.length() != 0 && this.mMessageBuffer.charAt(this.mMessageBuffer.length() - 1) != '\n') {
            this.mMessageBuffer.append('\n');
            ++this.mnMessageLines;
        }
        if (this.mnMessageLines + nLines < 30) {
            this.mMessageBuffer.append(sMessage);
            ++this.mnMessagesBuffered;
            this.mnMessageLines += nLines;
        } else {
            this.mbMessageOverflow = true;
        }
    }

    @Override
    public void onValidateStart() {
        this.mMessageBuffer.setLength(0);
        this.mnMessageCount = 0;
        this.mnMessageLines = 0;
        this.mnMessagesBuffered = 0;
        this.mbMessageOverflow = false;
        this.meValidationMessaging = this.getValidationMessaging();
    }

    @Override
    public void onValidateEnd() {
        if (this.mbMessageOverflow) {
            MsgFormatPos oErrLimit = new MsgFormatPos(ResId.MessageLimitExceeded);
            oErrLimit.format(this.mnMessageCount - this.mnMessagesBuffered);
            this.mMessageBuffer.append('\n');
            this.mMessageBuffer.append(oErrLimit.toString());
        }
        if (this.mMessageBuffer.length() != 0) {
            Utils.AlertNote(this.mMessageBuffer.toString(), 3670018, this.mDocumentContext != null ? this.mDocumentContext.mpdDoc : null);
            this.mMessageBuffer.setLength(0);
        }
    }

    private int getValidationMessaging() {
        Node configNode;
        ConfigurationModel configModel;
        int eValidationMessaging = 1082654722;
        if (this.mDocumentContext != null && (configModel = ConfigurationModel.getConfigurationModel(this.mDocumentContext.moAppModel, false)) != null && (configNode = configModel.resolveNode("acrobat.common.validationMessaging")) != null) {
            String sValue = ((ConfigurationValue)configNode).getValue().getAttrValue();
            if ("noMessages".equals(sValue)) {
                eValidationMessaging = 0x40880000;
            } else if ("firstMessageOnly".equals(sValue)) {
                eValidationMessaging = 1082654721;
            } else if ("allMessagesIndividually".equals(sValue)) {
                eValidationMessaging = 1082654722;
            } else if ("allMessagesTogether".equals(sValue)) {
                eValidationMessaging = 1082654723;
            }
        }
        return eValidationMessaging;
    }
}

