/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralDispatcher;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralTraverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CButtonBasedWidget;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChkBxBasedField;
import com.adobe.internal.util.ArrayListStack;

abstract class CChkBxBasedWidget
extends CButtonBasedWidget {
    private static final ASName k_Yes = ASName.create("Yes");
    protected ASName m_asaOnKey;

    public CChkBxBasedWidget(CosObject annot, int widget) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        super(annot, widget);
    }

    protected void delayInit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        CosObject coApp = this.getAppearance(ASName.k_N, null);
        if (coApp.getType() == 6) {
            GeneralTraverser chkBxTraverser = new GeneralTraverser(new GeneralDispatcher(){

                @Override
                public boolean finishDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
                    return CChkBxBasedWidget.this.getOnKeyEnum(entry.getKey());
                }

                @Override
                public boolean isCandidate(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) {
                    return true;
                }

                @Override
                public boolean startDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                    return false;
                }

                @Override
                public boolean continueTraversing(PDFInvalidDocumentException e) {
                    return true;
                }
            });
            chkBxTraverser.traverseCosGraph((CosDictionary)coApp, null);
        } else {
            this.m_asaOnKey = k_Yes;
        }
    }

    private boolean getOnKeyEnum(ASName asaKey) {
        if (asaKey != null && asaKey != CChkBxBasedField.k_Off) {
            this.m_asaOnKey = asaKey;
            return false;
        }
        return true;
    }

    public boolean isChecked() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        return this.isCheckedHelper(this.getCPDField().CPDField_getValue(ASName.k_V));
    }

    private boolean isCheckedHelper(CosObject coRawVal) {
        return coRawVal != null && coRawVal.getType() == 3 ? this.m_asaOnKey == ((CosName)coRawVal).nameValue() : false;
    }

    public void updateState() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        this.setState(this.isChecked() ? this.m_asaOnKey : CChkBxBasedField.k_Off);
    }
}

