/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xbm;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFBookmarkRoot;
import org.xml.sax.SAXException;

class BookmarksHandler
implements XPDFHandler {
    PDFDocument doc;
    XPDFBookmarkRoot root = null;

    public BookmarksHandler(PDFDocument doc) {
        this.doc = doc;
    }

    public PDFBookmarkRoot getBookmarkRoot() {
        return this.root.getPDFObject();
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
    }

    @Override
    public void fromXPDFCharacters(char[] chars, int start, int length, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        eh.XPDFErrorIfNotWhitespace(chars, start, length);
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Bookmarks".equals(lName)) {
            String version = att.getValue("version");
            if (version != null && !"1.0".equals(version)) {
                eh.XPDFError("Invalid value ('" + version + "') for 'version' attribute");
            }
            this.root = new XPDFBookmarkRoot(PDFBookmarkRoot.newSkeletonInstance(this.doc));
            return this.root;
        }
        return eh.XPDFInvalidElement(lName);
    }

    @Override
    public void fromXPDFEndElement(String lName, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
    }
}

