/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidStructureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.pdf.content.processor.CharacterScript;
import com.adobe.internal.pdftoolkit.pdf.content.processor.MarkedContentObject;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.pdf.content.processor.SimpleFontDataCache;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObject;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObjectList;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextRun;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextRunList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleType;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.interchange.structure.StructureFinder;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.AdjacencyInfo;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.HeightCharacterSorter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.HorizontalAdjacencyInfo;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.HorizontalCharacterSorter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.OverStrikeCharacterCache;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.PositionBasedHorizontalCharacterSorter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.RTLWordComparator;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.VerticalAdjacencyInfo;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.VerticalCharacterSorter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.WordBreakUtil;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.WordafierImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class Wordafier {
    private static final double verticalDiffThresholdFactor = 1.0E-5;
    private static final double MultipleOverstrikeFactor = 0.1;
    private PDFPage pdfPage;
    private LinkedHashSet<TextObjectList> textObjList = new LinkedHashSet();
    private int pageNumber;
    private TextObjectList textObjects;
    private HashMap<Integer, MarkedContentObject> mcObjects;
    private List<PDFCharacter> sortedHorizCharacters;
    private TreeSet<PDFCharacter> sortedVertCharacters;
    private List<PDFCharacter> sortedDiacritics;
    private ArrayList<PDFCharacter> diacriticList;
    private List<Word> readingOrderList;
    static final PositionBasedHorizontalCharacterSorter positionBasedHorizontalCharacterSorter = new PositionBasedHorizontalCharacterSorter();
    private static final HorizontalCharacterSorter horizontalCharacterSorter = new HorizontalCharacterSorter();
    private static final VerticalCharacterSorter verticalCharacterSorter = new VerticalCharacterSorter();
    private static final RTLWordComparator wComparator = new RTLWordComparator();
    private Map<PDFFont, byte[]> fontSpaceCharMap = new LinkedHashMap<PDFFont, byte[]>();
    private static final NumberFormat numberFormat;
    private static boolean isAGLAvailable;
    private static Method addBrokenHorizontalWords;
    private static Method addBrokenWords;
    private static Method addBrokenWordsInSentences;
    private static Method addVerticalBrokenWords;
    private static final double THRESHOLD_Y_OVERLAP = 0.8;
    private static final Pattern ALPHABETS_PATTERN;
    private boolean considerSpecialCharacter = false;
    private boolean shouldHonourSpaces = false;
    private boolean ignoreErrors = false;
    private boolean checkSuperscriptsSubscripts = false;
    public boolean workFlowOfInterest;
    public boolean bLog;

    public void setHonourSpaces(boolean honourSpaces) {
        this.shouldHonourSpaces = honourSpaces;
    }

    public void setCheckSuperscriptsSubscripts(boolean checkSuperscriptsSubscripts) {
        this.checkSuperscriptsSubscripts = checkSuperscriptsSubscripts;
    }

    public Wordafier(int pageNumber, TextObjectList textObjects, PDFPage page, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pageNumber = pageNumber;
        this.textObjects = textObjects;
        this.pdfPage = page;
        this.ignoreErrors = ignoreErrors;
        this.sortCharacters();
    }

    public Wordafier(int pageNumber, HashMap<Integer, MarkedContentObject> MCObjects, PDFPage page, StructureFinder finder, boolean ignoreErrors) throws PDFInvalidStructureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pageNumber = pageNumber;
        this.mcObjects = MCObjects;
        this.pdfPage = page;
        this.ignoreErrors = ignoreErrors;
        this.sortMCObjects(finder);
    }

    double getSpaceCharWidth(PDFCharacter character) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextRun textRun;
        Double spaceCharWidth;
        PDFFont font = character.getFont();
        byte[] charCodes = this.fontSpaceCharMap.get(font);
        if (charCodes == null) {
            charCodes = font.getSpaceCharCode();
            this.fontSpaceCharMap.put(font, charCodes);
        }
        if ((spaceCharWidth = (textRun = character.getTextRun()).getSpaceCharacterWidth()) == null) {
            spaceCharWidth = textRun.getScaledCharWidth(charCodes);
            textRun.setSpaceCharWidth(spaceCharWidth);
        }
        return spaceCharWidth;
    }

    private void sortMCObjects(StructureFinder finder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.textObjects = new TextObjectList(this.ignoreErrors);
        boolean isSoftHyphen = false;
        PDFStructureElement previous = null;
        PDFStructureElement current = null;
        TextObjectList blockLevelList = new TextObjectList(this.ignoreErrors);
        StructureFinder.FinderIterator finderIter = finder.getIterator();
        while (finderIter.hasNext()) {
            StructureFinder.Entry entry = finderIter.next();
            if (entry.getPage() != null && entry.getPage().equals(this.pdfPage)) {
                Iterator iter;
                MarkedContentObject mcObj;
                int nextMCID;
                int mcidInd;
                String actualText;
                Integer[] mcIDs;
                current = entry.getElement();
                while (current != null && current.getParent().getStructureType() == PDFStructureType.Element && PDFStructureUtils.getRole((PDFStructureElement)current.getParent()).getType().isType(PDFStructureRoleType.Inline)) {
                    PDFStructureNode parentNode = current.getParent();
                    current = parentNode instanceof PDFStructureElement ? (PDFStructureElement)parentNode : null;
                }
                PDFStructureRole structRole = PDFStructureUtils.getRole(current);
                if (structRole != null && !structRole.getType().isType(PDFStructureRoleType.Inline) && !current.equals(previous) || previous == null || !current.getParent().equals(previous.getParent())) {
                    blockLevelList = new TextObjectList(this.ignoreErrors);
                    mcIDs = Wordafier.getMCID(entry);
                    actualText = entry.getElement().getActualText();
                    if (actualText != null && actualText.length() > 0 && actualText.charAt(0) == '\u00ad') continue;
                    for (mcidInd = 0; mcidInd < mcIDs.length; ++mcidInd) {
                        nextMCID = mcIDs[mcidInd];
                        mcObj = this.mcObjects.get(nextMCID);
                        if (mcObj != null) {
                            iter = mcObj.getTextObjects().iterator();
                            while (iter.hasNext()) {
                                blockLevelList.add(new TextObject((TextObject)iter.next(), this.ignoreErrors));
                            }
                            continue;
                        }
                        throw new PDFInvalidDocumentException("Could not find a marked content object corresponding to MCID no " + nextMCID + ". Try to extract text after setting useStructure as false in TextExtraction options");
                    }
                } else {
                    mcIDs = Wordafier.getMCID(entry);
                    actualText = entry.getElement().getActualText();
                    if (actualText != null && actualText.length() > 0 && actualText.charAt(0) == '\u00ad') {
                        isSoftHyphen = true;
                    }
                    for (mcidInd = 0; mcidInd < mcIDs.length; ++mcidInd) {
                        nextMCID = mcIDs[mcidInd];
                        mcObj = this.mcObjects.get(nextMCID);
                        if (mcObj == null) {
                            throw new PDFInvalidDocumentException("Could not find a marked content object corresponding to MCID no " + nextMCID + ". Try to extract text after setting useStructure as false in TextExtraction options");
                        }
                        iter = mcObj.getTextObjects().iterator();
                        while (iter.hasNext()) {
                            TextObject thisobj = (TextObject)iter.next();
                            if (isSoftHyphen) {
                                this.setTextOnTextRun(thisobj, actualText);
                            }
                            blockLevelList.add(thisobj);
                            isSoftHyphen = false;
                        }
                    }
                }
            }
            previous = current;
            this.textObjList.add(blockLevelList);
        }
    }

    public void setTextOnTextRun(TextObject textObj, String actualText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextRunList textRuns = textObj.getTextRuns();
        if (textRuns != null) {
            Iterator trIter = textRuns.iterator();
            while (trIter.hasNext()) {
                TextRun textRun = (TextRun)trIter.next();
                ArrayList<PDFCharacter> chars = textRun.getCharacters();
                for (int i = 0; i < chars.size(); ++i) {
                    if (chars.get(i).getUnicodeString().charAt(0) != '-') continue;
                    chars.get(i).setUnicodeString(actualText);
                }
                textRun.setUnicodeString(actualText);
            }
        }
    }

    public static Integer[] getMCID(StructureFinder.Entry entry) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        StructureFinder sf;
        StructureFinder.FinderIterator finderIter;
        String actualText;
        Integer[] mcIDs = entry.getMCIDs();
        if (mcIDs.length == 0 && (actualText = entry.getElement().getActualText()) != null && (finderIter = (sf = StructureFinder.newInstance(entry.getElement())).getIterator()).hasNext()) {
            StructureFinder.Entry newentry = finderIter.next();
            return Wordafier.getMCID(newentry);
        }
        return mcIDs;
    }

    public List<Word> buildWords(TextObjectList textObjectslist) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Word> wordList = new ArrayList<Word>();
        ArrayList<PDFCharacter> allText = new ArrayList<PDFCharacter>();
        Iterator toIter = textObjectslist.iterator();
        while (toIter.hasNext()) {
            TextObject textObject = (TextObject)toIter.next();
            TextRunList textRuns = textObject.getTextRuns();
            if (textRuns == null) continue;
            Iterator trIter = textRuns.iterator();
            while (trIter.hasNext()) {
                TextRun textRun = (TextRun)trIter.next();
                allText.addAll(textRun.getCharacters());
            }
            String unicode = PDFCharacter.createUnicodeString(allText);
            CharacterScript wordScript = this.getPageScript(allText);
            boolean isWordEmpty = Wordafier.isWordEmpty(unicode);
            if (!isWordEmpty) {
                String dest = unicode;
                if (isAGLAvailable && addBrokenWords != null) {
                    try {
                        addBrokenWords.invoke(null, new Object[]{wordList, allText, unicode, wordScript, dest, this.pageNumber});
                    }
                    catch (Exception e) {
                        this.handleExceptionWhileWordBreaking(e, "AGLWordBreakUtil.addBrokenWords");
                    }
                } else {
                    WordBreakUtil.addBrokenWords(wordList, allText, unicode, wordScript, dest, this.pageNumber);
                }
            }
            allText.clear();
        }
        return wordList;
    }

    public List<Word> buildWords() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Word> wordList = new ArrayList<Word>();
        for (TextObjectList this.textObjects : this.textObjList) {
            ArrayList<PDFCharacter> allText = new ArrayList<PDFCharacter>();
            Iterator toIter = this.textObjects.iterator();
            while (toIter.hasNext()) {
                TextObject textObject = (TextObject)toIter.next();
                TextRunList textRuns = textObject.getTextRuns();
                if (textRuns == null) continue;
                Iterator trIter = textRuns.iterator();
                while (trIter.hasNext()) {
                    TextRun textRun = (TextRun)trIter.next();
                    allText.addAll(textRun.getCharacters());
                    allText.addAll(new ArrayList());
                }
                String unicode = PDFCharacter.createUnicodeString(allText);
                CharacterScript wordScript = this.getPageScript(allText);
                boolean isWordEmpty = Wordafier.isWordEmpty(unicode);
                if (!isWordEmpty) {
                    String dest = unicode;
                    if (isAGLAvailable && addBrokenWords != null) {
                        try {
                            addBrokenWords.invoke(null, new Object[]{wordList, allText, unicode, wordScript, dest, this.pageNumber});
                        }
                        catch (Exception e) {
                            this.handleExceptionWhileWordBreaking(e, "AGLWordBreakUtil.addBrokenWords");
                        }
                    } else {
                        WordBreakUtil.addBrokenWords(wordList, allText, unicode, wordScript, dest, this.pageNumber);
                    }
                }
                allText.clear();
            }
        }
        return wordList;
    }

    static String escapeUnicodeString(String str, boolean escapeAscii) {
        StringBuilder ostr = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!escapeAscii && ch >= ' ' && ch <= '~') {
                ostr.append(ch);
                continue;
            }
            ostr.append("\\u");
            String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                ostr.append("0");
            }
            ostr.append(hex.toUpperCase(Locale.ENGLISH));
        }
        return ostr.toString();
    }

    public List<Word> buildSentenses() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Word> wordList = new ArrayList<Word>();
        for (TextObjectList this.textObjects : this.textObjList) {
            ArrayList<PDFCharacter> allText = new ArrayList<PDFCharacter>();
            Iterator toIter = this.textObjects.iterator();
            while (toIter.hasNext()) {
                TextObject textObject = (TextObject)toIter.next();
                TextRunList textRuns = textObject.getTextRuns();
                if (textRuns == null) continue;
                Iterator trIter = textRuns.iterator();
                while (trIter.hasNext()) {
                    TextRun textRun = (TextRun)trIter.next();
                    allText.addAll(textRun.getCharacters());
                }
            }
            String unicode = PDFCharacter.createUnicodeString(allText);
            boolean isWordEmpty = Wordafier.isWordEmpty(unicode);
            if (isWordEmpty) continue;
            if (isAGLAvailable && addBrokenWordsInSentences != null) {
                try {
                    addBrokenWordsInSentences.invoke(null, wordList, allText, unicode, this.pageNumber);
                }
                catch (Exception e) {
                    this.handleExceptionWhileWordBreaking(e, "AGLWordBreakUtil.addBrokenWordsInSentences");
                }
                continue;
            }
            WordBreakUtil.addBrokenWordsInSentences(wordList, allText, unicode, this.pageNumber);
        }
        return wordList;
    }

    private void sortCharacters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.sortedHorizCharacters = new ArrayList<PDFCharacter>();
        this.sortedVertCharacters = new TreeSet(verticalCharacterSorter);
        this.sortedDiacritics = new ArrayList<PDFCharacter>();
        WordafierImpl wordafier = new WordafierImpl();
        Iterator toIter = this.textObjects.iterator();
        CharacterScript charScript = CharacterScript.ROMAN;
        while (toIter.hasNext()) {
            TextObject textObject = (TextObject)toIter.next();
            TextRunList textRuns = textObject.getTextRuns();
            if (textRuns == null) continue;
            Iterator trIter = textRuns.iterator();
            while (trIter.hasNext()) {
                TextRun textRun = (TextRun)trIter.next();
                if (textRun.isHorizontalWritingMode() || textRun.isTextPerpendicularToWritingDirection()) {
                    ArrayList<PDFCharacter> chars = textRun.getCharacters();
                    for (PDFCharacter c : chars) {
                        charScript = c.getScript();
                        if (charScript != null && charScript == CharacterScript.ARABIC || charScript == CharacterScript.HEBREW || charScript == CharacterScript.THAI) {
                            if (wordafier.charTypeTable.isDiacritic(c.toString().charAt(0)) || c.getTextRun().isMe(c.getUnicodes())) {
                                this.sortedDiacritics.add(c);
                                continue;
                            }
                            this.sortedHorizCharacters.add(c);
                            continue;
                        }
                        this.sortedHorizCharacters.add(c);
                    }
                    continue;
                }
                this.sortedVertCharacters.addAll(textRun.getCharacters());
            }
        }
        Collections.sort(this.sortedDiacritics, horizontalCharacterSorter);
        this.adjustCharacterHeightForSorting();
        Collections.sort(this.sortedHorizCharacters, horizontalCharacterSorter);
        this.adjustCharactersHeight();
    }

    public void adjustCharacterHeightForSorting() {
        PDFCharacter prevChar;
        Collections.sort(this.sortedHorizCharacters, new HeightCharacterSorter());
        Iterator<PDFCharacter> iter = this.sortedHorizCharacters.iterator();
        PDFCharacter pDFCharacter = prevChar = iter.hasNext() ? iter.next() : null;
        while (iter.hasNext()) {
            double y2;
            PDFCharacter currChar = iter.next();
            double y1 = prevChar.getSortCordinate() == null ? prevChar.getOrigin().y() : prevChar.getSortCordinate().y();
            double d = y2 = currChar.getSortCordinate() == null ? currChar.getOrigin().y() : currChar.getSortCordinate().y();
            if (Math.abs(y1 - y2) <= 0.05) {
                double x2 = currChar.getSortCordinate() == null ? currChar.getOrigin().x() : currChar.getSortCordinate().x();
                currChar.setSortCoordinate(new ASCoordinate(x2, y1));
            }
            prevChar = currChar;
        }
    }

    private void adjustCharactersHeight() {
        Iterator<PDFCharacter> iter = this.sortedHorizCharacters.iterator();
        HorizontalCharacterSorter onlyXBasedSorter = new HorizontalCharacterSorter(true);
        ArrayList<PDFCharacter> toRemove = new ArrayList<PDFCharacter>();
        PDFCharacter prevChar = null;
        PDFCharacter currChar = null;
        while (iter.hasNext()) {
            int comp;
            currChar = iter.next();
            if (prevChar == null) {
                prevChar = currChar;
                continue;
            }
            double h1 = prevChar.getHorizontalFontSize();
            double h2 = currChar.getHorizontalFontSize();
            double threshold = Wordafier.getVerticalDiffThreshold(h1, h2);
            double y1 = prevChar.getOrigin().y();
            double y2 = currChar.getOrigin().y();
            double deltaOrigin = y1 - y2;
            double yEnd1 = prevChar.getEnd().y();
            double yEnd2 = prevChar.getEnd().y();
            double deltaEnd = yEnd1 - yEnd2;
            if (currChar.getTextRun().getActualTextString() != null) {
                if (onlyXBasedSorter.compare(prevChar, currChar) > 0) {
                    if (currChar.getTextRun().getActualText().getNumTextruns() != 1) {
                        currChar.getTextRun().getActualText().decrementTextRunCount();
                        iter.remove();
                    }
                } else if (currChar.getTextRun().getActualText().getNumTextruns() != 0) {
                    currChar.getTextRun().getActualText().setTextRunCountZero();
                } else {
                    iter.remove();
                }
            } else if (Math.abs(deltaOrigin) < threshold && Math.abs(deltaEnd) < threshold && (comp = onlyXBasedSorter.compare(prevChar, currChar)) > 0) {
                toRemove.add(currChar);
                iter.remove();
                currChar.setSortCoordinate(currChar.getOrigin().translate(0.0, deltaOrigin));
                continue;
            }
            prevChar = currChar;
        }
        if (!toRemove.isEmpty()) {
            this.sortedHorizCharacters.addAll(toRemove);
            Collections.sort(this.sortedHorizCharacters, horizontalCharacterSorter);
        }
    }

    private static double getVerticalDiffThreshold(double h1, double h2) {
        double threshold = 0.0;
        if (Math.abs((h1 - h2) / h1) < 1.0E-5) {
            threshold = 1.0E-5 * h1;
        }
        return threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Word> buildWordList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument doc = this.pdfPage.getPDFDocument();
        SimpleFontDataCache simpeFontDataCache = SimpleFontDataCache.getInstance(doc);
        simpeFontDataCache.setEnabled(true);
        try {
            List<Word> wordList = new ArrayList<Word>();
            this.readingOrderList = new ArrayList<Word>();
            this.addHorizontalWords(wordList);
            wordList = this.getOrderedHorizontalWordsList(this.considerSpecialCharacter ? this.readingOrderList : wordList);
            this.addVerticalWords(wordList);
            List<Word> list = wordList;
            return list;
        }
        finally {
            try {
                simpeFontDataCache.setEnabled(false);
                simpeFontDataCache.message(new DocumentMessage(DocumentMessage.FINISH, doc));
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidDocumentException("Exception occured while clearing simple fonts cache", e);
            }
        }
    }

    private List<Word> getOrderedHorizontalWordsList(List<Word> wordList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int size = wordList.size();
        if (size == 0) {
            return wordList;
        }
        ArrayList<Word> finalList = new ArrayList<Word>();
        int index = -1;
        int rtl_start = 0;
        int rtl_end = 0;
        int non_rtl_start = 0;
        int non_rtl_end = 0;
        while (index < size - 1 && wordList.get(++index).isRTL()) {
            finalList.add(wordList.get(index));
        }
        while (index <= size - 1) {
            non_rtl_start = index;
            while (index < size - 1 && !wordList.get(++index).isRTL()) {
            }
            non_rtl_end = index;
            if (index >= size - 1) {
                ++non_rtl_end;
                ++index;
            }
            List<Word> nonrtlList = wordList.subList(non_rtl_start, non_rtl_end);
            List<Word> rtlList = null;
            if (index < size) {
                rtl_start = index;
                while (index < size - 1 && wordList.get(++index).isRTL()) {
                }
                rtl_end = index;
                if (index >= size - 1) {
                    ++rtl_end;
                    ++index;
                }
                rtlList = wordList.subList(rtl_start, rtl_end);
            }
            List<Word> temp = this.mergeLists(rtlList, nonrtlList);
            finalList.addAll(temp);
        }
        return finalList;
    }

    private List<Word> mergeLists(List<Word> rtl, List<Word> nonRTL) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (rtl == null || rtl.isEmpty()) {
            return nonRTL;
        }
        if (nonRTL == null || nonRTL.isEmpty()) {
            return rtl;
        }
        this.adjustRTLWordsYCoordinate(rtl);
        ArrayList<Word> newList = new ArrayList<Word>(rtl);
        newList.addAll(nonRTL);
        Collections.sort(newList, wComparator);
        this.reSortNonRTLWords(newList);
        return newList;
    }

    private void reSortNonRTLWords(ArrayList<Word> newList) {
        int nWords = newList.size();
        int index = 0;
        while (index < nWords - 1) {
            Word currWord = newList.get(index);
            Word nextWord = newList.get(index + 1);
            boolean onlyNeutralWordsFound = true;
            if (!currWord.isRTL()) {
                if (!currWord.isNeutralWord()) {
                    onlyNeutralWordsFound = false;
                }
                int ltrIdx = index;
                while (!nextWord.isRTL()) {
                    if (!nextWord.isNeutralWord()) {
                        onlyNeutralWordsFound = false;
                    }
                    if (++ltrIdx == nWords) break;
                    nextWord = newList.get(ltrIdx);
                }
                if (ltrIdx != index && !onlyNeutralWordsFound) {
                    this.reverseLTRWordsOrder(newList, index, ltrIdx - 1);
                    index = ltrIdx;
                    continue;
                }
                ++index;
                continue;
            }
            ++index;
        }
    }

    private void reverseLTRWordsOrder(ArrayList<Word> newList, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            Word tempWord = newList.get(startIndex);
            newList.set(startIndex, newList.get(endIndex));
            newList.set(endIndex, tempWord);
            ++startIndex;
            --endIndex;
        }
    }

    private void adjustRTLWordsYCoordinate(List<Word> rtl) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (rtl.size() < 2) {
            return;
        }
        for (int i = 1; i < rtl.size(); ++i) {
            Word current = rtl.get(i);
            Word prev = rtl.get(i - 1);
            if (!(current.getSortYCoordinate() > prev.getSortYCoordinate())) continue;
            current.setSortYCoordinate(prev.getSortYCoordinate());
        }
    }

    private CharacterScript getPageScript(ArrayList<PDFCharacter> charList) {
        int numArabic = 0;
        int numHebrew = 0;
        int numThai = 0;
        int numJapanese = 0;
        int numKorean = 0;
        int numSpaceChars = 0;
        int charSize = charList.size();
        block7: for (int i = 0; i < charSize; ++i) {
            PDFCharacter sChar = charList.get(i);
            if (sChar.toString().equals(" ")) {
                ++numSpaceChars;
            }
            CharacterScript scr = sChar.getScript();
            switch (scr) {
                case ARABIC: {
                    ++numArabic;
                    continue block7;
                }
                case HEBREW: {
                    ++numHebrew;
                    continue block7;
                }
                case THAI: {
                    ++numThai;
                    continue block7;
                }
                case HANI: 
                case HIRAGANA: 
                case KATAKANA: {
                    ++numJapanese;
                    continue block7;
                }
                case HANGUL: {
                    ++numKorean;
                    continue block7;
                }
            }
        }
        int charsWithoutSpace = charSize - numSpaceChars;
        if ((double)charsWithoutSpace * 0.6 < (double)numArabic) {
            return CharacterScript.ARABIC;
        }
        if ((double)charsWithoutSpace * 0.57 < (double)numHebrew) {
            return CharacterScript.HEBREW;
        }
        if ((double)charsWithoutSpace * 0.6 < (double)numThai) {
            return CharacterScript.THAI;
        }
        if ((double)charsWithoutSpace * 0.57 < (double)numJapanese) {
            return CharacterScript.JAPANESE;
        }
        if ((double)charsWithoutSpace * 0.6 < (double)numKorean) {
            return CharacterScript.HANGUL;
        }
        return CharacterScript.ROMAN;
    }

    private boolean isOptionalContentGroupSame(PDFCharacter c1, PDFCharacter c2) {
        if (c1.getTextRun() == c2.getTextRun()) {
            return true;
        }
        return PDFUtil.isPDFCosObjectRefEqual(c1.getTextRun().getGState().getOcGroup(), c2.getTextRun().getGState().getOcGroup());
    }

    private void addHorizontalWords(List<Word> wordList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        WordafierImpl wordafier = new WordafierImpl();
        ArrayList<PDFCharacter> toProcessChars = new ArrayList<PDFCharacter>(this.sortedHorizCharacters);
        ArrayList<PDFCharacter> tempCharsList = new ArrayList<PDFCharacter>();
        ArrayList<PDFCharacter> tiltedCharsList = new ArrayList<PDFCharacter>();
        ArrayList<PDFCharacter> finalCharsList = new ArrayList<PDFCharacter>();
        if (this.checkSuperscriptsSubscripts && !toProcessChars.isEmpty()) {
            int toProcessIdx = 0;
            PDFCharacter currChar = toProcessChars.get(toProcessIdx);
            boolean allCharsProcessed = false;
            if ((toProcessIdx = this.addTiltedCharsToList(toProcessChars, toProcessIdx, tiltedCharsList)) == toProcessChars.size()) {
                allCharsProcessed = true;
            }
            if (!allCharsProcessed) {
                currChar = toProcessChars.get(toProcessIdx);
                tempCharsList.add(currChar);
                double currY = currChar.getOrigin().y();
                ++toProcessIdx;
                while (toProcessIdx < toProcessChars.size() && (toProcessIdx = this.addTiltedCharsToList(toProcessChars, toProcessIdx, tiltedCharsList)) != toProcessChars.size()) {
                    PDFCharacter nextChar = toProcessChars.get(toProcessIdx);
                    double nextY = nextChar.getOrigin().y();
                    if (nextY == currY) {
                        tempCharsList.add(nextChar);
                    } else if (this.sufficientYOverlapForSuperscript(currChar, nextChar)) {
                        tempCharsList.add(nextChar);
                        currY = nextY;
                    } else {
                        Collections.sort(tempCharsList, new HorizontalCharacterSorter(true));
                        finalCharsList.addAll(tempCharsList);
                        tempCharsList.clear();
                        tempCharsList.add(nextChar);
                        currY = nextY;
                    }
                    currChar = nextChar;
                    ++toProcessIdx;
                }
            }
            Collections.sort(tempCharsList, new HorizontalCharacterSorter(true));
            finalCharsList.addAll(tempCharsList);
            tempCharsList.clear();
            finalCharsList.addAll(tiltedCharsList);
            tiltedCharsList.clear();
            toProcessChars = finalCharsList;
        }
        ArrayList<PDFCharacter> referenceList = new ArrayList<PDFCharacter>(this.sortedHorizCharacters);
        Collections.sort(referenceList, positionBasedHorizontalCharacterSorter);
        this.diacriticList = new ArrayList<PDFCharacter>(this.sortedDiacritics);
        OverStrikeCharacterCache overStrikeCharacterCache = new OverStrikeCharacterCache();
        ArrayList<PDFCharacter> currentWord = new ArrayList<PDFCharacter>();
        PDFCharacter currentChar = null;
        boolean wordBreak = false;
        CharacterScript pageScript = this.getPageScript(toProcessChars);
        while (!toProcessChars.isEmpty()) {
            Iterator<PDFCharacter> iter = toProcessChars.iterator();
            while (iter.hasNext() && !wordBreak) {
                PDFCharacter nextChar = iter.next();
                if (!wordafier.isWhitespace(nextChar)) {
                    double vertCutoff;
                    double nextCharEndY;
                    byte[] nextCharCodes;
                    if (currentChar == null) {
                        currentWord.add(nextChar);
                        iter.remove();
                        currentChar = nextChar;
                        overStrikeCharacterCache.put(currentChar);
                        continue;
                    }
                    overStrikeCharacterCache.put(currentChar);
                    if (!this.isOptionalContentGroupSame(currentChar, nextChar)) continue;
                    HorizontalAdjacencyInfo horizontalAdjacency = !this.checkSuperscriptsSubscripts ? new HorizontalAdjacencyInfo(currentChar, nextChar, referenceList, this) : new HorizontalAdjacencyInfo(currentChar, nextChar, referenceList, this, true);
                    byte[] currCharCodes = currentChar.getCharCode();
                    if (Arrays.equals(currCharCodes, nextCharCodes = nextChar.getCharCode())) {
                        double deltaVSize;
                        double msThreshold = 0.1 * horizontalAdjacency.getFontSize();
                        if (currentChar.getOrigin().distanceTo(nextChar.getOrigin()) < msThreshold && (deltaVSize = Math.abs(currentChar.getVerticalFontSize() - nextChar.getVerticalFontSize())) / currentChar.getVerticalFontSize() < 0.05 && Math.abs(currentChar.getBaselineAngle() - nextChar.getBaselineAngle()) < 0.175) {
                            iter.remove();
                            continue;
                        }
                    }
                    if (horizontalAdjacency.isAdjacent()) {
                        if (horizontalAdjacency.getXAdjacency() == AdjacencyInfo.XAdjacency.Next_Char_To_Right) {
                            if (pageScript == CharacterScript.THAI && this.isthaiVowel(nextChar)) {
                                if (this.isThaiTonal(currentWord.get(currentWord.size() - 1)) && !this.isThaiSaraAm(nextChar, currentWord.get(currentWord.size() - 1))) {
                                    currentWord.add(currentWord.size() - 1, nextChar);
                                } else {
                                    currentWord.add(nextChar);
                                }
                            } else if (nextChar.getScript() != null && (nextChar.getScript() == CharacterScript.HEBREW || nextChar.getScript() == CharacterScript.ARABIC)) {
                                currentWord.add(nextChar);
                            } else {
                                currentWord.add(nextChar);
                            }
                        } else if (horizontalAdjacency.getYAdjacency() == AdjacencyInfo.YAdjacency.Next_Char_To_Bottom) {
                            currentWord.add(0, nextChar);
                        } else {
                            this.addNextCharToWordAfterChecks(nextChar, currentWord);
                        }
                        currentChar = nextChar;
                        iter.remove();
                        continue;
                    }
                    if (nextChar.getScript() != null && (nextChar.getScript() == CharacterScript.ARABIC || nextChar.getScript() == CharacterScript.HEBREW || nextChar.getScript() == CharacterScript.THAI)) {
                        if (nextChar.getTextRun().isMe(nextChar.getUnicodes()) || wordafier.isDiacritic(nextChar, null)) {
                            this.diacriticList.add(nextChar);
                            iter.remove();
                        }
                        if (horizontalAdjacency.getDeltaYAbs() != 0.0) continue;
                        break;
                    }
                    if (horizontalAdjacency.getDeltaYAbs() == 0.0) break;
                    double maxThreshold = horizontalAdjacency.getFontSize();
                    double currCharOriginY = currentChar.getOrigin().y();
                    double currCharEndY = currentChar.getEnd().y();
                    double currCharLowestY = Math.min(currCharOriginY, currCharEndY);
                    double nextCharOriginY = nextChar.getOrigin().y();
                    double nextCharHighestY = Math.max(nextCharOriginY, nextCharEndY = nextChar.getEnd().y());
                    if (!(nextCharHighestY <= (vertCutoff = currCharLowestY - maxThreshold))) continue;
                    break;
                }
                iter.remove();
                boolean spaceCharCodeAvailableForType0Font = true;
                PDFFont font = nextChar.getFont();
                if (currentChar != null && !(font instanceof PDFFontSimple)) {
                    byte[] spaceCharCodes = this.fontSpaceCharMap.get(font);
                    if (spaceCharCodes == null) {
                        spaceCharCodes = font.getSpaceCharCode();
                        this.fontSpaceCharMap.put(font, spaceCharCodes);
                    }
                    if (spaceCharCodes == null || spaceCharCodes.length == 0) {
                        spaceCharCodeAvailableForType0Font = false;
                    } else {
                        boolean validCharCode = false;
                        for (byte spaceCharCode : spaceCharCodes) {
                            if (spaceCharCode < 0) continue;
                            validCharCode = true;
                            break;
                        }
                        spaceCharCodeAvailableForType0Font = validCharCode;
                    }
                }
                if (!this.shouldHonourSpaces && spaceCharCodeAvailableForType0Font || currentChar == null) continue;
                wordBreak = true;
            }
            if (!this.diacriticList.isEmpty()) {
                PDFCharacter c1 = null;
                PDFCharacter c2 = null;
                int wordSize = currentWord.size();
                ArrayList<PDFCharacter> finalWord = new ArrayList<PDFCharacter>();
                for (int i = 0; i < wordSize; ++i) {
                    c1 = currentWord.get(i);
                    c2 = i == wordSize - 1 ? null : currentWord.get(i + 1);
                    finalWord.add(c1);
                    ArrayList<Integer> matchedDiacritics = this.getAllCloseDiacrtics(c1, c2);
                    if (matchedDiacritics.isEmpty()) continue;
                    this.addDiacriticsToWord(matchedDiacritics, finalWord, pageScript);
                }
                currentWord = finalWord;
            }
            String unicode = PDFCharacter.createUnicodeString(currentWord);
            CharacterScript wordScript = this.getPageScript(currentWord);
            boolean isWordEmpty = Wordafier.isWordEmpty(unicode);
            if (!isWordEmpty) {
                ArrayList<PDFCharacter> roWord = new ArrayList<PDFCharacter>();
                roWord.addAll(0, currentWord);
                Word word = new Word(roWord, this.pageNumber);
                this.readingOrderList.add(word);
                if (ALPHABETS_PATTERN.matcher(unicode).matches()) {
                    wordList.add(word);
                } else if (isAGLAvailable && addBrokenHorizontalWords != null) {
                    try {
                        addBrokenHorizontalWords.invoke(null, new Object[]{wordList, currentWord, unicode, wordScript, this.pageNumber});
                    }
                    catch (Exception e) {
                        this.handleExceptionWhileWordBreaking(e, "AGLWordBreakUtil.addBrokenHorizontalWords");
                    }
                } else {
                    WordBreakUtil.addBrokenHorizontalWords(wordList, currentWord, unicode, wordScript, this.pageNumber);
                }
            }
            currentWord.clear();
            currentChar = null;
            wordBreak = false;
        }
        this.someDebugging(wordList);
    }

    private void someDebugging(List<Word> wordList) {
        this.bLog = false;
        if (!this.workFlowOfInterest) {
            return;
        }
        String stt = this.readingOrderList.toString();
        if (stt.indexOf("Wieselquist") != -1 || stt.indexOf("orth, Coast, Electric") != -1 || stt.indexOf("Friedman") != -1 || stt.indexOf("Teitelbaum") != -1 || stt.indexOf("Bentley") != -1 || stt.indexOf("Prieta") != -1 || stt.indexOf("dorlando") != -1 || stt.indexOf("Pester") != -1 || stt.indexOf("enddo") != -1 || stt.indexOf("not degrade single") != -1 || stt.indexOf("s00") != -1 || stt.indexOf("Gleneagles") != -1 || stt.indexOf("www.openfairways.com") != -1 || stt.indexOf("Gleneagles") != -1) {
            this.bLog = true;
        }
        if (this.bLog) {
            System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". readingOrderList: " + this.readingOrderList + ". wordList: " + wordList);
        }
    }

    private int addTiltedCharsToList(ArrayList<PDFCharacter> toProcessChars, int toProcessIdx, ArrayList<PDFCharacter> tiltedCharsList) {
        PDFCharacter nextChar = toProcessChars.get(toProcessIdx);
        while (nextChar.getBaselineAngle() != 0.0) {
            tiltedCharsList.add(nextChar);
            if (++toProcessIdx == toProcessChars.size()) break;
            nextChar = toProcessChars.get(toProcessIdx);
        }
        return toProcessIdx;
    }

    private boolean sufficientYOverlapForSuperscript(PDFCharacter currChar, PDFCharacter nextChar) {
        double currY = currChar.getOrigin().y();
        double nextY = nextChar.getOrigin().y();
        return nextY + nextChar.getVerticalFontSize() - currY > 0.8 * Math.min(currChar.getVerticalFontSize(), nextChar.getVerticalFontSize());
    }

    private void addNextCharToWordAfterChecks(PDFCharacter nextChar, ArrayList<PDFCharacter> currentWord) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!nextChar.isRTL()) {
            currentWord.add(0, nextChar);
        } else {
            currentWord.add(nextChar);
        }
    }

    private synchronized double format(double value) {
        return Double.valueOf(numberFormat.format(value));
    }

    ArrayList<Integer> belongsToDiacritic(PDFCharacter thisChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Integer> allClose = new ArrayList<Integer>();
        for (int i = 0; i < this.diacriticList.size(); ++i) {
            PDFCharacter checkThis = this.diacriticList.get(i);
            if (!(thisChar.getAbsYDistanceTo(checkThis) < Math.abs(thisChar.getSpaceCharHeight() * 0.5)) || !(this.format(thisChar.getEnd().x()) >= this.format(checkThis.getEnd().x()) && this.format(checkThis.getEnd().x()) >= this.format(thisChar.getOrigin().x())) && !(thisChar.getAbsXDistanceTo(checkThis) < Math.abs(this.getSpaceCharWidth(thisChar) * 0.5))) continue;
            allClose.add(i);
        }
        return allClose;
    }

    private ArrayList<Integer> getAllCloseDiacrtics(PDFCharacter thisChar, PDFCharacter nextChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Integer> allClose = new ArrayList<Integer>();
        for (int i = 0; i < this.diacriticList.size(); ++i) {
            double distanceNext;
            double distanceThis;
            boolean closeToThis = false;
            boolean closeToNext = false;
            PDFCharacter diacriticToCheck = this.diacriticList.get(i);
            if (thisChar.getAbsYDistanceTo(diacriticToCheck) < Math.abs(thisChar.getSpaceCharHeight() * 0.5) && (this.format(thisChar.getEnd().x()) >= this.format(diacriticToCheck.getEnd().x()) && this.format(diacriticToCheck.getEnd().x()) >= this.format(thisChar.getOrigin().x()) || thisChar.getAbsXDistanceTo(diacriticToCheck) < Math.abs(this.getSpaceCharWidth(thisChar) * 0.5))) {
                closeToThis = true;
            }
            if (nextChar != null && nextChar.getAbsYDistanceTo(diacriticToCheck) < Math.abs(nextChar.getSpaceCharHeight() * 0.5) && (this.format(nextChar.getEnd().x()) >= this.format(diacriticToCheck.getEnd().x()) && this.format(diacriticToCheck.getEnd().x()) >= this.format(nextChar.getOrigin().x()) || nextChar.getAbsXDistanceTo(diacriticToCheck) < Math.abs(this.getSpaceCharWidth(nextChar) * 0.5))) {
                closeToNext = true;
            }
            if (closeToNext && closeToThis && (distanceThis = Math.sqrt(Math.pow(thisChar.getAbsXDistanceTo(diacriticToCheck), 2.0) + Math.pow(thisChar.getAbsYDistanceTo(diacriticToCheck), 2.0))) > (distanceNext = Math.sqrt(Math.pow(nextChar.getAbsXDistanceTo(diacriticToCheck), 2.0) + Math.pow(nextChar.getAbsYDistanceTo(diacriticToCheck), 2.0)))) {
                double diacriticOrigin = diacriticToCheck.getOrigin().x();
                double nextCharOrigin = nextChar.getOrigin().x();
                if (thisChar.isRTL() && diacriticOrigin < nextCharOrigin || !thisChar.isRTL() && diacriticOrigin > nextCharOrigin) {
                    closeToThis = false;
                }
            }
            if (!closeToThis) continue;
            allClose.add(i);
        }
        return allClose;
    }

    private void addDiacriticsToWord(ArrayList<Integer> matchedDiacritics, ArrayList<PDFCharacter> word, CharacterScript pageScript) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pageScript == CharacterScript.THAI) {
            this.addThaiVowels(word, matchedDiacritics);
        } else {
            ArrayList<PDFCharacter> toRemove = new ArrayList<PDFCharacter>();
            if (!this.diacriticList.isEmpty() && !matchedDiacritics.isEmpty()) {
                int i;
                for (i = 0; i < matchedDiacritics.size(); ++i) {
                    int dFound = matchedDiacritics.get(i);
                    PDFCharacter o = this.diacriticList.get(dFound);
                    word.add(o);
                    toRemove.add(o);
                }
                for (i = 0; i < toRemove.size(); ++i) {
                    this.diacriticList.remove(toRemove.get(i));
                }
            }
        }
    }

    boolean belongsToDiacritic(PDFCharacter thisChar, PDFCharacter diacritic) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCharacter checkThis = diacritic;
        return thisChar.getAbsYDistanceTo(checkThis) < Math.abs(thisChar.getSpaceCharHeight() * 0.5) && this.format(thisChar.getEnd().x()) > this.format(checkThis.getEnd().x()) && this.format(checkThis.getEnd().x()) >= this.format(thisChar.getOrigin().x());
    }

    private void addVerticalWords(List<Word> wordList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        WordafierImpl wordafier = new WordafierImpl();
        ArrayList<PDFCharacter> toProcessChars = new ArrayList<PDFCharacter>(this.sortedVertCharacters);
        ArrayList<PDFCharacter> currentWord = new ArrayList<PDFCharacter>();
        PDFCharacter currentChar = null;
        boolean wordBreak = false;
        while (!toProcessChars.isEmpty()) {
            Iterator<PDFCharacter> iter = toProcessChars.iterator();
            while (iter.hasNext() && !wordBreak) {
                PDFCharacter nextChar = iter.next();
                if (!wordafier.isWhitespace(nextChar)) {
                    double horzCutoff;
                    double nextCharEndX;
                    byte[] nextCharCodes;
                    if (currentChar == null) {
                        currentWord.add(nextChar);
                        iter.remove();
                        currentChar = nextChar;
                        continue;
                    }
                    if (!this.isOptionalContentGroupSame(currentChar, nextChar)) continue;
                    boolean addToWord = false;
                    VerticalAdjacencyInfo vertcalAdjacencyInfo = new VerticalAdjacencyInfo(currentChar, nextChar, this);
                    byte[] currCharCodes = currentChar.getCharCode();
                    if (Arrays.equals(currCharCodes, nextCharCodes = nextChar.getCharCode())) {
                        double deltaVSize;
                        double msThreshold = 0.1 * vertcalAdjacencyInfo.getFontHeight();
                        if (currentChar.getOrigin().distanceTo(nextChar.getOrigin()) < msThreshold && (deltaVSize = Math.abs(currentChar.getVerticalFontSize() - nextChar.getVerticalFontSize())) / currentChar.getVerticalFontSize() < 0.05 && Math.abs(currentChar.getBaselineAngle() - nextChar.getBaselineAngle()) < 0.175) {
                            iter.remove();
                            continue;
                        }
                    }
                    if (vertcalAdjacencyInfo.isAdjacent()) {
                        addToWord = true;
                        if (!addToWord) continue;
                        if (vertcalAdjacencyInfo.getYAdjacency() == AdjacencyInfo.YAdjacency.Next_Char_To_Bottom) {
                            currentWord.add(nextChar);
                        } else if (vertcalAdjacencyInfo.getXAdjacency() == AdjacencyInfo.XAdjacency.Next_Char_To_Right) {
                            currentWord.add(nextChar);
                        } else {
                            currentWord.add(0, nextChar);
                        }
                        currentChar = nextChar;
                        iter.remove();
                        continue;
                    }
                    if (vertcalAdjacencyInfo.getDeltaXAbs() == 0.0) break;
                    double maxThreshold = vertcalAdjacencyInfo.getFontHeight();
                    double currCharOriginX = currentChar.getOrigin().x();
                    double currCharEndX = currentChar.getEnd().x();
                    double currCharRightmostX = Math.max(currCharOriginX, currCharEndX);
                    double nextCharOriginX = nextChar.getOrigin().x();
                    double nextCharLeftmostX = Math.min(nextCharOriginX, nextCharEndX = nextChar.getEnd().x());
                    if (!(nextCharLeftmostX > (horzCutoff = currCharRightmostX + maxThreshold))) continue;
                    break;
                }
                iter.remove();
            }
            String unicode = PDFCharacter.createUnicodeString(currentWord);
            boolean isWordEmpty = Wordafier.isWordEmpty(unicode);
            CharacterScript wordScript = this.getPageScript(currentWord);
            if (!isWordEmpty) {
                if (isAGLAvailable && addVerticalBrokenWords != null) {
                    try {
                        addVerticalBrokenWords.invoke(null, new Object[]{wordList, currentWord, unicode, this.pageNumber, wordScript});
                    }
                    catch (Exception e) {
                        this.handleExceptionWhileWordBreaking(e, "AGLWordBreakUtil.addVerticalBrokenWords");
                    }
                } else {
                    WordBreakUtil.addVerticalBrokenWords(wordList, currentWord, unicode, this.pageNumber);
                }
            }
            currentWord.clear();
            currentChar = null;
            wordBreak = false;
        }
    }

    static boolean isWordEmpty(String strVal) {
        return strVal != null && strVal.length() == 0;
    }

    private void addThaiVowels(ArrayList<PDFCharacter> currentWord, ArrayList<Integer> found) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFCharacter> toRemove = new ArrayList<PDFCharacter>();
        if (!this.diacriticList.isEmpty() && !found.isEmpty()) {
            int i;
            for (i = 0; i < found.size(); ++i) {
                int dFound = found.get(i);
                PDFCharacter o = this.diacriticList.get(dFound);
                if (this.isthaiVowel(o)) {
                    if (this.isThaiTonal(currentWord.get(currentWord.size() - 1)) && !this.isThaiSaraAm(o, currentWord.get(currentWord.size() - 1))) {
                        currentWord.add(currentWord.size() - 1, this.diacriticList.get(dFound));
                    } else {
                        currentWord.add(this.diacriticList.get(dFound));
                    }
                    toRemove.add(o);
                }
                if (!this.isThaiTonal(o)) continue;
                currentWord.add(this.diacriticList.get(dFound));
                toRemove.add(o);
            }
            for (i = 0; i < toRemove.size(); ++i) {
                this.diacriticList.remove(toRemove.get(i));
            }
        }
    }

    private boolean isThaiSaraAm(PDFCharacter diacritic, PDFCharacter tonal) {
        char uniChar1 = diacritic.getUnicodeChar(diacritic.getUnicodes());
        char uniChar2 = diacritic.getUnicodeChar(tonal.getUnicodes());
        return uniChar1 == '\u0e32' && (uniChar2 == '\u0e48' || uniChar2 == '\u0e4d');
    }

    private boolean isthaiVowel(PDFCharacter diacritic) {
        char uniChar = diacritic.getUnicodeChar(diacritic.getUnicodes());
        return uniChar >= '\u0e30' && uniChar <= '\u0e3a' || uniChar >= '\u0e40' && uniChar <= '\u0e47';
    }

    private boolean isThaiTonal(PDFCharacter diacritic) {
        char uniChar = diacritic.getUnicodeChar(diacritic.getUnicodes());
        return uniChar >= '\u0e48' && uniChar <= '\u0e4f';
    }

    public List<Word> getReadingOrderList() {
        return this.readingOrderList;
    }

    private void handleExceptionWhileWordBreaking(Exception e, String methodName) {
        if (e instanceof SecurityException) {
            throw new PDFRuntimeException("SecurityException while calling " + methodName + " method.", e);
        }
        if (e instanceof IllegalArgumentException) {
            throw new PDFRuntimeException("IllegalArgumentException while calling " + methodName + " method.", e);
        }
        if (e instanceof IllegalAccessException) {
            throw new PDFRuntimeException("IllegalAccessException while calling " + methodName + " method.", e);
        }
        if (e instanceof InvocationTargetException) {
            throw new PDFRuntimeException("InvocationTargetException while calling " + methodName + " method.", e);
        }
        throw new PDFRuntimeException("Unexpected exception while calling " + methodName + " method.", e);
    }

    public boolean isConsiderSpecialCharacter() {
        return this.considerSpecialCharacter;
    }

    public void setConsiderSpecialCharacter(boolean considerSpecialCharacter) {
        this.considerSpecialCharacter = considerSpecialCharacter;
    }

    static {
        isAGLAvailable = true;
        addBrokenHorizontalWords = null;
        addBrokenWords = null;
        addBrokenWordsInSentences = null;
        addVerticalBrokenWords = null;
        ALPHABETS_PATTERN = Pattern.compile("[a-zA-Z]+");
        numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setMinimumFractionDigits(6);
        numberFormat.setGroupingUsed(false);
        try {
            Class.forName("com.adobe.agl.text.BreakIterator");
        }
        catch (ClassNotFoundException e) {
            isAGLAvailable = false;
        }
        if (isAGLAvailable) {
            try {
                Class<?> c = Class.forName("com.adobe.internal.pdftoolkit.services.textextraction.impl.AGLWordBreakUtil");
                addBrokenHorizontalWords = c.getDeclaredMethod("addBrokenHorizontalWords", List.class, ArrayList.class, String.class, CharacterScript.class, Integer.class);
                addBrokenWords = c.getDeclaredMethod("addBrokenWords", List.class, ArrayList.class, String.class, CharacterScript.class, String.class, Integer.class);
                addBrokenWordsInSentences = c.getDeclaredMethod("addBrokenWordsInSentences", List.class, ArrayList.class, String.class, Integer.class);
                addVerticalBrokenWords = c.getDeclaredMethod("addVerticalBrokenWords", List.class, ArrayList.class, String.class, Integer.class, CharacterScript.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

