/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.CharacterScript;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.Wordafier;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class WordBreakUtil {
    WordBreakUtil() {
    }

    static void addBrokenHorizontalWords(List<Word> wordList, ArrayList<PDFCharacter> currentWord, String dest, CharacterScript wordScript, Integer pageNumber) {
        BreakIterator brkit = BreakIterator.getWordInstance(wordScript.getLocale());
        brkit.setText(dest);
        int start = brkit.first();
        int end = brkit.next();
        int newstart = start;
        while (end != -1) {
            ArrayList<PDFCharacter> newList;
            char[] uarray = new char[end - start];
            dest.getChars(start, end, uarray, 0);
            int newend = end;
            if (end > currentWord.size()) {
                newend = currentWord.size();
            }
            if ((newList = new ArrayList<PDFCharacter>(currentWord.subList(newstart, newend))).size() == 0) {
                if (wordScript == CharacterScript.ARABIC || wordScript == CharacterScript.HEBREW) {
                    newList.add(currentWord.get(0));
                } else {
                    newList.add(currentWord.get(currentWord.size() - 1));
                }
            }
            if (newList != null) {
                Word word1 = new Word(newList, new String(uarray), pageNumber);
                wordList.add(word1);
            }
            newstart = newend;
            start = end;
            end = brkit.next();
        }
    }

    static void addBrokenWords(List<Word> wordList, ArrayList allText, String unicode, CharacterScript wordScript, String dest, Integer pageNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        BreakIterator brkit = BreakIterator.getWordInstance(wordScript.getLocale());
        brkit.setText(dest);
        int start = brkit.first();
        int end = brkit.next();
        while (end != -1) {
            Word word1;
            char[] uarray = new char[end - start];
            unicode.getChars(start, end, uarray, 0);
            int newend = end;
            int newstart = start;
            if (end > allText.size()) {
                newstart = newend = allText.size();
            }
            ArrayList<PDFCharacter> newList = new ArrayList<PDFCharacter>(allText.subList(newstart, newend));
            String unicode1 = unicode.substring(newstart, newend);
            if (!(Wordafier.isWordEmpty(unicode1) && new String(uarray).equals(" ") || (newList == null || newList.isEmpty() || ((PDFCharacter)newList.get(0)).getUnicodeString().equalsIgnoreCase(" ")) && new String(uarray).equals(" ") || (word1 = new Word(newList, new String(uarray), pageNumber)).toString().equals(" "))) {
                wordList.add(word1);
            }
            start = end;
            end = brkit.next();
        }
    }

    static void addVerticalBrokenWords(List<Word> wordList, ArrayList<PDFCharacter> currentWord, String unicode, Integer pageNumber) {
        BreakIterator brkit = BreakIterator.getWordInstance(Locale.getDefault());
        brkit.setText(unicode);
        int start = brkit.first();
        int end = brkit.next();
        while (end != -1) {
            ArrayList<PDFCharacter> newList;
            String newWord = unicode.substring(start, end);
            if (end > currentWord.size()) {
                end = currentWord.size();
            }
            if ((newList = new ArrayList<PDFCharacter>(currentWord.subList(start, end))) != null && !newList.isEmpty()) {
                Word word1 = new Word(newList, newWord, pageNumber);
                wordList.add(word1);
            }
            start = end;
            end = brkit.next();
        }
    }

    static void addBrokenWordsInSentences(List<Word> wordList, ArrayList allText, String unicode, Integer pageNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        BreakIterator brkit = BreakIterator.getSentenceInstance(Locale.getDefault());
        brkit.setText(unicode);
        int start = brkit.first();
        int end = brkit.next();
        while (end != -1) {
            ArrayList<PDFCharacter> newList;
            String unicode1;
            char[] uarray = new char[end - start];
            unicode.getChars(start, end, uarray, 0);
            int newend = end;
            int newstart = start;
            if (end > allText.size()) {
                newstart = newend = allText.size();
            }
            if (!(Wordafier.isWordEmpty(unicode1 = PDFCharacter.createUnicodeString(newList = new ArrayList<PDFCharacter>(allText.subList(newstart, newend)))) || newList == null || newList.isEmpty() || ((PDFCharacter)newList.get(0)).getUnicodeString().equalsIgnoreCase(" "))) {
                Word word1 = new Word(newList, new String(uarray), pageNumber);
                wordList.add(word1);
            }
            start = end;
            end = brkit.next();
        }
    }
}

