/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf;

import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentImageItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.services.swf.SWFContentItem;
import com.adobe.internal.pdftoolkit.services.swf.SWFDocumentContext;
import com.adobe.internal.pdftoolkit.services.swf.SWFGraphicsState;
import com.adobe.internal.pdftoolkit.services.swf.exceptions.SWFRuntimeException;
import com.adobe.internal.pdftoolkit.services.swf.utils.ImageHelper;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFUtils;
import flash.swf.SwfUtils;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineTag;
import flash.swf.types.Matrix;
import java.io.IOException;

class SWFContentImageItem
extends ContentImageItem<SWFGraphicsState>
implements SWFContentItem {
    private double height;
    private double width;
    private double startX;
    private double startY;

    SWFContentImageItem(SWFGraphicsState gState, int id) {
        super(gState, id);
    }

    private void initialize() {
        double[] transformation = this.getTransformationMatrix();
        double[] bBox = SWFUtils.getImageBBox(transformation);
        this.startX = bBox[0];
        this.startY = bBox[1];
        this.width = bBox[2];
        this.height = bBox[3];
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        super.writeToDisplayArea(context);
        this.initialize();
        DefineShape shape = this.bitmap();
        Matrix matrix = new Matrix();
        matrix.translateX = SwfUtils.toTwips((double)this.startX);
        matrix.translateY = SwfUtils.toTwips((double)(((SWFDocumentContext)context).getPageHeight() - this.startY - this.height));
        double[] transformation = this.getTransformationMatrix();
        if (transformation[1] != 0.0 || transformation[2] != 0.0) {
            double angle = Math.PI;
            int xRotationSign = transformation[1] < 0.0 ? -1 : 1;
            int yRotationSign = transformation[2] < 0.0 ? -1 : 1;
            ASMatrix mat1 = new ASMatrix(Math.cos(angle), Math.sin(angle), -1.0 * Math.sin(angle), Math.cos(angle), 0.0, 0.0);
            ASMatrix mat2 = new ASMatrix(1.0, (double)(-xRotationSign) * Math.abs(transformation[1] / transformation[0]), (double)(-yRotationSign) * Math.abs(transformation[2] / transformation[3]), 1.0, 0.0, 0.0);
            ASMatrix mat3 = new ASMatrix(Math.cos(angle), Math.sin(angle), -1.0 * Math.sin(angle), Math.cos(angle), 0.0, 0.0);
            mat1 = mat1.concat(mat2).concat(mat3);
            matrix.setScale(mat1.geta(), mat1.getd());
            matrix.setRotate(mat1.getb(), mat1.getc());
            matrix.translateX += SwfUtils.toTwips((double)((double)yRotationSign * this.height * Math.abs(transformation[2] / transformation[3])));
        }
        if (transformation[0] < 0.0 || transformation[3] < 0.0) {
            int yScaleSign;
            int xScaleSign = transformation[0] < 0.0 ? -1 : 1;
            int n = yScaleSign = transformation[3] < 0.0 ? -1 : 1;
            if (matrix.hasScale) {
                matrix.scaleX *= xScaleSign;
                matrix.scaleY *= yScaleSign;
            } else {
                matrix.setScale((double)xScaleSign, (double)yScaleSign);
            }
            if (xScaleSign < 0) {
                matrix.translateX += SwfUtils.toTwips((double)(this.height * Math.abs(transformation[0] / transformation[3])));
            }
            if (yScaleSign < 0) {
                matrix.translateY += SwfUtils.toTwips((double)this.height);
            }
        }
        SWFUtils.placeObject((DefineTag)shape, matrix, ((SWFDocumentContext)context).getDefineSprite());
    }

    private DefineShape bitmap() {
        DefineBits imageTag = this.createDefineBits();
        DefineShape imageShape = ImageHelper.createShapeForImage(imageTag, this.width, this.height);
        return imageShape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefineBits createDefineBits() {
        DefineBits defineBits;
        ARGBImage bImage = this.getImage();
        ARGBImage sMaskImage = this.getSoftMask();
        if (bImage == null) {
            throw new SWFRuntimeException("MissingSourceAttribute");
        }
        try {
            defineBits = ImageHelper.createDefineBits(bImage, sMaskImage, this.getIsImageMask(), GraphicsUtils.toARGB(((SWFGraphicsState)this.getGState()).getFillColorValues(), ((SWFGraphicsState)this.getGState()).getNonStrokeAlpha()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (bImage != null) {
                        bImage.close();
                    }
                }
                finally {
                    if (sMaskImage != null) {
                        sMaskImage.close();
                    }
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new SWFRuntimeException(ioe);
            }
        }
        try {
            if (bImage != null) {
                bImage.close();
            }
        }
        finally {
            if (sMaskImage != null) {
                sMaskImage.close();
            }
        }
        return defineBits;
    }
}

