/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.PKCS7EnvelopedDataHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import java.security.Provider;
import java.security.SecureRandom;

public class SecurityProviders
extends SecurityProvidersImpl {
    private SecurityProviders(Provider md5, Provider rc4, Provider aes, Provider sha1, Provider sha1prng, PKCS7EnvelopedDataHandler pkcs7Handler, SecureRandom randomGenerator) {
        super(md5, rc4, aes, sha1, sha1prng, pkcs7Handler, randomGenerator);
    }

    private SecurityProviders(Provider md5, Provider rc4, Provider aes, Provider sha1, Provider sha1prng, Provider sha256, Provider sha384, Provider sha512, PKCS7EnvelopedDataHandler pkcs7Handler, SecureRandom randomGenerator) {
        super(md5, rc4, aes, sha1, sha1prng, sha256, sha384, sha512, pkcs7Handler, randomGenerator);
    }

    public static SecurityProviders newInstancePassword(Provider md5, Provider rc4) {
        return new SecurityProviders(md5, rc4, null, null, null, null, null);
    }

    public static SecurityProviders newInstancePassword(Provider md5, Provider rc4, Provider sha1prng) {
        return new SecurityProviders(md5, rc4, null, null, sha1prng, null, null);
    }

    public static SecurityProviders newInstancePassword(Provider md5, Provider rc4, SecureRandom randomGenerator) {
        return new SecurityProviders(md5, rc4, null, null, null, null, randomGenerator);
    }

    public static SecurityProviders newInstancePassword(Provider md5, Provider rc4, Provider aes, Provider sha1prng, Provider sha256, Provider sha384, Provider sha512) {
        return new SecurityProviders(md5, rc4, aes, null, sha1prng, sha256, sha384, sha512, null, null);
    }

    public static SecurityProviders newInstancePassword(Provider md5, Provider rc4, Provider aes, SecureRandom randomGenerator, Provider sha256, Provider sha384, Provider sha512) {
        return new SecurityProviders(md5, rc4, aes, null, null, sha256, sha384, sha512, null, randomGenerator);
    }

    public static SecurityProviders newInstancePKIRC4(Provider sha1, Provider md5, Provider rc4, Provider sha1prng) {
        return new SecurityProviders(md5, rc4, null, sha1, sha1prng, null, null);
    }

    public static SecurityProviders newInstancePKIRC4(Provider sha1, Provider md5, Provider rc4, SecureRandom randomGenerator) {
        return new SecurityProviders(md5, rc4, null, sha1, null, null, randomGenerator);
    }

    public static SecurityProviders newInstancePKIAES(Provider sha1, Provider md5, Provider aes, Provider sha1prng) {
        return new SecurityProviders(md5, null, aes, sha1, sha1prng, null, null);
    }

    public static SecurityProviders newInstancePKIAES(Provider sha1, Provider md5, Provider aes, SecureRandom randomGenerator) {
        return new SecurityProviders(md5, null, aes, sha1, null, null, randomGenerator);
    }

    public static SecurityProviders newInstance(Provider sha1, Provider md5, Provider rc4, Provider aes, Provider sha1prng, PKCS7EnvelopedDataHandler pkcs7Handler) {
        return new SecurityProviders(md5, rc4, aes, sha1, sha1prng, pkcs7Handler, null);
    }

    public static SecurityProviders newInstance(Provider sha1, Provider md5, Provider rc4, Provider aes, PKCS7EnvelopedDataHandler pkcs7Handler, SecureRandom randomGenerator) {
        return new SecurityProviders(md5, rc4, aes, sha1, null, pkcs7Handler, randomGenerator);
    }

    public static SecurityProviders newInstancePKIRC4(Provider sha1, Provider md5, Provider rc4, Provider sha1prng, PKCS7EnvelopedDataHandler pkcs7Handler) throws PDFSecurityConfigurationException {
        if (sha1 == null || md5 == null || rc4 == null || sha1prng == null || pkcs7Handler == null) {
            throw new PDFSecurityConfigurationException("Providers required for FIPS compliance are not specified");
        }
        return new SecurityProviders(md5, rc4, null, sha1, sha1prng, pkcs7Handler, null);
    }

    public static SecurityProviders newInstancePKIAES(Provider sha1, Provider md5, Provider aes, Provider sha1prng, PKCS7EnvelopedDataHandler pkcs7Handler) throws PDFSecurityConfigurationException {
        if (sha1 == null || md5 == null || aes == null || sha1prng == null || pkcs7Handler == null) {
            throw new PDFSecurityConfigurationException("Providers required for FIPS compliance are not specified");
        }
        return new SecurityProviders(md5, null, aes, sha1, sha1prng, pkcs7Handler, null);
    }
}

