/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProviderStandard;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityLockPasswordInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.security.SecurityLocation;
import com.adobe.internal.pdftoolkit.services.security.SecurityProviders;
import com.adobe.internal.pdftoolkit.services.security.StandardEncryptionPermissions;
import java.util.Map;

public class SecurityLockPassword
implements SecurityLockPasswordInterface {
    private SecurityLock mRealLock;
    static final String StrF = "StrF";
    static final String StmF = "StmF";
    static final String StdCF = "StdCF";
    static final String Identity = "Identity";
    static final String EFF = "EFF";

    private SecurityLockPassword(SecurityLock realLock) {
        this.mRealLock = realLock;
    }

    private static SecurityLockPassword newInstance(byte[] owner, byte[] user, Map encryptParams, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityException {
        if (owner == null && user == null || owner != null && user != null && ByteOps.equalArrays(owner, 0, user, 0, Math.max(owner.length, user.length)) == -1) {
            throw new PDFSecurityException("Cannot create SecurityLockPassword with equal user and owner passwords");
        }
        return new SecurityLockPassword(SecurityLocation.getSecurityLockPassword().makeSecurityLock(owner, user, encryptParams, encryptionPermissions, providers));
    }

    public static SecurityLockPassword newRC4_40bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions) throws PDFSecurityException {
        Map encryptParams = SecurityLocation.buildEncryptParams(1, 0, 2, null, null, true, false, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, null);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newRC4_128bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions) throws PDFSecurityException {
        Map encryptParams = SecurityLocation.buildEncryptParams(2, 128, 3, null, null, true, false, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, null);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newRC4_128bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData) throws PDFSecurityException {
        Map encryptParams = SecurityLocation.buildEncryptParams(4, 128, 4, null, StdCF, metaData, false, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, null);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_128bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData) throws PDFSecurityException {
        String defaultFilter = StdCF;
        Map encryptParams = SecurityLocation.buildEncryptParams(4, 128, 4, null, defaultFilter, metaData, true, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, null);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_128bit(byte[] fileAttachmentPassword) throws PDFSecurityException {
        String defaultFilter = StdCF;
        PermissionProviderStandard encryptionPermissions = new PermissionProviderStandard(-1028);
        Map encryptParams = SecurityLocation.buildEncryptParams(4, 128, 4, null, defaultFilter, false, true, false);
        encryptParams.put(EFF, StdCF);
        encryptParams.put(StrF, Identity);
        encryptParams.put(StmF, Identity);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(null, fileAttachmentPassword, encryptParams, encryptionPermissions, null);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newRC4_40bit(PDFDocument origDoc, byte[] owner, byte[] user) throws PDFSecurityException {
        return SecurityLockPassword.newRC4_40bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc));
    }

    public static SecurityLockPassword newRC4_128bit(PDFDocument origDoc, byte[] owner, byte[] user) throws PDFSecurityException {
        return SecurityLockPassword.newRC4_128bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc));
    }

    public static SecurityLockPassword newRC4_128bit(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData) throws PDFSecurityException {
        return SecurityLockPassword.newRC4_128bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData);
    }

    public static SecurityLockPassword newAES_128bit(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData) throws PDFSecurityException {
        return SecurityLockPassword.newAES_128bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData);
    }

    public static SecurityLockPassword newRC4_40bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, SecurityProviders providers) throws PDFSecurityException {
        Map encryptParams = SecurityLocation.buildEncryptParams(1, 0, 2, null, null, true, false, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, providers);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newRC4_128bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, SecurityProviders providers) throws PDFSecurityException {
        Map encryptParams = SecurityLocation.buildEncryptParams(2, 128, 3, null, null, true, false, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, providers);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newRC4_128bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        Map encryptParams = SecurityLocation.buildEncryptParams(4, 128, 4, null, StdCF, metaData, false, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, providers);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_128bit(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        String defaultFilter = StdCF;
        Map encryptParams = SecurityLocation.buildEncryptParams(4, 128, 4, null, defaultFilter, metaData, true, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, providers);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_128bit(byte[] fileAttachmentPassword, SecurityProviders providers) throws PDFSecurityException {
        String defaultFilter = StdCF;
        PermissionProviderStandard encryptionPermissions = new PermissionProviderStandard(-1028);
        Map encryptParams = SecurityLocation.buildEncryptParams(4, 128, 4, null, defaultFilter, false, true, false);
        encryptParams.put(EFF, StdCF);
        encryptParams.put(StrF, Identity);
        encryptParams.put(StmF, Identity);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(null, fileAttachmentPassword, encryptParams, encryptionPermissions, providers);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_256bitR5(byte[] fileAttachmentPassword) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(fileAttachmentPassword, 5);
    }

    public static SecurityLockPassword newAES_256bitR6(byte[] fileAttachmentPassword) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(fileAttachmentPassword, 6);
    }

    private static SecurityLockPassword getLockForAES_256(byte[] fileAttachmentPassword, int revision) throws PDFSecurityException {
        String defaultFilter = StdCF;
        PermissionProviderStandard encryptionPermissions = new PermissionProviderStandard(-1028);
        Map encryptParams = SecurityLocation.buildEncryptParams(5, 256, revision, null, defaultFilter, false, true, false);
        encryptParams.put(EFF, StdCF);
        encryptParams.put(StrF, Identity);
        encryptParams.put(StmF, Identity);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(null, fileAttachmentPassword, encryptParams, encryptionPermissions, null);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_256bitR5(byte[] fileAttachmentPassword, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(fileAttachmentPassword, providers, 5);
    }

    public static SecurityLockPassword newAES_256bitR6(byte[] fileAttachmentPassword, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(fileAttachmentPassword, providers, 6);
    }

    private static SecurityLockPassword getLockForAES_256(byte[] fileAttachmentPassword, SecurityProviders providers, int revision) throws PDFSecurityException {
        String defaultFilter = StdCF;
        PermissionProviderStandard encryptionPermissions = new PermissionProviderStandard(-1028);
        Map encryptParams = SecurityLocation.buildEncryptParams(5, 256, revision, null, defaultFilter, false, true, false);
        encryptParams.put(EFF, StdCF);
        encryptParams.put(StrF, Identity);
        encryptParams.put(StmF, Identity);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(null, fileAttachmentPassword, encryptParams, encryptionPermissions, providers);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_256bitR5(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData) throws PDFSecurityException {
        return SecurityLockPassword.newAES_256bitR5(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData);
    }

    public static SecurityLockPassword newAES_256bitR6(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData) throws PDFSecurityException {
        return SecurityLockPassword.newAES_256bitR6(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData);
    }

    public static SecurityLockPassword newAES_256bitR5(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.newAES_256bitR5(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData, providers);
    }

    public static SecurityLockPassword newAES_256bitR6(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.newAES_256bitR6(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData, providers);
    }

    public static SecurityLockPassword newAES_256bitR5(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(owner, user, encryptionPermissions, metaData, 5);
    }

    public static SecurityLockPassword newAES_256bitR6(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(owner, user, encryptionPermissions, metaData, 6);
    }

    private static SecurityLockPassword getLockForAES_256(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData, int revision) throws PDFSecurityException {
        String defaultFilter = StdCF;
        Map encryptParams = SecurityLocation.buildEncryptParams(5, 256, revision, null, defaultFilter, metaData, true, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, null);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newAES_256bitR5(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(owner, user, encryptionPermissions, metaData, providers, 5);
    }

    public static SecurityLockPassword newAES_256bitR6(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.getLockForAES_256(owner, user, encryptionPermissions, metaData, providers, 6);
    }

    private static SecurityLockPassword getLockForAES_256(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, boolean metaData, SecurityProviders providers, int revision) throws PDFSecurityException {
        String defaultFilter = StdCF;
        Map encryptParams = SecurityLocation.buildEncryptParams(5, 256, revision, null, defaultFilter, metaData, true, true);
        SecurityLockPassword lock = SecurityLockPassword.newInstance(owner, user, encryptParams, encryptionPermissions, providers);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPassword newRC4_40bit(PDFDocument origDoc, byte[] owner, byte[] user, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.newRC4_40bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), providers);
    }

    public static SecurityLockPassword newRC4_128bit(PDFDocument origDoc, byte[] owner, byte[] user, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.newRC4_128bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), providers);
    }

    public static SecurityLockPassword newRC4_128bit(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.newRC4_128bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData, providers);
    }

    public static SecurityLockPassword newAES_128bit(PDFDocument origDoc, byte[] owner, byte[] user, boolean metaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPassword.newAES_128bit(owner, user, SecurityLockPassword.getDefaultPermissions(origDoc), metaData, providers);
    }

    private static PermissionProvider getDefaultPermissions(PDFDocument pdfDoc) throws PDFSecurityException {
        PermissionProvider permProvider = null;
        try {
            if (pdfDoc.isEncrypted()) {
                permProvider = pdfDoc.getCosDocument().getEncryption().getDefaultDecryptionHandler().getPermissionProvider();
            }
        }
        catch (PDFCosParseException e) {
            throw new PDFSecurityException("", e);
        }
        if (permProvider == null) {
            StandardEncryptionPermissions encryptionPermissions = StandardEncryptionPermissions.newInstanceAll();
            permProvider = encryptionPermissions.getPermissionProvider();
        }
        if (permProvider == null) {
            throw new PDFSecurityException("Cannot create encryption provider");
        }
        return permProvider;
    }

    @Override
    public Map getEncryptParameters() {
        return this.mRealLock.getEncryptParameters();
    }

    @Override
    public void setEncryptParameters(Map encryptParams) {
        this.mRealLock.setEncryptParameters(encryptParams);
    }

    @Override
    public boolean shouldEncrypt() {
        return true;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.mRealLock.getSecurityManager();
    }

    @Override
    public SecurityLockPasswordInterface makeSecurityLock(byte[] owner, byte[] user, Map encryptParams, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityException {
        throw new RuntimeException("SecurityLockPassword.makeSecurityLock should never be caleed");
    }
}

