/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityLockPKIInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.pki.Identities;
import com.adobe.internal.pdftoolkit.services.security.SecurityLocation;
import com.adobe.internal.pdftoolkit.services.security.SecurityProviders;
import com.adobe.internal.pdftoolkit.services.security.StandardEncryptionPermissions;
import java.util.ArrayList;
import java.util.Map;

public class SecurityLockPKI
implements SecurityLock {
    private static final String PUBSEC = "Adobe.PubSec";
    private static final String DEFAULTCRYPT = "DefaultCryptFilter";
    private static final String ATTACHONLYCRYPT = "DefEmbeddedFile";
    private static final String S4 = "adbe.pkcs7.s4";
    private static final String S5 = "adbe.pkcs7.s5";
    SecurityLockPKIInterface mRealLock;

    private SecurityLockPKI(SecurityLockPKIInterface realLock) {
        this.mRealLock = realLock;
    }

    public byte[] buildRecipients(Identities identity, boolean inCrypt) throws PDFSecurityException {
        String filterName = null;
        Map encryptParams = this.getEncryptParameters();
        if (encryptParams != null) {
            filterName = (String)encryptParams.get("Filter");
        }
        if (filterName == null) {
            throw new PDFSecurityConfigurationException("Improperly built Security Lock");
        }
        return this.mRealLock.buildRecipients(filterName, identity, inCrypt, encryptParams);
    }

    public void setRecipients(Map encryptParams, Identities[] recipients, String cryptName) throws PDFSecurityException {
        Map recipientsDict = encryptParams;
        boolean inCrypt = false;
        if (cryptName != null) {
            Map cfDict = (Map)encryptParams.get("CF");
            if (cfDict != null) {
                recipientsDict = (Map)cfDict.get(cryptName);
                inCrypt = true;
            } else {
                recipientsDict = null;
            }
        }
        if (recipientsDict == null) {
            throw new PDFSecurityConfigurationException("Encryption Parameters Map does not contain " + cryptName + "Crypt dictionary");
        }
        if (inCrypt && recipients.length == 1 && !DEFAULTCRYPT.equals(cryptName)) {
            recipientsDict.put("Recipients", this.buildRecipients(recipients[0], false));
        } else {
            ArrayList<byte[]> recipientsArray = new ArrayList<byte[]>();
            for (int idInd = 0; idInd < recipients.length; ++idInd) {
                recipientsArray.add(this.buildRecipients(recipients[idInd], false));
            }
            recipientsDict.put("Recipients", recipientsArray);
        }
    }

    private static SecurityLockPKI newInstance(Identities[] identities, boolean encryptMetaData, String defaultCrypt, int version, boolean aes, boolean docOpen, SecurityProviders providers) throws PDFSecurityException {
        String subFilter = S4;
        int keyLength = 128;
        int revision = 131101;
        if (version == 4) {
            subFilter = S5;
            keyLength = -128;
        } else if (version == 5) {
            subFilter = S5;
            keyLength = 256;
            revision = 131102;
        }
        Map encryptParams = SecurityLocation.buildEncryptParams(version, keyLength, revision, PUBSEC, defaultCrypt, encryptMetaData, aes, docOpen);
        SecurityLockPKI lock = new SecurityLockPKI(SecurityLocation.getSecurityLockPKI().makeSecurityLock(encryptParams, providers));
        encryptParams.put("SubFilter", subFilter);
        lock.setEncryptParameters(encryptParams);
        lock.setRecipients(encryptParams, identities, (String)encryptParams.get("StmF"));
        return lock;
    }

    public static SecurityLockPKI newAES_256bit(Identities[] identities, boolean encryptMetaData) throws PDFSecurityException {
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 5, true, true, null);
    }

    public static SecurityLockPKI newAES_128bit(Identities[] identities, boolean encryptMetaData) throws PDFSecurityException {
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 4, true, true, null);
    }

    public static SecurityLockPKI newRC4_128bit(Identities[] identities, boolean encryptMetaData) throws PDFSecurityException {
        return SecurityLockPKI.newInstance(identities, encryptMetaData, null, 2, false, true, null);
    }

    public static SecurityLockPKI newAES_128bitAttachmentsOnly(Identities identity) throws PDFSecurityException {
        Identities allPermIdentities = Identities.newInstance(identity.getCredentials(), StandardEncryptionPermissions.newInstanceAll().getPermissionProvider());
        Identities[] identities = new Identities[]{allPermIdentities};
        SecurityLockPKI lock = SecurityLockPKI.newInstance(identities, true, ATTACHONLYCRYPT, 4, true, false, null);
        Map encryptParams = lock.getEncryptParameters();
        encryptParams.remove("StrF");
        encryptParams.remove("StmF");
        encryptParams.put("EFF", ATTACHONLYCRYPT);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPKI newAES_256bitAttachmentsOnly(Identities identity) throws PDFSecurityException {
        Identities allPermIdentities = Identities.newInstance(identity.getCredentials(), StandardEncryptionPermissions.newInstanceAll().getPermissionProvider());
        Identities[] identities = new Identities[]{allPermIdentities};
        SecurityLockPKI lock = SecurityLockPKI.newInstance(identities, true, ATTACHONLYCRYPT, 5, true, false, null);
        Map encryptParams = lock.getEncryptParameters();
        encryptParams.remove("StrF");
        encryptParams.remove("StmF");
        encryptParams.put("EFF", ATTACHONLYCRYPT);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPKI newAES_256bit(Identities identity, boolean encryptMetaData) throws PDFSecurityException {
        Identities[] identities = new Identities[]{identity};
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 5, true, true, null);
    }

    public static SecurityLockPKI newAES_128bit(Identities identity, boolean encryptMetaData) throws PDFSecurityException {
        Identities[] identities = new Identities[]{identity};
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 4, true, true, null);
    }

    public static SecurityLockPKI newRC4_128bit(Identities identity, boolean encryptMetaData) throws PDFSecurityException {
        Identities[] identities = new Identities[]{identity};
        return SecurityLockPKI.newInstance(identities, encryptMetaData, null, 2, false, true, null);
    }

    public static SecurityLockPKI newAES_256bit(Identities[] identities, boolean encryptMetaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 5, true, true, providers);
    }

    public static SecurityLockPKI newAES_128bit(Identities[] identities, boolean encryptMetaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 4, true, true, providers);
    }

    public static SecurityLockPKI newRC4_128bit(Identities[] identities, boolean encryptMetaData, SecurityProviders providers) throws PDFSecurityException {
        return SecurityLockPKI.newInstance(identities, encryptMetaData, null, 2, false, true, providers);
    }

    public static SecurityLockPKI newAES_128bitAttachmentsOnly(Identities identity, SecurityProviders providers) throws PDFSecurityException {
        Identities allPermIdentities = Identities.newInstance(identity.getCredentials(), StandardEncryptionPermissions.newInstanceAll().getPermissionProvider());
        Identities[] identities = new Identities[]{allPermIdentities};
        SecurityLockPKI lock = SecurityLockPKI.newInstance(identities, true, ATTACHONLYCRYPT, 4, true, false, providers);
        Map encryptParams = lock.getEncryptParameters();
        encryptParams.remove("StrF");
        encryptParams.remove("StmF");
        encryptParams.put("EFF", ATTACHONLYCRYPT);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPKI newAES_256bitAttachmentsOnly(Identities identity, SecurityProviders providers) throws PDFSecurityException {
        Identities allPermIdentities = Identities.newInstance(identity.getCredentials(), StandardEncryptionPermissions.newInstanceAll().getPermissionProvider());
        Identities[] identities = new Identities[]{allPermIdentities};
        SecurityLockPKI lock = SecurityLockPKI.newInstance(identities, true, ATTACHONLYCRYPT, 5, true, false, providers);
        Map encryptParams = lock.getEncryptParameters();
        encryptParams.remove("StrF");
        encryptParams.remove("StmF");
        encryptParams.put("EFF", ATTACHONLYCRYPT);
        lock.setEncryptParameters(encryptParams);
        return lock;
    }

    public static SecurityLockPKI newAES_256bit(Identities identity, boolean encryptMetaData, SecurityProviders providers) throws PDFSecurityException {
        Identities[] identities = new Identities[]{identity};
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 5, true, true, providers);
    }

    public static SecurityLockPKI newAES_128bit(Identities identity, boolean encryptMetaData, SecurityProviders providers) throws PDFSecurityException {
        Identities[] identities = new Identities[]{identity};
        return SecurityLockPKI.newInstance(identities, encryptMetaData, DEFAULTCRYPT, 4, true, true, providers);
    }

    public static SecurityLockPKI newRC4_128bit(Identities identity, boolean encryptMetaData, SecurityProviders providers) throws PDFSecurityException {
        Identities[] identities = new Identities[]{identity};
        return SecurityLockPKI.newInstance(identities, encryptMetaData, null, 2, false, true, providers);
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.mRealLock.getSecurityManager();
    }

    @Override
    public Map getEncryptParameters() {
        return this.mRealLock.getEncryptParameters();
    }

    @Override
    public void setEncryptParameters(Map encryptParams) {
        this.mRealLock.setEncryptParameters(encryptParams);
    }

    @Override
    public boolean shouldEncrypt() {
        return true;
    }
}

