/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentImageItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentPathItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentTextItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.Type3Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamReader;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.Bezier2D;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.InstructionModifier;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SanitizationUtils {
    private static final double posErrorAllowed = 0.1;
    private static final double tangentErrorAllowed = 0.17453292519943295;
    private static final int MIN_POINTS_FOR_BEZIER_FITTING = 7;
    private static final double factor = -Math.cos(2.0 * Math.atan(0.5));

    private SanitizationUtils() {
    }

    private static void addLineSegments(List<ASCoordinate> path, int ks, int ke, List<Instruction> pathInstructions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        for (int i = ks + 1; i <= ke; ++i) {
            pathInstructions.add(InstructionFactory.newLineTo(path.get(i).x(), path.get(i).y()));
        }
    }

    static boolean fitLinesToBezierCurves(List<ASCoordinate> currentPath, List<Instruction> pathInstructions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean fitted = false;
        if (currentPath == null) {
            return false;
        }
        try {
            if (currentPath.size() < 7) {
                SanitizationUtils.addLineSegments(currentPath, 0, currentPath.size() - 1, pathInstructions);
                return false;
            }
            int len = currentPath.size();
            ArrayList<Integer> K = new ArrayList<Integer>();
            int ks = 0;
            int ke = currentPath.size() - 1;
            if (SanitizationUtils.breakPathIntoCurves(ks, ke, currentPath, K, 0.1) == 0) {
                SanitizationUtils.addLineSegments(currentPath, ks, ke, pathInstructions);
                return false;
            }
            int i = 0;
            int j = 0;
            int nSize = K.size();
            while (i < len - 1) {
                if (j < nSize) {
                    if (i < (Integer)K.get(j)) {
                        SanitizationUtils.addLineSegments(currentPath, i, (Integer)K.get(j), pathInstructions);
                        i = (Integer)K.get(j);
                        continue;
                    }
                    ks = (Integer)K.get(j);
                    if (SanitizationUtils.fitCurves(ks, ke = ((Integer)K.get(j + 1)).intValue(), currentPath, pathInstructions)) {
                        fitted = true;
                    }
                    j += 2;
                    i = ke;
                    continue;
                }
                SanitizationUtils.addLineSegments(currentPath, (Integer)K.get(j - 1), len - 1, pathInstructions);
                i = len - 1;
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        return fitted;
    }

    private static boolean fitCurves(int ks, int ke, List<ASCoordinate> Q, List<Instruction> pathInstructions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        boolean fitted = false;
        assert (ke >= ks);
        if (ke - ks < 7) {
            SanitizationUtils.addLineSegments(Q, ks, ke, pathInstructions);
            return false;
        }
        SanitizationUtils.addLineSegments(Q, ks, ks + 1, pathInstructions);
        ++ks;
        --ke;
        Bezier2D bezier = new Bezier2D();
        if (bezier.fit(ks, ke, Q, 0.1, 0.1) <= 0.1 && bezier.angularError() <= 0.17453292519943295) {
            ASCoordinate P1 = bezier.getControlPoint(1);
            ASCoordinate P2 = bezier.getControlPoint(2);
            pathInstructions.add(InstructionFactory.newCurveTo(P1.x(), P1.y(), P2.x(), P2.y(), Q.get(ke).x(), Q.get(ke).y()));
            fitted = true;
        } else {
            if (SanitizationUtils.fitCurves(ks, (ks + ke) / 2, Q, pathInstructions)) {
                fitted = true;
            }
            if (SanitizationUtils.fitCurves((ks + ke) / 2, ke, Q, pathInstructions)) {
                fitted = true;
            }
        }
        SanitizationUtils.addLineSegments(Q, ke, ke + 1, pathInstructions);
        return fitted;
    }

    private static int breakPathIntoCurves(int ks, int ke, List<ASCoordinate> Q, List<Integer> K, double E) {
        if (ke - ks == 1) {
            return 0;
        }
        boolean cont = false;
        int last = 0;
        int curve_count = 0;
        int i = ks + 1;
        while (i < ke) {
            if (!SanitizationUtils.isCorner(Q.get(i - 1), Q.get(i), Q.get(i + 1), E)) {
                if (!cont) {
                    K.add(last);
                    cont = true;
                    ++curve_count;
                }
            } else if (cont) {
                K.add(i);
                cont = false;
                ++curve_count;
            }
            last = i++;
        }
        if (cont) {
            K.add(ke);
        }
        return curve_count;
    }

    private static boolean isCorner(ASCoordinate p1, ASCoordinate p2, ASCoordinate p3, double E) {
        double l3;
        double l2;
        double l1 = p1.distanceTo(p2);
        double s = (l1 + (l2 = p2.distanceTo(p3)) + (l3 = p3.distanceTo(p1))) / 2.0;
        double d = 4.0 * s * (s - l1) * (s - l2) * (s - l3) / (l3 * l3);
        if (d > 16.0 * E * E) {
            return true;
        }
        l3 = p1.distanceTo(p3);
        return !((l1 * l1 + l2 * l2 - l3 * l3) / (2.0 * l1 * l2) < factor);
    }

    private static boolean isXObjectHidden(PDFPage pdfPage, XObject xObj, double[] contentItemPixelsVisibility, List<ContentImageItem> images) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentItemsList items = xObj.getContentItems();
        if (items == null) {
            return false;
        }
        Iterator itr = items.iterator();
        ContentItem item = null;
        while (itr.hasNext()) {
            item = (ContentItem)itr.next();
            if (item instanceof XObject && SanitizationUtils.isXObjectHidden(pdfPage, (XObject)item, contentItemPixelsVisibility, images)) {
                return true;
            }
            if (item instanceof ContentTextItem && SanitizationUtils.isTextHidden((ContentTextItem)item, contentItemPixelsVisibility)) {
                return true;
            }
            if (item instanceof ContentPathItem && contentItemPixelsVisibility[item.getID()] == -1.0) {
                return true;
            }
            if (!(item instanceof ContentImageItem)) continue;
            if (contentItemPixelsVisibility[item.getID()] == -1.0 || SanitizationUtils.imageCropped(pdfPage, (ContentImageItem)item)) {
                return true;
            }
            if (images == null) continue;
            images.add((ContentImageItem)item);
        }
        return false;
    }

    static boolean isXObjectHidden(PDFPage pdfPage, XObject xObj, double[] contentItemPixelsVisibility, PDFXObjectForm xObjForm, SanitizationContext context) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<ContentImageItem> images = xObjForm == null ? null : new ArrayList<ContentImageItem>();
        boolean hidden = SanitizationUtils.isXObjectHidden(pdfPage, xObj, contentItemPixelsVisibility, images);
        if (hidden) {
            return true;
        }
        if (images != null && !images.isEmpty()) {
            SanitizationUtils.optimizeImagesInsideXObject(images.iterator(), xObjForm, pdfPage, context);
        }
        return false;
    }

    private static void optimizeImagesInsideXObject(Iterator<ContentImageItem> imagesItr, PDFXObjectForm xObjForm, PDFPage pdfPage, SanitizationContext context) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentImageItem imageItem = null;
        PDFResources xObjResources = xObjForm.getResources();
        xObjResources = xObjResources == null ? pdfPage.getResources() : xObjResources;
        ContentReader reader = ContentReader.newInstance(Content.getInstance(xObjForm.getContents(), xObjResources));
        Instruction instruction = null;
        PDFXObject xobj = null;
        Rectangle2D rect = null;
        while (reader.hasNext()) {
            instruction = reader.next();
            if (instruction.getOperator() != ASName.k_Do) continue;
            ASName xobjName = instruction.getOperands().peekName();
            xobj = xObjResources.getXObject(xobjName);
            if (xobj instanceof PDFXObjectImage) {
                if (!imagesItr.hasNext()) {
                    throw new PDFInvalidDocumentException("More images expected inside XObject while optimizing them.");
                }
                imageItem = imagesItr.next();
                rect = imageItem.getBoundingBox(null);
                context.getImageOptimizer().gatherImageOptimizationInfo((PDFXObjectImage)xobj, pdfPage, new ASRectangle(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()), true);
                continue;
            }
            if (!(xobj instanceof PDFXObjectForm)) continue;
            SanitizationUtils.optimizeImagesInsideXObject(imagesItr, (PDFXObjectForm)xobj, pdfPage, context);
        }
    }

    private static boolean imageCropped(PDFPage pdfPage, ContentImageItem image) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] cropBox = SanitizationUtils.getImageCropBox(pdfPage, image);
        return SanitizationUtils.getImageCroppingStatus(image, cropBox) != ImageVisibility.completelyVisible;
    }

    static ImageVisibility getImageCroppingStatus(ContentImageItem image, double[] visibleArea) {
        Rectangle2D imageBoundingBox = image.getBoundingBox(null);
        if (visibleArea[2] == 0.0 || visibleArea[3] == 0.0) {
            return ImageVisibility.completelyHidden;
        }
        if (Math.abs(visibleArea[2] - imageBoundingBox.getWidth()) < 0.001 && Math.abs(visibleArea[3] - imageBoundingBox.getHeight()) < 0.001) {
            return ImageVisibility.completelyVisible;
        }
        return ImageVisibility.partiallyCropped;
    }

    static double[] getImageCropBox(PDFPage pdfPage, ContentImageItem image) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Rectangle2D rect = image.getBoundingBox(null);
        PDFRectangle pageCropBox = pdfPage.getCropBox();
        Rectangle2D rect2D = ((GraphicsState)image.getGState()).getClipPath().getBounds2D();
        double left = Math.max(rect.getMinX(), rect2D.getMinX());
        double right = Math.min(rect.getMaxX(), rect2D.getMaxX());
        double bottom = Math.max(rect.getMinY(), rect2D.getMinY());
        double top = Math.min(rect.getMaxY(), rect2D.getMaxY());
        if (right < left || top < bottom) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        double x = left < pageCropBox.left() ? pageCropBox.left() : left;
        double y = bottom < pageCropBox.bottom() ? pageCropBox.bottom() : bottom;
        double width = right > pageCropBox.right() ? pageCropBox.right() - x : right - x;
        double height = top > pageCropBox.top() ? pageCropBox.top() - y : top - y;
        return new double[]{x, y, width, height};
    }

    static ASMatrix getCroppedImageMatrix(ASMatrix srcMatrix, int origImageWidth, int origImageHeight, ASRectangle margins) {
        ASCoordinate newLeftBottom = new ASCoordinate(margins.left() / (double)origImageWidth, margins.bottom() / (double)origImageHeight);
        newLeftBottom = newLeftBottom.transform(srcMatrix);
        ASMatrix subImageMatrix = new ASMatrix(((double)origImageWidth - margins.left() - margins.right()) / (double)origImageWidth, 0.0, 0.0, ((double)origImageHeight - margins.top() - margins.bottom()) / (double)origImageHeight, 0.0, 0.0);
        srcMatrix = srcMatrix.setTranslate(0.0, 0.0);
        ASMatrix dstMatrix = subImageMatrix.concat(srcMatrix);
        dstMatrix = dstMatrix.setTranslate(newLeftBottom.x(), newLeftBottom.y());
        return dstMatrix;
    }

    private static boolean isTextHidden(ContentTextItem textContent, double[] contentItemPixelsVisibility) {
        if (contentItemPixelsVisibility[textContent.getID()] == -1.0) {
            return true;
        }
        List<Glyph> text = textContent.getText();
        Iterator<Glyph> itr = text.iterator();
        Glyph glyph = null;
        while (itr.hasNext()) {
            glyph = itr.next();
            if (glyph.getCharCode() == 32 || !(contentItemPixelsVisibility[glyph.getID()] <= 0.6)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PDFXObjectForm removeHiddenInfoFromXObject(SanitizationContext context, PDFXObjectForm xObjForm, int currentContentIndex, ContentItemsList<GraphicsState, ContentItem<GraphicsState>> graphicsDOM, InstructionModifier currentModifier, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, IOException {
        ContentStreamReader streamReader = new ContentStreamReader();
        XObject xObj = (XObject)graphicsDOM.get(currentContentIndex);
        CosCloneMgr cloneMgr = new CosCloneMgr(xObjForm.getPDFDocument().getCosDocument());
        PDFXObjectForm newXObj = PDFXObjectForm.getInstance(cloneMgr.clone(xObjForm.getCosObject()));
        newXObj.setMatrix(null);
        newXObj.setBBox(PDFRectangle.newInstance(xObjForm.getPDFDocument(), xObjForm.getBBox().getRectangle().transform(currentModifier.getGState().getPendingMatrix()).normalized()));
        Content xObjContent = Content.newInstance(newXObj);
        PDFResources xObjectresources = newXObj.getResources();
        if (xObjectresources != null) {
            context.addResource(xObjectresources.getCosObject(), null, null);
        }
        xObjectresources = xObjectresources == null ? pdfPage.getResources() : xObjectresources;
        ContentWriter contentWriter = ContentWriter.newInstance(ModifiableContent.getInstance(PDFContents.newInstance(xObjForm.getPDFDocument()), xObjectresources));
        ContentStreamWriter writer = new ContentStreamWriter(contentWriter);
        contentWriter.setInstructionDelimiter(32);
        InstructionModifier modifier = new InstructionModifier(currentModifier, xObjectresources, writer, streamReader, xObj.getContentItems());
        try (ContentReader reader = ContentReader.newInstance(xObjContent);){
            modifier.parse(reader);
        }
        PDFContents pdfContents = contentWriter.close().getContents();
        try (InputByteStream contentStream = pdfContents.getContents();){
            if (contentStream == null || contentStream.length() == 0L) {
                PDFXObjectForm pDFXObjectForm = null;
                return pDFXObjectForm;
            }
        }
        newXObj.setContents(pdfContents);
        return newXObj;
    }

    static boolean isFontType3GlyphHidden(PDFPage pdfPage, Type3Glyph glyph, double[] contentItemPixelsVisibility) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentItemsList items = glyph.getOutline();
        Iterator itr = items.iterator();
        ContentItem item = null;
        while (itr.hasNext()) {
            item = itr.next();
            if (item instanceof XObject && SanitizationUtils.isXObjectHidden(pdfPage, (XObject)item, contentItemPixelsVisibility, null, null)) {
                return true;
            }
            if (!(contentItemPixelsVisibility[item.getID()] <= 0.6)) continue;
            return true;
        }
        return false;
    }

    static class ImageWriter {
        private boolean isImageMask;
        private OutputStream os;
        int bitsCount = 0;
        byte buffer = 0;

        ImageWriter(boolean isImageMask, OutputStream os) {
            this.isImageMask = isImageMask;
            this.os = os;
        }

        void write(int val) throws IOException {
            if (this.isImageMask) {
                if (this.bitsCount == 8) {
                    this.os.write(this.buffer);
                    this.bitsCount = 0;
                    this.buffer = 0;
                }
                this.buffer = (byte)(this.buffer << 1 | (val &= 1));
                ++this.bitsCount;
            } else {
                this.os.write(val >> 16);
                this.os.write(val >> 8);
                this.os.write(val);
            }
        }

        void flush() throws IOException {
            if (this.isImageMask) {
                this.buffer = (byte)(this.buffer << 8 - this.bitsCount);
                this.os.write(this.buffer);
                this.bitsCount = 0;
                this.buffer = 0;
            }
        }
    }

    static enum ImageVisibility {
        completelyVisible,
        partiallyCropped,
        completelyHidden;

    }
}

