/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.sanitization.SanitizationOptions;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.HiddenContentManager;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.ImageOptimizer;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class SanitizationContext {
    private SanitizationOptions sanitizationOptions = null;
    private Map<CosObject, Map<ASName, Set<ASName>>> referredResources = null;
    private HiddenContentManager hiddenContentManager = null;
    private ImageOptimizer imageOptimizer = null;

    ImageOptimizer getImageOptimizer() {
        return this.imageOptimizer;
    }

    public SanitizationContext(SanitizationOptions sanitizationOptions) {
        this.sanitizationOptions = sanitizationOptions;
        this.imageOptimizer = new ImageOptimizer();
    }

    SanitizationOptions getUserOptions() {
        return this.sanitizationOptions;
    }

    Map<CosObject, Map<ASName, Set<ASName>>> getReferredResources() {
        return this.referredResources;
    }

    void addResource(CosObject resourcesDict, ASName resourceType, ASName resourceName) {
        Set<ASName> resourceSet;
        Map<ASName, Set<ASName>> resourceMap;
        if (this.referredResources == null) {
            this.referredResources = new IdentityHashMap<CosObject, Map<ASName, Set<ASName>>>();
        }
        if ((resourceMap = this.referredResources.get(resourcesDict)) == null) {
            resourceMap = new IdentityHashMap<ASName, Set<ASName>>();
        }
        if ((resourceSet = resourceMap.get(resourceType)) == null) {
            resourceSet = new HashSet<ASName>();
        }
        resourceSet.add(resourceName);
        resourceMap.put(resourceType, resourceSet);
        this.referredResources.put(resourcesDict, resourceMap);
    }

    void setHiddenContentManager(HiddenContentManager hiddenContentManager) {
        this.hiddenContentManager = hiddenContentManager;
    }

    HiddenContentManager getHiddenContentManager() {
        return this.hiddenContentManager;
    }
}

