/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PDFOptimizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;

public class RootSanitizer {
    private RootSanitizer() {
    }

    public static void sanitize(PDFDocument pdfDoc, SanitizationContext context) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFOptimizer.doRootLevelOptimization(pdfDoc);
        PDFCatalog catalog = pdfDoc.requireCatalog();
        pdfDoc.setDocumentInfo(null);
        catalog.setURI(null);
        PDFNameDictionary names = catalog.getNameDictionary();
        if (names != null) {
            names.setNamedEmbeddedFiles(null);
        }
    }
}

