/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rcg.impl;

import com.adobe.internal.pdftoolkit.xml.CopyBlobProcessElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class RichTextBodyAttributes
implements CopyBlobProcessElement {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_XFA = "xmlns:xfa";
    private static final String PARA_TAG = "p";
    private static final String ITALIC_TAG = "i";
    private static final String BOLD_TAG = "b";
    private static final String SPAN_TAG = "span";
    private static final char[] lineBreak = new char[]{'\r'};
    private static final String XMLNS_XHTML = "http://www.w3.org/1999/xhtml";
    private static final String XMLNS_XFA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";
    private static final String STRING_TYPE = "string";
    private boolean gotCalled = false;
    private boolean needBreak = false;
    private boolean hasLineBreak = false;
    private XMLUtils.CopyBlob2String mCaller = null;
    static final String ELEM_BODY = "body";
    static final String ATTR_BODY_XHTML = "xmlns";
    static final String ATTR_BODY_XFA = "xmlns:xfa";

    @Override
    public void setCaller(XMLUtils.CopyBlob2String caller) {
        this.mCaller = caller;
    }

    @Override
    public Attributes processElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) {
        AttributesImpl newAttrs = new AttributesImpl(elemAttrs);
        String elemName = sName;
        if (elemName == null) {
            elemName = qName;
        }
        if (!ELEM_BODY.equals(elemName)) {
            if (PARA_TAG.equals(elemName)) {
                if (this.needBreak && this.mCaller != null && !this.hasLineEnding()) {
                    try {
                        this.mCaller.addRawContent(lineBreak, 0, lineBreak.length);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.needBreak = true;
            }
            return newAttrs;
        }
        this.gotCalled = true;
        boolean needsXFA = true;
        boolean needsW3 = true;
        int attrNum = elemAttrs.getLength();
        for (int attrInd = 0; attrInd < attrNum; ++attrInd) {
            String attrName = elemAttrs.getQName(attrInd);
            if ("xmlns".equals(attrName)) {
                needsW3 = false;
            }
            if (!"xmlns:xfa".equals(attrName)) continue;
            needsXFA = false;
        }
        if (needsW3) {
            newAttrs.addAttribute("", "xmlns", "xmlns", STRING_TYPE, XMLNS_XHTML);
        }
        if (needsXFA) {
            newAttrs.addAttribute("", "xmlns:xfa", "xmlns:xfa", STRING_TYPE, XMLNS_XFA_SCHEMA);
        }
        return newAttrs;
    }

    @Override
    public boolean wasProcessed() {
        return this.gotCalled;
    }

    @Override
    public boolean isCopyMode(String namespaceURI, String sName, String qName, Attributes elemAttrs) {
        String elemName = sName;
        if (elemName == null) {
            elemName = qName;
        }
        return ELEM_BODY.equals(elemName) || PARA_TAG.equals(elemName) || SPAN_TAG.equals(elemName) || ITALIC_TAG.equals(elemName) || BOLD_TAG.equals(elemName);
    }

    private boolean hasLineEnding() {
        String rawContent = this.mCaller.getRawContent();
        if (rawContent.endsWith(new String(lineBreak))) {
            this.hasLineBreak = true;
        }
        return this.hasLineBreak;
    }
}

