/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.AxialShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;

class RasterAxialShading
extends AxialShadingPattern<RasterGraphicsState, RasterTextState, RasterContentItem> {
    private double isExtendBeforeY = 0.0;
    private double isExtendAfterY = 0.0;
    private GeneralPath currentPath = null;
    private boolean stroke = false;

    public RasterAxialShading(RasterGraphicsState graphicsState, int id) {
        super(graphicsState, id);
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath(((RasterGraphicsState)this.getGState()).getClipPath());
        }
        RasterDocumentContext rasterDocumentContext = (RasterDocumentContext)context;
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(rasterDocumentContext.getWidthScalingFactor(), rasterDocumentContext.getHeightScalingFactor());
        this.currentPath.transform(scaleTransform);
        Graphics2D graphics2d = rasterDocumentContext.getGraphics2d();
        AffineTransform existingTransform = graphics2d.getTransform();
        graphics2d.translate(0, rasterDocumentContext.getPageHeight());
        graphics2d.scale(1.0, -1.0);
        RasterAxialShadingPaint paint = new RasterAxialShadingPaint();
        graphics2d.setPaint(paint);
        if (this.isStroke()) {
            graphics2d.draw(this.currentPath);
        } else {
            graphics2d.fill(this.currentPath);
            Graphics2D graphics2dForXobject = rasterDocumentContext.getGraphics2dForXobject();
            if (graphics2dForXobject != null) {
                GraphicsUtils.copyGraphics2DAttributes(graphics2dForXobject, graphics2d);
                graphics2dForXobject.setClip(null);
                graphics2dForXobject.setComposite(AlphaComposite.SrcOver);
                graphics2dForXobject.fill(this.currentPath);
                graphics2dForXobject.setTransform(existingTransform);
            }
        }
        graphics2d.setTransform(existingTransform);
    }

    Graphics2D postProcessing(int clipPathHeight, int clipPathWidth, Graphics2D graphics2d, boolean fill) {
        Color[] colorValues = this.getColorValues();
        int max = colorValues.length - 1;
        if (this.getIsVertical().booleanValue()) {
            for (int i = 0; i < clipPathHeight; ++i) {
                int count = i >= max ? max : (i < 0 ? 0 : i);
                graphics2d.setColor(colorValues[count]);
                this.fillorStroke(graphics2d, 0, count, clipPathWidth, 1, fill);
            }
        } else {
            this.fillHorizontalShading(graphics2d, clipPathHeight, max, fill);
        }
        return graphics2d;
    }

    private void fillHorizontalShading(Graphics2D graphics2d, int clipPathHeight, int max, boolean fill) {
        if (this.currentPath != null) {
            Paint currentPaint = graphics2d.getPaint();
            if (this.colorValues != null && this.colorValues.length > 1) {
                Rectangle2D bounds = this.currentPath.getBounds2D();
                double x = bounds.getX();
                double y = bounds.getY();
                double w = bounds.getWidth();
                int length = this.colorValues.length;
                GradientPaint gradientPaint = new GradientPaint((float)x, (float)y, this.colorValues[0], (float)(x + w), (float)y, this.colorValues[length - 1]);
                graphics2d.setPaint(gradientPaint);
                if (fill) {
                    graphics2d.fill(this.currentPath);
                } else {
                    graphics2d.draw(this.currentPath);
                }
                graphics2d.setPaint(currentPaint);
            }
        } else {
            for (int i = 0; i < clipPathHeight; ++i) {
                for (int j = 0; j < this.colorValues.length; ++j) {
                    int count = j >= max ? max : (j < 0 ? 0 : j);
                    graphics2d.setColor(this.colorValues[count]);
                    this.fillorStroke(graphics2d, i, j, 1, 1, fill);
                }
            }
        }
    }

    void setIsExtendAfterY(double isExtendAfterY) {
        this.isExtendAfterY = isExtendAfterY;
    }

    double getIsExtendAfterY() {
        return this.isExtendAfterY;
    }

    void setIsExtendBeforeY(double isExtendBeforeY) {
        this.isExtendBeforeY = isExtendBeforeY;
    }

    double getIsExtendBeforeY() {
        return this.isExtendBeforeY;
    }

    private void fillorStroke(Graphics2D graphics2d, int x, int y, int width, int height, boolean fill) {
        if (fill) {
            graphics2d.fillRect(x, y, width, height);
        } else {
            graphics2d.drawRect(x, y, width, height);
        }
    }

    public GeneralPath getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(GeneralPath currentPath) {
        this.currentPath = currentPath;
    }

    public boolean isStroke() {
        return this.stroke;
    }

    public void setStroke(boolean stroke) {
        this.stroke = stroke;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getColorValueIndexForAxialShading(double[] shadingCoordinates, ArrayList<Boolean> extendArray, double patternSpaceX, double patternSpaceY, Color[] colorValues) {
        double x0 = shadingCoordinates[0];
        double y0 = shadingCoordinates[1];
        double x1 = shadingCoordinates[2];
        double y1 = shadingCoordinates[3];
        double deltaX = x1 - x0;
        double deltaY = y1 - y0;
        double denominator = Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0);
        int tableLen = colorValues.length;
        double xdash = deltaX * (patternSpaceX - x0) + deltaY * (patternSpaceY - y0);
        if (denominator == 0.0) {
            denominator = 1.0;
        }
        if ((xdash /= denominator) < 0.0) {
            if (extendArray == null) return -1;
            if (extendArray.size() < 1) return -1;
            if (extendArray.get(0) == false) return -1;
            xdash = 0.0;
        } else if (xdash > 1.0) {
            if (extendArray == null) return -1;
            if (extendArray.size() <= 1) return -1;
            if (extendArray.get(1) == false) return -1;
            xdash = 1.0;
        }
        int t = (int)(xdash * (double)tableLen);
        if (t < 0) {
            t = 0;
        }
        if (t < colorValues.length) return t;
        return colorValues.length - 1;
    }

    private class RasterAxialShadingPaintContext
    implements PaintContext {
        AffineTransform xform;
        ColorModel cm;

        public RasterAxialShadingPaintContext(AffineTransform Tx, ColorModel cm) {
            this.xform = new AffineTransform(Tx);
            this.cm = cm;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return this.cm;
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
            int[] pixelsData = new int[w * h * 4];
            double currX = 0.0;
            double currY = 0.0;
            Color[] colorsValue = RasterAxialShading.this.getColorValues();
            AffineTransform transformation = null;
            try {
                if (RasterAxialShading.this.getMatrix() == null) {
                    transformation = RasterAxialShading.this.getTransform();
                    transformation = transformation.createInverse();
                    transformation.concatenate(this.xform.createInverse());
                } else {
                    double[] patternMatrix = RasterAxialShading.this.getMatrix();
                    transformation = new AffineTransform(patternMatrix[0], patternMatrix[1], patternMatrix[2], patternMatrix[3], patternMatrix[4], patternMatrix[5]);
                    transformation = transformation.createInverse();
                    transformation.concatenate(this.xform.createInverse());
                }
            }
            catch (NoninvertibleTransformException e) {
                return raster;
            }
            for (int yindex = 0; yindex < h; ++yindex) {
                for (int xindex = 0; xindex < w; ++xindex) {
                    double[] curCoordinates = new double[]{xindex + x, yindex + y};
                    transformation.transform(curCoordinates, 0, curCoordinates, 0, 1);
                    currX = curCoordinates[0];
                    currY = curCoordinates[1];
                    int t = RasterAxialShading.getColorValueIndexForAxialShading(RasterAxialShading.this.getCoordinates(), RasterAxialShading.this.getExtend(), currX, currY, colorsValue);
                    if (t == -1) continue;
                    int index = (yindex * w + xindex) * 4;
                    pixelsData[index] = colorsValue[t].getRed();
                    pixelsData[index + 1] = colorsValue[t].getGreen();
                    pixelsData[index + 2] = colorsValue[t].getBlue();
                    pixelsData[index + 3] = 255;
                }
            }
            raster.setPixels(0, 0, w, h, pixelsData);
            return raster;
        }
    }

    private class RasterAxialShadingPaint
    implements Paint {
        private RasterAxialShadingPaint() {
        }

        @Override
        public int getTransparency() {
            return 0;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            return new RasterAxialShadingPaintContext(xform, cm);
        }
    }
}

