/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.pdfParser.ContentStreamParser;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterCallBackInterface;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.DefaultCallBackHandler;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDisplayArea;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocument;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterPerformanceObserver;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public class PDFToRasterConverter {
    private static ArrayList<GraphicsState.BlendingMode> SupportedBlendingModes = new ArrayList();

    static ArrayList<GraphicsState.BlendingMode> getSupportedBlendingModes() {
        return SupportedBlendingModes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toBufferedImage(PDFPage page, PDFFontSet pdfFontSet, RasterizationOptions rasterConversionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        if (page == null) {
            throw new PDFInvalidParameterException("PDF page can not be null.");
        }
        if (pdfFontSet == null) {
            throw new PDFInvalidParameterException("PDF font set can not be null.");
        }
        RasterDocument rasterDocument = new RasterDocument();
        RasterCallBackInterface callBackImpl = rasterConversionOptions.getCallBackManager();
        if (callBackImpl == null) {
            callBackImpl = new DefaultCallBackHandler();
            rasterConversionOptions.registerCallBackManager(callBackImpl);
        }
        ContentStreamParser<RasterGraphicsState, RasterContentItem, RasterTextState, RasterDisplayArea> csParser = new ContentStreamParser<RasterGraphicsState, RasterContentItem, RasterTextState, RasterDisplayArea>(rasterDocument, pdfFontSet, null, rasterConversionOptions.processAnnotations(), callBackImpl, rasterConversionOptions.getIsApplyOverprintMode());
        csParser.setIgnoreErrors(rasterConversionOptions.ignoreErrors());
        double height = rasterConversionOptions.getHeight();
        double width = rasterConversionOptions.getWidth();
        RasterDisplayArea displayArea = csParser.processObjectsInPage(page, width, height, rasterConversionOptions.isRasterTrimBox());
        if (callBackImpl != null && !callBackImpl.start(displayArea, rasterDocument.getFactory())) {
            return null;
        }
        RasterDocumentContext context = new RasterDocumentContext();
        try {
            if (width != 0.0 && height != 0.0) {
                if (rasterConversionOptions.isRasterTrimBox()) {
                    PDFRectangle bBox = page.getTrimBox();
                    bBox = bBox.createIntersection(page.getCropBox());
                    PDFToRasterConverter.setScalingFactor(bBox.getValues(), context, width, height);
                } else {
                    PDFToRasterConverter.setScalingFactor(page.getCropBox().getValues(), context, width, height);
                }
            }
            csParser.setIsExceptionMode(RasterPerformanceObserver.isExceptionMode);
            BufferedImage bufferedImage = rasterDocument.createPage(displayArea, rasterConversionOptions, context);
            return bufferedImage;
        }
        finally {
            if (context != null) {
                context.destroy();
            }
        }
    }

    private static void setScalingFactor(double[] mediaBox, RasterDocumentContext context, double width, double height) {
        double[] bbox = new double[]{Math.min(mediaBox[0], mediaBox[2]), Math.min(mediaBox[1], mediaBox[3]), Math.max(mediaBox[0], mediaBox[2]), Math.max(mediaBox[1], mediaBox[3])};
        double pageWidth = (int)Math.ceil(bbox[2] - bbox[0]);
        double pageHeight = (int)Math.ceil(bbox[3] - bbox[1]);
        boolean isScale = false;
        if (pageHeight != height) {
            context.setHeightScalingFactor(height / pageHeight);
            isScale = true;
        }
        if (pageWidth != width) {
            context.setWidthScalingFactor(width / pageWidth);
            isScale = true;
        }
        context.setIsScale(isScale);
    }

    static {
        SupportedBlendingModes.add(GraphicsState.BlendingMode.NORMAL);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.MULTIPLY);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.SCREEN);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.DARKEN);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.LIGHTEN);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.DIFFERENCE);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.EXCLUSION);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.COLORDODGE);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.COLORBURN);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.HARDLIGHT);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.SOFTLIGHT);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.OVERLAY);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.LUMINOSITY);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.COLOR);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.HUE);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.SATURATION);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.OVERPRINTSrc);
        SupportedBlendingModes.add(GraphicsState.BlendingMode.OVERPRINTDst);
    }
}

