/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.permissions.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderDocMDP;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderUR;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderXFA_D;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderXFA_S;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PermissionsManagerImpl {
    private final PDFDocument m_PDFDocument;
    private final Map<String, PermissionProvider> m_PermissionProviders = new HashMap<String, PermissionProvider>();
    private static Method getDocumentType;

    public PermissionsManagerImpl(PDFDocument doc) {
        this.m_PDFDocument = doc;
    }

    public boolean isPermitted(ObjectOperations objOpr) throws PDFUnableToCompleteOperationException {
        Iterator<String> iterator = this.m_PermissionProviders.keySet().iterator();
        boolean bRet = true;
        while (iterator.hasNext()) {
            boolean bRetLocal;
            String permissionProviderName = iterator.next();
            PermissionProvider permProvider = this.m_PermissionProviders.get(permissionProviderName);
            if (permProvider == null || (bRetLocal = permProvider.isPermitted(objOpr))) continue;
            return false;
        }
        return bRet;
    }

    public List<PermissionProvider> getDenyingHandlers(ObjectOperations objOpr) throws PDFUnableToCompleteOperationException {
        ArrayList<PermissionProvider> denyingHandlers = new ArrayList<PermissionProvider>();
        for (String permissionProviderName : this.m_PermissionProviders.keySet()) {
            boolean bRetLocal;
            PermissionProvider permProvider = this.m_PermissionProviders.get(permissionProviderName);
            if (permProvider == null || (bRetLocal = permProvider.isPermitted(objOpr))) continue;
            denyingHandlers.add(permProvider);
        }
        return denyingHandlers;
    }

    public PermissionProvider getPermissionProvider(String name) throws PDFInvalidParameterException {
        if (name.equals("Security") || name.equals("UR") || name.equals("DocMDP") || name.equals("XFA")) {
            return this.m_PermissionProviders.get(name);
        }
        throw new PDFInvalidParameterException(name + " is not valid permission provider name");
    }

    public void registerAll() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFInvalidXMLException, PDFConfigurationException, PDFInvalidParameterException {
        this.RegisterSecurityPermisionProvider();
        this.RegisterURPermisionProvider();
        this.RegisterDocMDPPermisionProvider();
        this.RegisterXFAPermisionProvider();
    }

    public boolean enablePermissionProvider(String name) throws PDFInvalidParameterException {
        block7: {
            try {
                if (this.m_PermissionProviders.get(name) != null) {
                    return false;
                }
                if (name.equals("Security")) {
                    this.RegisterSecurityPermisionProvider();
                    break block7;
                }
                if (name.equals("UR")) {
                    this.RegisterURPermisionProvider();
                    break block7;
                }
                if (name.equals("DocMDP")) {
                    this.RegisterDocMDPPermisionProvider();
                    break block7;
                }
                if (name.equals("XFA")) {
                    this.RegisterXFAPermisionProvider();
                    break block7;
                }
                throw new PDFInvalidParameterException(name + " is not valid permission provider name");
            }
            catch (PDFException e) {
                throw new PDFInvalidParameterException("Unable to enable Permission Provider:[" + name + "]", e);
            }
        }
        return true;
    }

    public boolean disablePermissionProvider(String name) throws PDFInvalidParameterException {
        if (this.m_PermissionProviders.get(name) == null) {
            return false;
        }
        this.m_PermissionProviders.remove(name);
        return true;
    }

    private void RegisterSecurityPermisionProvider() throws PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        if (this.m_PDFDocument.isEncrypted()) {
            PermissionProvider permProvider = this.m_PDFDocument.getCosDocument().getEncryption().getDefaultDecryptionHandler().getPermissionProvider();
            this.m_PermissionProviders.put("Security", permProvider);
        }
    }

    private void RegisterDocMDPPermisionProvider() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms;
        if (PDFSignatureUtils.hasPermissionsSignature(this.m_PDFDocument) && (perms = this.m_PDFDocument.requireCatalog().getPermissions()).getDocMDP() != null) {
            this.m_PermissionProviders.put("DocMDP", new PermissionProviderDocMDP(this.m_PDFDocument));
        }
    }

    private void RegisterXFAPermisionProvider() throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        PDFInteractiveForm iform = this.m_PDFDocument.getInteractiveForm();
        if (iform != null && iform.hasXFA()) {
            boolean isDynamic = false;
            PDFDocument.PDFDocumentType type = null;
            try {
                if (getDocumentType != null) {
                    type = (PDFDocument.PDFDocumentType)((Object)getDocumentType.invoke(null, this.m_PDFDocument));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == null) {
                return;
            }
            isDynamic = type.isDynamic();
            if (isDynamic) {
                this.m_PermissionProviders.put("XFA", new PermissionProviderXFA_D());
            } else {
                this.m_PermissionProviders.put("XFA", new PermissionProviderXFA_S());
            }
        }
    }

    private void RegisterURPermisionProvider() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms;
        if (PDFSignatureUtils.hasUsageRights(this.m_PDFDocument, PDFSignature.k_UB1.asString(true))) {
            this.m_PermissionProviders.put("UR", new PermissionProviderUR(this.m_PDFDocument));
        } else if (PDFSignatureUtils.hasPermissionsSignature(this.m_PDFDocument) && ((perms = this.m_PDFDocument.requireCatalog().getPermissions()).getUR() != null || perms.getUR3() != null)) {
            this.m_PermissionProviders.put("UR", new PermissionProviderUR(this.m_PDFDocument));
        }
    }

    static {
        try {
            Class<?> XFAService2 = Class.forName("com.adobe.internal.pdftoolkit.services.xfa.XFAService");
            getDocumentType = XFAService2.getDeclaredMethod("getDocumentType", PDFDocument.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

