/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfport.impl;

import com.adobe.internal.agm.AGMGState;
import com.adobe.internal.agm.AGMPath;
import com.adobe.internal.agm.AGMPathSegment;
import com.adobe.internal.agm.AGMPathSegmentType;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortGState;
import java.util.ArrayList;
import java.util.Iterator;

public class PDFPortStrokePath {
    private PDFPortGState portGState;

    public PDFPortStrokePath(PDFPortGState pdfPortGState) {
        this.portGState = pdfPortGState;
    }

    private void setContent(ContentWriter portContentWriter, AGMGState agmGState, Iterator pathSegmentsIterator) throws PDFInvalidContentException, PDFIOException {
        Instruction q = InstructionFactory.newGSave();
        portContentWriter.write(q);
        try {
            this.portGState.setGState(portContentWriter, agmGState);
        }
        catch (PDFParseException e) {
            throw new PDFInvalidContentException(e);
        }
        while (pathSegmentsIterator.hasNext()) {
            Double y;
            Double x;
            AGMPathSegment pathSegment = (AGMPathSegment)pathSegmentsIterator.next();
            AGMPathSegmentType pathSegmentType = pathSegment.getSegmentType();
            ArrayList<Double> values = pathSegment.getSegmentOperands();
            if (pathSegmentType.getValue().equals(AGMPathSegmentType.MoveTo.getValue())) {
                x = values.get(0);
                y = values.get(1);
                Instruction m = InstructionFactory.newMoveTo(x, y);
                portContentWriter.write(m);
                continue;
            }
            if (pathSegmentType.getValue().equals(AGMPathSegmentType.LineTo.getValue())) {
                x = values.get(0);
                y = values.get(1);
                Instruction l = InstructionFactory.newLineTo(x, y);
                portContentWriter.write(l);
                continue;
            }
            if (pathSegmentType.getValue().equals(AGMPathSegmentType.CurveTo.getValue())) {
                Double x1 = values.get(0);
                Double y1 = values.get(1);
                Double x2 = values.get(2);
                Double y2 = values.get(3);
                Double x3 = values.get(4);
                Double y3 = values.get(5);
                Instruction c = InstructionFactory.newCurveTo(x1, y1, x2, y2, x3, y3);
                portContentWriter.write(c);
                continue;
            }
            if (pathSegmentType.getValue().equals(AGMPathSegmentType.ClosePath.getValue())) {
                Instruction h = InstructionFactory.newClosePath();
                portContentWriter.write(h);
                continue;
            }
            throw new PDFInvalidContentException("Unsupported path segment type: " + pathSegmentType.getValue());
        }
        Instruction S = InstructionFactory.newStrokePath();
        portContentWriter.write(S);
        Instruction Q = InstructionFactory.newGRestore();
        portContentWriter.write(Q);
    }

    public void pdfPortStrokePath(AGMPath path, ContentWriter portContentWriter) throws PDFInvalidContentException, PDFIOException {
        AGMGState agmGState = path.getAGMGState();
        Iterator pathSegmentsIterator = path.getPathSegmentsIterator();
        this.setContent(portContentWriter, agmGState, pathSegmentsIterator);
    }
}

